/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2024-09-28 09:47:08 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `wp_actionscheduler_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) NOT NULL,
  `status` varchar(20) NOT NULL,
  `scheduled_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  `args` varchar(191) DEFAULT NULL,
  `schedule` longtext DEFAULT NULL,
  `group_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `attempts` int(11) NOT NULL DEFAULT 0,
  `last_attempt_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `extended_args` varchar(8000) DEFAULT NULL,
  `priority` tinyint(3) unsigned NOT NULL DEFAULT 10,
  PRIMARY KEY (`action_id`),
  KEY `hook` (`hook`),
  KEY `status` (`status`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id_status_scheduled_date_gmt` (`claim_id`,`status`,`scheduled_date_gmt`),
  KEY `hook_status_scheduled_date_gmt` (`hook`(163),`status`,`scheduled_date_gmt`),
  KEY `status_scheduled_date_gmt` (`status`,`scheduled_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=754 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_actionscheduler_claims` (
  `claim_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=10289 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_actionscheduler_groups` (
  `group_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_actionscheduler_logs` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint(20) unsigned NOT NULL,
  `message` text NOT NULL,
  `log_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=2228 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT 0,
  `comment_author` tinytext NOT NULL,
  `comment_author_email` varchar(100) NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT 0,
  `comment_approved` varchar(20) NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) NOT NULL DEFAULT '',
  `comment_type` varchar(20) NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10)),
  KEY `woo_idx_comment_type` (`comment_type`)
) ENGINE=InnoDB AUTO_INCREMENT=27 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wp_e_events` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `event_data` text DEFAULT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `created_at_index` (`created_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) NOT NULL DEFAULT '',
  `link_name` varchar(255) NOT NULL DEFAULT '',
  `link_image` varchar(255) NOT NULL DEFAULT '',
  `link_target` varchar(25) NOT NULL DEFAULT '',
  `link_description` varchar(255) NOT NULL DEFAULT '',
  `link_visible` varchar(20) NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT 1,
  `link_rating` int(11) NOT NULL DEFAULT 0,
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) NOT NULL DEFAULT '',
  `link_notes` mediumtext NOT NULL,
  `link_rss` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) NOT NULL DEFAULT '',
  `option_value` longtext NOT NULL,
  `autoload` varchar(20) NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=43426 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=5743 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT 0,
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext NOT NULL,
  `post_title` text NOT NULL,
  `post_excerpt` text NOT NULL,
  `post_status` varchar(20) NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) NOT NULL DEFAULT 'open',
  `post_password` varchar(255) NOT NULL DEFAULT '',
  `post_name` varchar(200) NOT NULL DEFAULT '',
  `to_ping` text NOT NULL,
  `pinged` text NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `guid` varchar(255) NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT 0,
  `post_type` varchar(20) NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=1568 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_revslider_css` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `settings` longtext DEFAULT NULL,
  `hover` longtext DEFAULT NULL,
  `advanced` longtext DEFAULT NULL,
  `params` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `handle_index` (`handle`(64))
) ENGINE=InnoDB AUTO_INCREMENT=110 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wp_revslider_css_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `settings` longtext DEFAULT NULL,
  `hover` longtext DEFAULT NULL,
  `advanced` longtext DEFAULT NULL,
  `params` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `handle_index` (`handle`(64))
) ENGINE=InnoDB AUTO_INCREMENT=48 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wp_revslider_layer_animations` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `params` text NOT NULL,
  `settings` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wp_revslider_layer_animations_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `params` text NOT NULL,
  `settings` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wp_revslider_navigations` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `handle` varchar(191) NOT NULL,
  `type` varchar(191) NOT NULL,
  `css` longtext NOT NULL,
  `markup` longtext NOT NULL,
  `settings` longtext DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wp_revslider_navigations_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `handle` varchar(191) NOT NULL,
  `type` varchar(191) NOT NULL,
  `css` longtext NOT NULL,
  `markup` longtext NOT NULL,
  `settings` longtext DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wp_revslider_sliders` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `title` tinytext NOT NULL,
  `alias` tinytext DEFAULT NULL,
  `params` longtext NOT NULL,
  `settings` text DEFAULT NULL,
  `type` varchar(191) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `type_index` (`type`(8))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wp_revslider_sliders_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `title` tinytext NOT NULL,
  `alias` tinytext DEFAULT NULL,
  `params` longtext NOT NULL,
  `settings` text DEFAULT NULL,
  `type` varchar(191) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `type_index` (`type`(8))
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wp_revslider_slides` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `slide_order` int(11) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `slider_id_index` (`slider_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wp_revslider_slides_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `slide_order` int(11) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `slider_id_index` (`slider_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wp_revslider_static_slides` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `slider_id_index` (`slider_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wp_revslider_static_slides_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `slider_id_index` (`slider_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wp_social_users` (
  `social_users_id` int(11) NOT NULL AUTO_INCREMENT,
  `ID` int(11) NOT NULL,
  `type` varchar(20) NOT NULL,
  `identifier` varchar(100) NOT NULL,
  `register_date` datetime DEFAULT NULL,
  `login_date` datetime DEFAULT NULL,
  `link_date` datetime DEFAULT NULL,
  PRIMARY KEY (`social_users_id`),
  KEY `ID` (`ID`,`type`),
  KEY `identifier` (`identifier`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_order` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `taxonomy` varchar(32) NOT NULL DEFAULT '',
  `description` longtext NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=49 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=49 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_tutor_earnings` (
  `earning_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) DEFAULT NULL,
  `course_id` bigint(20) DEFAULT NULL,
  `order_id` bigint(20) DEFAULT NULL,
  `order_status` varchar(50) DEFAULT NULL,
  `course_price_total` decimal(16,2) DEFAULT NULL,
  `course_price_grand_total` decimal(16,2) DEFAULT NULL,
  `instructor_amount` decimal(16,2) DEFAULT NULL,
  `instructor_rate` decimal(16,2) DEFAULT NULL,
  `admin_amount` decimal(16,2) DEFAULT NULL,
  `admin_rate` decimal(16,2) DEFAULT NULL,
  `commission_type` varchar(20) DEFAULT NULL,
  `deduct_fees_amount` decimal(16,2) DEFAULT NULL,
  `deduct_fees_name` varchar(250) DEFAULT NULL,
  `deduct_fees_type` varchar(20) DEFAULT NULL,
  `process_by` varchar(20) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  PRIMARY KEY (`earning_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_tutor_quiz_attempt_answers` (
  `attempt_answer_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) DEFAULT NULL,
  `quiz_id` bigint(20) DEFAULT NULL,
  `question_id` bigint(20) DEFAULT NULL,
  `quiz_attempt_id` bigint(20) DEFAULT NULL,
  `given_answer` longtext DEFAULT NULL,
  `question_mark` decimal(8,2) DEFAULT NULL,
  `achieved_mark` decimal(8,2) DEFAULT NULL,
  `minus_mark` decimal(8,2) DEFAULT NULL,
  `is_correct` tinyint(4) DEFAULT NULL,
  PRIMARY KEY (`attempt_answer_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_tutor_quiz_attempts` (
  `attempt_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `course_id` bigint(20) DEFAULT NULL,
  `quiz_id` bigint(20) DEFAULT NULL,
  `user_id` bigint(20) DEFAULT NULL,
  `total_questions` int(11) DEFAULT NULL,
  `total_answered_questions` int(11) DEFAULT NULL,
  `total_marks` decimal(9,2) DEFAULT NULL,
  `earned_marks` decimal(9,2) DEFAULT NULL,
  `attempt_info` text DEFAULT NULL,
  `attempt_status` varchar(50) DEFAULT NULL,
  `attempt_ip` varchar(250) DEFAULT NULL,
  `attempt_started_at` datetime DEFAULT NULL,
  `attempt_ended_at` datetime DEFAULT NULL,
  `is_manually_reviewed` int(1) DEFAULT NULL,
  `manually_reviewed_at` datetime DEFAULT NULL,
  PRIMARY KEY (`attempt_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_tutor_quiz_question_answers` (
  `answer_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `belongs_question_id` bigint(20) DEFAULT NULL,
  `belongs_question_type` varchar(250) DEFAULT NULL,
  `answer_title` text DEFAULT NULL,
  `is_correct` tinyint(4) DEFAULT NULL,
  `image_id` bigint(20) DEFAULT NULL,
  `answer_two_gap_match` text DEFAULT NULL,
  `answer_view_format` varchar(250) DEFAULT NULL,
  `answer_settings` text DEFAULT NULL,
  `answer_order` int(11) DEFAULT 0,
  PRIMARY KEY (`answer_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_tutor_quiz_questions` (
  `question_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `quiz_id` bigint(20) DEFAULT NULL,
  `question_title` text DEFAULT NULL,
  `question_description` longtext DEFAULT NULL,
  `question_type` varchar(50) DEFAULT NULL,
  `question_mark` decimal(9,2) DEFAULT NULL,
  `question_settings` longtext DEFAULT NULL,
  `question_order` int(11) DEFAULT NULL,
  PRIMARY KEY (`question_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_tutor_withdraws` (
  `withdraw_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) DEFAULT NULL,
  `amount` decimal(16,2) DEFAULT NULL,
  `method_data` text DEFAULT NULL,
  `status` varchar(50) DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  PRIMARY KEY (`withdraw_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=95 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) NOT NULL DEFAULT '',
  `user_pass` varchar(255) NOT NULL DEFAULT '',
  `user_nicename` varchar(50) NOT NULL DEFAULT '',
  `user_email` varchar(100) NOT NULL DEFAULT '',
  `user_url` varchar(100) NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT 0,
  `display_name` varchar(250) NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_admin_note_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `note_id` bigint(20) unsigned NOT NULL,
  `name` varchar(255) NOT NULL,
  `label` varchar(255) NOT NULL,
  `query` longtext NOT NULL,
  `status` varchar(255) NOT NULL,
  `is_primary` tinyint(1) NOT NULL DEFAULT 0,
  `actioned_text` varchar(255) NOT NULL,
  `nonce_action` varchar(255) DEFAULT NULL,
  `nonce_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `note_id` (`note_id`)
) ENGINE=InnoDB AUTO_INCREMENT=60583 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_admin_notes` (
  `note_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `type` varchar(20) NOT NULL,
  `locale` varchar(20) NOT NULL,
  `title` longtext NOT NULL,
  `content` longtext NOT NULL,
  `content_data` longtext DEFAULT NULL,
  `status` varchar(200) NOT NULL,
  `source` varchar(200) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_reminder` datetime DEFAULT NULL,
  `is_snoozable` tinyint(1) NOT NULL DEFAULT 0,
  `layout` varchar(20) NOT NULL DEFAULT '',
  `image` varchar(200) DEFAULT NULL,
  `is_deleted` tinyint(1) NOT NULL DEFAULT 0,
  `is_read` tinyint(1) NOT NULL DEFAULT 0,
  `icon` varchar(200) NOT NULL DEFAULT 'info',
  PRIMARY KEY (`note_id`)
) ENGINE=InnoDB AUTO_INCREMENT=179 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_category_lookup` (
  `category_tree_id` bigint(20) unsigned NOT NULL,
  `category_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`category_tree_id`,`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_customer_lookup` (
  `customer_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `username` varchar(60) NOT NULL DEFAULT '',
  `first_name` varchar(255) NOT NULL,
  `last_name` varchar(255) NOT NULL,
  `email` varchar(100) DEFAULT NULL,
  `date_last_active` timestamp NULL DEFAULT NULL,
  `date_registered` timestamp NULL DEFAULT NULL,
  `country` char(2) NOT NULL DEFAULT '',
  `postcode` varchar(20) NOT NULL DEFAULT '',
  `city` varchar(100) NOT NULL DEFAULT '',
  `state` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`customer_id`),
  UNIQUE KEY `user_id` (`user_id`),
  KEY `email` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_download_log` (
  `download_log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `permission_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `user_ip_address` varchar(100) DEFAULT '',
  PRIMARY KEY (`download_log_id`),
  KEY `permission_id` (`permission_id`),
  KEY `timestamp` (`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_order_addresses` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned NOT NULL,
  `address_type` varchar(20) DEFAULT NULL,
  `first_name` text DEFAULT NULL,
  `last_name` text DEFAULT NULL,
  `company` text DEFAULT NULL,
  `address_1` text DEFAULT NULL,
  `address_2` text DEFAULT NULL,
  `city` text DEFAULT NULL,
  `state` text DEFAULT NULL,
  `postcode` text DEFAULT NULL,
  `country` text DEFAULT NULL,
  `email` varchar(320) DEFAULT NULL,
  `phone` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `address_type_order_id` (`address_type`,`order_id`),
  KEY `order_id` (`order_id`),
  KEY `email` (`email`(191)),
  KEY `phone` (`phone`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_coupon_lookup` (
  `order_id` bigint(20) unsigned NOT NULL,
  `coupon_id` bigint(20) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `discount_amount` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_id`,`coupon_id`),
  KEY `coupon_id` (`coupon_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_order_operational_data` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned DEFAULT NULL,
  `created_via` varchar(100) DEFAULT NULL,
  `woocommerce_version` varchar(20) DEFAULT NULL,
  `prices_include_tax` tinyint(1) DEFAULT NULL,
  `coupon_usages_are_counted` tinyint(1) DEFAULT NULL,
  `download_permission_granted` tinyint(1) DEFAULT NULL,
  `cart_hash` varchar(100) DEFAULT NULL,
  `new_order_email_sent` tinyint(1) DEFAULT NULL,
  `order_key` varchar(100) DEFAULT NULL,
  `order_stock_reduced` tinyint(1) DEFAULT NULL,
  `date_paid_gmt` datetime DEFAULT NULL,
  `date_completed_gmt` datetime DEFAULT NULL,
  `shipping_tax_amount` decimal(26,8) DEFAULT NULL,
  `shipping_total_amount` decimal(26,8) DEFAULT NULL,
  `discount_tax_amount` decimal(26,8) DEFAULT NULL,
  `discount_total_amount` decimal(26,8) DEFAULT NULL,
  `recorded_sales` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `order_id` (`order_id`),
  KEY `order_key` (`order_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_product_lookup` (
  `order_item_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `variation_id` bigint(20) unsigned NOT NULL,
  `customer_id` bigint(20) unsigned DEFAULT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `product_qty` int(11) NOT NULL,
  `product_net_revenue` double NOT NULL DEFAULT 0,
  `product_gross_revenue` double NOT NULL DEFAULT 0,
  `coupon_amount` double NOT NULL DEFAULT 0,
  `tax_amount` double NOT NULL DEFAULT 0,
  `shipping_amount` double NOT NULL DEFAULT 0,
  `shipping_tax_amount` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`),
  KEY `product_id` (`product_id`),
  KEY `customer_id` (`customer_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_order_stats` (
  `order_id` bigint(20) unsigned NOT NULL,
  `parent_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `num_items_sold` int(11) NOT NULL DEFAULT 0,
  `total_sales` double NOT NULL DEFAULT 0,
  `tax_total` double NOT NULL DEFAULT 0,
  `shipping_total` double NOT NULL DEFAULT 0,
  `net_total` double NOT NULL DEFAULT 0,
  `returning_customer` tinyint(1) DEFAULT NULL,
  `status` varchar(200) NOT NULL,
  `customer_id` bigint(20) unsigned NOT NULL,
  `date_paid` datetime DEFAULT '0000-00-00 00:00:00',
  `date_completed` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`order_id`),
  KEY `date_created` (`date_created`),
  KEY `customer_id` (`customer_id`),
  KEY `status` (`status`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_order_tax_lookup` (
  `order_id` bigint(20) unsigned NOT NULL,
  `tax_rate_id` bigint(20) unsigned NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `shipping_tax` double NOT NULL DEFAULT 0,
  `order_tax` double NOT NULL DEFAULT 0,
  `total_tax` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_id`,`tax_rate_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_orders` (
  `id` bigint(20) unsigned NOT NULL,
  `status` varchar(20) DEFAULT NULL,
  `currency` varchar(10) DEFAULT NULL,
  `type` varchar(20) DEFAULT NULL,
  `tax_amount` decimal(26,8) DEFAULT NULL,
  `total_amount` decimal(26,8) DEFAULT NULL,
  `customer_id` bigint(20) unsigned DEFAULT NULL,
  `billing_email` varchar(320) DEFAULT NULL,
  `date_created_gmt` datetime DEFAULT NULL,
  `date_updated_gmt` datetime DEFAULT NULL,
  `parent_order_id` bigint(20) unsigned DEFAULT NULL,
  `payment_method` varchar(100) DEFAULT NULL,
  `payment_method_title` text DEFAULT NULL,
  `transaction_id` varchar(100) DEFAULT NULL,
  `ip_address` varchar(100) DEFAULT NULL,
  `user_agent` text DEFAULT NULL,
  `customer_note` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `status` (`status`),
  KEY `date_created` (`date_created_gmt`),
  KEY `customer_id_billing_email` (`customer_id`,`billing_email`(171)),
  KEY `billing_email` (`billing_email`(191)),
  KEY `type_status_date` (`type`,`status`,`date_created_gmt`),
  KEY `parent_order_id` (`parent_order_id`),
  KEY `date_updated` (`date_updated_gmt`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_orders_meta` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned DEFAULT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `meta_key_value` (`meta_key`(100),`meta_value`(82)),
  KEY `order_id_meta_key_meta_value` (`order_id`,`meta_key`(100),`meta_value`(82))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_product_attributes_lookup` (
  `product_id` bigint(20) NOT NULL,
  `product_or_parent_id` bigint(20) NOT NULL,
  `taxonomy` varchar(32) NOT NULL,
  `term_id` bigint(20) NOT NULL,
  `is_variation_attribute` tinyint(1) NOT NULL,
  `in_stock` tinyint(1) NOT NULL,
  PRIMARY KEY (`product_or_parent_id`,`term_id`,`product_id`,`taxonomy`),
  KEY `is_variation_attribute_term_id` (`is_variation_attribute`,`term_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_product_download_directories` (
  `url_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(256) NOT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`url_id`),
  KEY `url` (`url`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_product_meta_lookup` (
  `product_id` bigint(20) NOT NULL,
  `sku` varchar(100) DEFAULT '',
  `virtual` tinyint(1) DEFAULT 0,
  `downloadable` tinyint(1) DEFAULT 0,
  `min_price` decimal(19,4) DEFAULT NULL,
  `max_price` decimal(19,4) DEFAULT NULL,
  `onsale` tinyint(1) DEFAULT 0,
  `stock_quantity` double DEFAULT NULL,
  `stock_status` varchar(100) DEFAULT 'instock',
  `rating_count` bigint(20) DEFAULT 0,
  `average_rating` decimal(3,2) DEFAULT 0.00,
  `total_sales` bigint(20) DEFAULT 0,
  `tax_status` varchar(100) DEFAULT 'taxable',
  `tax_class` varchar(100) DEFAULT '',
  `global_unique_id` varchar(100) DEFAULT '',
  PRIMARY KEY (`product_id`),
  KEY `virtual` (`virtual`),
  KEY `downloadable` (`downloadable`),
  KEY `stock_status` (`stock_status`),
  KEY `stock_quantity` (`stock_quantity`),
  KEY `onsale` (`onsale`),
  KEY `min_max_price` (`min_price`,`max_price`),
  KEY `sku` (`sku`(50))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_rate_limits` (
  `rate_limit_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `rate_limit_key` varchar(200) NOT NULL,
  `rate_limit_expiry` bigint(20) unsigned NOT NULL,
  `rate_limit_remaining` smallint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`rate_limit_id`),
  UNIQUE KEY `rate_limit_key` (`rate_limit_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_reserved_stock` (
  `order_id` bigint(20) NOT NULL,
  `product_id` bigint(20) NOT NULL,
  `stock_quantity` double NOT NULL DEFAULT 0,
  `timestamp` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `expires` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`order_id`,`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_tax_rate_classes` (
  `tax_rate_class_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_class_id`),
  UNIQUE KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_webhooks` (
  `webhook_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `status` varchar(200) NOT NULL,
  `name` text NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `delivery_url` text NOT NULL,
  `secret` text NOT NULL,
  `topic` varchar(200) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `api_version` smallint(4) NOT NULL,
  `failure_count` smallint(10) NOT NULL DEFAULT 0,
  `pending_delivery` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`webhook_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_api_keys` (
  `key_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `description` varchar(200) DEFAULT NULL,
  `permissions` varchar(10) NOT NULL,
  `consumer_key` char(64) NOT NULL,
  `consumer_secret` char(43) NOT NULL,
  `nonces` longtext DEFAULT NULL,
  `truncated_key` char(7) NOT NULL,
  `last_access` datetime DEFAULT NULL,
  PRIMARY KEY (`key_id`),
  KEY `consumer_key` (`consumer_key`),
  KEY `consumer_secret` (`consumer_secret`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_attribute_taxonomies` (
  `attribute_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `attribute_name` varchar(200) NOT NULL,
  `attribute_label` varchar(200) DEFAULT NULL,
  `attribute_type` varchar(20) NOT NULL,
  `attribute_orderby` varchar(20) NOT NULL,
  `attribute_public` int(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`attribute_id`),
  KEY `attribute_name` (`attribute_name`(20))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_downloadable_product_permissions` (
  `permission_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `download_id` varchar(36) NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `order_key` varchar(200) NOT NULL,
  `user_email` varchar(200) NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `downloads_remaining` varchar(9) DEFAULT NULL,
  `access_granted` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access_expires` datetime DEFAULT NULL,
  `download_count` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`permission_id`),
  KEY `download_order_key_product` (`product_id`,`order_id`,`order_key`(16),`download_id`),
  KEY `download_order_product` (`download_id`,`order_id`,`product_id`),
  KEY `order_id` (`order_id`),
  KEY `user_order_remaining_expires` (`user_id`,`order_id`,`downloads_remaining`,`access_expires`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_log` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `level` smallint(4) NOT NULL,
  `source` varchar(200) NOT NULL,
  `message` longtext NOT NULL,
  `context` longtext DEFAULT NULL,
  PRIMARY KEY (`log_id`),
  KEY `level` (`level`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_order_itemmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `order_item_id` (`order_item_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_order_items` (
  `order_item_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_name` text NOT NULL,
  `order_item_type` varchar(200) NOT NULL DEFAULT '',
  `order_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_payment_tokenmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `payment_token_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `payment_token_id` (`payment_token_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_payment_tokens` (
  `token_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `gateway_id` varchar(200) NOT NULL,
  `token` text NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `type` varchar(200) NOT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`token_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_sessions` (
  `session_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `session_key` char(32) NOT NULL,
  `session_value` longtext NOT NULL,
  `session_expiry` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`session_id`),
  UNIQUE KEY `session_key` (`session_key`)
) ENGINE=InnoDB AUTO_INCREMENT=283 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_shipping_zone_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_id` bigint(20) unsigned NOT NULL,
  `location_code` varchar(200) NOT NULL,
  `location_type` varchar(40) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `location_id` (`location_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20)),
  KEY `zone_id` (`zone_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_shipping_zone_methods` (
  `zone_id` bigint(20) unsigned NOT NULL,
  `instance_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `method_id` varchar(200) NOT NULL,
  `method_order` bigint(20) unsigned NOT NULL,
  `is_enabled` tinyint(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`instance_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_shipping_zones` (
  `zone_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_name` varchar(200) NOT NULL,
  `zone_order` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`zone_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_tax_rate_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `location_code` varchar(200) NOT NULL,
  `tax_rate_id` bigint(20) unsigned NOT NULL,
  `location_type` varchar(40) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_tax_rates` (
  `tax_rate_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `tax_rate_country` varchar(2) NOT NULL DEFAULT '',
  `tax_rate_state` varchar(200) NOT NULL DEFAULT '',
  `tax_rate` varchar(8) NOT NULL DEFAULT '',
  `tax_rate_name` varchar(200) NOT NULL DEFAULT '',
  `tax_rate_priority` bigint(20) unsigned NOT NULL,
  `tax_rate_compound` int(1) NOT NULL DEFAULT 0,
  `tax_rate_shipping` int(1) NOT NULL DEFAULT 1,
  `tax_rate_order` bigint(20) unsigned NOT NULL,
  `tax_rate_class` varchar(200) NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_id`),
  KEY `tax_rate_country` (`tax_rate_country`),
  KEY `tax_rate_state` (`tax_rate_state`(2)),
  KEY `tax_rate_class` (`tax_rate_class`(10)),
  KEY `tax_rate_priority` (`tax_rate_priority`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/***** TABLE CREATION END *****/


/* INSERT TABLE DATA: wp_actionscheduler_actions */
INSERT INTO `wp_actionscheduler_actions` VALUES("673", "woocommerce_cleanup_draft_orders", "complete", "2024-08-28 07:00:08", "2024-08-28 07:00:08", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1724828408;s:18:\"\0*\0first_timestamp\";i:1660990874;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1724828408;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "0", "1", "2024-08-28 17:06:11", "2024-08-28 20:36:11", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("674", "woocommerce_cleanup_draft_orders", "complete", "2024-08-29 17:06:11", "2024-08-29 17:06:11", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1724951171;s:18:\"\0*\0first_timestamp\";i:1660990874;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1724951171;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "0", "1", "2024-08-30 08:38:43", "2024-08-30 12:08:43", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("675", "woocommerce_cleanup_draft_orders", "complete", "2024-08-31 08:38:43", "2024-08-31 08:38:43", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1725093523;s:18:\"\0*\0first_timestamp\";i:1660990874;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1725093523;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "0", "1", "2024-08-31 09:13:25", "2024-08-31 12:43:25", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("676", "woocommerce_cleanup_draft_orders", "complete", "2024-09-01 09:13:25", "2024-09-01 09:13:25", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1725182005;s:18:\"\0*\0first_timestamp\";i:1660990874;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1725182005;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "0", "1", "2024-09-01 09:24:11", "2024-09-01 12:54:11", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("677", "woocommerce_cleanup_draft_orders", "complete", "2024-09-02 09:24:11", "2024-09-02 09:24:11", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1725269051;s:18:\"\0*\0first_timestamp\";i:1660990874;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1725269051;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "0", "1", "2024-09-02 12:27:00", "2024-09-02 15:57:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("678", "woocommerce_cleanup_draft_orders", "complete", "2024-09-03 12:27:00", "2024-09-03 12:27:00", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1725366420;s:18:\"\0*\0first_timestamp\";i:1660990874;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1725366420;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "0", "1", "2024-09-03 17:07:28", "2024-09-03 20:37:28", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("679", "woocommerce_cleanup_draft_orders", "complete", "2024-09-04 17:07:28", "2024-09-04 17:07:28", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1725469648;s:18:\"\0*\0first_timestamp\";i:1660990874;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1725469648;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "0", "1", "2024-09-05 02:17:11", "2024-09-05 05:47:11", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("680", "woocommerce_cleanup_draft_orders", "complete", "2024-09-06 02:17:11", "2024-09-06 02:17:11", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1725589031;s:18:\"\0*\0first_timestamp\";i:1660990874;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1725589031;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "0", "1", "2024-09-06 04:13:05", "2024-09-06 07:43:05", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("681", "woocommerce_cleanup_draft_orders", "complete", "2024-09-07 04:13:05", "2024-09-07 04:13:05", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1725682385;s:18:\"\0*\0first_timestamp\";i:1660990874;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1725682385;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "0", "1", "2024-09-07 06:32:56", "2024-09-07 10:02:56", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("682", "woocommerce_cleanup_draft_orders", "complete", "2024-09-08 06:32:56", "2024-09-08 06:32:56", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1725777176;s:18:\"\0*\0first_timestamp\";i:1660990874;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1725777176;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "0", "1", "2024-09-08 08:58:21", "2024-09-08 12:28:21", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("683", "woocommerce_cleanup_draft_orders", "complete", "2024-09-09 08:58:21", "2024-09-09 08:58:21", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1725872301;s:18:\"\0*\0first_timestamp\";i:1660990874;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1725872301;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "0", "1", "2024-09-09 10:45:51", "2024-09-09 14:15:51", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("684", "woocommerce_cleanup_draft_orders", "complete", "2024-09-10 10:45:51", "2024-09-10 10:45:51", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1725965151;s:18:\"\0*\0first_timestamp\";i:1660990874;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1725965151;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "0", "1", "2024-09-11 08:19:45", "2024-09-11 11:49:45", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("685", "woocommerce_cleanup_draft_orders", "complete", "2024-09-12 08:19:45", "2024-09-12 08:19:45", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1726129185;s:18:\"\0*\0first_timestamp\";i:1660990874;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1726129185;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "0", "1", "2024-09-12 08:59:01", "2024-09-12 12:29:01", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("686", "woocommerce_cleanup_draft_orders", "complete", "2024-09-13 08:59:01", "2024-09-13 08:59:01", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1726217941;s:18:\"\0*\0first_timestamp\";i:1660990874;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1726217941;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "0", "1", "2024-09-13 12:14:33", "2024-09-13 15:44:33", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("687", "woocommerce_cleanup_draft_orders", "complete", "2024-09-14 12:14:33", "2024-09-14 12:14:33", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1726316073;s:18:\"\0*\0first_timestamp\";i:1660990874;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1726316073;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "0", "1", "2024-09-14 16:14:22", "2024-09-14 19:44:22", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("688", "woocommerce_cleanup_draft_orders", "complete", "2024-09-15 16:14:22", "2024-09-15 16:14:22", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1726416862;s:18:\"\0*\0first_timestamp\";i:1660990874;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1726416862;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "0", "1", "2024-09-16 03:37:14", "2024-09-16 07:07:14", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("689", "woocommerce_cleanup_draft_orders", "complete", "2024-09-17 03:37:14", "2024-09-17 03:37:14", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1726544234;s:18:\"\0*\0first_timestamp\";i:1660990874;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1726544234;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "0", "1", "2024-09-17 10:23:55", "2024-09-17 13:53:55", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("690", "woocommerce_cleanup_draft_orders", "complete", "2024-09-18 10:23:55", "2024-09-18 10:23:55", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1726655035;s:18:\"\0*\0first_timestamp\";i:1660990874;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1726655035;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "0", "1", "2024-09-18 13:44:00", "2024-09-18 17:14:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("691", "woocommerce_cleanup_draft_orders", "complete", "2024-09-19 13:44:00", "2024-09-19 13:44:00", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1726753440;s:18:\"\0*\0first_timestamp\";i:1660990874;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1726753440;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "0", "1", "2024-09-19 13:55:11", "2024-09-19 17:25:11", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("692", "woocommerce_cleanup_draft_orders", "complete", "2024-09-20 13:55:11", "2024-09-20 13:55:11", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1726840511;s:18:\"\0*\0first_timestamp\";i:1660990874;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1726840511;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "0", "1", "2024-09-20 20:41:03", "2024-09-21 00:11:03", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("693", "woocommerce_cleanup_draft_orders", "complete", "2024-09-21 20:41:03", "2024-09-21 20:41:03", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1726951263;s:18:\"\0*\0first_timestamp\";i:1660990874;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1726951263;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "0", "1", "2024-09-22 12:25:39", "2024-09-22 15:55:39", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("694", "woocommerce_cleanup_draft_orders", "complete", "2024-09-23 12:25:39", "2024-09-23 12:25:39", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1727094339;s:18:\"\0*\0first_timestamp\";i:1660990874;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1727094339;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "0", "1", "2024-09-23 13:06:57", "2024-09-23 16:36:57", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("695", "woocommerce_cleanup_draft_orders", "complete", "2024-09-24 13:06:57", "2024-09-24 13:06:57", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1727183217;s:18:\"\0*\0first_timestamp\";i:1660990874;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1727183217;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "0", "1", "2024-09-24 19:32:42", "2024-09-24 23:02:42", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("696", "woocommerce_cleanup_draft_orders", "complete", "2024-09-25 19:32:42", "2024-09-25 19:32:42", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1727292762;s:18:\"\0*\0first_timestamp\";i:1660990874;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1727292762;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "0", "1", "2024-09-26 09:33:33", "2024-09-26 13:03:33", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("697", "woocommerce_cleanup_draft_orders", "complete", "2024-09-27 09:33:33", "2024-09-27 09:33:33", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1727429613;s:18:\"\0*\0first_timestamp\";i:1660990874;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1727429613;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "0", "1", "2024-09-27 12:14:22", "2024-09-27 15:44:22", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("698", "wc-admin_import_customers", "complete", "2024-09-26 09:35:02", "2024-09-26 09:35:02", "[1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727343302;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727343302;}", "2", "1", "2024-09-26 09:35:06", "2024-09-26 13:05:06", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("699", "woocommerce_run_update_callback", "complete", "2024-09-26 09:35:20", "2024-09-26 09:35:20", "{\"update_callback\":\"wc_update_650_approved_download_directories\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727343320;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727343320;}", "3", "1", "2024-09-26 09:35:20", "2024-09-26 13:05:20", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("700", "woocommerce_run_update_callback", "complete", "2024-09-26 09:35:21", "2024-09-26 09:35:21", "{\"update_callback\":\"wc_update_651_approved_download_directories\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727343321;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727343321;}", "3", "1", "2024-09-26 09:35:21", "2024-09-26 13:05:21", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("701", "woocommerce_run_update_callback", "complete", "2024-09-26 09:35:22", "2024-09-26 09:35:22", "{\"update_callback\":\"wc_update_670_purge_comments_count_cache\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727343322;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727343322;}", "3", "1", "2024-09-26 09:36:31", "2024-09-26 13:06:31", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("702", "woocommerce_run_update_callback", "complete", "2024-09-26 09:35:23", "2024-09-26 09:35:23", "{\"update_callback\":\"wc_update_670_delete_deprecated_remote_inbox_notifications_option\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727343323;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727343323;}", "3", "1", "2024-09-26 09:36:31", "2024-09-26 13:06:31", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("703", "woocommerce_update_db_to_current_version", "complete", "2024-09-26 09:35:24", "2024-09-26 09:35:24", "{\"version\":\"6.8.0\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727343324;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727343324;}", "3", "1", "2024-09-26 09:36:31", "2024-09-26 13:06:31", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("704", "woocommerce_download_dir_sync", "complete", "2024-09-26 09:35:20", "2024-09-26 09:35:20", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727343320;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727343320;}", "3", "1", "2024-09-26 09:35:21", "2024-09-26 13:05:21", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("705", "woocommerce_run_update_callback", "complete", "2024-09-26 09:35:30", "2024-09-26 09:35:30", "{\"update_callback\":\"wc_update_650_approved_download_directories\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727343330;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727343330;}", "3", "1", "2024-09-26 09:36:31", "2024-09-26 13:06:31", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("706", "woocommerce_run_update_callback", "complete", "2024-09-26 09:35:31", "2024-09-26 09:35:31", "{\"update_callback\":\"wc_update_651_approved_download_directories\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727343331;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727343331;}", "3", "1", "2024-09-26 09:36:31", "2024-09-26 13:06:31", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("707", "woocommerce_run_update_callback", "complete", "2024-09-26 09:35:32", "2024-09-26 09:35:32", "{\"update_callback\":\"wc_update_670_purge_comments_count_cache\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727343332;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727343332;}", "3", "1", "2024-09-26 09:36:31", "2024-09-26 13:06:31", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("708", "woocommerce_run_update_callback", "complete", "2024-09-26 09:35:33", "2024-09-26 09:35:33", "{\"update_callback\":\"wc_update_670_delete_deprecated_remote_inbox_notifications_option\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727343333;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727343333;}", "3", "1", "2024-09-26 09:36:31", "2024-09-26 13:06:31", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("709", "woocommerce_run_product_attribute_lookup_regeneration_callback", "complete", "2024-09-26 09:36:31", "2024-09-26 09:36:31", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727343391;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727343391;}", "3", "1", "2024-09-26 09:36:32", "2024-09-26 13:06:32", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("710", "woocommerce_run_on_woocommerce_admin_updated", "complete", "2024-09-26 09:36:30", "2024-09-26 09:36:30", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727343390;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727343390;}", "4", "1", "2024-09-26 09:36:32", "2024-09-26 13:06:32", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("711", "woocommerce_download_dir_sync", "complete", "2024-09-26 09:36:31", "2024-09-26 09:36:31", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727343391;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727343391;}", "3", "1", "2024-09-26 09:36:32", "2024-09-26 13:06:32", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("712", "woocommerce_run_update_callback", "complete", "2024-09-26 09:36:59", "2024-09-26 09:36:59", "{\"update_callback\":\"wc_update_700_remove_download_log_fk\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727343419;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727343419;}", "3", "1", "2024-09-26 09:37:31", "2024-09-26 13:07:31", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("713", "woocommerce_run_update_callback", "complete", "2024-09-26 09:37:00", "2024-09-26 09:37:00", "{\"update_callback\":\"wc_update_700_remove_recommended_marketing_plugins_transient\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727343420;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727343420;}", "3", "1", "2024-09-26 09:37:31", "2024-09-26 13:07:31", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("714", "woocommerce_run_update_callback", "complete", "2024-09-26 09:37:01", "2024-09-26 09:37:01", "{\"update_callback\":\"wc_update_721_adjust_new_zealand_states\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727343421;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727343421;}", "3", "1", "2024-09-26 09:37:31", "2024-09-26 13:07:31", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("715", "woocommerce_run_update_callback", "complete", "2024-09-26 09:37:02", "2024-09-26 09:37:02", "{\"update_callback\":\"wc_update_721_adjust_ukraine_states\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727343422;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727343422;}", "3", "1", "2024-09-26 09:37:31", "2024-09-26 13:07:31", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("716", "woocommerce_run_update_callback", "complete", "2024-09-26 09:37:03", "2024-09-26 09:37:03", "{\"update_callback\":\"wc_update_722_adjust_new_zealand_states\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727343423;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727343423;}", "3", "1", "2024-09-26 09:37:31", "2024-09-26 13:07:31", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("717", "woocommerce_run_update_callback", "complete", "2024-09-26 09:37:04", "2024-09-26 09:37:04", "{\"update_callback\":\"wc_update_722_adjust_ukraine_states\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727343424;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727343424;}", "3", "1", "2024-09-26 09:37:31", "2024-09-26 13:07:31", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("718", "woocommerce_run_update_callback", "complete", "2024-09-26 09:37:05", "2024-09-26 09:37:05", "{\"update_callback\":\"wc_update_750_add_columns_to_order_stats_table\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727343425;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727343425;}", "3", "1", "2024-09-26 09:37:31", "2024-09-26 13:07:31", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("719", "woocommerce_run_update_callback", "complete", "2024-09-26 09:37:06", "2024-09-26 09:37:06", "{\"update_callback\":\"wc_update_750_disable_new_product_management_experience\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727343426;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727343426;}", "3", "1", "2024-09-26 09:37:31", "2024-09-26 13:07:31", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("720", "woocommerce_run_update_callback", "complete", "2024-09-26 09:37:07", "2024-09-26 09:37:07", "{\"update_callback\":\"wc_update_770_remove_multichannel_marketing_feature_options\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727343427;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727343427;}", "3", "1", "2024-09-26 09:37:31", "2024-09-26 13:07:31", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("721", "woocommerce_run_update_callback", "complete", "2024-09-26 09:37:08", "2024-09-26 09:37:08", "{\"update_callback\":\"wc_update_810_migrate_transactional_metadata_for_hpos\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727343428;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727343428;}", "3", "1", "2024-09-26 09:37:31", "2024-09-26 13:07:31", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("722", "woocommerce_run_update_callback", "complete", "2024-09-26 09:37:09", "2024-09-26 09:37:09", "{\"update_callback\":\"wc_update_860_remove_recommended_marketing_plugins_transient\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727343429;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727343429;}", "3", "1", "2024-09-26 09:37:31", "2024-09-26 13:07:31", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("723", "woocommerce_run_update_callback", "complete", "2024-09-26 09:37:10", "2024-09-26 09:37:10", "{\"update_callback\":\"wc_update_870_prevent_listing_of_transient_files_directory\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727343430;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727343430;}", "3", "1", "2024-09-26 09:37:31", "2024-09-26 13:07:31", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("724", "woocommerce_run_update_callback", "complete", "2024-09-26 09:37:11", "2024-09-26 09:37:11", "{\"update_callback\":\"wc_update_890_update_connect_to_woocommerce_note\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727343431;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727343431;}", "3", "1", "2024-09-26 09:37:31", "2024-09-26 13:07:31", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("725", "woocommerce_run_update_callback", "complete", "2024-09-26 09:37:12", "2024-09-26 09:37:12", "{\"update_callback\":\"wc_update_890_update_paypal_standard_load_eligibility\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727343432;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727343432;}", "3", "1", "2024-09-26 09:37:31", "2024-09-26 13:07:31", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("726", "woocommerce_run_update_callback", "complete", "2024-09-26 09:37:13", "2024-09-26 09:37:13", "{\"update_callback\":\"wc_update_891_create_plugin_autoinstall_history_option\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727343433;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727343433;}", "3", "1", "2024-09-26 09:37:31", "2024-09-26 13:07:31", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("727", "woocommerce_run_update_callback", "complete", "2024-09-26 09:37:14", "2024-09-26 09:37:14", "{\"update_callback\":\"wc_update_910_add_launch_your_store_tour_option\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727343434;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727343434;}", "3", "1", "2024-09-26 09:37:31", "2024-09-26 13:07:31", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("728", "woocommerce_run_update_callback", "complete", "2024-09-26 09:37:15", "2024-09-26 09:37:15", "{\"update_callback\":\"wc_update_910_remove_obsolete_user_meta\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727343435;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727343435;}", "3", "1", "2024-09-26 09:37:31", "2024-09-26 13:07:31", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("729", "woocommerce_run_update_callback", "complete", "2024-09-26 09:37:16", "2024-09-26 09:37:16", "{\"update_callback\":\"wc_update_920_add_wc_hooked_blocks_version_option\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727343436;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727343436;}", "3", "1", "2024-09-26 09:37:31", "2024-09-26 13:07:31", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("730", "woocommerce_run_update_callback", "complete", "2024-09-26 09:37:17", "2024-09-26 09:37:17", "{\"update_callback\":\"wc_update_930_add_woocommerce_coming_soon_option\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727343437;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727343437;}", "3", "1", "2024-09-26 09:37:31", "2024-09-26 13:07:31", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("731", "woocommerce_run_update_callback", "complete", "2024-09-26 09:37:18", "2024-09-26 09:37:18", "{\"update_callback\":\"wc_update_930_migrate_user_meta_for_launch_your_store_tour\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727343438;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727343438;}", "3", "1", "2024-09-26 09:37:31", "2024-09-26 13:07:31", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("732", "woocommerce_update_db_to_current_version", "complete", "2024-09-26 09:37:19", "2024-09-26 09:37:19", "{\"version\":\"9.3.3\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727343439;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727343439;}", "3", "1", "2024-09-26 09:37:31", "2024-09-26 13:07:31", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("733", "woocommerce_run_update_callback", "complete", "2024-09-26 09:37:12", "2024-09-26 09:37:12", "{\"update_callback\":\"wc_update_700_remove_download_log_fk\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727343432;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727343432;}", "3", "1", "2024-09-26 09:37:31", "2024-09-26 13:07:31", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("734", "woocommerce_run_update_callback", "complete", "2024-09-26 09:37:13", "2024-09-26 09:37:13", "{\"update_callback\":\"wc_update_700_remove_recommended_marketing_plugins_transient\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727343433;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727343433;}", "3", "1", "2024-09-26 09:37:31", "2024-09-26 13:07:31", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("735", "woocommerce_run_update_callback", "complete", "2024-09-26 09:37:14", "2024-09-26 09:37:14", "{\"update_callback\":\"wc_update_721_adjust_new_zealand_states\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727343434;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727343434;}", "3", "1", "2024-09-26 09:37:31", "2024-09-26 13:07:31", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("736", "woocommerce_run_update_callback", "complete", "2024-09-26 09:37:15", "2024-09-26 09:37:15", "{\"update_callback\":\"wc_update_721_adjust_ukraine_states\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727343435;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727343435;}", "3", "1", "2024-09-26 09:37:31", "2024-09-26 13:07:31", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("737", "woocommerce_run_update_callback", "complete", "2024-09-26 09:37:16", "2024-09-26 09:37:16", "{\"update_callback\":\"wc_update_722_adjust_new_zealand_states\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727343436;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727343436;}", "3", "1", "2024-09-26 09:37:31", "2024-09-26 13:07:31", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("738", "woocommerce_run_update_callback", "complete", "2024-09-26 09:37:17", "2024-09-26 09:37:17", "{\"update_callback\":\"wc_update_722_adjust_ukraine_states\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727343437;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727343437;}", "3", "1", "2024-09-26 09:37:31", "2024-09-26 13:07:31", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("739", "woocommerce_run_update_callback", "complete", "2024-09-26 09:37:18", "2024-09-26 09:37:18", "{\"update_callback\":\"wc_update_750_add_columns_to_order_stats_table\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727343438;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727343438;}", "3", "1", "2024-09-26 09:37:31", "2024-09-26 13:07:31", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("740", "woocommerce_run_update_callback", "complete", "2024-09-26 09:37:19", "2024-09-26 09:37:19", "{\"update_callback\":\"wc_update_750_disable_new_product_management_experience\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727343439;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727343439;}", "3", "1", "2024-09-26 09:37:31", "2024-09-26 13:07:31", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("741", "woocommerce_run_update_callback", "complete", "2024-09-26 09:37:20", "2024-09-26 09:37:20", "{\"update_callback\":\"wc_update_770_remove_multichannel_marketing_feature_options\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727343440;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727343440;}", "3", "1", "2024-09-26 09:37:31", "2024-09-26 13:07:31", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("742", "woocommerce_run_update_callback", "complete", "2024-09-26 09:37:21", "2024-09-26 09:37:21", "{\"update_callback\":\"wc_update_810_migrate_transactional_metadata_for_hpos\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727343441;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727343441;}", "3", "1", "2024-09-26 09:37:31", "2024-09-26 13:07:31", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("743", "woocommerce_run_update_callback", "complete", "2024-09-26 09:37:22", "2024-09-26 09:37:22", "{\"update_callback\":\"wc_update_860_remove_recommended_marketing_plugins_transient\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727343442;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727343442;}", "3", "1", "2024-09-26 09:37:31", "2024-09-26 13:07:31", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("744", "woocommerce_run_update_callback", "complete", "2024-09-26 09:37:23", "2024-09-26 09:37:23", "{\"update_callback\":\"wc_update_870_prevent_listing_of_transient_files_directory\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727343443;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727343443;}", "3", "1", "2024-09-26 09:37:31", "2024-09-26 13:07:31", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("745", "woocommerce_run_update_callback", "complete", "2024-09-26 09:37:24", "2024-09-26 09:37:24", "{\"update_callback\":\"wc_update_890_update_connect_to_woocommerce_note\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727343444;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727343444;}", "3", "1", "2024-09-26 09:37:31", "2024-09-26 13:07:31", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("746", "woocommerce_run_update_callback", "complete", "2024-09-26 09:37:25", "2024-09-26 09:37:25", "{\"update_callback\":\"wc_update_890_update_paypal_standard_load_eligibility\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727343445;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727343445;}", "3", "1", "2024-09-26 09:37:31", "2024-09-26 13:07:31", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("747", "woocommerce_run_update_callback", "complete", "2024-09-26 09:37:26", "2024-09-26 09:37:26", "{\"update_callback\":\"wc_update_891_create_plugin_autoinstall_history_option\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727343446;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727343446;}", "3", "1", "2024-09-26 09:37:31", "2024-09-26 13:07:31", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("748", "woocommerce_run_update_callback", "complete", "2024-09-26 09:37:27", "2024-09-26 09:37:27", "{\"update_callback\":\"wc_update_910_add_launch_your_store_tour_option\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727343447;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727343447;}", "3", "1", "2024-09-26 09:37:31", "2024-09-26 13:07:31", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("749", "woocommerce_run_update_callback", "complete", "2024-09-26 09:37:28", "2024-09-26 09:37:28", "{\"update_callback\":\"wc_update_910_remove_obsolete_user_meta\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727343448;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727343448;}", "3", "1", "2024-09-26 09:37:31", "2024-09-26 13:07:31", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("750", "woocommerce_run_update_callback", "complete", "2024-09-26 09:37:29", "2024-09-26 09:37:29", "{\"update_callback\":\"wc_update_920_add_wc_hooked_blocks_version_option\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727343449;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727343449;}", "3", "1", "2024-09-26 09:37:31", "2024-09-26 13:07:31", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("751", "woocommerce_run_update_callback", "complete", "2024-09-26 09:37:30", "2024-09-26 09:37:30", "{\"update_callback\":\"wc_update_930_add_woocommerce_coming_soon_option\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727343450;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727343450;}", "3", "1", "2024-09-26 09:37:31", "2024-09-26 13:07:31", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("752", "woocommerce_run_update_callback", "complete", "2024-09-26 09:37:31", "2024-09-26 09:37:31", "{\"update_callback\":\"wc_update_930_migrate_user_meta_for_launch_your_store_tour\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727343451;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727343451;}", "3", "1", "2024-09-26 09:37:31", "2024-09-26 13:07:31", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("753", "woocommerce_cleanup_draft_orders", "pending", "2024-09-28 12:14:22", "2024-09-28 12:14:22", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1727525662;s:18:\"\0*\0first_timestamp\";i:1660990874;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1727525662;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");

/* INSERT TABLE DATA: wp_actionscheduler_groups */
INSERT INTO `wp_actionscheduler_groups` VALUES("1", "action-scheduler-migration");
INSERT INTO `wp_actionscheduler_groups` VALUES("2", "wc-admin-data");
INSERT INTO `wp_actionscheduler_groups` VALUES("3", "woocommerce-db-updates");
INSERT INTO `wp_actionscheduler_groups` VALUES("4", "woocommerce-remote-inbox-engine");
INSERT INTO `wp_actionscheduler_groups` VALUES("5", "");

/* INSERT TABLE DATA: wp_actionscheduler_logs */
INSERT INTO `wp_actionscheduler_logs` VALUES("1987", "673", "ایجاد فعالیت", "2024-08-27 07:00:08", "2024-08-27 07:00:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("1988", "673", "عملیات توسط WP Cron شروع شد", "2024-08-28 17:06:11", "2024-08-28 17:06:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("1989", "673", "عملیات توسط WP Cron کامل شد", "2024-08-28 17:06:11", "2024-08-28 17:06:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("1990", "674", "ایجاد فعالیت", "2024-08-28 17:06:11", "2024-08-28 17:06:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("1991", "674", "عملیات توسط WP Cron شروع شد", "2024-08-30 08:38:43", "2024-08-30 08:38:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("1992", "674", "عملیات توسط WP Cron کامل شد", "2024-08-30 08:38:43", "2024-08-30 08:38:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("1993", "675", "ایجاد فعالیت", "2024-08-30 08:38:43", "2024-08-30 08:38:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("1994", "675", "عملیات توسط WP Cron شروع شد", "2024-08-31 09:13:25", "2024-08-31 09:13:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("1995", "675", "عملیات توسط WP Cron کامل شد", "2024-08-31 09:13:25", "2024-08-31 09:13:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("1996", "676", "ایجاد فعالیت", "2024-08-31 09:13:25", "2024-08-31 09:13:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("1997", "676", "عملیات توسط WP Cron شروع شد", "2024-09-01 09:24:11", "2024-09-01 09:24:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("1998", "676", "عملیات توسط WP Cron کامل شد", "2024-09-01 09:24:11", "2024-09-01 09:24:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("1999", "677", "ایجاد فعالیت", "2024-09-01 09:24:11", "2024-09-01 09:24:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("2000", "677", "عملیات توسط WP Cron شروع شد", "2024-09-02 12:27:00", "2024-09-02 12:27:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("2001", "677", "عملیات توسط WP Cron کامل شد", "2024-09-02 12:27:00", "2024-09-02 12:27:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("2002", "678", "ایجاد فعالیت", "2024-09-02 12:27:00", "2024-09-02 12:27:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("2003", "678", "عملیات توسط WP Cron شروع شد", "2024-09-03 17:07:28", "2024-09-03 17:07:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("2004", "678", "عملیات توسط WP Cron کامل شد", "2024-09-03 17:07:28", "2024-09-03 17:07:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("2005", "679", "ایجاد فعالیت", "2024-09-03 17:07:28", "2024-09-03 17:07:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("2006", "679", "عملیات توسط WP Cron شروع شد", "2024-09-05 02:17:11", "2024-09-05 02:17:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("2007", "679", "عملیات توسط WP Cron کامل شد", "2024-09-05 02:17:11", "2024-09-05 02:17:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("2008", "680", "ایجاد فعالیت", "2024-09-05 02:17:11", "2024-09-05 02:17:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("2009", "680", "عملیات توسط WP Cron شروع شد", "2024-09-06 04:13:05", "2024-09-06 04:13:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("2010", "680", "عملیات توسط WP Cron کامل شد", "2024-09-06 04:13:05", "2024-09-06 04:13:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("2011", "681", "ایجاد فعالیت", "2024-09-06 04:13:05", "2024-09-06 04:13:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("2012", "681", "عملیات توسط WP Cron شروع شد", "2024-09-07 06:32:56", "2024-09-07 06:32:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("2013", "681", "عملیات توسط WP Cron کامل شد", "2024-09-07 06:32:56", "2024-09-07 06:32:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("2014", "682", "ایجاد فعالیت", "2024-09-07 06:32:56", "2024-09-07 06:32:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("2015", "682", "عملیات توسط WP Cron شروع شد", "2024-09-08 08:58:21", "2024-09-08 08:58:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("2016", "682", "عملیات توسط WP Cron کامل شد", "2024-09-08 08:58:21", "2024-09-08 08:58:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("2017", "683", "ایجاد فعالیت", "2024-09-08 08:58:21", "2024-09-08 08:58:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("2018", "683", "عملیات توسط Async Request شروع شد", "2024-09-09 10:45:51", "2024-09-09 10:45:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("2019", "683", "عملیات توسط Async Request کامل شد", "2024-09-09 10:45:51", "2024-09-09 10:45:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("2020", "684", "ایجاد فعالیت", "2024-09-09 10:45:51", "2024-09-09 10:45:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("2021", "684", "عملیات توسط WP Cron شروع شد", "2024-09-11 08:19:45", "2024-09-11 08:19:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("2022", "684", "عملیات توسط WP Cron کامل شد", "2024-09-11 08:19:45", "2024-09-11 08:19:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("2023", "685", "ایجاد فعالیت", "2024-09-11 08:19:45", "2024-09-11 08:19:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("2024", "685", "عملیات توسط WP Cron شروع شد", "2024-09-12 08:59:01", "2024-09-12 08:59:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("2025", "685", "عملیات توسط WP Cron کامل شد", "2024-09-12 08:59:01", "2024-09-12 08:59:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("2026", "686", "ایجاد فعالیت", "2024-09-12 08:59:01", "2024-09-12 08:59:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("2027", "686", "عملیات توسط WP Cron شروع شد", "2024-09-13 12:14:33", "2024-09-13 12:14:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("2028", "686", "عملیات توسط WP Cron کامل شد", "2024-09-13 12:14:33", "2024-09-13 12:14:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("2029", "687", "ایجاد فعالیت", "2024-09-13 12:14:33", "2024-09-13 12:14:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("2030", "687", "عملیات توسط WP Cron شروع شد", "2024-09-14 16:14:22", "2024-09-14 16:14:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("2031", "687", "عملیات توسط WP Cron کامل شد", "2024-09-14 16:14:22", "2024-09-14 16:14:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("2032", "688", "ایجاد فعالیت", "2024-09-14 16:14:22", "2024-09-14 16:14:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("2033", "688", "عملیات توسط WP Cron شروع شد", "2024-09-16 03:37:14", "2024-09-16 03:37:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("2034", "688", "عملیات توسط WP Cron کامل شد", "2024-09-16 03:37:14", "2024-09-16 03:37:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("2035", "689", "ایجاد فعالیت", "2024-09-16 03:37:14", "2024-09-16 03:37:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("2036", "689", "عملیات توسط WP Cron شروع شد", "2024-09-17 10:23:55", "2024-09-17 10:23:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("2037", "689", "عملیات توسط WP Cron کامل شد", "2024-09-17 10:23:55", "2024-09-17 10:23:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("2038", "690", "ایجاد فعالیت", "2024-09-17 10:23:55", "2024-09-17 10:23:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("2039", "690", "عملیات توسط WP Cron شروع شد", "2024-09-18 13:44:00", "2024-09-18 13:44:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("2040", "690", "عملیات توسط WP Cron کامل شد", "2024-09-18 13:44:00", "2024-09-18 13:44:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("2041", "691", "ایجاد فعالیت", "2024-09-18 13:44:00", "2024-09-18 13:44:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("2042", "691", "عملیات توسط WP Cron شروع شد", "2024-09-19 13:55:11", "2024-09-19 13:55:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("2043", "691", "عملیات توسط WP Cron کامل شد", "2024-09-19 13:55:11", "2024-09-19 13:55:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("2044", "692", "ایجاد فعالیت", "2024-09-19 13:55:11", "2024-09-19 13:55:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("2045", "692", "عملیات توسط WP Cron شروع شد", "2024-09-20 20:41:03", "2024-09-20 20:41:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("2046", "692", "عملیات توسط WP Cron کامل شد", "2024-09-20 20:41:03", "2024-09-20 20:41:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("2047", "693", "ایجاد فعالیت", "2024-09-20 20:41:03", "2024-09-20 20:41:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("2048", "693", "عملیات توسط WP Cron شروع شد", "2024-09-22 12:25:39", "2024-09-22 12:25:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("2049", "693", "عملیات توسط WP Cron کامل شد", "2024-09-22 12:25:39", "2024-09-22 12:25:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("2050", "694", "ایجاد فعالیت", "2024-09-22 12:25:39", "2024-09-22 12:25:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("2051", "694", "عملیات توسط WP Cron شروع شد", "2024-09-23 13:06:57", "2024-09-23 13:06:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("2052", "694", "عملیات توسط WP Cron کامل شد", "2024-09-23 13:06:57", "2024-09-23 13:06:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("2053", "695", "ایجاد فعالیت", "2024-09-23 13:06:57", "2024-09-23 13:06:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("2054", "695", "عملیات توسط WP Cron شروع شد", "2024-09-24 19:32:42", "2024-09-24 19:32:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("2055", "695", "عملیات توسط WP Cron کامل شد", "2024-09-24 19:32:42", "2024-09-24 19:32:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("2056", "696", "ایجاد فعالیت", "2024-09-24 19:32:42", "2024-09-24 19:32:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("2057", "696", "عملیات توسط WP Cron شروع شد", "2024-09-26 09:33:33", "2024-09-26 09:33:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("2058", "696", "عملیات توسط WP Cron کامل شد", "2024-09-26 09:33:33", "2024-09-26 09:33:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("2059", "697", "ایجاد فعالیت", "2024-09-26 09:33:33", "2024-09-26 09:33:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("2060", "698", "ایجاد فعالیت", "2024-09-26 09:34:57", "2024-09-26 09:34:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("2061", "698", "عملیات توسط Async Request شروع شد", "2024-09-26 09:35:06", "2024-09-26 09:35:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("2062", "698", "عملیات توسط Async Request کامل شد", "2024-09-26 09:35:06", "2024-09-26 09:35:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("2063", "699", "ایجاد فعالیت", "2024-09-26 09:35:20", "2024-09-26 09:35:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("2064", "700", "ایجاد فعالیت", "2024-09-26 09:35:20", "2024-09-26 09:35:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("2065", "701", "ایجاد فعالیت", "2024-09-26 09:35:20", "2024-09-26 09:35:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("2066", "702", "ایجاد فعالیت", "2024-09-26 09:35:20", "2024-09-26 09:35:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("2067", "703", "ایجاد فعالیت", "2024-09-26 09:35:20", "2024-09-26 09:35:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("2068", "699", "عملیات توسط WP Cron شروع شد", "2024-09-26 09:35:20", "2024-09-26 09:35:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("2069", "704", "ایجاد فعالیت", "2024-09-26 09:35:20", "2024-09-26 09:35:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("2070", "699", "عملیات توسط WP Cron کامل شد", "2024-09-26 09:35:20", "2024-09-26 09:35:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("2071", "704", "عملیات توسط WP Cron شروع شد", "2024-09-26 09:35:20", "2024-09-26 09:35:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("2072", "704", "عملیات توسط WP Cron کامل شد", "2024-09-26 09:35:21", "2024-09-26 09:35:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("2073", "700", "عملیات توسط WP Cron شروع شد", "2024-09-26 09:35:21", "2024-09-26 09:35:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("2074", "700", "عملیات توسط WP Cron کامل شد", "2024-09-26 09:35:21", "2024-09-26 09:35:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("2075", "705", "ایجاد فعالیت", "2024-09-26 09:35:30", "2024-09-26 09:35:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("2076", "706", "ایجاد فعالیت", "2024-09-26 09:35:30", "2024-09-26 09:35:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("2077", "707", "ایجاد فعالیت", "2024-09-26 09:35:30", "2024-09-26 09:35:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("2078", "708", "ایجاد فعالیت", "2024-09-26 09:35:30", "2024-09-26 09:35:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("2079", "709", "ایجاد فعالیت", "2024-09-26 09:36:30", "2024-09-26 09:36:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("2080", "710", "ایجاد فعالیت", "2024-09-26 09:36:30", "2024-09-26 09:36:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("2081", "701", "عملیات توسط WP Cron شروع شد", "2024-09-26 09:36:31", "2024-09-26 09:36:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2082", "701", "عملیات توسط WP Cron کامل شد", "2024-09-26 09:36:31", "2024-09-26 09:36:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2083", "702", "عملیات توسط WP Cron شروع شد", "2024-09-26 09:36:31", "2024-09-26 09:36:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2084", "702", "عملیات توسط WP Cron کامل شد", "2024-09-26 09:36:31", "2024-09-26 09:36:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2085", "703", "عملیات توسط WP Cron شروع شد", "2024-09-26 09:36:31", "2024-09-26 09:36:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2086", "703", "عملیات توسط WP Cron کامل شد", "2024-09-26 09:36:31", "2024-09-26 09:36:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2087", "705", "عملیات توسط WP Cron شروع شد", "2024-09-26 09:36:31", "2024-09-26 09:36:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2088", "711", "ایجاد فعالیت", "2024-09-26 09:36:31", "2024-09-26 09:36:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2089", "705", "عملیات توسط WP Cron کامل شد", "2024-09-26 09:36:31", "2024-09-26 09:36:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2090", "706", "عملیات توسط WP Cron شروع شد", "2024-09-26 09:36:31", "2024-09-26 09:36:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2091", "706", "عملیات توسط WP Cron کامل شد", "2024-09-26 09:36:31", "2024-09-26 09:36:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2092", "707", "عملیات توسط WP Cron شروع شد", "2024-09-26 09:36:31", "2024-09-26 09:36:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2093", "707", "عملیات توسط WP Cron کامل شد", "2024-09-26 09:36:31", "2024-09-26 09:36:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2094", "708", "عملیات توسط WP Cron شروع شد", "2024-09-26 09:36:31", "2024-09-26 09:36:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2095", "708", "عملیات توسط WP Cron کامل شد", "2024-09-26 09:36:31", "2024-09-26 09:36:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2096", "710", "عملیات توسط WP Cron شروع شد", "2024-09-26 09:36:31", "2024-09-26 09:36:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2097", "710", "عملیات توسط WP Cron کامل شد", "2024-09-26 09:36:32", "2024-09-26 09:36:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("2098", "709", "عملیات توسط WP Cron شروع شد", "2024-09-26 09:36:32", "2024-09-26 09:36:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("2099", "709", "عملیات توسط WP Cron کامل شد", "2024-09-26 09:36:32", "2024-09-26 09:36:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("2100", "711", "عملیات توسط WP Cron شروع شد", "2024-09-26 09:36:32", "2024-09-26 09:36:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("2101", "711", "عملیات توسط WP Cron کامل شد", "2024-09-26 09:36:32", "2024-09-26 09:36:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("2102", "712", "ایجاد فعالیت", "2024-09-26 09:36:59", "2024-09-26 09:36:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("2103", "713", "ایجاد فعالیت", "2024-09-26 09:36:59", "2024-09-26 09:36:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("2104", "714", "ایجاد فعالیت", "2024-09-26 09:36:59", "2024-09-26 09:36:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("2105", "715", "ایجاد فعالیت", "2024-09-26 09:36:59", "2024-09-26 09:36:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("2106", "716", "ایجاد فعالیت", "2024-09-26 09:36:59", "2024-09-26 09:36:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("2107", "717", "ایجاد فعالیت", "2024-09-26 09:36:59", "2024-09-26 09:36:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("2108", "718", "ایجاد فعالیت", "2024-09-26 09:36:59", "2024-09-26 09:36:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("2109", "719", "ایجاد فعالیت", "2024-09-26 09:36:59", "2024-09-26 09:36:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("2110", "720", "ایجاد فعالیت", "2024-09-26 09:36:59", "2024-09-26 09:36:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("2111", "721", "ایجاد فعالیت", "2024-09-26 09:36:59", "2024-09-26 09:36:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("2112", "722", "ایجاد فعالیت", "2024-09-26 09:36:59", "2024-09-26 09:36:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("2113", "723", "ایجاد فعالیت", "2024-09-26 09:36:59", "2024-09-26 09:36:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("2114", "724", "ایجاد فعالیت", "2024-09-26 09:36:59", "2024-09-26 09:36:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("2115", "725", "ایجاد فعالیت", "2024-09-26 09:36:59", "2024-09-26 09:36:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("2116", "726", "ایجاد فعالیت", "2024-09-26 09:36:59", "2024-09-26 09:36:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("2117", "727", "ایجاد فعالیت", "2024-09-26 09:36:59", "2024-09-26 09:36:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("2118", "728", "ایجاد فعالیت", "2024-09-26 09:36:59", "2024-09-26 09:36:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("2119", "729", "ایجاد فعالیت", "2024-09-26 09:36:59", "2024-09-26 09:36:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("2120", "730", "ایجاد فعالیت", "2024-09-26 09:36:59", "2024-09-26 09:36:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("2121", "731", "ایجاد فعالیت", "2024-09-26 09:36:59", "2024-09-26 09:36:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("2122", "732", "ایجاد فعالیت", "2024-09-26 09:36:59", "2024-09-26 09:36:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("2123", "733", "ایجاد فعالیت", "2024-09-26 09:37:12", "2024-09-26 09:37:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("2124", "734", "ایجاد فعالیت", "2024-09-26 09:37:12", "2024-09-26 09:37:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("2125", "735", "ایجاد فعالیت", "2024-09-26 09:37:12", "2024-09-26 09:37:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("2126", "736", "ایجاد فعالیت", "2024-09-26 09:37:12", "2024-09-26 09:37:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("2127", "737", "ایجاد فعالیت", "2024-09-26 09:37:12", "2024-09-26 09:37:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("2128", "738", "ایجاد فعالیت", "2024-09-26 09:37:12", "2024-09-26 09:37:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("2129", "739", "ایجاد فعالیت", "2024-09-26 09:37:12", "2024-09-26 09:37:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("2130", "740", "ایجاد فعالیت", "2024-09-26 09:37:12", "2024-09-26 09:37:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("2131", "741", "ایجاد فعالیت", "2024-09-26 09:37:12", "2024-09-26 09:37:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("2132", "742", "ایجاد فعالیت", "2024-09-26 09:37:12", "2024-09-26 09:37:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("2133", "743", "ایجاد فعالیت", "2024-09-26 09:37:12", "2024-09-26 09:37:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("2134", "744", "ایجاد فعالیت", "2024-09-26 09:37:12", "2024-09-26 09:37:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("2135", "745", "ایجاد فعالیت", "2024-09-26 09:37:12", "2024-09-26 09:37:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("2136", "746", "ایجاد فعالیت", "2024-09-26 09:37:12", "2024-09-26 09:37:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("2137", "747", "ایجاد فعالیت", "2024-09-26 09:37:12", "2024-09-26 09:37:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("2138", "748", "ایجاد فعالیت", "2024-09-26 09:37:12", "2024-09-26 09:37:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("2139", "749", "ایجاد فعالیت", "2024-09-26 09:37:12", "2024-09-26 09:37:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("2140", "750", "ایجاد فعالیت", "2024-09-26 09:37:12", "2024-09-26 09:37:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("2141", "751", "ایجاد فعالیت", "2024-09-26 09:37:12", "2024-09-26 09:37:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("2142", "752", "ایجاد فعالیت", "2024-09-26 09:37:12", "2024-09-26 09:37:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("2143", "712", "عملیات توسط Async Request شروع شد", "2024-09-26 09:37:31", "2024-09-26 09:37:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2144", "712", "عملیات توسط Async Request کامل شد", "2024-09-26 09:37:31", "2024-09-26 09:37:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2145", "713", "عملیات توسط Async Request شروع شد", "2024-09-26 09:37:31", "2024-09-26 09:37:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2146", "713", "عملیات توسط Async Request کامل شد", "2024-09-26 09:37:31", "2024-09-26 09:37:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2147", "714", "عملیات توسط Async Request شروع شد", "2024-09-26 09:37:31", "2024-09-26 09:37:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2148", "714", "عملیات توسط Async Request کامل شد", "2024-09-26 09:37:31", "2024-09-26 09:37:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2149", "715", "عملیات توسط Async Request شروع شد", "2024-09-26 09:37:31", "2024-09-26 09:37:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2150", "715", "عملیات توسط Async Request کامل شد", "2024-09-26 09:37:31", "2024-09-26 09:37:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2151", "716", "عملیات توسط Async Request شروع شد", "2024-09-26 09:37:31", "2024-09-26 09:37:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2152", "716", "عملیات توسط Async Request کامل شد", "2024-09-26 09:37:31", "2024-09-26 09:37:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2153", "717", "عملیات توسط Async Request شروع شد", "2024-09-26 09:37:31", "2024-09-26 09:37:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2154", "717", "عملیات توسط Async Request کامل شد", "2024-09-26 09:37:31", "2024-09-26 09:37:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2155", "718", "عملیات توسط Async Request شروع شد", "2024-09-26 09:37:31", "2024-09-26 09:37:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2156", "718", "عملیات توسط Async Request کامل شد", "2024-09-26 09:37:31", "2024-09-26 09:37:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2157", "719", "عملیات توسط Async Request شروع شد", "2024-09-26 09:37:31", "2024-09-26 09:37:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2158", "719", "عملیات توسط Async Request کامل شد", "2024-09-26 09:37:31", "2024-09-26 09:37:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2159", "720", "عملیات توسط Async Request شروع شد", "2024-09-26 09:37:31", "2024-09-26 09:37:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2160", "720", "عملیات توسط Async Request کامل شد", "2024-09-26 09:37:31", "2024-09-26 09:37:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2161", "721", "عملیات توسط Async Request شروع شد", "2024-09-26 09:37:31", "2024-09-26 09:37:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2162", "721", "عملیات توسط Async Request کامل شد", "2024-09-26 09:37:31", "2024-09-26 09:37:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2163", "722", "عملیات توسط Async Request شروع شد", "2024-09-26 09:37:31", "2024-09-26 09:37:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2164", "722", "عملیات توسط Async Request کامل شد", "2024-09-26 09:37:31", "2024-09-26 09:37:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2165", "723", "عملیات توسط Async Request شروع شد", "2024-09-26 09:37:31", "2024-09-26 09:37:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2166", "723", "عملیات توسط Async Request کامل شد", "2024-09-26 09:37:31", "2024-09-26 09:37:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2167", "724", "عملیات توسط Async Request شروع شد", "2024-09-26 09:37:31", "2024-09-26 09:37:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2168", "724", "عملیات توسط Async Request کامل شد", "2024-09-26 09:37:31", "2024-09-26 09:37:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2169", "725", "عملیات توسط Async Request شروع شد", "2024-09-26 09:37:31", "2024-09-26 09:37:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2170", "725", "عملیات توسط Async Request کامل شد", "2024-09-26 09:37:31", "2024-09-26 09:37:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2171", "733", "عملیات توسط Async Request شروع شد", "2024-09-26 09:37:31", "2024-09-26 09:37:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2172", "733", "عملیات توسط Async Request کامل شد", "2024-09-26 09:37:31", "2024-09-26 09:37:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2173", "726", "عملیات توسط Async Request شروع شد", "2024-09-26 09:37:31", "2024-09-26 09:37:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2174", "726", "عملیات توسط Async Request کامل شد", "2024-09-26 09:37:31", "2024-09-26 09:37:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2175", "734", "عملیات توسط Async Request شروع شد", "2024-09-26 09:37:31", "2024-09-26 09:37:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2176", "734", "عملیات توسط Async Request کامل شد", "2024-09-26 09:37:31", "2024-09-26 09:37:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2177", "727", "عملیات توسط Async Request شروع شد", "2024-09-26 09:37:31", "2024-09-26 09:37:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2178", "727", "عملیات توسط Async Request کامل شد", "2024-09-26 09:37:31", "2024-09-26 09:37:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2179", "735", "عملیات توسط Async Request شروع شد", "2024-09-26 09:37:31", "2024-09-26 09:37:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2180", "735", "عملیات توسط Async Request کامل شد", "2024-09-26 09:37:31", "2024-09-26 09:37:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2181", "728", "عملیات توسط Async Request شروع شد", "2024-09-26 09:37:31", "2024-09-26 09:37:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2182", "728", "عملیات توسط Async Request کامل شد", "2024-09-26 09:37:31", "2024-09-26 09:37:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2183", "736", "عملیات توسط Async Request شروع شد", "2024-09-26 09:37:31", "2024-09-26 09:37:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2184", "736", "عملیات توسط Async Request کامل شد", "2024-09-26 09:37:31", "2024-09-26 09:37:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2185", "729", "عملیات توسط Async Request شروع شد", "2024-09-26 09:37:31", "2024-09-26 09:37:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2186", "729", "عملیات توسط Async Request کامل شد", "2024-09-26 09:37:31", "2024-09-26 09:37:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2187", "737", "عملیات توسط Async Request شروع شد", "2024-09-26 09:37:31", "2024-09-26 09:37:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2188", "737", "عملیات توسط Async Request کامل شد", "2024-09-26 09:37:31", "2024-09-26 09:37:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2189", "730", "عملیات توسط Async Request شروع شد", "2024-09-26 09:37:31", "2024-09-26 09:37:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2190", "730", "عملیات توسط Async Request کامل شد", "2024-09-26 09:37:31", "2024-09-26 09:37:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2191", "738", "عملیات توسط Async Request شروع شد", "2024-09-26 09:37:31", "2024-09-26 09:37:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2192", "738", "عملیات توسط Async Request کامل شد", "2024-09-26 09:37:31", "2024-09-26 09:37:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2193", "731", "عملیات توسط Async Request شروع شد", "2024-09-26 09:37:31", "2024-09-26 09:37:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2194", "731", "عملیات توسط Async Request کامل شد", "2024-09-26 09:37:31", "2024-09-26 09:37:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2195", "739", "عملیات توسط Async Request شروع شد", "2024-09-26 09:37:31", "2024-09-26 09:37:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2196", "739", "عملیات توسط Async Request کامل شد", "2024-09-26 09:37:31", "2024-09-26 09:37:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2197", "732", "عملیات توسط Async Request شروع شد", "2024-09-26 09:37:31", "2024-09-26 09:37:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2198", "732", "عملیات توسط Async Request کامل شد", "2024-09-26 09:37:31", "2024-09-26 09:37:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2199", "740", "عملیات توسط Async Request شروع شد", "2024-09-26 09:37:31", "2024-09-26 09:37:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2200", "740", "عملیات توسط Async Request کامل شد", "2024-09-26 09:37:31", "2024-09-26 09:37:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2201", "741", "عملیات توسط Async Request شروع شد", "2024-09-26 09:37:31", "2024-09-26 09:37:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2202", "741", "عملیات توسط Async Request کامل شد", "2024-09-26 09:37:31", "2024-09-26 09:37:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2203", "742", "عملیات توسط Async Request شروع شد", "2024-09-26 09:37:31", "2024-09-26 09:37:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2204", "742", "عملیات توسط Async Request کامل شد", "2024-09-26 09:37:31", "2024-09-26 09:37:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2205", "743", "عملیات توسط Async Request شروع شد", "2024-09-26 09:37:31", "2024-09-26 09:37:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2206", "743", "عملیات توسط Async Request کامل شد", "2024-09-26 09:37:31", "2024-09-26 09:37:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2207", "744", "عملیات توسط Async Request شروع شد", "2024-09-26 09:37:31", "2024-09-26 09:37:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2208", "744", "عملیات توسط Async Request کامل شد", "2024-09-26 09:37:31", "2024-09-26 09:37:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2209", "745", "عملیات توسط Async Request شروع شد", "2024-09-26 09:37:31", "2024-09-26 09:37:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2210", "745", "عملیات توسط Async Request کامل شد", "2024-09-26 09:37:31", "2024-09-26 09:37:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2211", "746", "عملیات توسط Async Request شروع شد", "2024-09-26 09:37:31", "2024-09-26 09:37:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2212", "746", "عملیات توسط Async Request کامل شد", "2024-09-26 09:37:31", "2024-09-26 09:37:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2213", "747", "عملیات توسط Async Request شروع شد", "2024-09-26 09:37:31", "2024-09-26 09:37:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2214", "747", "عملیات توسط Async Request کامل شد", "2024-09-26 09:37:31", "2024-09-26 09:37:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2215", "748", "عملیات توسط Async Request شروع شد", "2024-09-26 09:37:31", "2024-09-26 09:37:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2216", "748", "عملیات توسط Async Request کامل شد", "2024-09-26 09:37:31", "2024-09-26 09:37:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2217", "749", "عملیات توسط Async Request شروع شد", "2024-09-26 09:37:31", "2024-09-26 09:37:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2218", "749", "عملیات توسط Async Request کامل شد", "2024-09-26 09:37:31", "2024-09-26 09:37:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2219", "750", "عملیات توسط Async Request شروع شد", "2024-09-26 09:37:31", "2024-09-26 09:37:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2220", "750", "عملیات توسط Async Request کامل شد", "2024-09-26 09:37:31", "2024-09-26 09:37:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2221", "751", "عملیات توسط Async Request شروع شد", "2024-09-26 09:37:31", "2024-09-26 09:37:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2222", "751", "عملیات توسط Async Request کامل شد", "2024-09-26 09:37:31", "2024-09-26 09:37:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2223", "752", "عملیات توسط Async Request شروع شد", "2024-09-26 09:37:31", "2024-09-26 09:37:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2224", "752", "عملیات توسط Async Request کامل شد", "2024-09-26 09:37:31", "2024-09-26 09:37:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2225", "697", "عملیات توسط WP Cron شروع شد", "2024-09-27 12:14:22", "2024-09-27 12:14:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("2226", "697", "عملیات توسط WP Cron کامل شد", "2024-09-27 12:14:22", "2024-09-27 12:14:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("2227", "753", "ایجاد فعالیت", "2024-09-27 12:14:22", "2024-09-27 12:14:22");

/* INSERT TABLE DATA: wp_commentmeta */
INSERT INTO `wp_commentmeta` VALUES("1", "2", "tutor_rating", "4");
INSERT INTO `wp_commentmeta` VALUES("2", "3", "tutor_rating", "5");
INSERT INTO `wp_commentmeta` VALUES("3", "4", "tutor_rating", "4");
INSERT INTO `wp_commentmeta` VALUES("4", "5", "tutor_rating", "5");
INSERT INTO `wp_commentmeta` VALUES("5", "6", "tutor_rating", "5");
INSERT INTO `wp_commentmeta` VALUES("6", "7", "tutor_rating", "4");
INSERT INTO `wp_commentmeta` VALUES("7", "8", "tutor_rating", "3");
INSERT INTO `wp_commentmeta` VALUES("8", "9", "tutor_rating", "5");
INSERT INTO `wp_commentmeta` VALUES("9", "10", "tutor_rating", "4");
INSERT INTO `wp_commentmeta` VALUES("10", "11", "tutor_rating", "3");
INSERT INTO `wp_commentmeta` VALUES("11", "12", "tutor_rating", "3");
INSERT INTO `wp_commentmeta` VALUES("12", "13", "tutor_rating", "4");
INSERT INTO `wp_commentmeta` VALUES("13", "14", "tutor_rating", "5");
INSERT INTO `wp_commentmeta` VALUES("14", "15", "tutor_rating", "2");
INSERT INTO `wp_commentmeta` VALUES("15", "16", "tutor_rating", "4");
INSERT INTO `wp_commentmeta` VALUES("16", "17", "tutor_rating", "3");
INSERT INTO `wp_commentmeta` VALUES("17", "18", "tutor_rating", "4.00");
INSERT INTO `wp_commentmeta` VALUES("18", "19", "tutor_question_title", "Question");
INSERT INTO `wp_commentmeta` VALUES("19", "21", "tutor_question_title", "How to start course ?");
INSERT INTO `wp_commentmeta` VALUES("20", "22", "tutor_rating", "5");

/* INSERT TABLE DATA: wp_comments */
INSERT INTO `wp_comments` VALUES("2", "868", "student", "", "", "", "2021-07-30 02:33:08", "2021-07-30 02:33:08", "Great starting point for learning Swift. If you have never programmed, or never used Swift it is a great place to start.", "0", "approved", "", "tutor_course_rating", "0", "0");
INSERT INTO `wp_comments` VALUES("3", "868", "student_2", "", "", "", "2021-07-30 02:34:36", "2021-07-30 02:34:36", "This course is amazing, it is extremely thorough and in depth.", "0", "approved", "", "tutor_course_rating", "0", "0");
INSERT INTO `wp_comments` VALUES("4", "876", "student", "", "", "", "2021-07-30 02:31:37", "2021-07-30 02:31:37", "Great starting point for learning Swift. If you have never programmed, or never used Swift it is a great place to start.", "0", "approved", "", "tutor_course_rating", "0", "0");
INSERT INTO `wp_comments` VALUES("5", "876", "student_2", "", "", "", "2021-07-30 02:34:24", "2021-07-30 02:34:24", "This course is amazing, it is extremely thorough and in depth.", "0", "approved", "", "tutor_course_rating", "0", "0");
INSERT INTO `wp_comments` VALUES("6", "877", "student", "", "", "", "2021-07-30 02:30:42", "2021-07-30 02:30:42", "Great starting point for learning Swift. If you have never programmed, or never used Swift it is a great place to start.", "0", "approved", "", "tutor_course_rating", "0", "0");
INSERT INTO `wp_comments` VALUES("7", "877", "student_2", "", "", "", "2021-07-30 02:36:00", "2021-07-30 02:36:00", "This course is amazing, it is extremely thorough and in depth.", "0", "approved", "", "tutor_course_rating", "0", "0");
INSERT INTO `wp_comments` VALUES("8", "878", "student", "", "", "", "2021-07-30 02:30:31", "2021-07-30 02:30:31", "Great starting point for learning Swift. If you have never programmed, or never used Swift it is a great place to start.", "0", "approved", "", "tutor_course_rating", "0", "0");
INSERT INTO `wp_comments` VALUES("9", "878", "student_2", "", "", "", "2021-07-30 02:35:48", "2021-07-30 02:35:48", "This course is amazing, it is extremely thorough and in depth.", "0", "approved", "", "tutor_course_rating", "0", "0");
INSERT INTO `wp_comments` VALUES("10", "879", "student", "", "", "", "2021-07-30 02:30:17", "2021-07-30 02:30:17", "Great starting point for learning Swift. If you have never programmed, or never used Swift it is a great place to start.", "0", "approved", "", "tutor_course_rating", "0", "0");
INSERT INTO `wp_comments` VALUES("11", "879", "student_2", "", "", "", "2021-07-30 02:35:34", "2021-07-30 02:35:34", "This course is amazing, it is extremely thorough and in depth.", "0", "approved", "", "tutor_course_rating", "0", "0");
INSERT INTO `wp_comments` VALUES("12", "880", "student", "", "", "", "2021-07-30 02:30:05", "2021-07-30 02:30:05", "Great starting point for learning Swift. If you have never programmed, or never used Swift it is a great place to start.", "0", "approved", "", "tutor_course_rating", "0", "0");
INSERT INTO `wp_comments` VALUES("13", "880", "student_2", "", "", "", "2021-07-30 02:35:18", "2021-07-30 02:35:18", "This course is amazing, it is extremely thorough and in depth.", "0", "approved", "", "tutor_course_rating", "0", "0");
INSERT INTO `wp_comments` VALUES("14", "881", "student", "", "", "", "2021-07-30 02:29:48", "2021-07-30 02:29:48", "Great starting point for learning Swift. If you have never programmed, or never used Swift it is a great place to start.", "0", "approved", "", "tutor_course_rating", "0", "0");
INSERT INTO `wp_comments` VALUES("15", "881", "student_2", "", "", "", "2021-07-30 02:35:06", "2021-07-30 02:35:06", "This course is amazing, it is extremely thorough and in depth.", "0", "approved", "", "tutor_course_rating", "0", "0");
INSERT INTO `wp_comments` VALUES("16", "882", "student", "", "", "", "2021-07-30 02:29:31", "2021-07-30 02:29:31", "Great starting point for learning Swift. If you have never programmed, or never used Swift it is a great place to start.", "0", "approved", "", "tutor_course_rating", "0", "0");
INSERT INTO `wp_comments` VALUES("17", "882", "student_2", "", "", "", "2021-07-30 02:34:58", "2021-07-30 02:34:58", "This course is amazing, it is extremely thorough and in depth.", "0", "approved", "", "tutor_course_rating", "0", "0");
INSERT INTO `wp_comments` VALUES("18", "883", "demo", "", "", "", "2021-07-06 09:24:32", "2021-07-06 09:24:32", "This course is amazing, it is extremely thorough and in depth.", "0", "approved", "", "tutor_course_rating", "0", "0");
INSERT INTO `wp_comments` VALUES("19", "883", "demo", "", "", "", "2021-07-06 10:15:31", "2021-07-06 10:15:31", "Question content", "0", "waiting_for_answer", "", "tutor_q_and_a", "0", "0");
INSERT INTO `wp_comments` VALUES("20", "883", "demo", "", "", "", "2021-07-06 10:15:54", "2021-07-06 10:15:54", "Ok Anwser", "0", "approved", "", "tutor_q_and_a", "19", "0");
INSERT INTO `wp_comments` VALUES("21", "883", "admin", "", "", "", "2021-07-07 04:01:56", "2021-07-07 04:01:56", "You can start from the first lesson.", "0", "waiting_for_answer", "", "tutor_q_and_a", "0", "0");
INSERT INTO `wp_comments` VALUES("22", "883", "student", "", "", "", "2021-07-30 02:28:49", "2021-07-30 02:28:49", "This course is amazing, it is extremely thorough and in depth.", "0", "approved", "", "tutor_course_rating", "0", "0");
INSERT INTO `wp_comments` VALUES("23", "1217", "یک مشتری", "wapuu@wordpress.example", "", "", "2020-12-08 03:30:52", "2020-12-08 00:00:52", "لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است ", "0", "1", "", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("24", "1217", "یاسمین نصیری", "admin@example.com", "", "::1", "2021-08-20 14:43:12", "2021-08-20 11:13:12", "لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است ", "0", "1", "", "comment", "23", "0");
INSERT INTO `wp_comments` VALUES("25", "48", "علی", "test@gmail.com", "", "5.250.66.144", "2022-04-26 00:55:40", "2022-04-25 21:25:40", "Vrvrvrv", "0", "spam", "Mozilla/5.0 (Linux; Android 11; SM-A505F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/100.0.4896.127 Mobile Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("26", "48", "علی", "test@gmail.com", "", "5.250.66.144", "2022-04-26 00:56:03", "2022-04-25 21:26:03", "Great", "0", "spam", "Mozilla/5.0 (Linux; Android 11; SM-A505F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/100.0.4896.127 Mobile Safari/537.36", "comment", "25", "0");

/* INSERT TABLE DATA: wp_duplicator_packages */
INSERT INTO `wp_duplicator_packages` VALUES("4", "20220426_d982d8a7d984d8a8d988d8b1d8afd9", "da0c797e19d060ec7910_20240928094626", "21", "2024-09-28 09:47:08", "Zilom", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2024-09-28 09:46:26\";s:7:\"Version\";s:6:\"1.5.11\";s:9:\"VersionWP\";s:5:\"6.6.2\";s:9:\"VersionDB\";s:7:\"10.11.9\";s:10:\"VersionPHP\";s:6:\"7.4.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:4;s:4:\"Name\";s:39:\"20220426_d982d8a7d984d8a8d988d8b1d8afd9\";s:4:\"Hash\";s:35:\"da0c797e19d060ec7910_20240928094626\";s:8:\"NameHash\";s:75:\"20220426_d982d8a7d984d8a8d988d8b1d8afd9_da0c797e19d060ec7910_20240928094626\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:85:\"20220426_d982d8a7d984d8a8d988d8b1d8afd9_da0c797e19d060ec7910_20240928094626_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";s:4:\"20.8\";s:6:\"WPUser\";s:5:\"Zilom\";s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:87:\"20220426_d982d8a7d984d8a8d988d8b1d8afd9_da0c797e19d060ec7910_20240928094626_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:33:\"/home/themeswpn/public_html/Zilom\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:2876;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:17844;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2024-09-28 09:46:26\";s:7:\"Version\";s:6:\"1.5.11\";s:9:\"VersionWP\";s:5:\"6.6.2\";s:9:\"VersionDB\";s:7:\"10.11.9\";s:10:\"VersionPHP\";s:6:\"7.4.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:39:\"20220426_d982d8a7d984d8a8d988d8b1d8afd9\";s:4:\"Hash\";s:35:\"da0c797e19d060ec7910_20240928094626\";s:8:\"NameHash\";s:75:\"20220426_d982d8a7d984d8a8d988d8b1d8afd9_da0c797e19d060ec7910_20240928094626\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";s:93:\"20220426_d982d8a7d984d8a8d988d8b1d8afd9_da0c797e19d060ec7910_20240928094626_installer.php.bak\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:47:\"/home/themeswpn/public_html/Zilom/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:88:\"20220426_d982d8a7d984d8a8d988d8b1d8afd9_da0c797e19d060ec7910_20240928094626_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:14:\"MariaDB Server\";s:19:\"sameNameTableExists\";b:0;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:19:\"lowerCaseTableNames\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:154:\"/home/themeswpn/public_html/Zilom/wp-content/backups-dup-lite/tmp/20220426_d982d8a7d984d8a8d988d8b1d8afd9_da0c797e19d060ec7910_20240928094626_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:42:\"/home/themeswpn/public_html/Zilom/wp-admin\";i:1;s:45:\"/home/themeswpn/public_html/Zilom/wp-includes\";i:2;s:54:\"/home/themeswpn/public_html/Zilom/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:33:\"/home/themeswpn/public_html/Zilom\";i:1;s:33:\"/home/themeswpn/public_html/Zilom\";i:2;s:44:\"/home/themeswpn/public_html/Zilom/wp-content\";i:3;s:52:\"/home/themeswpn/public_html/Zilom/wp-content/uploads\";i:4;s:52:\"/home/themeswpn/public_html/Zilom/wp-content/plugins\";i:5;s:55:\"/home/themeswpn/public_html/Zilom/wp-content/mu-plugins\";i:6;s:51:\"/home/themeswpn/public_html/Zilom/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:65:\"/home/themeswpn/public_html/Zilom/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:144;}");

/* INSERT TABLE DATA: wp_options */
INSERT INTO `wp_options` VALUES("1", "siteurl", "https://themes.wpnovin.com/Zilom", "yes");
INSERT INTO `wp_options` VALUES("2", "home", "https://themes.wpnovin.com/Zilom", "yes");
INSERT INTO `wp_options` VALUES("3", "blogname", "قالب وردپرس آموزشی زیلوم", "yes");
INSERT INTO `wp_options` VALUES("4", "blogdescription", "یک سایت دیگر با وردپرس فارسی", "yes");
INSERT INTO `wp_options` VALUES("5", "users_can_register", "0", "yes");
INSERT INTO `wp_options` VALUES("6", "admin_email", "wpnovin.ir@gmail.com", "yes");
INSERT INTO `wp_options` VALUES("7", "start_of_week", "6", "yes");
INSERT INTO `wp_options` VALUES("8", "use_balanceTags", "0", "yes");
INSERT INTO `wp_options` VALUES("9", "use_smilies", "1", "yes");
INSERT INTO `wp_options` VALUES("10", "require_name_email", "1", "yes");
INSERT INTO `wp_options` VALUES("11", "comments_notify", "1", "yes");
INSERT INTO `wp_options` VALUES("12", "posts_per_rss", "10", "yes");
INSERT INTO `wp_options` VALUES("13", "rss_use_excerpt", "0", "yes");
INSERT INTO `wp_options` VALUES("14", "mailserver_url", "mail.example.com", "yes");
INSERT INTO `wp_options` VALUES("15", "mailserver_login", "login@example.com", "yes");
INSERT INTO `wp_options` VALUES("16", "mailserver_pass", "password", "yes");
INSERT INTO `wp_options` VALUES("17", "mailserver_port", "110", "yes");
INSERT INTO `wp_options` VALUES("18", "default_category", "1", "yes");
INSERT INTO `wp_options` VALUES("19", "default_comment_status", "open", "yes");
INSERT INTO `wp_options` VALUES("20", "default_ping_status", "open", "yes");
INSERT INTO `wp_options` VALUES("21", "default_pingback_flag", "1", "yes");
INSERT INTO `wp_options` VALUES("22", "posts_per_page", "10", "yes");
INSERT INTO `wp_options` VALUES("23", "date_format", "F j, Y", "yes");
INSERT INTO `wp_options` VALUES("24", "time_format", "g:i a", "yes");
INSERT INTO `wp_options` VALUES("25", "links_updated_date_format", "F j, Y g:i a", "yes");
INSERT INTO `wp_options` VALUES("26", "comment_moderation", "0", "yes");
INSERT INTO `wp_options` VALUES("27", "moderation_notify", "1", "yes");
INSERT INTO `wp_options` VALUES("28", "permalink_structure", "/%postname%/", "yes");
INSERT INTO `wp_options` VALUES("29", "rewrite_rules", "a:671:{s:28:\"tribe/events/kitchen-sink/?$\";s:69:\"index.php?post_type=tribe_events&tribe_events_views_kitchen_sink=page\";s:93:\"tribe/events/kitchen-sink/(page|grid|typographical|elements|events-bar|navigation|manager)/?$\";s:76:\"index.php?post_type=tribe_events&tribe_events_views_kitchen_sink=$matches[1]\";s:28:\"event-aggregator/(insert)/?$\";s:53:\"index.php?tribe-aggregator=1&tribe-action=$matches[1]\";s:25:\"(?:event)/([^/]+)/ical/?$\";s:56:\"index.php?ical=1&name=$matches[1]&post_type=tribe_events\";s:62:\"(?:events)/(?:page|صفحه|%D8%B5%D9%81%D8%AD%D9%87)/(\\d+)/?$\";s:71:\"index.php?post_type=tribe_events&eventDisplay=default&paged=$matches[1]\";s:100:\"(?:events)/(?:featured|%d9%88%db%8c%da%98%d9%87)/(?:page|صفحه|%D8%B5%D9%81%D8%AD%D9%87)/(\\d+)/?$\";s:79:\"index.php?post_type=tribe_events&featured=1&eventDisplay=list&paged=$matches[1]\";s:38:\"(?:events)/(feed|rdf|rss|rss2|atom)/?$\";s:67:\"index.php?post_type=tribe_events&eventDisplay=list&feed=$matches[1]\";s:76:\"(?:events)/(?:featured|%d9%88%db%8c%da%98%d9%87)/(feed|rdf|rss|rss2|atom)/?$\";s:78:\"index.php?post_type=tribe_events&featured=1&eventDisplay=list&feed=$matches[1]\";s:42:\"(?:events)/(?:month|%d9%85%d8%a7%d9%87)/?$\";s:51:\"index.php?post_type=tribe_events&eventDisplay=month\";s:80:\"(?:events)/(?:month|%d9%85%d8%a7%d9%87)/(?:featured|%d9%88%db%8c%da%98%d9%87)/?$\";s:62:\"index.php?post_type=tribe_events&eventDisplay=month&featured=1\";s:56:\"(?:events)/(?:month|%d9%85%d8%a7%d9%87)/(\\d{4}-\\d{2})/?$\";s:73:\"index.php?post_type=tribe_events&eventDisplay=month&eventDate=$matches[1]\";s:102:\"(?:events)/(?:list|%d9%81%d9%87%d8%b1%d8%b3%d8%aa)/(?:page|صفحه|%D8%B5%D9%81%D8%AD%D9%87)/(\\d+)/?$\";s:68:\"index.php?post_type=tribe_events&eventDisplay=list&paged=$matches[1]\";s:140:\"(?:events)/(?:list|%d9%81%d9%87%d8%b1%d8%b3%d8%aa)/(?:featured|%d9%88%db%8c%da%98%d9%87)/(?:page|صفحه|%D8%B5%D9%81%D8%AD%D9%87)/(\\d+)/?$\";s:79:\"index.php?post_type=tribe_events&eventDisplay=list&featured=1&paged=$matches[1]\";s:53:\"(?:events)/(?:list|%d9%81%d9%87%d8%b1%d8%b3%d8%aa)/?$\";s:50:\"index.php?post_type=tribe_events&eventDisplay=list\";s:91:\"(?:events)/(?:list|%d9%81%d9%87%d8%b1%d8%b3%d8%aa)/(?:featured|%d9%88%db%8c%da%98%d9%87)/?$\";s:61:\"index.php?post_type=tribe_events&eventDisplay=list&featured=1\";s:54:\"(?:events)/(?:today|%d8%a7%d9%85%d8%b1%d9%88%d8%b2)/?$\";s:49:\"index.php?post_type=tribe_events&eventDisplay=day\";s:92:\"(?:events)/(?:today|%d8%a7%d9%85%d8%b1%d9%88%d8%b2)/(?:featured|%d9%88%db%8c%da%98%d9%87)/?$\";s:60:\"index.php?post_type=tribe_events&eventDisplay=day&featured=1\";s:27:\"(?:events)/(\\d{4}-\\d{2})/?$\";s:73:\"index.php?post_type=tribe_events&eventDisplay=month&eventDate=$matches[1]\";s:65:\"(?:events)/(\\d{4}-\\d{2})/(?:featured|%d9%88%db%8c%da%98%d9%87)/?$\";s:84:\"index.php?post_type=tribe_events&eventDisplay=month&eventDate=$matches[1]&featured=1\";s:33:\"(?:events)/(\\d{4}-\\d{2}-\\d{2})/?$\";s:71:\"index.php?post_type=tribe_events&eventDisplay=day&eventDate=$matches[1]\";s:71:\"(?:events)/(\\d{4}-\\d{2}-\\d{2})/(?:featured|%d9%88%db%8c%da%98%d9%87)/?$\";s:82:\"index.php?post_type=tribe_events&eventDisplay=day&eventDate=$matches[1]&featured=1\";s:51:\"(?:events)/(?:featured|%d9%88%db%8c%da%98%d9%87)/?$\";s:43:\"index.php?post_type=tribe_events&featured=1\";s:13:\"(?:events)/?$\";s:53:\"index.php?post_type=tribe_events&eventDisplay=default\";s:18:\"(?:events)/ical/?$\";s:39:\"index.php?post_type=tribe_events&ical=1\";s:56:\"(?:events)/(?:featured|%d9%88%db%8c%da%98%d9%87)/ical/?$\";s:50:\"index.php?post_type=tribe_events&ical=1&featured=1\";s:38:\"(?:events)/(\\d{4}-\\d{2}-\\d{2})/ical/?$\";s:78:\"index.php?post_type=tribe_events&ical=1&eventDisplay=day&eventDate=$matches[1]\";s:76:\"(?:events)/(\\d{4}-\\d{2}-\\d{2})/ical/(?:featured|%d9%88%db%8c%da%98%d9%87)/?$\";s:89:\"index.php?post_type=tribe_events&ical=1&eventDisplay=day&eventDate=$matches[1]&featured=1\";s:145:\"(?:events)/(?:category|%d8%af%d8%b3%d8%aa%d9%87\\-%d8%a8%d9%86%d8%af%db%8c)/(?:[^/]+/)*([^/]+)/(?:page|صفحه|%D8%B5%D9%81%D8%AD%D9%87)/(\\d+)/?$\";s:97:\"index.php?post_type=tribe_events&tribe_events_cat=$matches[1]&eventDisplay=list&paged=$matches[2]\";s:183:\"(?:events)/(?:category|%d8%af%d8%b3%d8%aa%d9%87\\-%d8%a8%d9%86%d8%af%db%8c)/(?:[^/]+/)*([^/]+)/(?:featured|%d9%88%db%8c%da%98%d9%87)/(?:page|صفحه|%D8%B5%D9%81%D8%AD%D9%87)/(\\d+)/?$\";s:108:\"index.php?post_type=tribe_events&tribe_events_cat=$matches[1]&featured=1&eventDisplay=list&paged=$matches[2]\";s:125:\"(?:events)/(?:category|%d8%af%d8%b3%d8%aa%d9%87\\-%d8%a8%d9%86%d8%af%db%8c)/(?:[^/]+/)*([^/]+)/(?:month|%d9%85%d8%a7%d9%87)/?$\";s:80:\"index.php?post_type=tribe_events&tribe_events_cat=$matches[1]&eventDisplay=month\";s:163:\"(?:events)/(?:category|%d8%af%d8%b3%d8%aa%d9%87\\-%d8%a8%d9%86%d8%af%db%8c)/(?:[^/]+/)*([^/]+)/(?:month|%d9%85%d8%a7%d9%87)/(?:featured|%d9%88%db%8c%da%98%d9%87)/?$\";s:91:\"index.php?post_type=tribe_events&tribe_events_cat=$matches[1]&eventDisplay=month&featured=1\";s:185:\"(?:events)/(?:category|%d8%af%d8%b3%d8%aa%d9%87\\-%d8%a8%d9%86%d8%af%db%8c)/(?:[^/]+/)*([^/]+)/(?:list|%d9%81%d9%87%d8%b1%d8%b3%d8%aa)/(?:page|صفحه|%D8%B5%D9%81%D8%AD%D9%87)/(\\d+)/?$\";s:97:\"index.php?post_type=tribe_events&tribe_events_cat=$matches[1]&eventDisplay=list&paged=$matches[2]\";s:223:\"(?:events)/(?:category|%d8%af%d8%b3%d8%aa%d9%87\\-%d8%a8%d9%86%d8%af%db%8c)/(?:[^/]+/)*([^/]+)/(?:list|%d9%81%d9%87%d8%b1%d8%b3%d8%aa)/(?:featured|%d9%88%db%8c%da%98%d9%87)/(?:page|صفحه|%D8%B5%D9%81%D8%AD%D9%87)/(\\d+)/?$\";s:108:\"index.php?post_type=tribe_events&tribe_events_cat=$matches[1]&eventDisplay=list&featured=1&paged=$matches[2]\";s:136:\"(?:events)/(?:category|%d8%af%d8%b3%d8%aa%d9%87\\-%d8%a8%d9%86%d8%af%db%8c)/(?:[^/]+/)*([^/]+)/(?:list|%d9%81%d9%87%d8%b1%d8%b3%d8%aa)/?$\";s:79:\"index.php?post_type=tribe_events&tribe_events_cat=$matches[1]&eventDisplay=list\";s:174:\"(?:events)/(?:category|%d8%af%d8%b3%d8%aa%d9%87\\-%d8%a8%d9%86%d8%af%db%8c)/(?:[^/]+/)*([^/]+)/(?:list|%d9%81%d9%87%d8%b1%d8%b3%d8%aa)/(?:featured|%d9%88%db%8c%da%98%d9%87)/?$\";s:90:\"index.php?post_type=tribe_events&tribe_events_cat=$matches[1]&eventDisplay=list&featured=1\";s:137:\"(?:events)/(?:category|%d8%af%d8%b3%d8%aa%d9%87\\-%d8%a8%d9%86%d8%af%db%8c)/(?:[^/]+/)*([^/]+)/(?:today|%d8%a7%d9%85%d8%b1%d9%88%d8%b2)/?$\";s:78:\"index.php?post_type=tribe_events&tribe_events_cat=$matches[1]&eventDisplay=day\";s:175:\"(?:events)/(?:category|%d8%af%d8%b3%d8%aa%d9%87\\-%d8%a8%d9%86%d8%af%db%8c)/(?:[^/]+/)*([^/]+)/(?:today|%d8%a7%d9%85%d8%b1%d9%88%d8%b2)/(?:featured|%d9%88%db%8c%da%98%d9%87)/?$\";s:89:\"index.php?post_type=tribe_events&tribe_events_cat=$matches[1]&eventDisplay=day&featured=1\";s:143:\"(?:events)/(?:category|%d8%af%d8%b3%d8%aa%d9%87\\-%d8%a8%d9%86%d8%af%db%8c)/(?:[^/]+/)*([^/]+)/(?:day|%d8%b1%d9%88%d8%b2)/(\\d{4}-\\d{2}-\\d{2})/?$\";s:100:\"index.php?post_type=tribe_events&tribe_events_cat=$matches[1]&eventDisplay=day&eventDate=$matches[2]\";s:181:\"(?:events)/(?:category|%d8%af%d8%b3%d8%aa%d9%87\\-%d8%a8%d9%86%d8%af%db%8c)/(?:[^/]+/)*([^/]+)/(?:day|%d8%b1%d9%88%d8%b2)/(\\d{4}-\\d{2}-\\d{2})/(?:featured|%d9%88%db%8c%da%98%d9%87)/?$\";s:111:\"index.php?post_type=tribe_events&tribe_events_cat=$matches[1]&eventDisplay=day&eventDate=$matches[2]&featured=1\";s:110:\"(?:events)/(?:category|%d8%af%d8%b3%d8%aa%d9%87\\-%d8%a8%d9%86%d8%af%db%8c)/(?:[^/]+/)*([^/]+)/(\\d{4}-\\d{2})/?$\";s:102:\"index.php?post_type=tribe_events&tribe_events_cat=$matches[1]&eventDisplay=month&eventDate=$matches[2]\";s:148:\"(?:events)/(?:category|%d8%af%d8%b3%d8%aa%d9%87\\-%d8%a8%d9%86%d8%af%db%8c)/(?:[^/]+/)*([^/]+)/(\\d{4}-\\d{2})/(?:featured|%d9%88%db%8c%da%98%d9%87)/?$\";s:113:\"index.php?post_type=tribe_events&tribe_events_cat=$matches[1]&eventDisplay=month&eventDate=$matches[2]&featured=1\";s:116:\"(?:events)/(?:category|%d8%af%d8%b3%d8%aa%d9%87\\-%d8%a8%d9%86%d8%af%db%8c)/(?:[^/]+/)*([^/]+)/(\\d{4}-\\d{2}-\\d{2})/?$\";s:100:\"index.php?post_type=tribe_events&tribe_events_cat=$matches[1]&eventDisplay=day&eventDate=$matches[2]\";s:154:\"(?:events)/(?:category|%d8%af%d8%b3%d8%aa%d9%87\\-%d8%a8%d9%86%d8%af%db%8c)/(?:[^/]+/)*([^/]+)/(\\d{4}-\\d{2}-\\d{2})/(?:featured|%d9%88%db%8c%da%98%d9%87)/?$\";s:111:\"index.php?post_type=tribe_events&tribe_events_cat=$matches[1]&eventDisplay=day&eventDate=$matches[2]&featured=1\";s:101:\"(?:events)/(?:category|%d8%af%d8%b3%d8%aa%d9%87\\-%d8%a8%d9%86%d8%af%db%8c)/(?:[^/]+/)*([^/]+)/feed/?$\";s:89:\"index.php?post_type=tribe_events&tribe_events_cat=$matches[1]&eventDisplay=list&feed=rss2\";s:139:\"(?:events)/(?:category|%d8%af%d8%b3%d8%aa%d9%87\\-%d8%a8%d9%86%d8%af%db%8c)/(?:[^/]+/)*([^/]+)/(?:featured|%d9%88%db%8c%da%98%d9%87)/feed/?$\";s:100:\"index.php?post_type=tribe_events&tribe_events_cat=$matches[1]&featured=1&eventDisplay=list&feed=rss2\";s:101:\"(?:events)/(?:category|%d8%af%d8%b3%d8%aa%d9%87\\-%d8%a8%d9%86%d8%af%db%8c)/(?:[^/]+/)*([^/]+)/ical/?$\";s:68:\"index.php?post_type=tribe_events&tribe_events_cat=$matches[1]&ical=1\";s:139:\"(?:events)/(?:category|%d8%af%d8%b3%d8%aa%d9%87\\-%d8%a8%d9%86%d8%af%db%8c)/(?:[^/]+/)*([^/]+)/(?:featured|%d9%88%db%8c%da%98%d9%87)/ical/?$\";s:79:\"index.php?post_type=tribe_events&tribe_events_cat=$matches[1]&featured=1&ical=1\";s:126:\"(?:events)/(?:category|%d8%af%d8%b3%d8%aa%d9%87\\-%d8%a8%d9%86%d8%af%db%8c)/(?:[^/]+/)*([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:78:\"index.php?post_type=tribe_events&tribe_events_cat=$matches[1]&feed=$matches[2]\";s:164:\"(?:events)/(?:category|%d8%af%d8%b3%d8%aa%d9%87\\-%d8%a8%d9%86%d8%af%db%8c)/(?:[^/]+/)*([^/]+)/(?:featured|%d9%88%db%8c%da%98%d9%87)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:89:\"index.php?post_type=tribe_events&tribe_events_cat=$matches[1]&featured=1&feed=$matches[2]\";s:134:\"(?:events)/(?:category|%d8%af%d8%b3%d8%aa%d9%87\\-%d8%a8%d9%86%d8%af%db%8c)/(?:[^/]+/)*([^/]+)/(?:featured|%d9%88%db%8c%da%98%d9%87)/?$\";s:93:\"index.php?post_type=tribe_events&tribe_events_cat=$matches[1]&featured=1&eventDisplay=default\";s:96:\"(?:events)/(?:category|%d8%af%d8%b3%d8%aa%d9%87\\-%d8%a8%d9%86%d8%af%db%8c)/(?:[^/]+/)*([^/]+)/?$\";s:82:\"index.php?post_type=tribe_events&tribe_events_cat=$matches[1]&eventDisplay=default\";s:129:\"(?:events)/(?:tag|%d8%a8%d8%b1%da%86%d8%b3%d8%a8\\-%d8%b2%d8%af%d9%86)/([^/]+)/(?:page|صفحه|%D8%B5%D9%81%D8%AD%D9%87)/(\\d+)/?$\";s:84:\"index.php?post_type=tribe_events&tag=$matches[1]&eventDisplay=list&paged=$matches[2]\";s:167:\"(?:events)/(?:tag|%d8%a8%d8%b1%da%86%d8%b3%d8%a8\\-%d8%b2%d8%af%d9%86)/([^/]+)/(?:featured|%d9%88%db%8c%da%98%d9%87)/(?:page|صفحه|%D8%B5%D9%81%D8%AD%D9%87)/(\\d+)/?$\";s:95:\"index.php?post_type=tribe_events&tag=$matches[1]&featured=1&eventDisplay=list&paged=$matches[2]\";s:109:\"(?:events)/(?:tag|%d8%a8%d8%b1%da%86%d8%b3%d8%a8\\-%d8%b2%d8%af%d9%86)/([^/]+)/(?:month|%d9%85%d8%a7%d9%87)/?$\";s:67:\"index.php?post_type=tribe_events&tag=$matches[1]&eventDisplay=month\";s:147:\"(?:events)/(?:tag|%d8%a8%d8%b1%da%86%d8%b3%d8%a8\\-%d8%b2%d8%af%d9%86)/([^/]+)/(?:month|%d9%85%d8%a7%d9%87)/(?:featured|%d9%88%db%8c%da%98%d9%87)/?$\";s:78:\"index.php?post_type=tribe_events&tag=$matches[1]&eventDisplay=month&featured=1\";s:169:\"(?:events)/(?:tag|%d8%a8%d8%b1%da%86%d8%b3%d8%a8\\-%d8%b2%d8%af%d9%86)/([^/]+)/(?:list|%d9%81%d9%87%d8%b1%d8%b3%d8%aa)/(?:page|صفحه|%D8%B5%D9%81%D8%AD%D9%87)/(\\d+)/?$\";s:84:\"index.php?post_type=tribe_events&tag=$matches[1]&eventDisplay=list&paged=$matches[2]\";s:207:\"(?:events)/(?:tag|%d8%a8%d8%b1%da%86%d8%b3%d8%a8\\-%d8%b2%d8%af%d9%86)/([^/]+)/(?:list|%d9%81%d9%87%d8%b1%d8%b3%d8%aa)/(?:featured|%d9%88%db%8c%da%98%d9%87)/(?:page|صفحه|%D8%B5%D9%81%D8%AD%D9%87)/(\\d+)/?$\";s:95:\"index.php?post_type=tribe_events&tag=$matches[1]&eventDisplay=list&featured=1&paged=$matches[2]\";s:120:\"(?:events)/(?:tag|%d8%a8%d8%b1%da%86%d8%b3%d8%a8\\-%d8%b2%d8%af%d9%86)/([^/]+)/(?:list|%d9%81%d9%87%d8%b1%d8%b3%d8%aa)/?$\";s:66:\"index.php?post_type=tribe_events&tag=$matches[1]&eventDisplay=list\";s:158:\"(?:events)/(?:tag|%d8%a8%d8%b1%da%86%d8%b3%d8%a8\\-%d8%b2%d8%af%d9%86)/([^/]+)/(?:list|%d9%81%d9%87%d8%b1%d8%b3%d8%aa)/(?:featured|%d9%88%db%8c%da%98%d9%87)/?$\";s:77:\"index.php?post_type=tribe_events&tag=$matches[1]&eventDisplay=list&featured=1\";s:121:\"(?:events)/(?:tag|%d8%a8%d8%b1%da%86%d8%b3%d8%a8\\-%d8%b2%d8%af%d9%86)/([^/]+)/(?:today|%d8%a7%d9%85%d8%b1%d9%88%d8%b2)/?$\";s:65:\"index.php?post_type=tribe_events&tag=$matches[1]&eventDisplay=day\";s:159:\"(?:events)/(?:tag|%d8%a8%d8%b1%da%86%d8%b3%d8%a8\\-%d8%b2%d8%af%d9%86)/([^/]+)/(?:today|%d8%a7%d9%85%d8%b1%d9%88%d8%b2)/(?:featured|%d9%88%db%8c%da%98%d9%87)/?$\";s:76:\"index.php?post_type=tribe_events&tag=$matches[1]&eventDisplay=day&featured=1\";s:127:\"(?:events)/(?:tag|%d8%a8%d8%b1%da%86%d8%b3%d8%a8\\-%d8%b2%d8%af%d9%86)/([^/]+)/(?:day|%d8%b1%d9%88%d8%b2)/(\\d{4}-\\d{2}-\\d{2})/?$\";s:87:\"index.php?post_type=tribe_events&tag=$matches[1]&eventDisplay=day&eventDate=$matches[2]\";s:165:\"(?:events)/(?:tag|%d8%a8%d8%b1%da%86%d8%b3%d8%a8\\-%d8%b2%d8%af%d9%86)/([^/]+)/(?:day|%d8%b1%d9%88%d8%b2)/(\\d{4}-\\d{2}-\\d{2})/(?:featured|%d9%88%db%8c%da%98%d9%87)/?$\";s:98:\"index.php?post_type=tribe_events&tag=$matches[1]&eventDisplay=day&eventDate=$matches[2]&featured=1\";s:94:\"(?:events)/(?:tag|%d8%a8%d8%b1%da%86%d8%b3%d8%a8\\-%d8%b2%d8%af%d9%86)/([^/]+)/(\\d{4}-\\d{2})/?$\";s:89:\"index.php?post_type=tribe_events&tag=$matches[1]&eventDisplay=month&eventDate=$matches[2]\";s:132:\"(?:events)/(?:tag|%d8%a8%d8%b1%da%86%d8%b3%d8%a8\\-%d8%b2%d8%af%d9%86)/([^/]+)/(\\d{4}-\\d{2})/(?:featured|%d9%88%db%8c%da%98%d9%87)/?$\";s:100:\"index.php?post_type=tribe_events&tag=$matches[1]&eventDisplay=month&eventDate=$matches[2]&featured=1\";s:100:\"(?:events)/(?:tag|%d8%a8%d8%b1%da%86%d8%b3%d8%a8\\-%d8%b2%d8%af%d9%86)/([^/]+)/(\\d{4}-\\d{2}-\\d{2})/?$\";s:87:\"index.php?post_type=tribe_events&tag=$matches[1]&eventDisplay=day&eventDate=$matches[2]\";s:138:\"(?:events)/(?:tag|%d8%a8%d8%b1%da%86%d8%b3%d8%a8\\-%d8%b2%d8%af%d9%86)/([^/]+)/(\\d{4}-\\d{2}-\\d{2})/(?:featured|%d9%88%db%8c%da%98%d9%87)/?$\";s:98:\"index.php?post_type=tribe_events&tag=$matches[1]&eventDisplay=day&eventDate=$matches[2]&featured=1\";s:85:\"(?:events)/(?:tag|%d8%a8%d8%b1%da%86%d8%b3%d8%a8\\-%d8%b2%d8%af%d9%86)/([^/]+)/feed/?$\";s:76:\"index.php?post_type=tribe_events&tag=$matches[1]&eventDisplay=list&feed=rss2\";s:123:\"(?:events)/(?:tag|%d8%a8%d8%b1%da%86%d8%b3%d8%a8\\-%d8%b2%d8%af%d9%86)/([^/]+)/(?:featured|%d9%88%db%8c%da%98%d9%87)/feed/?$\";s:87:\"index.php?post_type=tribe_events&tag=$matches[1]&eventDisplay=list&feed=rss2&featured=1\";s:85:\"(?:events)/(?:tag|%d8%a8%d8%b1%da%86%d8%b3%d8%a8\\-%d8%b2%d8%af%d9%86)/([^/]+)/ical/?$\";s:55:\"index.php?post_type=tribe_events&tag=$matches[1]&ical=1\";s:123:\"(?:events)/(?:tag|%d8%a8%d8%b1%da%86%d8%b3%d8%a8\\-%d8%b2%d8%af%d9%86)/([^/]+)/(?:featured|%d9%88%db%8c%da%98%d9%87)/ical/?$\";s:66:\"index.php?post_type=tribe_events&tag=$matches[1]&featured=1&ical=1\";s:110:\"(?:events)/(?:tag|%d8%a8%d8%b1%da%86%d8%b3%d8%a8\\-%d8%b2%d8%af%d9%86)/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:65:\"index.php?post_type=tribe_events&tag=$matches[1]&feed=$matches[2]\";s:148:\"(?:events)/(?:tag|%d8%a8%d8%b1%da%86%d8%b3%d8%a8\\-%d8%b2%d8%af%d9%86)/([^/]+)/(?:featured|%d9%88%db%8c%da%98%d9%87)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:76:\"index.php?post_type=tribe_events&tag=$matches[1]&featured=1&feed=$matches[2]\";s:118:\"(?:events)/(?:tag|%d8%a8%d8%b1%da%86%d8%b3%d8%a8\\-%d8%b2%d8%af%d9%86)/([^/]+)/(?:featured|%d9%88%db%8c%da%98%d9%87)/?$\";s:59:\"index.php?post_type=tribe_events&tag=$matches[1]&featured=1\";s:80:\"(?:events)/(?:tag|%d8%a8%d8%b1%da%86%d8%b3%d8%a8\\-%d8%b2%d8%af%d9%86)/([^/]+)/?$\";s:69:\"index.php?post_type=tribe_events&tag=$matches[1]&eventDisplay=default\";s:29:\"courses/(.+?)/lesson/(.+?)/?$\";s:43:\"index.php?post_type=lesson&name=$matches[2]\";s:30:\"courses/(.+?)/quizzes/(.+?)/?$\";s:47:\"index.php?post_type=tutor_quiz&name=$matches[2]\";s:34:\"courses/(.+?)/assignments/(.+?)/?$\";s:54:\"index.php?post_type=tutor_assignments&name=$matches[2]\";s:35:\"courses/(.+?)/zoom-lessons/(.+?)/?$\";s:55:\"index.php?post_type=tutor_zoom_meeting&name=$matches[2]\";s:35:\"courses/(.+?)/meet-lessons/(.+?)/?$\";s:54:\"index.php?post_type=tutor-google-meet&name=$matches[2]\";s:18:\"video-url/(.+?)/?$\";s:61:\"index.php?post_type=lesson&lesson_video=true&name=$matches[1]\";s:16:\"profile/(.+?)/?$\";s:44:\"index.php?tutor_profile_username=$matches[1]\";s:20:\"(dashboard)/index/?$\";s:57:\"index.php?pagename=$matches[1]&tutor_dashboard_page=index\";s:26:\"(dashboard)/index/(.+?)/?$\";s:94:\"index.php?pagename=$matches[1]&tutor_dashboard_page=index&tutor_dashboard_sub_page=$matches[2]\";s:25:\"(dashboard)/my-profile/?$\";s:62:\"index.php?pagename=$matches[1]&tutor_dashboard_page=my-profile\";s:31:\"(dashboard)/my-profile/(.+?)/?$\";s:99:\"index.php?pagename=$matches[1]&tutor_dashboard_page=my-profile&tutor_dashboard_sub_page=$matches[2]\";s:31:\"(dashboard)/enrolled-courses/?$\";s:68:\"index.php?pagename=$matches[1]&tutor_dashboard_page=enrolled-courses\";s:37:\"(dashboard)/enrolled-courses/(.+?)/?$\";s:105:\"index.php?pagename=$matches[1]&tutor_dashboard_page=enrolled-courses&tutor_dashboard_sub_page=$matches[2]\";s:23:\"(dashboard)/wishlist/?$\";s:60:\"index.php?pagename=$matches[1]&tutor_dashboard_page=wishlist\";s:29:\"(dashboard)/wishlist/(.+?)/?$\";s:97:\"index.php?pagename=$matches[1]&tutor_dashboard_page=wishlist&tutor_dashboard_sub_page=$matches[2]\";s:22:\"(dashboard)/reviews/?$\";s:59:\"index.php?pagename=$matches[1]&tutor_dashboard_page=reviews\";s:28:\"(dashboard)/reviews/(.+?)/?$\";s:96:\"index.php?pagename=$matches[1]&tutor_dashboard_page=reviews&tutor_dashboard_sub_page=$matches[2]\";s:31:\"(dashboard)/my-quiz-attempts/?$\";s:68:\"index.php?pagename=$matches[1]&tutor_dashboard_page=my-quiz-attempts\";s:37:\"(dashboard)/my-quiz-attempts/(.+?)/?$\";s:105:\"index.php?pagename=$matches[1]&tutor_dashboard_page=my-quiz-attempts&tutor_dashboard_sub_page=$matches[2]\";s:31:\"(dashboard)/purchase_history/?$\";s:68:\"index.php?pagename=$matches[1]&tutor_dashboard_page=purchase_history\";s:37:\"(dashboard)/purchase_history/(.+?)/?$\";s:105:\"index.php?pagename=$matches[1]&tutor_dashboard_page=purchase_history&tutor_dashboard_sub_page=$matches[2]\";s:30:\"(dashboard)/question-answer/?$\";s:67:\"index.php?pagename=$matches[1]&tutor_dashboard_page=question-answer\";s:36:\"(dashboard)/question-answer/(.+?)/?$\";s:104:\"index.php?pagename=$matches[1]&tutor_dashboard_page=question-answer&tutor_dashboard_sub_page=$matches[2]\";s:26:\"(dashboard)/separator-1/?$\";s:63:\"index.php?pagename=$matches[1]&tutor_dashboard_page=separator-1\";s:32:\"(dashboard)/separator-1/(.+?)/?$\";s:100:\"index.php?pagename=$matches[1]&tutor_dashboard_page=separator-1&tutor_dashboard_sub_page=$matches[2]\";s:28:\"(dashboard)/create-course/?$\";s:65:\"index.php?pagename=$matches[1]&tutor_dashboard_page=create-course\";s:34:\"(dashboard)/create-course/(.+?)/?$\";s:102:\"index.php?pagename=$matches[1]&tutor_dashboard_page=create-course&tutor_dashboard_sub_page=$matches[2]\";s:28:\"(dashboard)/create-bundle/?$\";s:65:\"index.php?pagename=$matches[1]&tutor_dashboard_page=create-bundle\";s:34:\"(dashboard)/create-bundle/(.+?)/?$\";s:102:\"index.php?pagename=$matches[1]&tutor_dashboard_page=create-bundle&tutor_dashboard_sub_page=$matches[2]\";s:25:\"(dashboard)/my-courses/?$\";s:62:\"index.php?pagename=$matches[1]&tutor_dashboard_page=my-courses\";s:31:\"(dashboard)/my-courses/(.+?)/?$\";s:99:\"index.php?pagename=$matches[1]&tutor_dashboard_page=my-courses&tutor_dashboard_sub_page=$matches[2]\";s:28:\"(dashboard)/announcements/?$\";s:65:\"index.php?pagename=$matches[1]&tutor_dashboard_page=announcements\";s:34:\"(dashboard)/announcements/(.+?)/?$\";s:102:\"index.php?pagename=$matches[1]&tutor_dashboard_page=announcements&tutor_dashboard_sub_page=$matches[2]\";s:23:\"(dashboard)/withdraw/?$\";s:60:\"index.php?pagename=$matches[1]&tutor_dashboard_page=withdraw\";s:29:\"(dashboard)/withdraw/(.+?)/?$\";s:97:\"index.php?pagename=$matches[1]&tutor_dashboard_page=withdraw&tutor_dashboard_sub_page=$matches[2]\";s:28:\"(dashboard)/quiz-attempts/?$\";s:65:\"index.php?pagename=$matches[1]&tutor_dashboard_page=quiz-attempts\";s:34:\"(dashboard)/quiz-attempts/(.+?)/?$\";s:102:\"index.php?pagename=$matches[1]&tutor_dashboard_page=quiz-attempts&tutor_dashboard_sub_page=$matches[2]\";s:26:\"(dashboard)/separator-2/?$\";s:63:\"index.php?pagename=$matches[1]&tutor_dashboard_page=separator-2\";s:32:\"(dashboard)/separator-2/(.+?)/?$\";s:100:\"index.php?pagename=$matches[1]&tutor_dashboard_page=separator-2&tutor_dashboard_sub_page=$matches[2]\";s:23:\"(dashboard)/settings/?$\";s:60:\"index.php?pagename=$matches[1]&tutor_dashboard_page=settings\";s:29:\"(dashboard)/settings/(.+?)/?$\";s:97:\"index.php?pagename=$matches[1]&tutor_dashboard_page=settings&tutor_dashboard_sub_page=$matches[2]\";s:21:\"(dashboard)/logout/?$\";s:58:\"index.php?pagename=$matches[1]&tutor_dashboard_page=logout\";s:27:\"(dashboard)/logout/(.+?)/?$\";s:95:\"index.php?pagename=$matches[1]&tutor_dashboard_page=logout&tutor_dashboard_sub_page=$matches[2]\";s:32:\"(dashboard)/retrieve-password/?$\";s:69:\"index.php?pagename=$matches[1]&tutor_dashboard_page=retrieve-password\";s:38:\"(dashboard)/retrieve-password/(.+?)/?$\";s:106:\"index.php?pagename=$matches[1]&tutor_dashboard_page=retrieve-password&tutor_dashboard_sub_page=$matches[2]\";s:24:\"^wc-auth/v([1]{1})/(.*)?\";s:63:\"index.php?wc-auth-version=$matches[1]&wc-auth-route=$matches[2]\";s:22:\"^wc-api/v([1-3]{1})/?$\";s:51:\"index.php?wc-api-version=$matches[1]&wc-api-route=/\";s:24:\"^wc-api/v([1-3]{1})(.*)?\";s:61:\"index.php?wc-api-version=$matches[1]&wc-api-route=$matches[2]\";s:21:\"^wc/file/transient/?$\";s:33:\"index.php?wc-transient-file-name=\";s:24:\"^wc/file/transient/(.+)$\";s:44:\"index.php?wc-transient-file-name=$matches[1]\";s:7:\"shop/?$\";s:27:\"index.php?post_type=product\";s:37:\"shop/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=product&feed=$matches[1]\";s:32:\"shop/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=product&feed=$matches[1]\";s:24:\"shop/page/([0-9]{1,})/?$\";s:45:\"index.php?post_type=product&paged=$matches[1]\";s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:10:\"courses/?$\";s:27:\"index.php?post_type=courses\";s:40:\"courses/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=courses&feed=$matches[1]\";s:35:\"courses/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=courses&feed=$matches[1]\";s:27:\"courses/page/([0-9]{1,})/?$\";s:45:\"index.php?post_type=courses&paged=$matches[1]\";s:9:\"lesson/?$\";s:37:\"index.php?post_type=tutor_assignments\";s:39:\"lesson/feed/(feed|rdf|rss|rss2|atom)/?$\";s:54:\"index.php?post_type=tutor_assignments&feed=$matches[1]\";s:34:\"lesson/(feed|rdf|rss|rss2|atom)/?$\";s:54:\"index.php?post_type=tutor_assignments&feed=$matches[1]\";s:26:\"lesson/page/([0-9]{1,})/?$\";s:55:\"index.php?post_type=tutor_assignments&paged=$matches[1]\";s:9:\"footer/?$\";s:26:\"index.php?post_type=footer\";s:39:\"footer/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?post_type=footer&feed=$matches[1]\";s:34:\"footer/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?post_type=footer&feed=$matches[1]\";s:26:\"footer/page/([0-9]{1,})/?$\";s:44:\"index.php?post_type=footer&paged=$matches[1]\";s:13:\"gva_header/?$\";s:30:\"index.php?post_type=gva_header\";s:43:\"gva_header/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?post_type=gva_header&feed=$matches[1]\";s:38:\"gva_header/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?post_type=gva_header&feed=$matches[1]\";s:30:\"gva_header/page/([0-9]{1,})/?$\";s:48:\"index.php?post_type=gva_header&paged=$matches[1]\";s:7:\"team/?$\";s:28:\"index.php?post_type=gva_team\";s:37:\"team/feed/(feed|rdf|rss|rss2|atom)/?$\";s:45:\"index.php?post_type=gva_team&feed=$matches[1]\";s:32:\"team/(feed|rdf|rss|rss2|atom)/?$\";s:45:\"index.php?post_type=gva_team&feed=$matches[1]\";s:24:\"team/page/([0-9]{1,})/?$\";s:46:\"index.php?post_type=gva_team&paged=$matches[1]\";s:12:\"portfolio/?$\";s:29:\"index.php?post_type=portfolio\";s:42:\"portfolio/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?post_type=portfolio&feed=$matches[1]\";s:37:\"portfolio/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?post_type=portfolio&feed=$matches[1]\";s:29:\"portfolio/page/([0-9]{1,})/?$\";s:47:\"index.php?post_type=portfolio&paged=$matches[1]\";s:22:\"tribe-promoter-auth/?$\";s:37:\"index.php?tribe-promoter-auth-check=1\";s:8:\"event/?$\";s:32:\"index.php?post_type=tribe_events\";s:38:\"event/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?post_type=tribe_events&feed=$matches[1]\";s:33:\"event/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?post_type=tribe_events&feed=$matches[1]\";s:25:\"event/page/([0-9]{1,})/?$\";s:50:\"index.php?post_type=tribe_events&paged=$matches[1]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:32:\"category/(.+?)/wc-api(/(.*))?/?$\";s:54:\"index.php?category_name=$matches[1]&wc-api=$matches[3]\";s:43:\"category/(.+?)/wc/file/transient(/(.*))?/?$\";s:65:\"index.php?category_name=$matches[1]&wc/file/transient=$matches[3]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:29:\"tag/([^/]+)/wc-api(/(.*))?/?$\";s:44:\"index.php?tag=$matches[1]&wc-api=$matches[3]\";s:40:\"tag/([^/]+)/wc/file/transient(/(.*))?/?$\";s:55:\"index.php?tag=$matches[1]&wc/file/transient=$matches[3]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:42:\"e-landing-page/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:52:\"e-landing-page/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:72:\"e-landing-page/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"e-landing-page/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"e-landing-page/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:48:\"e-landing-page/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:31:\"e-landing-page/([^/]+)/embed/?$\";s:47:\"index.php?e-landing-page=$matches[1]&embed=true\";s:35:\"e-landing-page/([^/]+)/trackback/?$\";s:41:\"index.php?e-landing-page=$matches[1]&tb=1\";s:43:\"e-landing-page/([^/]+)/page/?([0-9]{1,})/?$\";s:54:\"index.php?e-landing-page=$matches[1]&paged=$matches[2]\";s:50:\"e-landing-page/([^/]+)/comment-page-([0-9]{1,})/?$\";s:54:\"index.php?e-landing-page=$matches[1]&cpage=$matches[2]\";s:40:\"e-landing-page/([^/]+)/wc-api(/(.*))?/?$\";s:55:\"index.php?e-landing-page=$matches[1]&wc-api=$matches[3]\";s:51:\"e-landing-page/([^/]+)/wc/file/transient(/(.*))?/?$\";s:66:\"index.php?e-landing-page=$matches[1]&wc/file/transient=$matches[3]\";s:46:\"e-landing-page/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:57:\"e-landing-page/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:57:\"e-landing-page/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:68:\"e-landing-page/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:39:\"e-landing-page/([^/]+)(?:/([0-9]+))?/?$\";s:53:\"index.php?e-landing-page=$matches[1]&page=$matches[2]\";s:31:\"e-landing-page/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:41:\"e-landing-page/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:61:\"e-landing-page/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"e-landing-page/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"e-landing-page/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:37:\"e-landing-page/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:55:\"product-category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_cat=$matches[1]&feed=$matches[2]\";s:50:\"product-category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_cat=$matches[1]&feed=$matches[2]\";s:31:\"product-category/(.+?)/embed/?$\";s:44:\"index.php?product_cat=$matches[1]&embed=true\";s:43:\"product-category/(.+?)/page/?([0-9]{1,})/?$\";s:51:\"index.php?product_cat=$matches[1]&paged=$matches[2]\";s:25:\"product-category/(.+?)/?$\";s:33:\"index.php?product_cat=$matches[1]\";s:52:\"product-tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_tag=$matches[1]&feed=$matches[2]\";s:47:\"product-tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_tag=$matches[1]&feed=$matches[2]\";s:28:\"product-tag/([^/]+)/embed/?$\";s:44:\"index.php?product_tag=$matches[1]&embed=true\";s:40:\"product-tag/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?product_tag=$matches[1]&paged=$matches[2]\";s:22:\"product-tag/([^/]+)/?$\";s:33:\"index.php?product_tag=$matches[1]\";s:35:\"product/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"product/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"product/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"product/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"product/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"product/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:24:\"product/([^/]+)/embed/?$\";s:40:\"index.php?product=$matches[1]&embed=true\";s:28:\"product/([^/]+)/trackback/?$\";s:34:\"index.php?product=$matches[1]&tb=1\";s:48:\"product/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?product=$matches[1]&feed=$matches[2]\";s:43:\"product/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?product=$matches[1]&feed=$matches[2]\";s:36:\"product/([^/]+)/page/?([0-9]{1,})/?$\";s:47:\"index.php?product=$matches[1]&paged=$matches[2]\";s:43:\"product/([^/]+)/comment-page-([0-9]{1,})/?$\";s:47:\"index.php?product=$matches[1]&cpage=$matches[2]\";s:33:\"product/([^/]+)/wc-api(/(.*))?/?$\";s:48:\"index.php?product=$matches[1]&wc-api=$matches[3]\";s:44:\"product/([^/]+)/wc/file/transient(/(.*))?/?$\";s:59:\"index.php?product=$matches[1]&wc/file/transient=$matches[3]\";s:39:\"product/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:50:\"product/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:50:\"product/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:61:\"product/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:32:\"product/([^/]+)(?:/([0-9]+))?/?$\";s:46:\"index.php?product=$matches[1]&page=$matches[2]\";s:24:\"product/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:34:\"product/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:54:\"product/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"product/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"product/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:30:\"product/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:35:\"courses/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"courses/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"courses/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"courses/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"courses/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"courses/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:24:\"courses/([^/]+)/embed/?$\";s:40:\"index.php?courses=$matches[1]&embed=true\";s:28:\"courses/([^/]+)/trackback/?$\";s:34:\"index.php?courses=$matches[1]&tb=1\";s:48:\"courses/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?courses=$matches[1]&feed=$matches[2]\";s:43:\"courses/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?courses=$matches[1]&feed=$matches[2]\";s:36:\"courses/([^/]+)/page/?([0-9]{1,})/?$\";s:47:\"index.php?courses=$matches[1]&paged=$matches[2]\";s:43:\"courses/([^/]+)/comment-page-([0-9]{1,})/?$\";s:47:\"index.php?courses=$matches[1]&cpage=$matches[2]\";s:33:\"courses/([^/]+)/wc-api(/(.*))?/?$\";s:48:\"index.php?courses=$matches[1]&wc-api=$matches[3]\";s:44:\"courses/([^/]+)/wc/file/transient(/(.*))?/?$\";s:59:\"index.php?courses=$matches[1]&wc/file/transient=$matches[3]\";s:39:\"courses/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:50:\"courses/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:50:\"courses/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:61:\"courses/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:32:\"courses/([^/]+)(?:/([0-9]+))?/?$\";s:46:\"index.php?courses=$matches[1]&page=$matches[2]\";s:24:\"courses/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:34:\"courses/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:54:\"courses/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"courses/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"courses/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:30:\"courses/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:56:\"course-category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:54:\"index.php?course-category=$matches[1]&feed=$matches[2]\";s:51:\"course-category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:54:\"index.php?course-category=$matches[1]&feed=$matches[2]\";s:32:\"course-category/([^/]+)/embed/?$\";s:48:\"index.php?course-category=$matches[1]&embed=true\";s:44:\"course-category/([^/]+)/page/?([0-9]{1,})/?$\";s:55:\"index.php?course-category=$matches[1]&paged=$matches[2]\";s:26:\"course-category/([^/]+)/?$\";s:37:\"index.php?course-category=$matches[1]\";s:51:\"course-tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?course-tag=$matches[1]&feed=$matches[2]\";s:46:\"course-tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?course-tag=$matches[1]&feed=$matches[2]\";s:27:\"course-tag/([^/]+)/embed/?$\";s:43:\"index.php?course-tag=$matches[1]&embed=true\";s:39:\"course-tag/([^/]+)/page/?([0-9]{1,})/?$\";s:50:\"index.php?course-tag=$matches[1]&paged=$matches[2]\";s:21:\"course-tag/([^/]+)/?$\";s:32:\"index.php?course-tag=$matches[1]\";s:34:\"lesson/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:44:\"lesson/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:64:\"lesson/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"lesson/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"lesson/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:40:\"lesson/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:23:\"lesson/([^/]+)/embed/?$\";s:50:\"index.php?tutor_assignments=$matches[1]&embed=true\";s:27:\"lesson/([^/]+)/trackback/?$\";s:44:\"index.php?tutor_assignments=$matches[1]&tb=1\";s:47:\"lesson/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:56:\"index.php?tutor_assignments=$matches[1]&feed=$matches[2]\";s:42:\"lesson/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:56:\"index.php?tutor_assignments=$matches[1]&feed=$matches[2]\";s:35:\"lesson/([^/]+)/page/?([0-9]{1,})/?$\";s:57:\"index.php?tutor_assignments=$matches[1]&paged=$matches[2]\";s:42:\"lesson/([^/]+)/comment-page-([0-9]{1,})/?$\";s:57:\"index.php?tutor_assignments=$matches[1]&cpage=$matches[2]\";s:32:\"lesson/([^/]+)/wc-api(/(.*))?/?$\";s:58:\"index.php?tutor_assignments=$matches[1]&wc-api=$matches[3]\";s:43:\"lesson/([^/]+)/wc/file/transient(/(.*))?/?$\";s:69:\"index.php?tutor_assignments=$matches[1]&wc/file/transient=$matches[3]\";s:38:\"lesson/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:49:\"lesson/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:49:\"lesson/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:60:\"lesson/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:31:\"lesson/([^/]+)(?:/([0-9]+))?/?$\";s:56:\"index.php?tutor_assignments=$matches[1]&page=$matches[2]\";s:23:\"lesson/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:33:\"lesson/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:53:\"lesson/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:48:\"lesson/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:48:\"lesson/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:29:\"lesson/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:34:\"topics/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:44:\"topics/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:64:\"topics/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"topics/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"topics/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:40:\"topics/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:23:\"topics/([^/]+)/embed/?$\";s:54:\"index.php?post_type=topics&name=$matches[1]&embed=true\";s:27:\"topics/([^/]+)/trackback/?$\";s:48:\"index.php?post_type=topics&name=$matches[1]&tb=1\";s:35:\"topics/([^/]+)/page/?([0-9]{1,})/?$\";s:61:\"index.php?post_type=topics&name=$matches[1]&paged=$matches[2]\";s:42:\"topics/([^/]+)/comment-page-([0-9]{1,})/?$\";s:61:\"index.php?post_type=topics&name=$matches[1]&cpage=$matches[2]\";s:32:\"topics/([^/]+)/wc-api(/(.*))?/?$\";s:62:\"index.php?post_type=topics&name=$matches[1]&wc-api=$matches[3]\";s:43:\"topics/([^/]+)/wc/file/transient(/(.*))?/?$\";s:73:\"index.php?post_type=topics&name=$matches[1]&wc/file/transient=$matches[3]\";s:38:\"topics/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:49:\"topics/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:49:\"topics/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:60:\"topics/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:31:\"topics/([^/]+)(?:/([0-9]+))?/?$\";s:60:\"index.php?post_type=topics&name=$matches[1]&page=$matches[2]\";s:23:\"topics/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:33:\"topics/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:53:\"topics/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:48:\"topics/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:48:\"topics/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:29:\"topics/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:42:\"tutor_enrolled/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:52:\"tutor_enrolled/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:72:\"tutor_enrolled/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"tutor_enrolled/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"tutor_enrolled/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:48:\"tutor_enrolled/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:31:\"tutor_enrolled/([^/]+)/embed/?$\";s:62:\"index.php?post_type=tutor_enrolled&name=$matches[1]&embed=true\";s:35:\"tutor_enrolled/([^/]+)/trackback/?$\";s:56:\"index.php?post_type=tutor_enrolled&name=$matches[1]&tb=1\";s:43:\"tutor_enrolled/([^/]+)/page/?([0-9]{1,})/?$\";s:69:\"index.php?post_type=tutor_enrolled&name=$matches[1]&paged=$matches[2]\";s:50:\"tutor_enrolled/([^/]+)/comment-page-([0-9]{1,})/?$\";s:69:\"index.php?post_type=tutor_enrolled&name=$matches[1]&cpage=$matches[2]\";s:40:\"tutor_enrolled/([^/]+)/wc-api(/(.*))?/?$\";s:70:\"index.php?post_type=tutor_enrolled&name=$matches[1]&wc-api=$matches[3]\";s:51:\"tutor_enrolled/([^/]+)/wc/file/transient(/(.*))?/?$\";s:81:\"index.php?post_type=tutor_enrolled&name=$matches[1]&wc/file/transient=$matches[3]\";s:46:\"tutor_enrolled/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:57:\"tutor_enrolled/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:57:\"tutor_enrolled/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:68:\"tutor_enrolled/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:39:\"tutor_enrolled/([^/]+)(?:/([0-9]+))?/?$\";s:68:\"index.php?post_type=tutor_enrolled&name=$matches[1]&page=$matches[2]\";s:31:\"tutor_enrolled/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:41:\"tutor_enrolled/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:61:\"tutor_enrolled/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"tutor_enrolled/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"tutor_enrolled/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:37:\"tutor_enrolled/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:32:\"footer/.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:42:\"footer/.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:62:\"footer/.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"footer/.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"footer/.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:38:\"footer/.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:21:\"footer/(.+?)/embed/?$\";s:39:\"index.php?footer=$matches[1]&embed=true\";s:25:\"footer/(.+?)/trackback/?$\";s:33:\"index.php?footer=$matches[1]&tb=1\";s:45:\"footer/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:45:\"index.php?footer=$matches[1]&feed=$matches[2]\";s:40:\"footer/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:45:\"index.php?footer=$matches[1]&feed=$matches[2]\";s:33:\"footer/(.+?)/page/?([0-9]{1,})/?$\";s:46:\"index.php?footer=$matches[1]&paged=$matches[2]\";s:40:\"footer/(.+?)/comment-page-([0-9]{1,})/?$\";s:46:\"index.php?footer=$matches[1]&cpage=$matches[2]\";s:30:\"footer/(.+?)/wc-api(/(.*))?/?$\";s:47:\"index.php?footer=$matches[1]&wc-api=$matches[3]\";s:41:\"footer/(.+?)/wc/file/transient(/(.*))?/?$\";s:58:\"index.php?footer=$matches[1]&wc/file/transient=$matches[3]\";s:36:\"footer/.+?/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:47:\"footer/.+?/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:47:\"footer/.+?/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:58:\"footer/.+?/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:29:\"footer/(.+?)(?:/([0-9]+))?/?$\";s:45:\"index.php?footer=$matches[1]&page=$matches[2]\";s:36:\"gva_header/.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:46:\"gva_header/.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:66:\"gva_header/.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:61:\"gva_header/.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:61:\"gva_header/.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:42:\"gva_header/.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:25:\"gva_header/(.+?)/embed/?$\";s:43:\"index.php?gva_header=$matches[1]&embed=true\";s:29:\"gva_header/(.+?)/trackback/?$\";s:37:\"index.php?gva_header=$matches[1]&tb=1\";s:49:\"gva_header/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?gva_header=$matches[1]&feed=$matches[2]\";s:44:\"gva_header/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?gva_header=$matches[1]&feed=$matches[2]\";s:37:\"gva_header/(.+?)/page/?([0-9]{1,})/?$\";s:50:\"index.php?gva_header=$matches[1]&paged=$matches[2]\";s:44:\"gva_header/(.+?)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?gva_header=$matches[1]&cpage=$matches[2]\";s:34:\"gva_header/(.+?)/wc-api(/(.*))?/?$\";s:51:\"index.php?gva_header=$matches[1]&wc-api=$matches[3]\";s:45:\"gva_header/(.+?)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?gva_header=$matches[1]&wc/file/transient=$matches[3]\";s:40:\"gva_header/.+?/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:51:\"gva_header/.+?/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:51:\"gva_header/.+?/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:62:\"gva_header/.+?/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:33:\"gva_header/(.+?)(?:/([0-9]+))?/?$\";s:49:\"index.php?gva_header=$matches[1]&page=$matches[2]\";s:32:\"team/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:42:\"team/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:62:\"team/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"team/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"team/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:38:\"team/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:21:\"team/([^/]+)/embed/?$\";s:41:\"index.php?gva_team=$matches[1]&embed=true\";s:25:\"team/([^/]+)/trackback/?$\";s:35:\"index.php?gva_team=$matches[1]&tb=1\";s:45:\"team/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?gva_team=$matches[1]&feed=$matches[2]\";s:40:\"team/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?gva_team=$matches[1]&feed=$matches[2]\";s:33:\"team/([^/]+)/page/?([0-9]{1,})/?$\";s:48:\"index.php?gva_team=$matches[1]&paged=$matches[2]\";s:40:\"team/([^/]+)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?gva_team=$matches[1]&cpage=$matches[2]\";s:30:\"team/([^/]+)/wc-api(/(.*))?/?$\";s:49:\"index.php?gva_team=$matches[1]&wc-api=$matches[3]\";s:41:\"team/([^/]+)/wc/file/transient(/(.*))?/?$\";s:60:\"index.php?gva_team=$matches[1]&wc/file/transient=$matches[3]\";s:36:\"team/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:47:\"team/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:47:\"team/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:58:\"team/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:29:\"team/([^/]+)(?:/([0-9]+))?/?$\";s:47:\"index.php?gva_team=$matches[1]&page=$matches[2]\";s:21:\"team/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:31:\"team/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:51:\"team/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:46:\"team/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:46:\"team/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:27:\"team/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:35:\"portfolio/.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"portfolio/.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"portfolio/.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"portfolio/.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"portfolio/.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"portfolio/.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:24:\"portfolio/(.+?)/embed/?$\";s:42:\"index.php?portfolio=$matches[1]&embed=true\";s:28:\"portfolio/(.+?)/trackback/?$\";s:36:\"index.php?portfolio=$matches[1]&tb=1\";s:48:\"portfolio/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?portfolio=$matches[1]&feed=$matches[2]\";s:43:\"portfolio/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?portfolio=$matches[1]&feed=$matches[2]\";s:36:\"portfolio/(.+?)/page/?([0-9]{1,})/?$\";s:49:\"index.php?portfolio=$matches[1]&paged=$matches[2]\";s:43:\"portfolio/(.+?)/comment-page-([0-9]{1,})/?$\";s:49:\"index.php?portfolio=$matches[1]&cpage=$matches[2]\";s:33:\"portfolio/(.+?)/wc-api(/(.*))?/?$\";s:50:\"index.php?portfolio=$matches[1]&wc-api=$matches[3]\";s:44:\"portfolio/(.+?)/wc/file/transient(/(.*))?/?$\";s:61:\"index.php?portfolio=$matches[1]&wc/file/transient=$matches[3]\";s:39:\"portfolio/.+?/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:50:\"portfolio/.+?/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:50:\"portfolio/.+?/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:61:\"portfolio/.+?/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:32:\"portfolio/(.+?)(?:/([0-9]+))?/?$\";s:48:\"index.php?portfolio=$matches[1]&page=$matches[2]\";s:59:\"category-portfolio/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:57:\"index.php?category_portfolio=$matches[1]&feed=$matches[2]\";s:54:\"category-portfolio/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:57:\"index.php?category_portfolio=$matches[1]&feed=$matches[2]\";s:35:\"category-portfolio/([^/]+)/embed/?$\";s:51:\"index.php?category_portfolio=$matches[1]&embed=true\";s:47:\"category-portfolio/([^/]+)/page/?([0-9]{1,})/?$\";s:58:\"index.php?category_portfolio=$matches[1]&paged=$matches[2]\";s:29:\"category-portfolio/([^/]+)/?$\";s:40:\"index.php?category_portfolio=$matches[1]\";s:46:\"%D9%85%D8%AD%D9%84/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:56:\"%D9%85%D8%AD%D9%84/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:76:\"%D9%85%D8%AD%D9%84/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:71:\"%D9%85%D8%AD%D9%84/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:71:\"%D9%85%D8%AD%D9%84/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:52:\"%D9%85%D8%AD%D9%84/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:35:\"%D9%85%D8%AD%D9%84/([^/]+)/embed/?$\";s:44:\"index.php?tribe_venue=$matches[1]&embed=true\";s:39:\"%D9%85%D8%AD%D9%84/([^/]+)/trackback/?$\";s:38:\"index.php?tribe_venue=$matches[1]&tb=1\";s:47:\"%D9%85%D8%AD%D9%84/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?tribe_venue=$matches[1]&paged=$matches[2]\";s:54:\"%D9%85%D8%AD%D9%84/([^/]+)/comment-page-([0-9]{1,})/?$\";s:51:\"index.php?tribe_venue=$matches[1]&cpage=$matches[2]\";s:44:\"%D9%85%D8%AD%D9%84/([^/]+)/wc-api(/(.*))?/?$\";s:52:\"index.php?tribe_venue=$matches[1]&wc-api=$matches[3]\";s:55:\"%D9%85%D8%AD%D9%84/([^/]+)/wc/file/transient(/(.*))?/?$\";s:63:\"index.php?tribe_venue=$matches[1]&wc/file/transient=$matches[3]\";s:50:\"%D9%85%D8%AD%D9%84/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:61:\"%D9%85%D8%AD%D9%84/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:61:\"%D9%85%D8%AD%D9%84/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:72:\"%D9%85%D8%AD%D9%84/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:43:\"%D9%85%D8%AD%D9%84/([^/]+)(?:/([0-9]+))?/?$\";s:50:\"index.php?tribe_venue=$matches[1]&page=$matches[2]\";s:35:\"%D9%85%D8%AD%D9%84/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"%D9%85%D8%AD%D9%84/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"%D9%85%D8%AD%D9%84/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"%D9%85%D8%AD%D9%84/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"%D9%85%D8%AD%D9%84/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"%D9%85%D8%AD%D9%84/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:89:\"%D8%AA%D9%86%D8%B8%DB%8C%D9%85-%DA%A9%D9%86%D9%86%D8%AF%D9%87/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:99:\"%D8%AA%D9%86%D8%B8%DB%8C%D9%85-%DA%A9%D9%86%D9%86%D8%AF%D9%87/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:119:\"%D8%AA%D9%86%D8%B8%DB%8C%D9%85-%DA%A9%D9%86%D9%86%D8%AF%D9%87/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:114:\"%D8%AA%D9%86%D8%B8%DB%8C%D9%85-%DA%A9%D9%86%D9%86%D8%AF%D9%87/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:114:\"%D8%AA%D9%86%D8%B8%DB%8C%D9%85-%DA%A9%D9%86%D9%86%D8%AF%D9%87/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:95:\"%D8%AA%D9%86%D8%B8%DB%8C%D9%85-%DA%A9%D9%86%D9%86%D8%AF%D9%87/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:78:\"%D8%AA%D9%86%D8%B8%DB%8C%D9%85-%DA%A9%D9%86%D9%86%D8%AF%D9%87/([^/]+)/embed/?$\";s:48:\"index.php?tribe_organizer=$matches[1]&embed=true\";s:82:\"%D8%AA%D9%86%D8%B8%DB%8C%D9%85-%DA%A9%D9%86%D9%86%D8%AF%D9%87/([^/]+)/trackback/?$\";s:42:\"index.php?tribe_organizer=$matches[1]&tb=1\";s:90:\"%D8%AA%D9%86%D8%B8%DB%8C%D9%85-%DA%A9%D9%86%D9%86%D8%AF%D9%87/([^/]+)/page/?([0-9]{1,})/?$\";s:55:\"index.php?tribe_organizer=$matches[1]&paged=$matches[2]\";s:97:\"%D8%AA%D9%86%D8%B8%DB%8C%D9%85-%DA%A9%D9%86%D9%86%D8%AF%D9%87/([^/]+)/comment-page-([0-9]{1,})/?$\";s:55:\"index.php?tribe_organizer=$matches[1]&cpage=$matches[2]\";s:87:\"%D8%AA%D9%86%D8%B8%DB%8C%D9%85-%DA%A9%D9%86%D9%86%D8%AF%D9%87/([^/]+)/wc-api(/(.*))?/?$\";s:56:\"index.php?tribe_organizer=$matches[1]&wc-api=$matches[3]\";s:98:\"%D8%AA%D9%86%D8%B8%DB%8C%D9%85-%DA%A9%D9%86%D9%86%D8%AF%D9%87/([^/]+)/wc/file/transient(/(.*))?/?$\";s:67:\"index.php?tribe_organizer=$matches[1]&wc/file/transient=$matches[3]\";s:93:\"%D8%AA%D9%86%D8%B8%DB%8C%D9%85-%DA%A9%D9%86%D9%86%D8%AF%D9%87/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:104:\"%D8%AA%D9%86%D8%B8%DB%8C%D9%85-%DA%A9%D9%86%D9%86%D8%AF%D9%87/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:104:\"%D8%AA%D9%86%D8%B8%DB%8C%D9%85-%DA%A9%D9%86%D9%86%D8%AF%D9%87/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:115:\"%D8%AA%D9%86%D8%B8%DB%8C%D9%85-%DA%A9%D9%86%D9%86%D8%AF%D9%87/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:86:\"%D8%AA%D9%86%D8%B8%DB%8C%D9%85-%DA%A9%D9%86%D9%86%D8%AF%D9%87/([^/]+)(?:/([0-9]+))?/?$\";s:54:\"index.php?tribe_organizer=$matches[1]&page=$matches[2]\";s:78:\"%D8%AA%D9%86%D8%B8%DB%8C%D9%85-%DA%A9%D9%86%D9%86%D8%AF%D9%87/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:88:\"%D8%AA%D9%86%D8%B8%DB%8C%D9%85-%DA%A9%D9%86%D9%86%D8%AF%D9%87/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:108:\"%D8%AA%D9%86%D8%B8%DB%8C%D9%85-%DA%A9%D9%86%D9%86%D8%AF%D9%87/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:103:\"%D8%AA%D9%86%D8%B8%DB%8C%D9%85-%DA%A9%D9%86%D9%86%D8%AF%D9%87/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:103:\"%D8%AA%D9%86%D8%B8%DB%8C%D9%85-%DA%A9%D9%86%D9%86%D8%AF%D9%87/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:84:\"%D8%AA%D9%86%D8%B8%DB%8C%D9%85-%DA%A9%D9%86%D9%86%D8%AF%D9%87/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:33:\"event/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:43:\"event/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:63:\"event/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"event/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"event/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:39:\"event/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:22:\"event/([^/]+)/embed/?$\";s:45:\"index.php?tribe_events=$matches[1]&embed=true\";s:26:\"event/([^/]+)/trackback/?$\";s:39:\"index.php?tribe_events=$matches[1]&tb=1\";s:46:\"event/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?tribe_events=$matches[1]&feed=$matches[2]\";s:41:\"event/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?tribe_events=$matches[1]&feed=$matches[2]\";s:34:\"event/([^/]+)/page/?([0-9]{1,})/?$\";s:52:\"index.php?tribe_events=$matches[1]&paged=$matches[2]\";s:41:\"event/([^/]+)/comment-page-([0-9]{1,})/?$\";s:52:\"index.php?tribe_events=$matches[1]&cpage=$matches[2]\";s:31:\"event/([^/]+)/wc-api(/(.*))?/?$\";s:53:\"index.php?tribe_events=$matches[1]&wc-api=$matches[3]\";s:42:\"event/([^/]+)/wc/file/transient(/(.*))?/?$\";s:64:\"index.php?tribe_events=$matches[1]&wc/file/transient=$matches[3]\";s:37:\"event/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:48:\"event/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:48:\"event/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:59:\"event/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:30:\"event/([^/]+)(?:/([0-9]+))?/?$\";s:51:\"index.php?tribe_events=$matches[1]&page=$matches[2]\";s:22:\"event/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:32:\"event/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:52:\"event/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:47:\"event/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:47:\"event/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:28:\"event/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:95:\"events/%d8%af%d8%b3%d8%aa%d9%87-%d8%a8%d9%86%d8%af%db%8c/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:184:\"index.php?%d8%$matches[1]&%d8%$matches[2]&%d8%$matches[3]&%d9%$matches[4]&%d8%$matches[5]&%d9%$matches[6]&%d8%$matches[7]&%db%$matches[8]&tribe_events_cat=$matches[9]&feed=$matches[10]\";s:90:\"events/%d8%af%d8%b3%d8%aa%d9%87-%d8%a8%d9%86%d8%af%db%8c/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:184:\"index.php?%d8%$matches[1]&%d8%$matches[2]&%d8%$matches[3]&%d9%$matches[4]&%d8%$matches[5]&%d9%$matches[6]&%d8%$matches[7]&%db%$matches[8]&tribe_events_cat=$matches[9]&feed=$matches[10]\";s:71:\"events/%d8%af%d8%b3%d8%aa%d9%87-%d8%a8%d9%86%d8%af%db%8c/(.+?)/embed/?$\";s:177:\"index.php?%d8%$matches[1]&%d8%$matches[2]&%d8%$matches[3]&%d9%$matches[4]&%d8%$matches[5]&%d9%$matches[6]&%d8%$matches[7]&%db%$matches[8]&tribe_events_cat=$matches[9]&embed=true\";s:83:\"events/%d8%af%d8%b3%d8%aa%d9%87-%d8%a8%d9%86%d8%af%db%8c/(.+?)/page/?([0-9]{1,})/?$\";s:185:\"index.php?%d8%$matches[1]&%d8%$matches[2]&%d8%$matches[3]&%d9%$matches[4]&%d8%$matches[5]&%d9%$matches[6]&%d8%$matches[7]&%db%$matches[8]&tribe_events_cat=$matches[9]&paged=$matches[10]\";s:65:\"events/%d8%af%d8%b3%d8%aa%d9%87-%d8%a8%d9%86%d8%af%db%8c/(.+?)/?$\";s:166:\"index.php?%d8%$matches[1]&%d8%$matches[2]&%d8%$matches[3]&%d9%$matches[4]&%d8%$matches[5]&%d9%$matches[6]&%d8%$matches[7]&%db%$matches[8]&tribe_events_cat=$matches[9]\";s:89:\"events/%d8%af%d8%b3%d8%aa%d9%87-%d8%a8%d9%86%d8%af%db%8c/feed/(feed|rdf|rss|rss2|atom)/?$\";s:154:\"index.php?%d8%$matches[1]&%d8%$matches[2]&%d8%$matches[3]&%d9%$matches[4]&%d8%$matches[5]&%d9%$matches[6]&%d8%$matches[7]&%db%$matches[8]&feed=$matches[9]\";s:84:\"events/%d8%af%d8%b3%d8%aa%d9%87-%d8%a8%d9%86%d8%af%db%8c/(feed|rdf|rss|rss2|atom)/?$\";s:154:\"index.php?%d8%$matches[1]&%d8%$matches[2]&%d8%$matches[3]&%d9%$matches[4]&%d8%$matches[5]&%d9%$matches[6]&%d8%$matches[7]&%db%$matches[8]&feed=$matches[9]\";s:65:\"events/%d8%af%d8%b3%d8%aa%d9%87-%d8%a8%d9%86%d8%af%db%8c/embed/?$\";s:148:\"index.php?%d8%$matches[1]&%d8%$matches[2]&%d8%$matches[3]&%d9%$matches[4]&%d8%$matches[5]&%d9%$matches[6]&%d8%$matches[7]&%db%$matches[8]&embed=true\";s:77:\"events/%d8%af%d8%b3%d8%aa%d9%87-%d8%a8%d9%86%d8%af%db%8c/page/?([0-9]{1,})/?$\";s:155:\"index.php?%d8%$matches[1]&%d8%$matches[2]&%d8%$matches[3]&%d9%$matches[4]&%d8%$matches[5]&%d9%$matches[6]&%d8%$matches[7]&%db%$matches[8]&paged=$matches[9]\";s:59:\"events/%d8%af%d8%b3%d8%aa%d9%87-%d8%a8%d9%86%d8%af%db%8c/?$\";s:137:\"index.php?%d8%$matches[1]&%d8%$matches[2]&%d8%$matches[3]&%d9%$matches[4]&%d8%$matches[5]&%d9%$matches[6]&%d8%$matches[7]&%db%$matches[8]\";s:41:\"deleted_event/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:51:\"deleted_event/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:71:\"deleted_event/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:66:\"deleted_event/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:66:\"deleted_event/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:47:\"deleted_event/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:30:\"deleted_event/([^/]+)/embed/?$\";s:46:\"index.php?deleted_event=$matches[1]&embed=true\";s:34:\"deleted_event/([^/]+)/trackback/?$\";s:40:\"index.php?deleted_event=$matches[1]&tb=1\";s:42:\"deleted_event/([^/]+)/page/?([0-9]{1,})/?$\";s:53:\"index.php?deleted_event=$matches[1]&paged=$matches[2]\";s:49:\"deleted_event/([^/]+)/comment-page-([0-9]{1,})/?$\";s:53:\"index.php?deleted_event=$matches[1]&cpage=$matches[2]\";s:39:\"deleted_event/([^/]+)/wc-api(/(.*))?/?$\";s:54:\"index.php?deleted_event=$matches[1]&wc-api=$matches[3]\";s:50:\"deleted_event/([^/]+)/wc/file/transient(/(.*))?/?$\";s:65:\"index.php?deleted_event=$matches[1]&wc/file/transient=$matches[3]\";s:45:\"deleted_event/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:56:\"deleted_event/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:56:\"deleted_event/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:67:\"deleted_event/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:38:\"deleted_event/([^/]+)(?:/([0-9]+))?/?$\";s:52:\"index.php?deleted_event=$matches[1]&page=$matches[2]\";s:30:\"deleted_event/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:40:\"deleted_event/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:60:\"deleted_event/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:55:\"deleted_event/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:55:\"deleted_event/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:36:\"deleted_event/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:38:\"mc4wp-form/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:48:\"mc4wp-form/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:68:\"mc4wp-form/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"mc4wp-form/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"mc4wp-form/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:44:\"mc4wp-form/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:27:\"mc4wp-form/([^/]+)/embed/?$\";s:43:\"index.php?mc4wp-form=$matches[1]&embed=true\";s:31:\"mc4wp-form/([^/]+)/trackback/?$\";s:37:\"index.php?mc4wp-form=$matches[1]&tb=1\";s:39:\"mc4wp-form/([^/]+)/page/?([0-9]{1,})/?$\";s:50:\"index.php?mc4wp-form=$matches[1]&paged=$matches[2]\";s:46:\"mc4wp-form/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?mc4wp-form=$matches[1]&cpage=$matches[2]\";s:36:\"mc4wp-form/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?mc4wp-form=$matches[1]&wc-api=$matches[3]\";s:47:\"mc4wp-form/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?mc4wp-form=$matches[1]&wc/file/transient=$matches[3]\";s:42:\"mc4wp-form/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:53:\"mc4wp-form/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:53:\"mc4wp-form/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:64:\"mc4wp-form/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:35:\"mc4wp-form/([^/]+)(?:/([0-9]+))?/?$\";s:49:\"index.php?mc4wp-form=$matches[1]&page=$matches[2]\";s:27:\"mc4wp-form/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"mc4wp-form/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"mc4wp-form/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"mc4wp-form/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"mc4wp-form/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"mc4wp-form/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:39:\"index.php?&page_id=18&cpage=$matches[1]\";s:17:\"wc-api(/(.*))?/?$\";s:29:\"index.php?&wc-api=$matches[2]\";s:28:\"wc/file/transient(/(.*))?/?$\";s:40:\"index.php?&wc/file/transient=$matches[2]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:26:\"comments/wc-api(/(.*))?/?$\";s:29:\"index.php?&wc-api=$matches[2]\";s:37:\"comments/wc/file/transient(/(.*))?/?$\";s:40:\"index.php?&wc/file/transient=$matches[2]\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:29:\"search/(.+)/wc-api(/(.*))?/?$\";s:42:\"index.php?s=$matches[1]&wc-api=$matches[3]\";s:40:\"search/(.+)/wc/file/transient(/(.*))?/?$\";s:53:\"index.php?s=$matches[1]&wc/file/transient=$matches[3]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:32:\"author/([^/]+)/wc-api(/(.*))?/?$\";s:52:\"index.php?author_name=$matches[1]&wc-api=$matches[3]\";s:43:\"author/([^/]+)/wc/file/transient(/(.*))?/?$\";s:63:\"index.php?author_name=$matches[1]&wc/file/transient=$matches[3]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:54:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/wc-api(/(.*))?/?$\";s:82:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&wc-api=$matches[5]\";s:65:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/wc/file/transient(/(.*))?/?$\";s:93:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&wc/file/transient=$matches[5]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:41:\"([0-9]{4})/([0-9]{1,2})/wc-api(/(.*))?/?$\";s:66:\"index.php?year=$matches[1]&monthnum=$matches[2]&wc-api=$matches[4]\";s:52:\"([0-9]{4})/([0-9]{1,2})/wc/file/transient(/(.*))?/?$\";s:77:\"index.php?year=$matches[1]&monthnum=$matches[2]&wc/file/transient=$matches[4]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:28:\"([0-9]{4})/wc-api(/(.*))?/?$\";s:45:\"index.php?year=$matches[1]&wc-api=$matches[3]\";s:39:\"([0-9]{4})/wc/file/transient(/(.*))?/?$\";s:56:\"index.php?year=$matches[1]&wc/file/transient=$matches[3]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:25:\"(.?.+?)/wc-api(/(.*))?/?$\";s:49:\"index.php?pagename=$matches[1]&wc-api=$matches[3]\";s:36:\"(.?.+?)/wc/file/transient(/(.*))?/?$\";s:60:\"index.php?pagename=$matches[1]&wc/file/transient=$matches[3]\";s:28:\"(.?.+?)/order-pay(/(.*))?/?$\";s:52:\"index.php?pagename=$matches[1]&order-pay=$matches[3]\";s:33:\"(.?.+?)/order-received(/(.*))?/?$\";s:57:\"index.php?pagename=$matches[1]&order-received=$matches[3]\";s:25:\"(.?.+?)/orders(/(.*))?/?$\";s:49:\"index.php?pagename=$matches[1]&orders=$matches[3]\";s:29:\"(.?.+?)/view-order(/(.*))?/?$\";s:53:\"index.php?pagename=$matches[1]&view-order=$matches[3]\";s:28:\"(.?.+?)/downloads(/(.*))?/?$\";s:52:\"index.php?pagename=$matches[1]&downloads=$matches[3]\";s:31:\"(.?.+?)/edit-account(/(.*))?/?$\";s:55:\"index.php?pagename=$matches[1]&edit-account=$matches[3]\";s:31:\"(.?.+?)/edit-address(/(.*))?/?$\";s:55:\"index.php?pagename=$matches[1]&edit-address=$matches[3]\";s:34:\"(.?.+?)/payment-methods(/(.*))?/?$\";s:58:\"index.php?pagename=$matches[1]&payment-methods=$matches[3]\";s:32:\"(.?.+?)/lost-password(/(.*))?/?$\";s:56:\"index.php?pagename=$matches[1]&lost-password=$matches[3]\";s:34:\"(.?.+?)/customer-logout(/(.*))?/?$\";s:58:\"index.php?pagename=$matches[1]&customer-logout=$matches[3]\";s:37:\"(.?.+?)/add-payment-method(/(.*))?/?$\";s:61:\"index.php?pagename=$matches[1]&add-payment-method=$matches[3]\";s:40:\"(.?.+?)/delete-payment-method(/(.*))?/?$\";s:64:\"index.php?pagename=$matches[1]&delete-payment-method=$matches[3]\";s:45:\"(.?.+?)/set-default-payment-method(/(.*))?/?$\";s:69:\"index.php?pagename=$matches[1]&set-default-payment-method=$matches[3]\";s:31:\".?.+?/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:42:\".?.+?/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:42:\".?.+?/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:53:\".?.+?/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"([^/]+)/embed/?$\";s:37:\"index.php?name=$matches[1]&embed=true\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:25:\"([^/]+)/wc-api(/(.*))?/?$\";s:45:\"index.php?name=$matches[1]&wc-api=$matches[3]\";s:36:\"([^/]+)/wc/file/transient(/(.*))?/?$\";s:56:\"index.php?name=$matches[1]&wc/file/transient=$matches[3]\";s:31:\"[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:42:\"[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:42:\"[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:53:\"[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:24:\"([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:22:\"[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";}", "yes");
INSERT INTO `wp_options` VALUES("30", "hack_file", "0", "yes");
INSERT INTO `wp_options` VALUES("31", "blog_charset", "UTF-8", "yes");
INSERT INTO `wp_options` VALUES("32", "moderation_keys", "", "no");
INSERT INTO `wp_options` VALUES("33", "active_plugins", "a:15:{i:0;s:29:\"Novin-Fonts/font-uploader.php\";i:1;s:33:\"classic-editor/classic-editor.php\";i:2;s:36:\"contact-form-7/wp-contact-form-7.php\";i:3;s:25:\"duplicator/duplicator.php\";i:4;s:23:\"elementor/elementor.php\";i:5;s:37:\"mailchimp-for-wp/mailchimp-for-wp.php\";i:6;s:21:\"meta-box/meta-box.php\";i:7;s:53:\"nextend-facebook-connect/nextend-facebook-connect.php\";i:8;s:23:\"revslider/revslider.php\";i:9;s:43:\"the-events-calendar/the-events-calendar.php\";i:10;s:15:\"tutor/tutor.php\";i:11;s:53:\"widget-importer-exporter/widget-importer-exporter.php\";i:12;s:27:\"woocommerce/woocommerce.php\";i:13;s:29:\"wp-parsidate/wp-parsidate.php\";i:14;s:29:\"zilom-themer/zilom-themer.php\";}", "yes");
INSERT INTO `wp_options` VALUES("34", "category_base", "", "yes");
INSERT INTO `wp_options` VALUES("35", "ping_sites", "http://rpc.pingomatic.com/", "yes");
INSERT INTO `wp_options` VALUES("36", "comment_max_links", "2", "yes");
INSERT INTO `wp_options` VALUES("37", "gmt_offset", "+3.5", "yes");
INSERT INTO `wp_options` VALUES("38", "default_email_category", "1", "yes");
INSERT INTO `wp_options` VALUES("39", "recently_edited", "a:3:{i:0;s:67:\"/home/themeswpn/public_html/Zilom/wp-content/themes/zilom/style.css\";i:2;s:73:\"/home/themeswpn/public_html/Zilom/wp-content/themes/zilom_child/style.css\";i:3;s:0:\"\";}", "no");
INSERT INTO `wp_options` VALUES("40", "template", "zilom", "yes");
INSERT INTO `wp_options` VALUES("41", "stylesheet", "zilom", "yes");
INSERT INTO `wp_options` VALUES("42", "comment_registration", "0", "yes");
INSERT INTO `wp_options` VALUES("43", "html_type", "text/html", "yes");
INSERT INTO `wp_options` VALUES("44", "use_trackback", "0", "yes");
INSERT INTO `wp_options` VALUES("45", "default_role", "subscriber", "yes");
INSERT INTO `wp_options` VALUES("46", "db_version", "57155", "yes");
INSERT INTO `wp_options` VALUES("47", "uploads_use_yearmonth_folders", "1", "yes");
INSERT INTO `wp_options` VALUES("48", "upload_path", "", "yes");
INSERT INTO `wp_options` VALUES("49", "blog_public", "1", "yes");
INSERT INTO `wp_options` VALUES("50", "default_link_category", "2", "yes");
INSERT INTO `wp_options` VALUES("51", "show_on_front", "page", "yes");
INSERT INTO `wp_options` VALUES("52", "tag_base", "", "yes");
INSERT INTO `wp_options` VALUES("53", "show_avatars", "1", "yes");
INSERT INTO `wp_options` VALUES("54", "avatar_rating", "G", "yes");
INSERT INTO `wp_options` VALUES("55", "upload_url_path", "", "yes");
INSERT INTO `wp_options` VALUES("56", "thumbnail_size_w", "180", "yes");
INSERT INTO `wp_options` VALUES("57", "thumbnail_size_h", "180", "yes");
INSERT INTO `wp_options` VALUES("58", "thumbnail_crop", "1", "yes");
INSERT INTO `wp_options` VALUES("59", "medium_size_w", "600", "yes");
INSERT INTO `wp_options` VALUES("60", "medium_size_h", "600", "yes");
INSERT INTO `wp_options` VALUES("61", "avatar_default", "mystery", "yes");
INSERT INTO `wp_options` VALUES("62", "large_size_w", "1024", "yes");
INSERT INTO `wp_options` VALUES("63", "large_size_h", "1024", "yes");
INSERT INTO `wp_options` VALUES("64", "image_default_link_type", "none", "yes");
INSERT INTO `wp_options` VALUES("65", "image_default_size", "", "yes");
INSERT INTO `wp_options` VALUES("66", "image_default_align", "", "yes");
INSERT INTO `wp_options` VALUES("67", "close_comments_for_old_posts", "0", "yes");
INSERT INTO `wp_options` VALUES("68", "close_comments_days_old", "14", "yes");
INSERT INTO `wp_options` VALUES("69", "thread_comments", "1", "yes");
INSERT INTO `wp_options` VALUES("70", "thread_comments_depth", "5", "yes");
INSERT INTO `wp_options` VALUES("71", "page_comments", "0", "yes");
INSERT INTO `wp_options` VALUES("72", "comments_per_page", "50", "yes");
INSERT INTO `wp_options` VALUES("73", "default_comments_page", "newest", "yes");
INSERT INTO `wp_options` VALUES("74", "comment_order", "asc", "yes");
INSERT INTO `wp_options` VALUES("75", "sticky_posts", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("76", "widget_categories", "a:2:{i:1;a:4:{s:5:\"title\";s:17:\"دسته بندی\";s:5:\"count\";i:1;s:12:\"hierarchical\";i:1;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("77", "widget_text", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("78", "widget_rss", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("79", "uninstall_plugins", "a:2:{s:23:\"elementor/elementor.php\";a:2:{i:0;s:21:\"Elementor\\Maintenance\";i:1;s:9:\"uninstall\";}s:15:\"tutor/tutor.php\";a:2:{i:0;s:12:\"\\TUTOR\\Tutor\";i:1;s:15:\"tutor_uninstall\";}}", "no");
INSERT INTO `wp_options` VALUES("80", "timezone_string", "", "yes");
INSERT INTO `wp_options` VALUES("81", "page_for_posts", "0", "yes");
INSERT INTO `wp_options` VALUES("82", "page_on_front", "18", "yes");
INSERT INTO `wp_options` VALUES("83", "default_post_format", "0", "yes");
INSERT INTO `wp_options` VALUES("84", "link_manager_enabled", "0", "yes");
INSERT INTO `wp_options` VALUES("85", "finished_splitting_shared_terms", "1", "yes");
INSERT INTO `wp_options` VALUES("86", "site_icon", "0", "yes");
INSERT INTO `wp_options` VALUES("87", "medium_large_size_w", "768", "yes");
INSERT INTO `wp_options` VALUES("88", "medium_large_size_h", "0", "yes");
INSERT INTO `wp_options` VALUES("89", "wp_page_for_privacy_policy", "3", "yes");
INSERT INTO `wp_options` VALUES("90", "show_comments_cookies_opt_in", "1", "yes");
INSERT INTO `wp_options` VALUES("91", "admin_email_lifespan", "1742895301", "yes");
INSERT INTO `wp_options` VALUES("92", "disallowed_keys", "", "no");
INSERT INTO `wp_options` VALUES("93", "comment_previously_approved", "1", "yes");
INSERT INTO `wp_options` VALUES("94", "auto_plugin_theme_update_emails", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("95", "auto_update_core_dev", "enabled", "yes");
INSERT INTO `wp_options` VALUES("96", "auto_update_core_minor", "enabled", "yes");
INSERT INTO `wp_options` VALUES("97", "auto_update_core_major", "enabled", "yes");
INSERT INTO `wp_options` VALUES("98", "wp_force_deactivated_plugins", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("99", "initial_db_version", "49752", "yes");
INSERT INTO `wp_options` VALUES("100", "wp_user_roles", "a:8:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:188:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:12:\"manage_tutor\";b:1;s:23:\"manage_tutor_instructor\";b:1;s:17:\"edit_tutor_course\";b:1;s:17:\"read_tutor_course\";b:1;s:19:\"delete_tutor_course\";b:1;s:20:\"delete_tutor_courses\";b:1;s:18:\"edit_tutor_courses\";b:1;s:25:\"edit_others_tutor_courses\";b:1;s:26:\"read_private_tutor_courses\";b:1;s:17:\"edit_tutor_lesson\";b:1;s:17:\"read_tutor_lesson\";b:1;s:19:\"delete_tutor_lesson\";b:1;s:20:\"delete_tutor_lessons\";b:1;s:18:\"edit_tutor_lessons\";b:1;s:25:\"edit_others_tutor_lessons\";b:1;s:26:\"read_private_tutor_lessons\";b:1;s:21:\"publish_tutor_lessons\";b:1;s:15:\"edit_tutor_quiz\";b:1;s:15:\"read_tutor_quiz\";b:1;s:17:\"delete_tutor_quiz\";b:1;s:20:\"delete_tutor_quizzes\";b:1;s:18:\"edit_tutor_quizzes\";b:1;s:25:\"edit_others_tutor_quizzes\";b:1;s:26:\"read_private_tutor_quizzes\";b:1;s:21:\"publish_tutor_quizzes\";b:1;s:19:\"edit_tutor_question\";b:1;s:19:\"read_tutor_question\";b:1;s:21:\"delete_tutor_question\";b:1;s:22:\"delete_tutor_questions\";b:1;s:20:\"edit_tutor_questions\";b:1;s:27:\"edit_others_tutor_questions\";b:1;s:23:\"publish_tutor_questions\";b:1;s:28:\"read_private_tutor_questions\";b:1;s:21:\"publish_tutor_courses\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;s:25:\"read_private_tribe_events\";b:1;s:17:\"edit_tribe_events\";b:1;s:24:\"edit_others_tribe_events\";b:1;s:25:\"edit_private_tribe_events\";b:1;s:27:\"edit_published_tribe_events\";b:1;s:19:\"delete_tribe_events\";b:1;s:26:\"delete_others_tribe_events\";b:1;s:27:\"delete_private_tribe_events\";b:1;s:29:\"delete_published_tribe_events\";b:1;s:20:\"publish_tribe_events\";b:1;s:25:\"read_private_tribe_venues\";b:1;s:17:\"edit_tribe_venues\";b:1;s:24:\"edit_others_tribe_venues\";b:1;s:25:\"edit_private_tribe_venues\";b:1;s:27:\"edit_published_tribe_venues\";b:1;s:19:\"delete_tribe_venues\";b:1;s:26:\"delete_others_tribe_venues\";b:1;s:27:\"delete_private_tribe_venues\";b:1;s:29:\"delete_published_tribe_venues\";b:1;s:20:\"publish_tribe_venues\";b:1;s:29:\"read_private_tribe_organizers\";b:1;s:21:\"edit_tribe_organizers\";b:1;s:28:\"edit_others_tribe_organizers\";b:1;s:29:\"edit_private_tribe_organizers\";b:1;s:31:\"edit_published_tribe_organizers\";b:1;s:23:\"delete_tribe_organizers\";b:1;s:30:\"delete_others_tribe_organizers\";b:1;s:31:\"delete_private_tribe_organizers\";b:1;s:33:\"delete_published_tribe_organizers\";b:1;s:24:\"publish_tribe_organizers\";b:1;s:31:\"read_private_aggregator-records\";b:1;s:23:\"edit_aggregator-records\";b:1;s:30:\"edit_others_aggregator-records\";b:1;s:31:\"edit_private_aggregator-records\";b:1;s:33:\"edit_published_aggregator-records\";b:1;s:25:\"delete_aggregator-records\";b:1;s:32:\"delete_others_aggregator-records\";b:1;s:33:\"delete_private_aggregator-records\";b:1;s:35:\"delete_published_aggregator-records\";b:1;s:26:\"publish_aggregator-records\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:74:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:25:\"read_private_tribe_events\";b:1;s:17:\"edit_tribe_events\";b:1;s:24:\"edit_others_tribe_events\";b:1;s:25:\"edit_private_tribe_events\";b:1;s:27:\"edit_published_tribe_events\";b:1;s:19:\"delete_tribe_events\";b:1;s:26:\"delete_others_tribe_events\";b:1;s:27:\"delete_private_tribe_events\";b:1;s:29:\"delete_published_tribe_events\";b:1;s:20:\"publish_tribe_events\";b:1;s:25:\"read_private_tribe_venues\";b:1;s:17:\"edit_tribe_venues\";b:1;s:24:\"edit_others_tribe_venues\";b:1;s:25:\"edit_private_tribe_venues\";b:1;s:27:\"edit_published_tribe_venues\";b:1;s:19:\"delete_tribe_venues\";b:1;s:26:\"delete_others_tribe_venues\";b:1;s:27:\"delete_private_tribe_venues\";b:1;s:29:\"delete_published_tribe_venues\";b:1;s:20:\"publish_tribe_venues\";b:1;s:29:\"read_private_tribe_organizers\";b:1;s:21:\"edit_tribe_organizers\";b:1;s:28:\"edit_others_tribe_organizers\";b:1;s:29:\"edit_private_tribe_organizers\";b:1;s:31:\"edit_published_tribe_organizers\";b:1;s:23:\"delete_tribe_organizers\";b:1;s:30:\"delete_others_tribe_organizers\";b:1;s:31:\"delete_private_tribe_organizers\";b:1;s:33:\"delete_published_tribe_organizers\";b:1;s:24:\"publish_tribe_organizers\";b:1;s:31:\"read_private_aggregator-records\";b:1;s:23:\"edit_aggregator-records\";b:1;s:30:\"edit_others_aggregator-records\";b:1;s:31:\"edit_private_aggregator-records\";b:1;s:33:\"edit_published_aggregator-records\";b:1;s:25:\"delete_aggregator-records\";b:1;s:32:\"delete_others_aggregator-records\";b:1;s:33:\"delete_private_aggregator-records\";b:1;s:35:\"delete_published_aggregator-records\";b:1;s:26:\"publish_aggregator-records\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:30:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:17:\"edit_tribe_events\";b:1;s:27:\"edit_published_tribe_events\";b:1;s:19:\"delete_tribe_events\";b:1;s:29:\"delete_published_tribe_events\";b:1;s:20:\"publish_tribe_events\";b:1;s:17:\"edit_tribe_venues\";b:1;s:27:\"edit_published_tribe_venues\";b:1;s:19:\"delete_tribe_venues\";b:1;s:29:\"delete_published_tribe_venues\";b:1;s:20:\"publish_tribe_venues\";b:1;s:21:\"edit_tribe_organizers\";b:1;s:31:\"edit_published_tribe_organizers\";b:1;s:23:\"delete_tribe_organizers\";b:1;s:33:\"delete_published_tribe_organizers\";b:1;s:24:\"publish_tribe_organizers\";b:1;s:23:\"edit_aggregator-records\";b:1;s:33:\"edit_published_aggregator-records\";b:1;s:25:\"delete_aggregator-records\";b:1;s:35:\"delete_published_aggregator-records\";b:1;s:26:\"publish_aggregator-records\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:13:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:17:\"edit_tribe_events\";b:1;s:19:\"delete_tribe_events\";b:1;s:17:\"edit_tribe_venues\";b:1;s:19:\"delete_tribe_venues\";b:1;s:21:\"edit_tribe_organizers\";b:1;s:23:\"delete_tribe_organizers\";b:1;s:23:\"edit_aggregator-records\";b:1;s:25:\"delete_aggregator-records\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:16:\"tutor_instructor\";a:2:{s:4:\"name\";s:16:\"Tutor Instructor\";s:12:\"capabilities\";a:35:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:12:\"upload_files\";b:1;s:23:\"manage_tutor_instructor\";b:1;s:17:\"edit_tutor_course\";b:1;s:17:\"read_tutor_course\";b:1;s:19:\"delete_tutor_course\";b:1;s:20:\"delete_tutor_courses\";b:1;s:18:\"edit_tutor_courses\";b:1;s:25:\"edit_others_tutor_courses\";b:1;s:26:\"read_private_tutor_courses\";b:1;s:17:\"edit_tutor_lesson\";b:1;s:17:\"read_tutor_lesson\";b:1;s:19:\"delete_tutor_lesson\";b:1;s:20:\"delete_tutor_lessons\";b:1;s:18:\"edit_tutor_lessons\";b:1;s:25:\"edit_others_tutor_lessons\";b:1;s:26:\"read_private_tutor_lessons\";b:1;s:21:\"publish_tutor_lessons\";b:1;s:15:\"edit_tutor_quiz\";b:1;s:15:\"read_tutor_quiz\";b:1;s:17:\"delete_tutor_quiz\";b:1;s:20:\"delete_tutor_quizzes\";b:1;s:18:\"edit_tutor_quizzes\";b:1;s:25:\"edit_others_tutor_quizzes\";b:1;s:26:\"read_private_tutor_quizzes\";b:1;s:21:\"publish_tutor_quizzes\";b:1;s:19:\"edit_tutor_question\";b:1;s:19:\"read_tutor_question\";b:1;s:21:\"delete_tutor_question\";b:1;s:22:\"delete_tutor_questions\";b:1;s:20:\"edit_tutor_questions\";b:1;s:27:\"edit_others_tutor_questions\";b:1;s:23:\"publish_tutor_questions\";b:1;s:28:\"read_private_tutor_questions\";b:1;}}s:8:\"customer\";a:2:{s:4:\"name\";s:8:\"Customer\";s:12:\"capabilities\";a:1:{s:4:\"read\";b:1;}}s:12:\"shop_manager\";a:2:{s:4:\"name\";s:12:\"Shop manager\";s:12:\"capabilities\";a:92:{s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:4:\"read\";b:1;s:18:\"read_private_pages\";b:1;s:18:\"read_private_posts\";b:1;s:10:\"edit_posts\";b:1;s:10:\"edit_pages\";b:1;s:20:\"edit_published_posts\";b:1;s:20:\"edit_published_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"edit_private_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:17:\"edit_others_pages\";b:1;s:13:\"publish_posts\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_posts\";b:1;s:12:\"delete_pages\";b:1;s:20:\"delete_private_pages\";b:1;s:20:\"delete_private_posts\";b:1;s:22:\"delete_published_pages\";b:1;s:22:\"delete_published_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:19:\"delete_others_pages\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:17:\"moderate_comments\";b:1;s:12:\"upload_files\";b:1;s:6:\"export\";b:1;s:6:\"import\";b:1;s:10:\"list_users\";b:1;s:18:\"edit_theme_options\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;}}}", "yes");
INSERT INTO `wp_options` VALUES("101", "fresh_site", "0", "yes");
INSERT INTO `wp_options` VALUES("102", "WPLANG", "fa_IR", "yes");
INSERT INTO `wp_options` VALUES("103", "widget_block", "a:7:{i:2;a:1:{s:7:\"content\";s:19:\"<!-- wp:search /-->\";}i:3;a:1:{s:7:\"content\";s:170:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>نوشته‌های تازه</h2><!-- /wp:heading --><!-- wp:latest-posts /--></div><!-- /wp:group -->\";}i:4;a:1:{s:7:\"content\";s:242:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>آخرین دیدگاه‌ها</h2><!-- /wp:heading --><!-- wp:latest-comments {\"displayAvatar\":false,\"displayDate\":false,\"displayExcerpt\":false} /--></div><!-- /wp:group -->\";}i:5;a:1:{s:7:\"content\";s:159:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>بایگانی‌ها</h2><!-- /wp:heading --><!-- wp:archives /--></div><!-- /wp:group -->\";}i:6;a:1:{s:7:\"content\";s:155:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>دسته‌ها</h2><!-- /wp:heading --><!-- wp:categories /--></div><!-- /wp:group -->\";}i:7;a:1:{s:7:\"content\";s:444:\"<div class=\"block-banner\">\r\n<div class=\"banner-image\">\r\n    <img src=\"https://themes.wpnovin.com/Zilom/wp-content/uploads/2021/06/image-3.jpg\" alt=\"banner\">\r\n  </div>\r\n<div class=\"banner-content\">\r\n<div class=\"subtitle\">خوش آمدید</div>\r\n<h3 class=\"title\">ما به دنبال شریک تجاری هستیم</h3>\r\n<p></p></div>\r\n<p>  <a href=\"https://themes.wpnovin.com/Zilom/become-a-teacher/\" class=\"link-term-overlay\"></a>\r\n</p></div>\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("104", "sidebars_widgets", "a:10:{s:19:\"wp_inactive_widgets\";a:5:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";i:3;s:7:\"block-5\";i:4;s:7:\"block-6\";}s:15:\"default_sidebar\";a:0:{}s:19:\"woocommerce_sidebar\";a:0:{}s:26:\"woocommerce_single_summary\";a:0:{}s:24:\"offcanvas_sidebar_mobile\";a:0:{}s:12:\"blog_sidebar\";a:4:{i:0;s:12:\"categories-1\";i:1;s:11:\"tag_cloud-1\";i:2;s:18:\"gva-recent-posts-1\";i:3;s:13:\"custom_html-1\";}s:13:\"other_sidebar\";a:0:{}s:16:\"porfolio_sidebar\";a:3:{i:0;s:10:\"nav_menu-1\";i:1;s:18:\"gva-recent-posts-2\";i:2;s:13:\"custom_html-2\";}s:22:\"archive_course_sidebar\";a:1:{i:0;s:7:\"block-7\";}s:13:\"array_version\";i:3;}", "yes");
INSERT INTO `wp_options` VALUES("105", "cron", "a:30:{i:1727516840;a:1:{s:26:\"action_scheduler_run_queue\";a:1:{s:32:\"0d04ed39571b55704c122d726248bbac\";a:3:{s:8:\"schedule\";s:12:\"every_minute\";s:4:\"args\";a:1:{i:0;s:7:\"WP Cron\";}s:8:\"interval\";i:60;}}}i:1727518985;a:1:{s:21:\"wp_update_user_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1727519082;a:3:{s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1727519572;a:1:{s:30:\"tribe_schedule_transient_purge\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1727519573;a:1:{s:33:\"wc_admin_process_orders_milestone\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1727519594;a:1:{s:29:\"wc_admin_unsnooze_admin_notes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1727519786;a:1:{s:20:\"jetpack_clean_nonces\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1727519957;a:1:{s:32:\"woocommerce_cancel_unpaid_orders\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1727523398;a:1:{s:34:\"puc_cron_check_updates_theme-zilom\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1727526990;a:2:{s:24:\"woocommerce_cleanup_logs\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:31:\"woocommerce_cleanup_rate_limits\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1727532140;a:1:{s:30:\"tutor_once_in_day_run_schedule\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1727537790;a:1:{s:28:\"woocommerce_cleanup_sessions\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1727545724;a:1:{s:35:\"puc_cron_check_updates-zilom-themer\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1727551651;a:1:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1727557200;a:1:{s:27:\"woocommerce_scheduled_sales\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1727562282;a:1:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1727562343;a:2:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1727562344;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1727562740;a:1:{s:28:\"elementor/tracker/send_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1727562772;a:2:{s:24:\"tribe_common_log_cleanup\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:16:\"tribe_daily_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1727562773;a:1:{s:14:\"wc_admin_daily\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1727589540;a:1:{s:29:\"mc4wp_refresh_mailchimp_lists\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1727602586;a:1:{s:20:\"jetpack_v2_heartbeat\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1727602600;a:2:{s:33:\"woocommerce_cleanup_personal_data\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:30:\"woocommerce_tracker_send_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1727648682;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1727692200;a:1:{s:29:\"duplicator_email_summary_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1727854053;a:1:{s:30:\"wp_delete_temp_updater_backups\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1727976236;a:1:{s:30:\"duplicator_usage_tracking_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1728639450;a:1:{s:25:\"woocommerce_geoip_updater\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:11:\"fifteendays\";s:4:\"args\";a:0:{}s:8:\"interval\";i:1296000;}}}s:7:\"version\";i:2;}", "yes");
INSERT INTO `wp_options` VALUES("106", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("107", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("108", "widget_archives", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("109", "widget_media_audio", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("110", "widget_media_image", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("111", "widget_media_gallery", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("112", "widget_media_video", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("113", "widget_meta", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("114", "widget_search", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("115", "widget_tag_cloud", "a:2:{i:1;a:3:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:8:\"taxonomy\";s:8:\"post_tag\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("116", "widget_nav_menu", "a:2:{i:1;a:1:{s:5:\"title\";s:10:\"خدمات\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("117", "widget_custom_html", "a:3:{i:1;a:2:{s:5:\"title\";s:0:\"\";s:7:\"content\";s:78:\"<div class=\"download-box\">\r\n	<a href=\"#\">دانلود جزئیات</a>\r\n</div>\";}i:2;a:2:{s:5:\"title\";s:0:\"\";s:7:\"content\";s:453:\"<div class=\"support-box\">\r\n<ul>\r\n	<li class=\"title\">کمک نیاز دارید؟</li>\r\n 	<li class=\"text\">برای پر کردن فرم با ما صحبت کنید؟ با دفتر شرکت تماس بگیرید و ما شما را با یکی از اعضای تیم که می تواند کمک کند ارتباط میدهیم.    </li>\r\n	<li class=\"phone\"><a href=\"tel:02191035407\"><i class=\"fi flaticon-calling\"></i>02191035407</a></li>\r\n</ul>\r\n</div>\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("119", "recovery_keys", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("120", "theme_mods_twentytwentyone", "a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1650147961;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}s:9:\"sidebar-2\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}}}}", "no");
INSERT INTO `wp_options` VALUES("121", "https_detection_errors", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("127", "db_upgraded", "", "yes");
INSERT INTO `wp_options` VALUES("136", "auto_core_update_notified", "a:4:{s:4:\"type\";s:7:\"success\";s:5:\"email\";s:20:\"wpnovin.ir@gmail.com\";s:7:\"version\";s:5:\"6.6.2\";s:9:\"timestamp\";i:1726042791;}", "off");
INSERT INTO `wp_options` VALUES("155", "current_theme", "Zilom", "yes");
INSERT INTO `wp_options` VALUES("156", "theme_mods_twentytwentytwo", "a:3:{i:0;b:0;s:18:\"nav_menu_locations\";a:0:{}s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1650148174;s:4:\"data\";a:1:{s:19:\"wp_inactive_widgets\";a:5:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";i:3;s:7:\"block-5\";i:4;s:7:\"block-6\";}}}}", "no");
INSERT INTO `wp_options` VALUES("157", "theme_switched", "", "yes");
INSERT INTO `wp_options` VALUES("160", "finished_updating_comment_type", "1", "yes");
INSERT INTO `wp_options` VALUES("162", "theme_mods_zilom", "a:3:{i:0;b:0;s:18:\"nav_menu_locations\";a:1:{s:7:\"primary\";i:47;}s:18:\"custom_css_post_id\";i:1375;}", "yes");
INSERT INTO `wp_options` VALUES("163", "gaviasthemer_active_post_types", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("164", "medium_crop", "1", "yes");
INSERT INTO `wp_options` VALUES("165", "nsl-version", "3.1.14", "on");
INSERT INTO `wp_options` VALUES("166", "tutor_wizard", "active", "yes");
INSERT INTO `wp_options` VALUES("168", "wpcf7", "a:2:{s:7:\"version\";s:5:\"5.9.8\";s:13:\"bulk_validate\";a:4:{s:9:\"timestamp\";i:1727516624;s:7:\"version\";s:5:\"5.9.8\";s:11:\"count_valid\";i:1;s:13:\"count_invalid\";i:2;}}", "yes");
INSERT INTO `wp_options` VALUES("169", "elementor_active_kit", "6", "yes");
INSERT INTO `wp_options` VALUES("175", "revslider_servers", "a:3:{i:0;s:22:\"themepunch-ext-a.tools\";i:1;s:22:\"themepunch-ext-b.tools\";i:2;s:22:\"themepunch-ext-c.tools\";}", "yes");
INSERT INTO `wp_options` VALUES("176", "revslider_server_refresh", "1727343212", "yes");
INSERT INTO `wp_options` VALUES("177", "revslider-update-check-short", "1727439265", "yes");
INSERT INTO `wp_options` VALUES("178", "revslider-connection", "1", "yes");
INSERT INTO `wp_options` VALUES("179", "revslider-update-hash", "3385738c30e61954ec57a1ca4d7338ac", "yes");
INSERT INTO `wp_options` VALUES("180", "revslider-latest-version", "6.7.19", "yes");
INSERT INTO `wp_options` VALUES("181", "revslider-stable-version", "4.2.0", "yes");
INSERT INTO `wp_options` VALUES("182", "revslider-notices", "a:3:{i:0;O:8:\"stdClass\":9:{s:7:\"version\";s:5:\"0.9.9\";s:4:\"text\";s:952:\"<div style=\"display: block; background: #1b0e41;text-align: center; height:300px;\"><noscript><img src=\"//updates.themepunch-ext-a.tools//banners/rs60/cyberweek.jpg\" usemap=\"#srbannermap\" style=\"min-width:920px;height:300px;display: inline-block;\"></noscript><img usemap=\"#srbannermap\" style=\"min-width:920px;height:300px;display: inline-block;\" src=\"//updates.themepunch-ext-a.tools//banners/rs60/cyberweek.jpg\"></div>\n<map name=\"srbannermap\">\n    <area target=\"_blank\" alt=\"Slider Revolution\" title=\"Slider Revolution\" href=\"https://www.sliderrevolution.com/black-friday-and-cyber-monday-sale/?utm_source=admin&utm_medium=banner&utm_campaign=srusers&utm_content=cyberweeks22\" coords=\"569,135,890,196\" shape=\"rect\">\n    <area target=\"_blank\" alt=\"Essential Grid\" title=\"Essential Grid\" href=\"https://www.essential-grid.com/?utm_source=admin&utm_medium=banner&utm_campaign=esgusers&utm_content=cyberweeks22\" coords=\"570,200,889,260\" shape=\"rect\">\n</map>\";s:4:\"code\";s:9:\"TPSRCW111\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:9:\"is_global\";b:0;s:4:\"type\";s:1:\"3\";s:10:\"show_until\";s:19:\"0000-00-00 00:00:00\";s:10:\"additional\";a:0:{}}i:1;O:8:\"stdClass\":10:{s:7:\"version\";s:5:\"9.9.9\";s:4:\"text\";s:527:\"<div style=\"display: block; background: #0d0d0e;text-align: center; height: 504px;\"><a href=\"https://account.sliderrevolution.com/portal/pricing/?utm_source=admin&utm_medium=banner&utm_campaign=srusers&utm_content=getpremium3\" target=\"_blank\" rel=\"noopener\"><video style=\"object-fit: cover; background-size: cover; opacity: 1; width: 900px; height: 504px; display: inline-block;\" muted loop autoplay preload=\"auto\"><source src=\"//updates.themepunch-ext-a.tools//banners/rs60/buypremium3.mp4\" type=\"video/mp4\"></video></a></div>\";s:4:\"code\";s:11:\"TPSNOTR3011\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:10:\"registered\";b:0;s:9:\"is_global\";b:0;s:4:\"type\";s:1:\"3\";s:10:\"show_until\";s:19:\"0000-00-00 00:00:00\";s:10:\"additional\";a:0:{}}i:2;O:8:\"stdClass\":10:{s:7:\"version\";s:5:\"0.9.9\";s:4:\"text\";s:302:\"<div style=\"display: block; background: #0d0d0e;text-align: center; height: 250px;\"><a href=\"https://forms.gle/jrzzrpu34VvrFDsMA\" target=\"_blank\" rel=\"noopener\">\n<img style=\"min-width:920px;height:250px;display: inline-block;\" src=\"//updates.themepunch-ext-a.tools//banners/SR2024survey.jpg\"></a></div>\";s:4:\"code\";s:12:\"TPSURVEY2024\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:10:\"registered\";b:1;s:9:\"is_global\";b:0;s:4:\"type\";s:1:\"3\";s:10:\"show_until\";s:19:\"0000-00-00 00:00:00\";s:10:\"additional\";a:0:{}}}", "yes");
INSERT INTO `wp_options` VALUES("183", "revslider-additions", "O:8:\"stdClass\":2:{s:9:\"templates\";O:8:\"stdClass\":3:{s:9:\"tutorials\";a:3:{i:0;O:8:\"stdClass\":2:{s:5:\"title\";s:19:\"Rapid Fire Overview\";s:3:\"url\";s:49:\"https://www.youtube.com/watch?v=LRNTFu-MFgw&t=25s\";}i:1;O:8:\"stdClass\":2:{s:5:\"title\";s:34:\"Responsiveness in Edited Templates\";s:3:\"url\";s:43:\"https://www.youtube.com/watch?v=hP4oV8SWgKY\";}i:2;O:8:\"stdClass\":2:{s:5:\"title\";s:16:\"Animation Basics\";s:3:\"url\";s:43:\"https://www.youtube.com/watch?v=nn3azizwpbs\";}}s:5:\"guide\";O:8:\"stdClass\":3:{s:5:\"title\";s:78:\"Require Expert Technical Advice?<br />Submit a Ticket for Dedicated 1on1 Help.\";s:3:\"url\";s:36:\"https://support.sliderrevolution.com\";s:3:\"img\";s:67:\"//updates.themepunch-ext-a.tools/banners/default_template_guide.jpg\";}s:6:\"bottom\";O:8:\"stdClass\":2:{s:5:\"title\";s:32:\"Load A Template From The Library\";s:3:\"img\";s:61:\"//updates.themepunch-ext-a.tools/banners/guide_mod_banner.png\";}}s:7:\"selling\";b:1;}", "yes");
INSERT INTO `wp_options` VALUES("184", "rs-addons-counter", "33", "yes");
INSERT INTO `wp_options` VALUES("185", "revslider-addons", "O:8:\"stdClass\":33:{s:28:\"revslider-particlewave-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"380\";s:9:\"releaseid\";s:2:\"29\";s:4:\"slug\";s:28:\"revslider-particlewave-addon\";s:12:\"version_from\";s:6:\"6.5.15\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:13:\"Particle Wave\";s:6:\"line_1\";s:36:\"Create 3D particle and polygon grids\";s:6:\"line_2\";s:40:\"with lots of style and animation options\";s:9:\"available\";s:5:\"1.1.5\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:0:\"\";s:4:\"sort\";s:1:\"9\";s:11:\"last_update\";s:10:\"2023-08-24\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:79:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_particlewave.jpg\";s:8:\"img_file\";s:46:\"revslider/addons/images/addon_particlewave.jpg\";s:7:\"img_md5\";s:32:\"623bec30f175f4cc541048f1d6d5fd07\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PW\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:25:\"revslider-particles-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"424\";s:9:\"releaseid\";s:1:\"7\";s:4:\"slug\";s:25:\"revslider-particles-addon\";s:12:\"version_from\";s:5:\"6.5.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:16:\"Particle Effects\";s:6:\"line_1\";s:17:\"Let\'s Parti(cle)!\";s:6:\"line_2\";s:51:\"Add interactive particle animations to your sliders\";s:9:\"available\";s:5:\"3.3.3\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:2:\"10\";s:11:\"last_update\";s:10:\"2023-07-28\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:76:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_particles.jpg\";s:8:\"img_file\";s:43:\"revslider/addons/images/addon_particles.jpg\";s:7:\"img_md5\";s:32:\"b668a4015ddc6a532b43bb558967a062\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PT\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:27:\"revslider-bubblemorph-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"405\";s:9:\"releaseid\";s:2:\"20\";s:4:\"slug\";s:27:\"revslider-bubblemorph-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:11:\"BubbleMorph\";s:6:\"line_1\";s:26:\"Include BubbleMorph Layers\";s:6:\"line_2\";s:33:\"for a decorative lava lamp effect\";s:9:\"available\";s:5:\"6.7.2\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:2:\"20\";s:11:\"last_update\";s:10:\"2024-04-19\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:78:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_bubblemorph.jpg\";s:8:\"img_file\";s:45:\"revslider/addons/images/addon_bubblemorph.jpg\";s:7:\"img_md5\";s:32:\"22d03d5de3034069c6db1fdeafd467cd\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"BM\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:30:\"revslider-transitionpack-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"369\";s:9:\"releaseid\";s:2:\"28\";s:4:\"slug\";s:30:\"revslider-transitionpack-addon\";s:12:\"version_from\";s:5:\"6.5.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:20:\"Advanced Transitions\";s:6:\"line_1\";s:43:\"Add never-before-seen slide transitions to \";s:6:\"line_2\";s:42:\"Slider Revolution with the power of WEBGL.\";s:9:\"available\";s:5:\"1.0.6\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:0:\"\";s:4:\"sort\";s:2:\"30\";s:11:\"last_update\";s:10:\"2023-02-23\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:77:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_transition.jpg\";s:8:\"img_file\";s:44:\"revslider/addons/images/addon_transition.jpg\";s:7:\"img_md5\";s:32:\"fe0f1c539053620039a0ad96c4ac27e6\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"AT\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:27:\"revslider-beforeafter-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"404\";s:9:\"releaseid\";s:2:\"15\";s:4:\"slug\";s:27:\"revslider-beforeafter-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:14:\"Before & After\";s:6:\"line_1\";s:35:\"Compare two slides before and after\";s:6:\"line_2\";s:33:\"use it vertically or horizontally\";s:9:\"available\";s:5:\"3.1.0\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:0:\"\";s:4:\"sort\";s:2:\"40\";s:11:\"last_update\";s:10:\"2023-05-20\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:78:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_beforeafter.jpg\";s:8:\"img_file\";s:45:\"revslider/addons/images/addon_beforeafter.jpg\";s:7:\"img_md5\";s:32:\"5a34f20417a7874e1b95693ef37a0758\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"BA\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:26:\"revslider-typewriter-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"418\";s:9:\"releaseid\";s:1:\"3\";s:4:\"slug\";s:26:\"revslider-typewriter-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:17:\"Typewriter Effect\";s:6:\"line_1\";s:27:\"Enhance your slider\'s text \";s:6:\"line_2\";s:24:\"with typewriter effects \";s:9:\"available\";s:5:\"3.0.6\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:2:\"50\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:77:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_typewriter.jpg\";s:8:\"img_file\";s:44:\"revslider/addons/images/addon_typewriter.jpg\";s:7:\"img_md5\";s:32:\"727b604f6fd3fc55894ba50eb566efed\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"TW\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:25:\"revslider-mousetrap-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"410\";s:9:\"releaseid\";s:2:\"24\";s:4:\"slug\";s:25:\"revslider-mousetrap-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:9:\"Mousetrap\";s:6:\"line_1\";s:31:\"Create all kinds of interesting\";s:6:\"line_2\";s:19:\" mouse interactions\";s:9:\"available\";s:5:\"3.0.4\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:2:\"60\";s:11:\"last_update\";s:10:\"2021-10-20\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:76:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_mousetrap.jpg\";s:8:\"img_file\";s:43:\"revslider/addons/images/addon_mousetrap.jpg\";s:7:\"img_md5\";s:32:\"2329053c3b1d19bdaee131c3dc258d3a\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"MT\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:28:\"revslider-liquideffect-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"409\";s:9:\"releaseid\";s:2:\"21\";s:4:\"slug\";s:28:\"revslider-liquideffect-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Distortion\";s:6:\"line_1\";s:22:\"Add Distortion Effects\";s:6:\"line_2\";s:30:\"to your slides and transitions\";s:9:\"available\";s:5:\"3.0.3\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:2:\"70\";s:11:\"last_update\";s:10:\"2021-10-20\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:77:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_distortion.jpg\";s:8:\"img_file\";s:44:\"revslider/addons/images/addon_distortion.jpg\";s:7:\"img_md5\";s:32:\"c26c52a563008b7dc907a288c1e4bb8e\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"LE\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:22:\"revslider-lottie-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"420\";s:9:\"releaseid\";s:2:\"25\";s:4:\"slug\";s:22:\"revslider-lottie-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Lottie\";s:6:\"line_1\";s:53:\"Adds support for the popular Lottie Animation format,\";s:6:\"line_2\";s:70:\" including animation control, style customization and a local library.\";s:9:\"available\";s:5:\"3.1.2\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:2:\"80\";s:11:\"last_update\";s:10:\"2023-06-26\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:73:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_lottie.jpg\";s:8:\"img_file\";s:40:\"revslider/addons/images/addon_lottie.jpg\";s:7:\"img_md5\";s:32:\"4aa677a45bb13732e4f10bcb632afcce\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"LT\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:26:\"revslider-paintbrush-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"411\";s:9:\"releaseid\";s:2:\"23\";s:4:\"slug\";s:26:\"revslider-paintbrush-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Paintbrush\";s:6:\"line_1\";s:14:\"Paint or Erase\";s:6:\"line_2\";s:22:\"your background images\";s:9:\"available\";s:5:\"3.0.4\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:2:\"90\";s:11:\"last_update\";s:10:\"2023-08-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:77:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_paintbrush.jpg\";s:8:\"img_file\";s:44:\"revslider/addons/images/addon_paintbrush.jpg\";s:7:\"img_md5\";s:32:\"308a56289b9a29d1916c2acfc141b699\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PB\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:22:\"revslider-charts-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"483\";s:9:\"releaseid\";s:2:\"27\";s:4:\"slug\";s:22:\"revslider-charts-addon\";s:12:\"version_from\";s:6:\"6.5.17\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Charts\";s:6:\"line_1\";s:93:\"The Charts addon allows you to create visually impressive line or bar graphs from .csv data, \";s:6:\"line_2\";s:56:\"with tons of options to take full control of the design.\";s:9:\"available\";s:5:\"3.0.5\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:0:\"\";s:4:\"sort\";s:3:\"100\";s:11:\"last_update\";s:10:\"2022-08-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:73:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_charts.jpg\";s:8:\"img_file\";s:40:\"revslider/addons/images/addon_charts.jpg\";s:7:\"img_md5\";s:32:\"d2c184371a575faade425c0377c1fdbd\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"CH\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:22:\"revslider-slicey-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"417\";s:9:\"releaseid\";s:2:\"13\";s:4:\"slug\";s:22:\"revslider-slicey-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Slicey\";s:6:\"line_1\";s:20:\"Slice \'em up nicely!\";s:6:\"line_2\";s:38:\"Create image slices of your background\";s:9:\"available\";s:5:\"6.7.2\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"110\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:73:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_slicey.jpg\";s:8:\"img_file\";s:40:\"revslider/addons/images/addon_slicey.jpg\";s:7:\"img_md5\";s:32:\"28afd29b7738a452194f0a0bc1d21cbe\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SL\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:25:\"revslider-filmstrip-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"422\";s:9:\"releaseid\";s:2:\"10\";s:4:\"slug\";s:25:\"revslider-filmstrip-addon\";s:12:\"version_from\";s:5:\"6.5.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:9:\"Filmstrip\";s:6:\"line_1\";s:44:\"Display a continously rotating set of images\";s:6:\"line_2\";s:26:\"for your slide backgrounds\";s:9:\"available\";s:5:\"3.0.6\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"125\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:76:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_filmstrip.jpg\";s:8:\"img_file\";s:43:\"revslider/addons/images/addon_filmstrip.jpg\";s:7:\"img_md5\";s:32:\"dac40ee57d2be9aaf01faacf51ccb412\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"FS\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:27:\"revslider-maintenance-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"421\";s:9:\"releaseid\";s:1:\"4\";s:4:\"slug\";s:27:\"revslider-maintenance-addon\";s:12:\"version_from\";s:5:\"6.5.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:15:\"Coming & Maint.\";s:6:\"line_1\";s:37:\"Simple Coming Soon & Maintenance Page\";s:6:\"line_2\";s:42:\"Let your visitors know what\'s up and when!\";s:9:\"available\";s:5:\"3.0.0\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"127\";s:11:\"last_update\";s:10:\"2023-07-17\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:84:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_underconstruction.jpg\";s:8:\"img_file\";s:51:\"revslider/addons/images/addon_underconstruction.jpg\";s:7:\"img_md5\";s:32:\"17f8cba84931541c065cfb1943edafb2\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"MT\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:24:\"revslider-revealer-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"416\";s:9:\"releaseid\";s:2:\"19\";s:4:\"slug\";s:24:\"revslider-revealer-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Reveal\";s:6:\"line_1\";s:9:\"Reveal...\";s:6:\"line_2\";s:37:\"...your inner beast... and RevSliders\";s:9:\"available\";s:5:\"3.0.3\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"130\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:73:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_reveal.jpg\";s:8:\"img_file\";s:40:\"revslider/addons/images/addon_reveal.jpg\";s:7:\"img_md5\";s:32:\"a7ce4bf5eb6fdc1497ed6276ca623046\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"RV\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:24:\"revslider-panorama-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"423\";s:9:\"releaseid\";s:2:\"17\";s:4:\"slug\";s:24:\"revslider-panorama-addon\";s:12:\"version_from\";s:5:\"6.5.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:8:\"Panorama\";s:6:\"line_1\";s:14:\"Panorama AddOn\";s:6:\"line_2\";s:28:\"Display images in 360 degree\";s:9:\"available\";s:5:\"3.0.9\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"135\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:75:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_panorama.jpg\";s:8:\"img_file\";s:42:\"revslider/addons/images/addon_panorama.jpg\";s:7:\"img_md5\";s:32:\"210953d59903bed91688138cb60777d2\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PN\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:27:\"revslider-scrollvideo-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"396\";s:9:\"releaseid\";s:2:\"26\";s:4:\"slug\";s:27:\"revslider-scrollvideo-addon\";s:12:\"version_from\";s:5:\"6.5.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:12:\"Scroll Video\";s:6:\"line_1\";s:114:\"This addon allows you to generate a sequence of images from any html5 video and play them with scroll interaction.\";s:6:\"line_2\";s:49:\"Quality options are included for optimal results!\";s:9:\"available\";s:5:\"3.0.2\";s:10:\"background\";s:78:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_scrollvideo.jpg\";s:15:\"background_file\";s:45:\"revslider/addons/images/addon_scrollvideo.jpg\";s:14:\"background_md5\";s:32:\"82b2706dfa20a7b0cfabfe7ff28562f9\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"140\";s:11:\"last_update\";s:10:\"2021-12-23\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:78:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_scrollvideo.jpg\";s:8:\"img_file\";s:45:\"revslider/addons/images/addon_scrollvideo.jpg\";s:7:\"img_md5\";s:32:\"82b2706dfa20a7b0cfabfe7ff28562f9\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SV\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:31:\"revslider-explodinglayers-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"407\";s:9:\"releaseid\";s:2:\"22\";s:4:\"slug\";s:31:\"revslider-explodinglayers-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:16:\"Exploding Layers\";s:6:\"line_1\";s:23:\"Add explosive particles\";s:6:\"line_2\";s:24:\"to your layers animation\";s:9:\"available\";s:5:\"3.0.5\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"150\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:76:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_exploding.jpg\";s:8:\"img_file\";s:43:\"revslider/addons/images/addon_exploding.jpg\";s:7:\"img_md5\";s:32:\"44d60b83cdf5b29033d41feb516b47e1\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"EL\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:23:\"revslider-sharing-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"397\";s:9:\"releaseid\";s:1:\"5\";s:4:\"slug\";s:23:\"revslider-sharing-addon\";s:12:\"version_from\";s:5:\"6.5.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:14:\"Social Sharing\";s:6:\"line_1\";s:17:\"Share your slides\";s:6:\"line_2\";s:50:\"with RevSlider \"actions\" because sharing is caring\";s:9:\"available\";s:5:\"3.0.1\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"165\";s:11:\"last_update\";s:10:\"2023-07-08\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:80:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_socialsharing.jpg\";s:8:\"img_file\";s:47:\"revslider/addons/images/addon_socialsharing.jpg\";s:7:\"img_md5\";s:32:\"6b074630853c4f95d5337bc85e496cbe\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SH\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:26:\"revslider-whiteboard-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"419\";s:9:\"releaseid\";s:1:\"1\";s:4:\"slug\";s:26:\"revslider-whiteboard-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Whiteboard\";s:6:\"line_1\";s:31:\"Create Hand-Drawn Presentations\";s:6:\"line_2\";s:45:\"that are understandable, memorable & engaging\";s:9:\"available\";s:5:\"3.0.5\";s:10:\"background\";s:81:\"//updates.themepunch-ext-a.tools/revslider/addons/images/whiteboard_widget_bg.jpg\";s:15:\"background_file\";s:48:\"revslider/addons/images/whiteboard_widget_bg.jpg\";s:14:\"background_md5\";s:32:\"cc69160eb95469dc033e0cc094a24847\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"170\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:77:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_whiteboard.jpg\";s:8:\"img_file\";s:44:\"revslider/addons/images/addon_whiteboard.jpg\";s:7:\"img_md5\";s:32:\"b0bb636fb30ffc3d112ba4c563395ee6\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"WB\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:24:\"revslider-polyfold-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"414\";s:9:\"releaseid\";s:2:\"14\";s:4:\"slug\";s:24:\"revslider-polyfold-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:22:\"Polyfold Scroll Effect\";s:6:\"line_1\";s:32:\"Add sharp edges to your sliders \";s:6:\"line_2\";s:35:\"as they scroll into and out of view\";s:9:\"available\";s:5:\"3.0.6\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"180\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:75:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_polyfold.jpg\";s:8:\"img_file\";s:42:\"revslider/addons/images/addon_polyfold.jpg\";s:7:\"img_md5\";s:32:\"02c6af89e4208f0da5920c6c3e6bb744\";s:5:\"color\";s:7:\"#3e186f\";s:4:\"text\";s:2:\"PF\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:29:\"revslider-domain-switch-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:2:\"78\";s:9:\"releaseid\";s:2:\"11\";s:4:\"slug\";s:29:\"revslider-domain-switch-addon\";s:12:\"version_from\";s:5:\"6.0.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:13:\"Domain Switch\";s:6:\"line_1\";s:17:\"Switch Image URLs\";s:6:\"line_2\";s:37:\"in sliders from one domain to another\";s:9:\"available\";s:5:\"1.0.1\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"300\";s:11:\"last_update\";s:10:\"2022-02-19\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:79:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_domainswitch.jpg\";s:8:\"img_file\";s:46:\"revslider/addons/images/addon_domainswitch.jpg\";s:7:\"img_md5\";s:32:\"f2036924e7993f94bd5c9876fa0bf09b\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"DS\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:23:\"revslider-refresh-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"415\";s:9:\"releaseid\";s:2:\"10\";s:4:\"slug\";s:23:\"revslider-refresh-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:8:\"(Re)Load\";s:6:\"line_1\";s:39:\"Reload the current page or a custom URL\";s:6:\"line_2\";s:34:\"after a certain time, loops, slide\";s:9:\"available\";s:5:\"3.0.4\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"330\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:73:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_reload.jpg\";s:8:\"img_file\";s:40:\"revslider/addons/images/addon_reload.jpg\";s:7:\"img_md5\";s:32:\"d1d34d204e627168f4cc4e7422a6d40c\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"RF\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:25:\"revslider-rel-posts-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:2:\"55\";s:9:\"releaseid\";s:1:\"9\";s:4:\"slug\";s:25:\"revslider-rel-posts-addon\";s:12:\"version_from\";s:7:\"5.2.4.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:13:\"Related Posts\";s:6:\"line_1\";s:25:\"Add related Posts Sliders\";s:6:\"line_2\";s:31:\"at the end of your post content\";s:9:\"available\";s:5:\"2.0.2\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"340\";s:11:\"last_update\";s:10:\"2023-06-12\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:76:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_wprelated.jpg\";s:8:\"img_file\";s:43:\"revslider/addons/images/addon_wprelated.jpg\";s:7:\"img_md5\";s:32:\"e2e7d6c3a428a55442ba90131556c930\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"RP\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:20:\"revslider-snow-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"399\";s:9:\"releaseid\";s:1:\"6\";s:4:\"slug\";s:20:\"revslider-snow-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:12:\"Holiday Snow\";s:6:\"line_1\";s:12:\"Let it snow!\";s:6:\"line_2\";s:32:\"Add animated snow to any Slider \";s:9:\"available\";s:5:\"3.0.5\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"380\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:71:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_snow.jpg\";s:8:\"img_file\";s:38:\"revslider/addons/images/addon_snow.jpg\";s:7:\"img_md5\";s:32:\"d6bac718866b0070198a4340041bc60b\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SN\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:23:\"revslider-gallery-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"378\";s:9:\"releaseid\";s:1:\"2\";s:4:\"slug\";s:23:\"revslider-gallery-addon\";s:12:\"version_from\";s:6:\"6.4.11\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:17:\"WordPress Gallery\";s:6:\"line_1\";s:31:\"Replace the standard WP Gallery\";s:6:\"line_2\";s:31:\"with the Sliders of your choice\";s:9:\"available\";s:5:\"2.0.5\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"430\";s:11:\"last_update\";s:10:\"2023-12-11\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:76:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_wpgallery.jpg\";s:8:\"img_file\";s:43:\"revslider/addons/images/addon_wpgallery.jpg\";s:7:\"img_md5\";s:32:\"74392a04b741d83c51e55059dbb388ef\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"GA\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:22:\"revslider-backup-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:2:\"53\";s:9:\"releaseid\";s:1:\"3\";s:4:\"slug\";s:22:\"revslider-backup-addon\";s:12:\"version_from\";s:5:\"5.2.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Backup\";s:6:\"line_1\";s:12:\"Make Backups\";s:6:\"line_2\";s:25:\"Revisions for your safety\";s:9:\"available\";s:5:\"2.0.3\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"500\";s:11:\"last_update\";s:10:\"2023-05-31\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:73:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_backup.jpg\";s:8:\"img_file\";s:40:\"revslider/addons/images/addon_backup.jpg\";s:7:\"img_md5\";s:32:\"104797323a0293cd3f200b0172db1186\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"BU\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:19:\"revslider-404-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:2:\"62\";s:9:\"releaseid\";s:1:\"8\";s:4:\"slug\";s:19:\"revslider-404-addon\";s:12:\"version_from\";s:3:\"5.3\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:3:\"404\";s:6:\"line_1\";s:39:\"Build custom 404 \"Page not Found\" Pages\";s:6:\"line_2\";s:28:\"with Slider Revolution swag!\";s:9:\"available\";s:5:\"2.0.1\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"620\";s:11:\"last_update\";s:10:\"2022-12-04\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:70:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_404.jpg\";s:8:\"img_file\";s:37:\"revslider/addons/images/addon_404.jpg\";s:7:\"img_md5\";s:32:\"217b0d118a107dc50979740dd61228df\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:3:\"404\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:30:\"revslider-prevnext-posts-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:2:\"63\";s:9:\"releaseid\";s:1:\"9\";s:4:\"slug\";s:30:\"revslider-prevnext-posts-addon\";s:12:\"version_from\";s:3:\"5.4\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:14:\"Adjacent Posts\";s:6:\"line_1\";s:30:\"Display previous and next post\";s:6:\"line_2\";s:28:\"to the currently showing one\";s:9:\"available\";s:5:\"2.0.2\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"630\";s:11:\"last_update\";s:10:\"2023-08-04\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:77:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_wpadjacent.jpg\";s:8:\"img_file\";s:44:\"revslider/addons/images/addon_wpadjacent.jpg\";s:7:\"img_md5\";s:32:\"cb1feb1257e55d0f42c29dfde2d809ed\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PN\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:21:\"revslider-login-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"388\";s:9:\"releaseid\";s:2:\"11\";s:4:\"slug\";s:21:\"revslider-login-addon\";s:12:\"version_from\";s:5:\"6.5.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Login Page\";s:6:\"line_1\";s:25:\"Very simple WP Login Page\";s:6:\"line_2\";s:34:\"enhanced with your favorite slider\";s:9:\"available\";s:5:\"3.0.1\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"650\";s:11:\"last_update\";s:10:\"2023-06-12\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:72:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_login.jpg\";s:8:\"img_file\";s:39:\"revslider/addons/images/addon_login.jpg\";s:7:\"img_md5\";s:32:\"f0f2edffb4e155acf67799692428644d\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"LI\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:24:\"revslider-featured-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"379\";s:9:\"releaseid\";s:2:\"12\";s:4:\"slug\";s:24:\"revslider-featured-addon\";s:12:\"version_from\";s:6:\"6.4.11\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:20:\"Post Featured Slider\";s:6:\"line_1\";s:25:\"Display a featured Slider\";s:6:\"line_2\";s:41:\"instead of a featured Image in your Posts\";s:9:\"available\";s:5:\"2.0.4\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"660\";s:11:\"last_update\";s:10:\"2023-05-31\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:77:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_wpfeatured.jpg\";s:8:\"img_file\";s:44:\"revslider/addons/images/addon_wpfeatured.jpg\";s:7:\"img_md5\";s:32:\"bcc840e68194f3eb05795e1353954bda\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"FT\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:23:\"revslider-weather-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"402\";s:9:\"releaseid\";s:2:\"16\";s:4:\"slug\";s:23:\"revslider-weather-addon\";s:12:\"version_from\";s:5:\"6.5.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:7:\"Weather\";s:6:\"line_1\";s:21:\"Every where you go...\";s:6:\"line_2\";s:36:\"...always take the weather with you!\";s:9:\"available\";s:5:\"3.0.1\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"690\";s:11:\"last_update\";s:10:\"2023-05-31\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:74:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_weather.jpg\";s:8:\"img_file\";s:41:\"revslider/addons/images/addon_weather.jpg\";s:7:\"img_md5\";s:32:\"c69d1c9a69c2dec43ca0578ac35792bd\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"WT\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:30:\"revslider-duotonefilters-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"406\";s:9:\"releaseid\";s:2:\"18\";s:4:\"slug\";s:30:\"revslider-duotonefilters-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:7:\"Duotone\";s:6:\"line_1\";s:7:\"Duotone\";s:6:\"line_2\";s:25:\"Because one is not enough\";s:9:\"available\";s:5:\"3.0.5\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"710\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:74:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_duotone.jpg\";s:8:\"img_file\";s:41:\"revslider/addons/images/addon_duotone.jpg\";s:7:\"img_md5\";s:32:\"fb666e487e7ac28e6a2a157eed1fb682\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:3:\"DTF\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}}", "yes");
INSERT INTO `wp_options` VALUES("186", "revslider-library-check", "1726229678", "yes");
INSERT INTO `wp_options` VALUES("187", "revslider-library-hash", "dae3de1eb57eeeee008b70e9a23844b5", "yes");
INSERT INTO `wp_options` VALUES("188", "rs-library", "a:3:{s:4:\"hash\";s:32:\"dae3de1eb57eeeee008b70e9a23844b5\";s:7:\"objects\";a:417:{i:0;a:12:{s:2:\"id\";s:3:\"198\";s:6:\"handle\";s:16:\"object_dvd_1.png\";s:4:\"name\";s:3:\"DVD\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:43:17\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:1;a:12:{s:2:\"id\";s:3:\"188\";s:6:\"handle\";s:18:\"object_plant_1.png\";s:4:\"name\";s:7:\"Plant 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-12 16:25:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:2;a:12:{s:2:\"id\";s:3:\"187\";s:6:\"handle\";s:16:\"object_pen_1.png\";s:4:\"name\";s:5:\"Pen 1\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-12 16:25:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:3;a:12:{s:2:\"id\";s:3:\"172\";s:6:\"handle\";s:16:\"object_egg_1.png\";s:4:\"name\";s:3:\"Egg\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"600\";s:6:\"height\";s:3:\"600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:4;a:12:{s:2:\"id\";s:3:\"171\";s:6:\"handle\";s:19:\"object_guitar_1.png\";s:4:\"name\";s:6:\"Guitar\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:5;a:12:{s:2:\"id\";s:3:\"170\";s:6:\"handle\";s:21:\"object_envelope_1.png\";s:4:\"name\";s:15:\"Closed Envelope\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:6;a:12:{s:2:\"id\";s:3:\"169\";s:6:\"handle\";s:19:\"object_postit_2.png\";s:4:\"name\";s:18:\"Postit Label White\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:7;a:12:{s:2:\"id\";s:3:\"168\";s:6:\"handle\";s:21:\"object_envelope_2.png\";s:4:\"name\";s:13:\"Open Envelope\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:8;a:12:{s:2:\"id\";s:3:\"167\";s:6:\"handle\";s:17:\"object_eggs_1.png\";s:4:\"name\";s:10:\"Egg Carton\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:9;a:12:{s:2:\"id\";s:3:\"166\";s:6:\"handle\";s:25:\"object_bottleopener_1.png\";s:4:\"name\";s:13:\"Bottle Opener\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:10;a:12:{s:2:\"id\";s:3:\"165\";s:6:\"handle\";s:23:\"object_blueprints_1.png\";s:4:\"name\";s:10:\"Blueprints\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:11;a:12:{s:2:\"id\";s:3:\"164\";s:6:\"handle\";s:22:\"object_holepunch_1.png\";s:4:\"name\";s:10:\"Hole punch\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:12;a:12:{s:2:\"id\";s:3:\"163\";s:6:\"handle\";s:20:\"object_speaker_1.png\";s:4:\"name\";s:13:\"Black Speaker\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:13;a:12:{s:2:\"id\";s:3:\"162\";s:6:\"handle\";s:19:\"object_eraser_1.png\";s:4:\"name\";s:6:\"Eraser\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:14;a:12:{s:2:\"id\";s:3:\"161\";s:6:\"handle\";s:23:\"object_vinylcover_1.png\";s:4:\"name\";s:11:\"Vinyl Cover\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:15;a:12:{s:2:\"id\";s:3:\"160\";s:6:\"handle\";s:20:\"object_booklet_1.png\";s:4:\"name\";s:9:\"Booklet 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:16;a:12:{s:2:\"id\";s:3:\"159\";s:6:\"handle\";s:22:\"object_earphones_2.png\";s:4:\"name\";s:11:\"Earphones 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:17;a:12:{s:2:\"id\";s:3:\"158\";s:6:\"handle\";s:18:\"object_vinyl_1.png\";s:4:\"name\";s:5:\"Vinyl\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:18;a:12:{s:2:\"id\";s:3:\"157\";s:6:\"handle\";s:19:\"object_postit_1.png\";s:4:\"name\";s:17:\"Postit Label Pink\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:19;a:12:{s:2:\"id\";s:3:\"156\";s:6:\"handle\";s:23:\"object_mechpencil_1.png\";s:4:\"name\";s:17:\"Mechanical Pencil\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:20;a:12:{s:2:\"id\";s:3:\"155\";s:6:\"handle\";s:22:\"object_turntable_1.png\";s:4:\"name\";s:9:\"Turntable\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:21;a:12:{s:2:\"id\";s:3:\"154\";s:6:\"handle\";s:19:\"object_folder_2.png\";s:4:\"name\";s:19:\"Closed Folder Black\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:22;a:12:{s:2:\"id\";s:3:\"153\";s:6:\"handle\";s:19:\"object_postit_4.png\";s:4:\"name\";s:18:\"Postit Label Green\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:23;a:12:{s:2:\"id\";s:3:\"152\";s:6:\"handle\";s:19:\"object_folder_1.png\";s:4:\"name\";s:12:\"Blank Folder\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:24;a:12:{s:2:\"id\";s:3:\"151\";s:6:\"handle\";s:19:\"object_pencup_1.png\";s:4:\"name\";s:7:\"Pen Cup\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:25;a:12:{s:2:\"id\";s:3:\"150\";s:6:\"handle\";s:23:\"object_winebottle_1.png\";s:4:\"name\";s:15:\"Red Wine Bottle\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:26;a:12:{s:2:\"id\";s:3:\"149\";s:6:\"handle\";s:23:\"object_headphones_1.png\";s:4:\"name\";s:10:\"Headphones\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:27;a:12:{s:2:\"id\";s:3:\"148\";s:6:\"handle\";s:22:\"object_earphones_1.png\";s:4:\"name\";s:9:\"Earphones\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:28;a:12:{s:2:\"id\";s:3:\"147\";s:6:\"handle\";s:19:\"object_postit_3.png\";s:4:\"name\";s:19:\"Postit Label Yellow\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:29;a:12:{s:2:\"id\";s:3:\"146\";s:6:\"handle\";s:22:\"object_corkscrew_1.png\";s:4:\"name\";s:23:\"Corkscrew Bottle Opener\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1300\";s:6:\"height\";s:4:\"1300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:30;a:12:{s:2:\"id\";s:3:\"145\";s:6:\"handle\";s:19:\"object_muffin_1.png\";s:4:\"name\";s:16:\"Chocolate Muffin\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:31;a:12:{s:2:\"id\";s:3:\"144\";s:6:\"handle\";s:18:\"object_chair_2.png\";s:4:\"name\";s:12:\"Yellow Chair\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:32;a:12:{s:2:\"id\";s:3:\"143\";s:6:\"handle\";s:18:\"object_knife_2.png\";s:4:\"name\";s:7:\"Knife 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:33;a:12:{s:2:\"id\";s:3:\"142\";s:6:\"handle\";s:26:\"object_choppingboard_2.png\";s:4:\"name\";s:16:\"Chopping Board 3\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:34;a:12:{s:2:\"id\";s:3:\"141\";s:6:\"handle\";s:26:\"object_choppingboard_3.png\";s:4:\"name\";s:16:\"Chopping Board 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:35;a:12:{s:2:\"id\";s:3:\"140\";s:6:\"handle\";s:19:\"object_coffee_2.png\";s:4:\"name\";s:12:\"Coffee Cup 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1200\";s:6:\"height\";s:4:\"1200\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:36;a:12:{s:2:\"id\";s:3:\"139\";s:6:\"handle\";s:18:\"object_bread_1.png\";s:4:\"name\";s:15:\"Croissant Bread\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:37;a:12:{s:2:\"id\";s:3:\"138\";s:6:\"handle\";s:18:\"object_spoon_2.png\";s:4:\"name\";s:12:\"Wodden Spoon\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:38;a:12:{s:2:\"id\";s:3:\"137\";s:6:\"handle\";s:26:\"object_choppingboard_1.png\";s:4:\"name\";s:16:\"Chopping Board 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:39;a:12:{s:2:\"id\";s:3:\"136\";s:6:\"handle\";s:16:\"object_cup_2.png\";s:4:\"name\";s:11:\"Empty Cup 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:40;a:12:{s:2:\"id\";s:3:\"135\";s:6:\"handle\";s:18:\"object_knife_1.png\";s:4:\"name\";s:5:\"Knife\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:41;a:12:{s:2:\"id\";s:3:\"134\";s:6:\"handle\";s:18:\"object_spoon_1.png\";s:4:\"name\";s:5:\"Spoon\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:42;a:12:{s:2:\"id\";s:3:\"133\";s:6:\"handle\";s:16:\"object_cup_1.png\";s:4:\"name\";s:9:\"Empty Cup\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:43;a:12:{s:2:\"id\";s:3:\"132\";s:6:\"handle\";s:18:\"object_chair_3.png\";s:4:\"name\";s:11:\"White Chair\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:44;a:12:{s:2:\"id\";s:3:\"131\";s:6:\"handle\";s:19:\"object_coffee_1.png\";s:4:\"name\";s:10:\"Coffee Cup\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:45;a:12:{s:2:\"id\";s:3:\"130\";s:6:\"handle\";s:19:\"object_frypan_2.png\";s:4:\"name\";s:9:\"Fry Pan 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:46;a:12:{s:2:\"id\";s:3:\"129\";s:6:\"handle\";s:19:\"object_frypan_1.png\";s:4:\"name\";s:9:\"Fry Pan 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:47;a:12:{s:2:\"id\";s:3:\"128\";s:6:\"handle\";s:17:\"object_fork_1.png\";s:4:\"name\";s:4:\"Fork\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:48;a:12:{s:2:\"id\";s:3:\"127\";s:6:\"handle\";s:20:\"object_dishrag_1.png\";s:4:\"name\";s:13:\"Dishrag Cloth\";s:4:\"tags\";a:0:{}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:49;a:12:{s:2:\"id\";s:3:\"126\";s:6:\"handle\";s:20:\"object_wacom_pen.png\";s:4:\"name\";s:17:\"Wacom Drawing Pen\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:2;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1060\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:50;a:12:{s:2:\"id\";s:3:\"125\";s:6:\"handle\";s:21:\"object_occulus_vr.png\";s:4:\"name\";s:23:\"Occulus Virtual Reality\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:51;a:12:{s:2:\"id\";s:3:\"124\";s:6:\"handle\";s:18:\"object_antenna.png\";s:4:\"name\";s:13:\"Antenna Radar\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:52;a:12:{s:2:\"id\";s:3:\"123\";s:6:\"handle\";s:21:\"object_solarpanel.png\";s:4:\"name\";s:11:\"Solar Panel\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:53;a:12:{s:2:\"id\";s:3:\"122\";s:6:\"handle\";s:16:\"object_wacom.png\";s:4:\"name\";s:20:\"Wacom Drawing Tablet\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:2;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:54;a:12:{s:2:\"id\";s:3:\"121\";s:6:\"handle\";s:18:\"object_earth_2.png\";s:4:\"name\";s:20:\"Earth Globe Planet 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:55;a:12:{s:2:\"id\";s:3:\"120\";s:6:\"handle\";s:18:\"object_chair_1.png\";s:4:\"name\";s:12:\"Office Chair\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:56;a:12:{s:2:\"id\";s:3:\"119\";s:6:\"handle\";s:24:\"object_windturbine_2.png\";s:4:\"name\";s:14:\"Wind Turbine 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:57;a:12:{s:2:\"id\";s:3:\"118\";s:6:\"handle\";s:22:\"object_windturbine.png\";s:4:\"name\";s:12:\"Wind Turbine\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:58;a:12:{s:2:\"id\";s:3:\"117\";s:6:\"handle\";s:16:\"object_earth.png\";s:4:\"name\";s:18:\"Earth Globe Planet\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:59;a:12:{s:2:\"id\";s:2:\"88\";s:6:\"handle\";s:24:\"object_eiffeltower_2.png\";s:4:\"name\";s:13:\"Eiffeltower 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"700\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:60;a:12:{s:2:\"id\";s:2:\"87\";s:6:\"handle\";s:21:\"object_notebook_1.png\";s:4:\"name\";s:11:\"Notebook PC\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:61;a:12:{s:2:\"id\";s:2:\"86\";s:6:\"handle\";s:20:\"object_macbook_1.png\";s:4:\"name\";s:20:\"Apple Macbook Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:62;a:12:{s:2:\"id\";s:2:\"85\";s:6:\"handle\";s:18:\"object_canon_2.png\";s:4:\"name\";s:21:\"Canon Camera DSLR Top\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:63;a:12:{s:2:\"id\";s:2:\"84\";s:6:\"handle\";s:19:\"object_iphone_3.png\";s:4:\"name\";s:25:\"Apple iPhone Silver White\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:64;a:12:{s:2:\"id\";s:2:\"83\";s:6:\"handle\";s:18:\"object_candy_2.png\";s:4:\"name\";s:15:\"Candy Colored 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:65;a:12:{s:2:\"id\";s:2:\"82\";s:6:\"handle\";s:21:\"object_macmouse_1.png\";s:4:\"name\";s:15:\"Apple Mac Mouse\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:66;a:12:{s:2:\"id\";s:2:\"81\";s:6:\"handle\";s:19:\"object_iphone_1.png\";s:4:\"name\";s:18:\"Apple iPhone Black\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:67;a:12:{s:2:\"id\";s:2:\"80\";s:6:\"handle\";s:17:\"object_deco_1.png\";s:4:\"name\";s:17:\"White Deco Object\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:68;a:12:{s:2:\"id\";s:2:\"79\";s:6:\"handle\";s:23:\"object_applewatch_1.png\";s:4:\"name\";s:24:\"Apple Watch White Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:69;a:12:{s:2:\"id\";s:2:\"78\";s:6:\"handle\";s:23:\"object_swissknife_1.png\";s:4:\"name\";s:11:\"Swiss Knife\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:70;a:12:{s:2:\"id\";s:2:\"77\";s:6:\"handle\";s:23:\"object_applewatch_2.png\";s:4:\"name\";s:17:\"Apple Watch Black\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:71;a:12:{s:2:\"id\";s:2:\"76\";s:6:\"handle\";s:18:\"object_candy_1.png\";s:4:\"name\";s:13:\"Candy Colored\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:72;a:12:{s:2:\"id\";s:2:\"75\";s:6:\"handle\";s:17:\"object_ipad_1.png\";s:4:\"name\";s:16:\"Apple iPad Black\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:73;a:12:{s:2:\"id\";s:2:\"74\";s:6:\"handle\";s:17:\"object_lamp_2.png\";s:4:\"name\";s:15:\"Black Desk Lamp\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:74;a:12:{s:2:\"id\";s:2:\"73\";s:6:\"handle\";s:18:\"object_canon_1.png\";s:4:\"name\";s:17:\"Canon Camera DLSR\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:75;a:12:{s:2:\"id\";s:2:\"72\";s:6:\"handle\";s:23:\"object_blackberry_2.png\";s:4:\"name\";s:12:\"Blackberry 3\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:76;a:12:{s:2:\"id\";s:2:\"71\";s:6:\"handle\";s:19:\"object_iphone_2.png\";s:4:\"name\";s:19:\"Apple iPhone Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:77;a:12:{s:2:\"id\";s:2:\"70\";s:6:\"handle\";s:17:\"object_ipad_2.png\";s:4:\"name\";s:15:\"Apple iPad Gold\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:78;a:12:{s:2:\"id\";s:2:\"69\";s:6:\"handle\";s:20:\"object_printer_1.png\";s:4:\"name\";s:7:\"Printer\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:79;a:12:{s:2:\"id\";s:2:\"68\";s:6:\"handle\";s:20:\"object_pcmouse_1.png\";s:4:\"name\";s:14:\"Black PC Mouse\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:80;a:12:{s:2:\"id\";s:2:\"67\";s:6:\"handle\";s:17:\"object_ipad_3.png\";s:4:\"name\";s:17:\"Apple iPad Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:81;a:12:{s:2:\"id\";s:2:\"66\";s:6:\"handle\";s:17:\"object_lamp_1.png\";s:4:\"name\";s:13:\"Desk Lamp Top\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:82;a:12:{s:2:\"id\";s:2:\"65\";s:6:\"handle\";s:22:\"object_macscreen_1.png\";s:4:\"name\";s:16:\"Apple Mac Screen\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:83;a:12:{s:2:\"id\";s:2:\"64\";s:6:\"handle\";s:23:\"object_blackberry_3.png\";s:4:\"name\";s:12:\"Blackberry 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:84;a:12:{s:2:\"id\";s:2:\"63\";s:6:\"handle\";s:23:\"object_applewatch_3.png\";s:4:\"name\";s:16:\"Apple Watch Gold\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:85;a:12:{s:2:\"id\";s:2:\"62\";s:6:\"handle\";s:23:\"object_blackberry_1.png\";s:4:\"name\";s:10:\"Blackberry\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:86;a:12:{s:2:\"id\";s:2:\"49\";s:6:\"handle\";s:19:\"object_bottle_1.png\";s:4:\"name\";s:18:\"Brown Glass Bottle\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:87;a:12:{s:2:\"id\";s:2:\"48\";s:6:\"handle\";s:20:\"object_glasses_1.png\";s:4:\"name\";s:19:\"Hipster Glasses Top\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:88;a:12:{s:2:\"id\";s:2:\"47\";s:6:\"handle\";s:21:\"object_magazine_1.png\";s:4:\"name\";s:14:\"Blank Magazine\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:89;a:12:{s:2:\"id\";s:2:\"46\";s:6:\"handle\";s:28:\"object_leatherdocument_2.png\";s:4:\"name\";s:24:\"Black Leather Document 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:90;a:12:{s:2:\"id\";s:2:\"45\";s:6:\"handle\";s:18:\"object_purse_2.png\";s:4:\"name\";s:13:\"Black Purse 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:91;a:12:{s:2:\"id\";s:2:\"44\";s:6:\"handle\";s:23:\"object_typewriter_1.png\";s:4:\"name\";s:18:\"Retro Typewriter 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:92;a:12:{s:2:\"id\";s:2:\"43\";s:6:\"handle\";s:17:\"object_book_5.png\";s:4:\"name\";s:9:\"Old Books\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:93;a:12:{s:2:\"id\";s:2:\"42\";s:6:\"handle\";s:28:\"object_leatherdocument_1.png\";s:4:\"name\";s:29:\"Black Leather Document Closed\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:94;a:12:{s:2:\"id\";s:2:\"41\";s:6:\"handle\";s:17:\"object_book_4.png\";s:4:\"name\";s:8:\"Old Book\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:95;a:12:{s:2:\"id\";s:2:\"40\";s:6:\"handle\";s:19:\"object_wallet_2.png\";s:4:\"name\";s:22:\"Black Leather Document\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:96;a:12:{s:2:\"id\";s:2:\"39\";s:6:\"handle\";s:18:\"object_quill_2.png\";s:4:\"name\";s:15:\"Quill Feather 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:97;a:12:{s:2:\"id\";s:2:\"38\";s:6:\"handle\";s:24:\"object_eiffeltower_1.png\";s:4:\"name\";s:11:\"Eiffeltower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:98;a:12:{s:2:\"id\";s:2:\"37\";s:6:\"handle\";s:21:\"object_magazine_2.png\";s:4:\"name\";s:11:\"Open Book 3\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1333\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:99;a:12:{s:2:\"id\";s:2:\"36\";s:6:\"handle\";s:17:\"object_book_1.png\";s:4:\"name\";s:10:\"Blank Book\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:100;a:12:{s:2:\"id\";s:2:\"35\";s:6:\"handle\";s:20:\"object_glasses_2.png\";s:4:\"name\";s:15:\"Hipster Glasses\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:101;a:12:{s:2:\"id\";s:2:\"34\";s:6:\"handle\";s:17:\"object_book_2.png\";s:4:\"name\";s:11:\"Open Book 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:102;a:12:{s:2:\"id\";s:2:\"33\";s:6:\"handle\";s:19:\"object_gloves_1.png\";s:4:\"name\";s:12:\"Black Gloves\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:103;a:12:{s:2:\"id\";s:2:\"32\";s:6:\"handle\";s:23:\"object_typewriter_2.png\";s:4:\"name\";s:16:\"Retro Typewriter\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:104;a:12:{s:2:\"id\";s:2:\"31\";s:6:\"handle\";s:17:\"object_book_3.png\";s:4:\"name\";s:9:\"Open Book\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:105;a:12:{s:2:\"id\";s:2:\"30\";s:6:\"handle\";s:19:\"object_wallet_1.png\";s:4:\"name\";s:12:\"Black Wallet\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:106;a:12:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:18:\"object_purse_1.png\";s:4:\"name\";s:11:\"Black Purse\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:107;a:12:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:18:\"object_quill_1.png\";s:4:\"name\";s:13:\"Quill Feather\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:108;a:12:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:19:\"object_artbox_2.png\";s:4:\"name\";s:16:\"Art Box Colors 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:109;a:12:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:18:\"object_cloth_1.png\";s:4:\"name\";s:17:\"Cloth Paint Color\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:110;a:12:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:21:\"object_brushpot_1.png\";s:4:\"name\";s:9:\"Brush Pot\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"984\";s:6:\"height\";s:3:\"984\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:111;a:12:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:24:\"object_paintbucket_1.png\";s:4:\"name\";s:12:\"Paint Bucket\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:112;a:12:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:23:\"object_paintbrush_2.png\";s:4:\"name\";s:12:\"Paintbrush 3\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"700\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:113;a:12:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:19:\"object_artbox_1.png\";s:4:\"name\";s:14:\"Art Box Colors\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:114;a:12:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:23:\"object_paintbrush_3.png\";s:4:\"name\";s:12:\"Paintbrush 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1100\";s:6:\"height\";s:4:\"1100\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:115;a:12:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:23:\"object_paintbrush_1.png\";s:4:\"name\";s:12:\"Paintbrush 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:116;a:12:{s:2:\"id\";s:2:\"11\";s:6:\"handle\";s:21:\"table_radio_right.png\";s:4:\"name\";s:18:\"Radio Speaker Wood\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:117;a:12:{s:2:\"id\";s:2:\"10\";s:6:\"handle\";s:18:\"keyboard_apple.png\";s:4:\"name\";s:14:\"Apple Keyboard\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:118;a:12:{s:2:\"id\";s:1:\"9\";s:6:\"handle\";s:20:\"macbook_top_gold.png\";s:4:\"name\";s:18:\"Apple Macbook Gold\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:119;a:12:{s:2:\"id\";s:1:\"8\";s:6:\"handle\";s:21:\"nexus6_front_blue.png\";s:4:\"name\";s:19:\"Google Nexus 6 Blue\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1100\";s:6:\"height\";s:4:\"1100\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:120;a:12:{s:2:\"id\";s:3:\"479\";s:6:\"handle\";s:31:\"Tram-beside-waiting-station.jpg\";s:4:\"name\";s:27:\"Tram beside waiting station\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1450\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:52:06\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:121;a:12:{s:2:\"id\";s:3:\"478\";s:6:\"handle\";s:14:\"Pulling-up.jpg\";s:4:\"name\";s:10:\"Pulling up\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1297\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:41:20\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:122;a:12:{s:2:\"id\";s:3:\"477\";s:6:\"handle\";s:16:\"Snowboarding.jpg\";s:4:\"name\";s:12:\"Snowboarding\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1290\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:41:20\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:123;a:12:{s:2:\"id\";s:3:\"476\";s:6:\"handle\";s:16:\"Morning-yoga.jpg\";s:4:\"name\";s:12:\"Morning yoga\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1346\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:124;a:12:{s:2:\"id\";s:3:\"475\";s:6:\"handle\";s:8:\"Yoga.jpg\";s:4:\"name\";s:4:\"Yoga\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1079\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:125;a:12:{s:2:\"id\";s:3:\"474\";s:6:\"handle\";s:14:\"Golf-balls.jpg\";s:4:\"name\";s:10:\"Golf balls\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:126;a:12:{s:2:\"id\";s:3:\"473\";s:6:\"handle\";s:19:\"Confident-Boxer.jpg\";s:4:\"name\";s:15:\"Confident Boxer\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:127;a:12:{s:2:\"id\";s:3:\"472\";s:6:\"handle\";s:11:\"Aerobic.jpg\";s:4:\"name\";s:7:\"Aerobic\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:128;a:12:{s:2:\"id\";s:3:\"471\";s:6:\"handle\";s:18:\"Riding-bicycle.jpg\";s:4:\"name\";s:14:\"Riding bicycle\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1358\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:129;a:12:{s:2:\"id\";s:3:\"470\";s:6:\"handle\";s:27:\"woman-with-barbell-back.jpg\";s:4:\"name\";s:23:\"woman with barbell back\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:130;a:12:{s:2:\"id\";s:3:\"469\";s:6:\"handle\";s:24:\"Woman-lying-on-floor.jpg\";s:4:\"name\";s:20:\"Woman lying on floor\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1318\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:131;a:12:{s:2:\"id\";s:3:\"468\";s:6:\"handle\";s:27:\"Holding-black-dumbbells.jpg\";s:4:\"name\";s:23:\"Holding black dumbbells\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1275\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:132;a:12:{s:2:\"id\";s:3:\"467\";s:6:\"handle\";s:25:\"Woman-using-dumbbells.jpg\";s:4:\"name\";s:21:\"Woman using dumbbells\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1425\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:133;a:12:{s:2:\"id\";s:3:\"466\";s:6:\"handle\";s:16:\"Soccer-cleat.jpg\";s:4:\"name\";s:12:\"Soccer cleat\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:134;a:12:{s:2:\"id\";s:3:\"465\";s:6:\"handle\";s:16:\"Soccer-field.jpg\";s:4:\"name\";s:12:\"Soccer field\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:135;a:12:{s:2:\"id\";s:3:\"464\";s:6:\"handle\";s:23:\"Man-tying-his-shoes.jpg\";s:4:\"name\";s:19:\"Man tying his shoes\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1200\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:136;a:12:{s:2:\"id\";s:3:\"463\";s:6:\"handle\";s:10:\"Boxing.jpg\";s:4:\"name\";s:6:\"Boxing\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:137;a:12:{s:2:\"id\";s:3:\"462\";s:6:\"handle\";s:22:\"woman-with-barbell.jpg\";s:4:\"name\";s:18:\"woman with barbell\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:138;a:12:{s:2:\"id\";s:3:\"461\";s:6:\"handle\";s:12:\"Crossfit.jpg\";s:4:\"name\";s:8:\"Crossfit\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:139;a:12:{s:2:\"id\";s:3:\"460\";s:6:\"handle\";s:25:\"Man-and-woman-jogging.jpg\";s:4:\"name\";s:21:\"Man and woman jogging\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:140;a:12:{s:2:\"id\";s:3:\"459\";s:6:\"handle\";s:16:\"Playing-golf.jpg\";s:4:\"name\";s:12:\"Playing golf\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:141;a:12:{s:2:\"id\";s:3:\"458\";s:6:\"handle\";s:18:\"Surfer-in-wave.jpg\";s:4:\"name\";s:14:\"Surfer in wave\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:142;a:12:{s:2:\"id\";s:3:\"457\";s:6:\"handle\";s:25:\"Woman-lifting-barbell.jpg\";s:4:\"name\";s:21:\"Woman lifting barbell\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:143;a:12:{s:2:\"id\";s:3:\"456\";s:6:\"handle\";s:14:\"Stretching.jpg\";s:4:\"name\";s:10:\"Stretching\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:144;a:12:{s:2:\"id\";s:3:\"455\";s:6:\"handle\";s:18:\"Snowboarding-2.jpg\";s:4:\"name\";s:14:\"Snowboarding 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:145;a:12:{s:2:\"id\";s:3:\"454\";s:6:\"handle\";s:11:\"Balance.jpg\";s:4:\"name\";s:7:\"Balance\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1920\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:146;a:12:{s:2:\"id\";s:3:\"453\";s:6:\"handle\";s:19:\"Pool-meditation.jpg\";s:4:\"name\";s:15:\"Pool meditation\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:147;a:12:{s:2:\"id\";s:3:\"452\";s:6:\"handle\";s:18:\"Soccer-stadium.jpg\";s:4:\"name\";s:14:\"Soccer stadium\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:148;a:12:{s:2:\"id\";s:3:\"451\";s:6:\"handle\";s:25:\"Soccer-field-top-view.jpg\";s:4:\"name\";s:21:\"Soccer field top view\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:149;a:12:{s:2:\"id\";s:3:\"450\";s:6:\"handle\";s:14:\"Basketball.jpg\";s:4:\"name\";s:10:\"Basketball\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:150;a:12:{s:2:\"id\";s:3:\"449\";s:6:\"handle\";s:14:\"in-the-fog.jpg\";s:4:\"name\";s:10:\"in the fog\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:151;a:12:{s:2:\"id\";s:3:\"448\";s:6:\"handle\";s:13:\"Handstand.jpg\";s:4:\"name\";s:9:\"Handstand\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1079\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:152;a:12:{s:2:\"id\";s:3:\"447\";s:6:\"handle\";s:11:\"Friends.jpg\";s:4:\"name\";s:7:\"Friends\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:153;a:12:{s:2:\"id\";s:3:\"446\";s:6:\"handle\";s:28:\"Sneakers-on-the-railroad.jpg\";s:4:\"name\";s:24:\"Sneakers on the railroad\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:154;a:12:{s:2:\"id\";s:3:\"445\";s:6:\"handle\";s:23:\"Family-on-the-ocean.jpg\";s:4:\"name\";s:19:\"Family on the ocean\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:155;a:12:{s:2:\"id\";s:3:\"444\";s:6:\"handle\";s:10:\"Sunset.jpg\";s:4:\"name\";s:6:\"Sunset\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:156;a:12:{s:2:\"id\";s:3:\"443\";s:6:\"handle\";s:9:\"Books.jpg\";s:4:\"name\";s:5:\"Books\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1275\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:157;a:12:{s:2:\"id\";s:3:\"442\";s:6:\"handle\";s:25:\"Looking-at-the-window.jpg\";s:4:\"name\";s:21:\"Looking at the window\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:158;a:12:{s:2:\"id\";s:3:\"441\";s:6:\"handle\";s:48:\"woman-standing-near-buildings-during-daytime.jpg\";s:4:\"name\";s:44:\"woman standing near buildings during daytime\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:159;a:12:{s:2:\"id\";s:3:\"440\";s:6:\"handle\";s:12:\"Lollipop.jpg\";s:4:\"name\";s:8:\"Lollipop\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1395\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:160;a:12:{s:2:\"id\";s:3:\"439\";s:6:\"handle\";s:26:\"People-crossing-street.jpg\";s:4:\"name\";s:22:\"People crossing street\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:161;a:12:{s:2:\"id\";s:3:\"438\";s:6:\"handle\";s:24:\"Friends-on-the-shore.jpg\";s:4:\"name\";s:20:\"Friends on the shore\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:162;a:12:{s:2:\"id\";s:3:\"437\";s:6:\"handle\";s:13:\"Coworkers.jpg\";s:4:\"name\";s:9:\"Coworkers\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:163;a:12:{s:2:\"id\";s:3:\"436\";s:6:\"handle\";s:27:\"Hiking-in-the-Dolomites.jpg\";s:4:\"name\";s:23:\"Hiking in the Dolomites\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:164;a:12:{s:2:\"id\";s:3:\"435\";s:6:\"handle\";s:18:\"Successful-man.jpg\";s:4:\"name\";s:14:\"Successful man\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:165;a:12:{s:2:\"id\";s:3:\"434\";s:6:\"handle\";s:23:\"Beautiful-sunny-day.jpg\";s:4:\"name\";s:19:\"Beautiful sunny day\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:166;a:12:{s:2:\"id\";s:3:\"433\";s:6:\"handle\";s:8:\"Guys.jpg\";s:4:\"name\";s:4:\"Guys\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:167;a:12:{s:2:\"id\";s:3:\"432\";s:6:\"handle\";s:19:\"Confetti-Shower.jpg\";s:4:\"name\";s:15:\"Confetti Shower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:168;a:12:{s:2:\"id\";s:3:\"431\";s:6:\"handle\";s:24:\"Sun-was-setting-down.jpg\";s:4:\"name\";s:20:\"Sun was setting down\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:169;a:12:{s:2:\"id\";s:3:\"430\";s:6:\"handle\";s:9:\"Jumps.jpg\";s:4:\"name\";s:5:\"Jumps\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:170;a:12:{s:2:\"id\";s:3:\"429\";s:6:\"handle\";s:23:\"Friends-by-the-fire.jpg\";s:4:\"name\";s:19:\"Friends by the fire\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:171;a:12:{s:2:\"id\";s:3:\"428\";s:6:\"handle\";s:21:\"Under-the-blanket.jpg\";s:4:\"name\";s:17:\"Under the blanket\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1413\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:172;a:12:{s:2:\"id\";s:3:\"427\";s:6:\"handle\";s:18:\"Pretty-in-Pink.jpg\";s:4:\"name\";s:14:\"Pretty in Pink\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1394\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:173;a:12:{s:2:\"id\";s:3:\"426\";s:6:\"handle\";s:31:\"Discussions-at-a-long-table.jpg\";s:4:\"name\";s:27:\"Discussions at a long table\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1268\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:174;a:12:{s:2:\"id\";s:3:\"425\";s:6:\"handle\";s:18:\"Lost-in-Lemons.jpg\";s:4:\"name\";s:14:\"Lost in Lemons\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:175;a:12:{s:2:\"id\";s:3:\"424\";s:6:\"handle\";s:13:\"Team-work.jpg\";s:4:\"name\";s:9:\"Team work\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:176;a:12:{s:2:\"id\";s:3:\"423\";s:6:\"handle\";s:20:\"Romantic-evening.jpg\";s:4:\"name\";s:16:\"Romantic evening\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1263\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:177;a:12:{s:2:\"id\";s:3:\"422\";s:6:\"handle\";s:19:\"Crew-collective.jpg\";s:4:\"name\";s:15:\"Crew collective\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:178;a:12:{s:2:\"id\";s:3:\"421\";s:6:\"handle\";s:8:\"Code.jpg\";s:4:\"name\";s:4:\"Code\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:179;a:12:{s:2:\"id\";s:3:\"420\";s:6:\"handle\";s:48:\"Yellow-ceramic-mug-beside-gray-aluminum-iMac.jpg\";s:4:\"name\";s:44:\"Yellow ceramic mug beside gray aluminum iMac\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:180;a:12:{s:2:\"id\";s:3:\"419\";s:6:\"handle\";s:11:\"My-desk.jpg\";s:4:\"name\";s:7:\"My desk\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1315\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:181;a:12:{s:2:\"id\";s:3:\"418\";s:6:\"handle\";s:17:\"Cooperation-2.jpg\";s:4:\"name\";s:13:\"Cooperation 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:182;a:12:{s:2:\"id\";s:3:\"417\";s:6:\"handle\";s:33:\"MacBook-on-top-of-brown-table.jpg\";s:4:\"name\";s:29:\"MacBook on top of brown table\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:183;a:12:{s:2:\"id\";s:3:\"416\";s:6:\"handle\";s:27:\"Beautiful-working-place.jpg\";s:4:\"name\";s:23:\"Beautiful working place\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:184;a:12:{s:2:\"id\";s:3:\"415\";s:6:\"handle\";s:14:\"Typewriter.jpg\";s:4:\"name\";s:10:\"Typewriter\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:185;a:12:{s:2:\"id\";s:3:\"414\";s:6:\"handle\";s:19:\"White-desk-lamp.jpg\";s:4:\"name\";s:15:\"White desk lamp\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:186;a:12:{s:2:\"id\";s:3:\"413\";s:6:\"handle\";s:18:\"Office-working.jpg\";s:4:\"name\";s:14:\"Office working\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:187;a:12:{s:2:\"id\";s:3:\"412\";s:6:\"handle\";s:36:\"Silver-iMac-on-brown-wooden-desk.jpg\";s:4:\"name\";s:32:\"Silver iMac on brown wooden desk\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1240\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:188;a:12:{s:2:\"id\";s:3:\"411\";s:6:\"handle\";s:23:\"Working-in-progress.jpg\";s:4:\"name\";s:19:\"Working in progress\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:189;a:12:{s:2:\"id\";s:3:\"410\";s:6:\"handle\";s:15:\"Cooperation.jpg\";s:4:\"name\";s:11:\"Cooperation\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:190;a:12:{s:2:\"id\";s:3:\"409\";s:6:\"handle\";s:17:\"Working-place.jpg\";s:4:\"name\";s:13:\"Working place\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:191;a:12:{s:2:\"id\";s:3:\"408\";s:6:\"handle\";s:16:\"Working-desk.jpg\";s:4:\"name\";s:12:\"Working desk\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:192;a:12:{s:2:\"id\";s:3:\"407\";s:6:\"handle\";s:23:\"low-angle-of-forest.jpg\";s:4:\"name\";s:19:\"low angle of forest\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:193;a:12:{s:2:\"id\";s:3:\"406\";s:6:\"handle\";s:23:\"Lake-under-blue-sky.jpg\";s:4:\"name\";s:19:\"Lake under blue sky\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1351\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:194;a:12:{s:2:\"id\";s:3:\"405\";s:6:\"handle\";s:21:\"Blue-starry-night.jpg\";s:4:\"name\";s:17:\"Blue starry night\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:195;a:12:{s:2:\"id\";s:3:\"404\";s:6:\"handle\";s:22:\"Aerial-photography.jpg\";s:4:\"name\";s:18:\"Aerial photography\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:196;a:12:{s:2:\"id\";s:3:\"403\";s:6:\"handle\";s:14:\"Red-clouds.jpg\";s:4:\"name\";s:10:\"Red clouds\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:197;a:12:{s:2:\"id\";s:3:\"402\";s:6:\"handle\";s:14:\"Snow-field.jpg\";s:4:\"name\";s:10:\"Snow field\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1227\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:198;a:12:{s:2:\"id\";s:3:\"401\";s:6:\"handle\";s:13:\"White-sky.jpg\";s:4:\"name\";s:9:\"White sky\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:199;a:12:{s:2:\"id\";s:3:\"400\";s:6:\"handle\";s:24:\"Trees-covered-by-fog.jpg\";s:4:\"name\";s:20:\"Trees covered by fog\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:200;a:12:{s:2:\"id\";s:3:\"399\";s:6:\"handle\";s:26:\"Red-and-white-mushroom.jpg\";s:4:\"name\";s:22:\"Red and white mushroom\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:201;a:12:{s:2:\"id\";s:3:\"398\";s:6:\"handle\";s:24:\"Lake-near-pine-trees.jpg\";s:4:\"name\";s:20:\"Lake near pine trees\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:202;a:12:{s:2:\"id\";s:3:\"397\";s:6:\"handle\";s:35:\"After-a-long-day-of-backpacking.jpg\";s:4:\"name\";s:31:\"After a long day of backpacking\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:203;a:12:{s:2:\"id\";s:3:\"396\";s:6:\"handle\";s:32:\"Mountains-during-golden-hour.jpg\";s:4:\"name\";s:28:\"Mountains during golden hour\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:204;a:12:{s:2:\"id\";s:3:\"395\";s:6:\"handle\";s:27:\"Man-looking-on-mountain.jpg\";s:4:\"name\";s:23:\"Man looking on mountain\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:205;a:12:{s:2:\"id\";s:3:\"394\";s:6:\"handle\";s:19:\"Body-of-water-2.jpg\";s:4:\"name\";s:15:\"Body of water 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:206;a:12:{s:2:\"id\";s:3:\"393\";s:6:\"handle\";s:15:\"Brown-cliff.jpg\";s:4:\"name\";s:11:\"Brown cliff\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:207;a:12:{s:2:\"id\";s:3:\"392\";s:6:\"handle\";s:20:\"Green-foggy-tree.jpg\";s:4:\"name\";s:16:\"Green foggy tree\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1417\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:208;a:12:{s:2:\"id\";s:3:\"391\";s:6:\"handle\";s:32:\"Grayscale-photo-of-mountains.jpg\";s:4:\"name\";s:28:\"Grayscale photo of mountains\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:209;a:12:{s:2:\"id\";s:3:\"390\";s:6:\"handle\";s:19:\"Under-sunny-sky.jpg\";s:4:\"name\";s:15:\"Under sunny sky\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:210;a:12:{s:2:\"id\";s:3:\"389\";s:6:\"handle\";s:16:\"Rock-concert.jpg\";s:4:\"name\";s:12:\"Rock concert\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1443\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:211;a:12:{s:2:\"id\";s:3:\"388\";s:6:\"handle\";s:30:\"Group-of-people-in-concert.jpg\";s:4:\"name\";s:26:\"Group of people in concert\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:212;a:12:{s:2:\"id\";s:3:\"387\";s:6:\"handle\";s:6:\"DJ.jpg\";s:4:\"name\";s:2:\"DJ\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:213;a:12:{s:2:\"id\";s:3:\"386\";s:6:\"handle\";s:56:\"Woman-standing-watching-LED-light-musical-instrument.jpg\";s:4:\"name\";s:52:\"Woman standing watching LED light musical instrument\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:214;a:12:{s:2:\"id\";s:3:\"385\";s:6:\"handle\";s:16:\"Concert-hall.jpg\";s:4:\"name\";s:12:\"Concert hall\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:215;a:12:{s:2:\"id\";s:3:\"384\";s:6:\"handle\";s:18:\"Concert-hall-2.jpg\";s:4:\"name\";s:14:\"Concert hall 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:216;a:12:{s:2:\"id\";s:3:\"383\";s:6:\"handle\";s:29:\"man-playing-upright-piano.jpg\";s:4:\"name\";s:25:\"man playing upright piano\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1340\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:217;a:12:{s:2:\"id\";s:3:\"382\";s:6:\"handle\";s:30:\"person-performing-on-stage.jpg\";s:4:\"name\";s:26:\"person performing on stage\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:218;a:12:{s:2:\"id\";s:3:\"381\";s:6:\"handle\";s:27:\"Brown-string-instrument.jpg\";s:4:\"name\";s:23:\"Brown string instrument\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1272\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:219;a:12:{s:2:\"id\";s:3:\"380\";s:6:\"handle\";s:36:\"silhouette-of-person-with-guitar.jpg\";s:4:\"name\";s:32:\"silhouette of person with guitar\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:220;a:12:{s:2:\"id\";s:3:\"379\";s:6:\"handle\";s:14:\"Party-fans.jpg\";s:4:\"name\";s:10:\"Party fans\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:221;a:12:{s:2:\"id\";s:3:\"378\";s:6:\"handle\";s:24:\"Condenser-microphone.jpg\";s:4:\"name\";s:20:\"Condenser microphone\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:222;a:12:{s:2:\"id\";s:3:\"377\";s:6:\"handle\";s:42:\"Low-angle-photo-of-high-rise-buildings.jpg\";s:4:\"name\";s:38:\"Low angle photo of high rise buildings\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:223;a:12:{s:2:\"id\";s:3:\"376\";s:6:\"handle\";s:23:\"High-rise-buildings.jpg\";s:4:\"name\";s:19:\"High rise buildings\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:224;a:12:{s:2:\"id\";s:3:\"375\";s:6:\"handle\";s:16:\"Cable-bridge.jpg\";s:4:\"name\";s:12:\"Cable bridge\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1272\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:225;a:12:{s:2:\"id\";s:3:\"374\";s:6:\"handle\";s:35:\"Bokeh-effect-from-street-lights.jpg\";s:4:\"name\";s:31:\"Bokeh effect from street lights\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:226;a:12:{s:2:\"id\";s:3:\"373\";s:6:\"handle\";s:18:\"Low-angle-view.jpg\";s:4:\"name\";s:14:\"Low angle view\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:227;a:12:{s:2:\"id\";s:3:\"372\";s:6:\"handle\";s:21:\"Double-decker-bus.jpg\";s:4:\"name\";s:17:\"Double decker bus\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1373\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:228;a:12:{s:2:\"id\";s:3:\"371\";s:6:\"handle\";s:32:\"Buildings-near-body-of-water.jpg\";s:4:\"name\";s:28:\"Buildings near body of water\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1370\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:229;a:12:{s:2:\"id\";s:3:\"370\";s:6:\"handle\";s:18:\"Satellite-view.jpg\";s:4:\"name\";s:14:\"Satellite view\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:230;a:12:{s:2:\"id\";s:3:\"369\";s:6:\"handle\";s:14:\"Twin-Tower.jpg\";s:4:\"name\";s:10:\"Twin Tower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:231;a:12:{s:2:\"id\";s:3:\"368\";s:6:\"handle\";s:22:\"Two-person-walking.jpg\";s:4:\"name\";s:18:\"Two person walking\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1345\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:232;a:12:{s:2:\"id\";s:3:\"367\";s:6:\"handle\";s:15:\"Sears-Tower.jpg\";s:4:\"name\";s:11:\"Sears Tower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:233;a:12:{s:2:\"id\";s:3:\"366\";s:6:\"handle\";s:19:\"Night-cityscape.jpg\";s:4:\"name\";s:15:\"Night cityscape\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:234;a:12:{s:2:\"id\";s:3:\"365\";s:6:\"handle\";s:25:\"Empire-State-Building.jpg\";s:4:\"name\";s:21:\"Empire State Building\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:235;a:12:{s:2:\"id\";s:3:\"364\";s:6:\"handle\";s:9:\"Paris.jpg\";s:4:\"name\";s:5:\"Paris\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:236;a:12:{s:2:\"id\";s:3:\"363\";s:6:\"handle\";s:31:\"Building-during-golden-hour.jpg\";s:4:\"name\";s:27:\"Building during golden hour\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1288\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:237;a:12:{s:2:\"id\";s:3:\"362\";s:6:\"handle\";s:21:\"Afternoon-skyline.jpg\";s:4:\"name\";s:17:\"Afternoon skyline\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:238;a:12:{s:2:\"id\";s:3:\"361\";s:6:\"handle\";s:22:\"Concrete-buildings.jpg\";s:4:\"name\";s:18:\"Concrete buildings\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:239;a:12:{s:2:\"id\";s:3:\"360\";s:6:\"handle\";s:26:\"Architectural-building.jpg\";s:4:\"name\";s:22:\"Architectural building\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1382\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:240;a:12:{s:2:\"id\";s:3:\"359\";s:6:\"handle\";s:23:\"Skyline-photography.jpg\";s:4:\"name\";s:19:\"Skyline photography\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:241;a:12:{s:2:\"id\";s:3:\"358\";s:6:\"handle\";s:38:\"People-standing-on-pedestrian-lane.jpg\";s:4:\"name\";s:34:\"People standing on pedestrian lane\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1154\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:242;a:12:{s:2:\"id\";s:3:\"357\";s:6:\"handle\";s:16:\"Burj-Khalifa.jpg\";s:4:\"name\";s:12:\"Burj Khalifa\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:243;a:12:{s:2:\"id\";s:3:\"356\";s:6:\"handle\";s:13:\"Skycraper.jpg\";s:4:\"name\";s:9:\"Skycraper\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:244;a:12:{s:2:\"id\";s:3:\"355\";s:6:\"handle\";s:14:\"Gray-tower.jpg\";s:4:\"name\";s:10:\"Gray tower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1433\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:245;a:12:{s:2:\"id\";s:3:\"354\";s:6:\"handle\";s:28:\"One-fine-day-in-Maldives.jpg\";s:4:\"name\";s:24:\"One fine day in Maldives\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1116\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:246;a:12:{s:2:\"id\";s:3:\"353\";s:6:\"handle\";s:25:\"Boat-on-body-of-water.jpg\";s:4:\"name\";s:21:\"Boat on body of water\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:247;a:12:{s:2:\"id\";s:3:\"352\";s:6:\"handle\";s:33:\"Aerial-photo-of-body-of-water.jpg\";s:4:\"name\";s:29:\"Aerial photo of body of water\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1078\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:248;a:12:{s:2:\"id\";s:3:\"351\";s:6:\"handle\";s:31:\"Assorted-color-beach-houses.jpg\";s:4:\"name\";s:27:\"Assorted color beach houses\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1135\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:249;a:12:{s:2:\"id\";s:3:\"350\";s:6:\"handle\";s:36:\"Woman-leaning-on-tree-near-beach.jpg\";s:4:\"name\";s:32:\"Woman leaning on tree near beach\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1559\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:250;a:12:{s:2:\"id\";s:3:\"349\";s:6:\"handle\";s:17:\"Body-of-water.jpg\";s:4:\"name\";s:13:\"Body of water\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1269\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:251;a:12:{s:2:\"id\";s:3:\"348\";s:6:\"handle\";s:17:\"People-on-sea.jpg\";s:4:\"name\";s:13:\"People on sea\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:252;a:12:{s:2:\"id\";s:3:\"347\";s:6:\"handle\";s:31:\"Man-sitting-beside-of-woman.jpg\";s:4:\"name\";s:27:\"Man sitting beside of woman\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:253;a:12:{s:2:\"id\";s:3:\"346\";s:6:\"handle\";s:22:\"woman-in-the-water.jpg\";s:4:\"name\";s:18:\"woman in the water\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:254;a:12:{s:2:\"id\";s:3:\"345\";s:6:\"handle\";s:39:\"Brown-stone-near-sea-at-golden-hour.jpg\";s:4:\"name\";s:35:\"Brown stone near sea at golden hour\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:255;a:12:{s:2:\"id\";s:3:\"344\";s:6:\"handle\";s:18:\"Birds-eye-view.jpg\";s:4:\"name\";s:14:\"Birds eye view\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1079\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:256;a:12:{s:2:\"id\";s:3:\"343\";s:6:\"handle\";s:18:\"Empty-seashore.jpg\";s:4:\"name\";s:14:\"Empty seashore\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1365\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:257;a:12:{s:2:\"id\";s:3:\"342\";s:6:\"handle\";s:31:\"Seashore-during-golden-hour.jpg\";s:4:\"name\";s:27:\"Seashore during golden hour\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1439\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:258;a:12:{s:2:\"id\";s:3:\"341\";s:6:\"handle\";s:16:\"Coconut-tree.jpg\";s:4:\"name\";s:12:\"Coconut tree\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:259;a:12:{s:2:\"id\";s:3:\"340\";s:6:\"handle\";s:37:\"Aerial-photography-of-beach-shore.jpg\";s:4:\"name\";s:33:\"Aerial photography of beach shore\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1439\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:260;a:12:{s:2:\"id\";s:3:\"197\";s:6:\"handle\";s:17:\"relax_hammock.jpg\";s:4:\"name\";s:13:\"Relax Hammock\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:261;a:12:{s:2:\"id\";s:3:\"196\";s:6:\"handle\";s:16:\"beach_houses.jpg\";s:4:\"name\";s:12:\"Beach Houses\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:262;a:12:{s:2:\"id\";s:3:\"195\";s:6:\"handle\";s:17:\"forest_road_2.jpg\";s:4:\"name\";s:13:\"Forest Road 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:263;a:12:{s:2:\"id\";s:3:\"194\";s:6:\"handle\";s:14:\"clean_desk.jpg\";s:4:\"name\";s:10:\"Clean Desk\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:264;a:12:{s:2:\"id\";s:3:\"193\";s:6:\"handle\";s:19:\"mountain_view_6.jpg\";s:4:\"name\";s:15:\"Mountain View 6\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1249\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:265;a:12:{s:2:\"id\";s:3:\"192\";s:6:\"handle\";s:14:\"corn_field.jpg\";s:4:\"name\";s:10:\"Corn Field\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1320\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:266;a:12:{s:2:\"id\";s:3:\"191\";s:6:\"handle\";s:21:\"stylish_apartment.jpg\";s:4:\"name\";s:17:\"Stylish Apartment\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:267;a:12:{s:2:\"id\";s:3:\"190\";s:6:\"handle\";s:24:\"hipster_coffee_house.jpg\";s:4:\"name\";s:20:\"Hipster Coffee House\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:268;a:12:{s:2:\"id\";s:3:\"189\";s:6:\"handle\";s:16:\"blurry_beach.jpg\";s:4:\"name\";s:12:\"Blurry Beach\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:269;a:12:{s:2:\"id\";s:3:\"186\";s:6:\"handle\";s:17:\"greens_street.jpg\";s:4:\"name\";s:13:\"Greens Street\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:270;a:12:{s:2:\"id\";s:3:\"185\";s:6:\"handle\";s:10:\"desert.jpg\";s:4:\"name\";s:6:\"Desert\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:271;a:12:{s:2:\"id\";s:3:\"184\";s:6:\"handle\";s:19:\"mountain_view_5.jpg\";s:4:\"name\";s:15:\"Mountain View 5\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:272;a:12:{s:2:\"id\";s:3:\"183\";s:6:\"handle\";s:10:\"laptop.jpg\";s:4:\"name\";s:6:\"Laptop\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1391\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:273;a:12:{s:2:\"id\";s:3:\"182\";s:6:\"handle\";s:16:\"grand_canyon.jpg\";s:4:\"name\";s:12:\"Grand Canyon\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1287\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:274;a:12:{s:2:\"id\";s:3:\"181\";s:6:\"handle\";s:20:\"landscape_clouds.jpg\";s:4:\"name\";s:16:\"Landscape Clouds\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1272\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:275;a:12:{s:2:\"id\";s:3:\"180\";s:6:\"handle\";s:17:\"highway_night.jpg\";s:4:\"name\";s:13:\"Highway Night\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:276;a:12:{s:2:\"id\";s:3:\"179\";s:6:\"handle\";s:15:\"beach_water.jpg\";s:4:\"name\";s:11:\"Beach Water\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:277;a:12:{s:2:\"id\";s:3:\"177\";s:6:\"handle\";s:15:\"woman_beach.jpg\";s:4:\"name\";s:11:\"Woman Beach\";s:4:\"tags\";a:4:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:3;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:278;a:12:{s:2:\"id\";s:3:\"175\";s:6:\"handle\";s:12:\"cool_guy.jpg\";s:4:\"name\";s:8:\"Cool Guy\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:279;a:12:{s:2:\"id\";s:3:\"174\";s:6:\"handle\";s:13:\"beach_sea.jpg\";s:4:\"name\";s:9:\"Beach Sea\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:280;a:12:{s:2:\"id\";s:3:\"173\";s:6:\"handle\";s:17:\"bridge_clouds.jpg\";s:4:\"name\";s:13:\"Bridge Clouds\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:281;a:12:{s:2:\"id\";s:3:\"116\";s:6:\"handle\";s:19:\"mountain_view_2.jpg\";s:4:\"name\";s:15:\"Mountain View 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1275\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:282;a:12:{s:2:\"id\";s:3:\"115\";s:6:\"handle\";s:16:\"desert_trees.jpg\";s:4:\"name\";s:12:\"Desert Trees\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1275\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:283;a:12:{s:2:\"id\";s:3:\"114\";s:6:\"handle\";s:20:\"explore_moutains.jpg\";s:4:\"name\";s:17:\"Explore Mountains\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:284;a:12:{s:2:\"id\";s:3:\"113\";s:6:\"handle\";s:19:\"night_skyline_2.jpg\";s:4:\"name\";s:15:\"Night Skyline 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:285;a:12:{s:2:\"id\";s:3:\"112\";s:6:\"handle\";s:15:\"cliff_ocean.jpg\";s:4:\"name\";s:11:\"Cliff Ocean\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:286;a:12:{s:2:\"id\";s:3:\"111\";s:6:\"handle\";s:14:\"city_smoke.jpg\";s:4:\"name\";s:10:\"City Smoke\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:287;a:12:{s:2:\"id\";s:3:\"110\";s:6:\"handle\";s:16:\"surfer_beach.jpg\";s:4:\"name\";s:12:\"Surfer Beach\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:288;a:12:{s:2:\"id\";s:3:\"109\";s:6:\"handle\";s:13:\"sky_night.jpg\";s:4:\"name\";s:9:\"Sky Night\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:289;a:12:{s:2:\"id\";s:3:\"108\";s:6:\"handle\";s:15:\"palm_sunset.jpg\";s:4:\"name\";s:11:\"Palm Sunset\";s:4:\"tags\";a:4:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}i:3;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1372\";s:6:\"height\";s:4:\"1920\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:290;a:12:{s:2:\"id\";s:3:\"107\";s:6:\"handle\";s:18:\"concert_people.jpg\";s:4:\"name\";s:14:\"Concert People\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:291;a:12:{s:2:\"id\";s:3:\"106\";s:6:\"handle\";s:15:\"forest_road.jpg\";s:4:\"name\";s:11:\"Forest Road\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:292;a:12:{s:2:\"id\";s:3:\"105\";s:6:\"handle\";s:15:\"beach_ocean.jpg\";s:4:\"name\";s:11:\"Beach Ocean\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:293;a:12:{s:2:\"id\";s:3:\"104\";s:6:\"handle\";s:18:\"mountain_night.jpg\";s:4:\"name\";s:14:\"Mountain Night\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:294;a:12:{s:2:\"id\";s:3:\"103\";s:6:\"handle\";s:19:\"ocean_mountains.jpg\";s:4:\"name\";s:15:\"Ocean Mountains\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:295;a:12:{s:2:\"id\";s:3:\"102\";s:6:\"handle\";s:10:\"forest.jpg\";s:4:\"name\";s:6:\"Forest\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:296;a:12:{s:2:\"id\";s:3:\"101\";s:6:\"handle\";s:16:\"ocean_stones.jpg\";s:4:\"name\";s:12:\"Ocean Stones\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:297;a:12:{s:2:\"id\";s:3:\"100\";s:6:\"handle\";s:16:\"country_road.jpg\";s:4:\"name\";s:12:\"Country Road\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:298;a:12:{s:2:\"id\";s:2:\"99\";s:6:\"handle\";s:9:\"beach.jpg\";s:4:\"name\";s:5:\"Beach\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:299;a:12:{s:2:\"id\";s:2:\"98\";s:6:\"handle\";s:16:\"city_skyline.jpg\";s:4:\"name\";s:12:\"City Skyline\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:300;a:12:{s:2:\"id\";s:2:\"97\";s:6:\"handle\";s:17:\"night_skyline.jpg\";s:4:\"name\";s:13:\"Night Skyline\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}i:2;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:301;a:12:{s:2:\"id\";s:2:\"96\";s:6:\"handle\";s:14:\"city_river.jpg\";s:4:\"name\";s:10:\"City River\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:302;a:12:{s:2:\"id\";s:2:\"95\";s:6:\"handle\";s:19:\"mountain_view_3.jpg\";s:4:\"name\";s:15:\"Mountain View 3\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:303;a:12:{s:2:\"id\";s:2:\"94\";s:6:\"handle\";s:14:\"misty_farm.jpg\";s:4:\"name\";s:10:\"Misty Farm\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:304;a:12:{s:2:\"id\";s:2:\"93\";s:6:\"handle\";s:17:\"mountain_path.jpg\";s:4:\"name\";s:13:\"Mountain Path\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:305;a:12:{s:2:\"id\";s:2:\"92\";s:6:\"handle\";s:19:\"night_skyline_3.jpg\";s:4:\"name\";s:15:\"Night Skyline 3\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:306;a:12:{s:2:\"id\";s:2:\"91\";s:6:\"handle\";s:17:\"mountain_view.jpg\";s:4:\"name\";s:13:\"Mountain View\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1160\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:307;a:12:{s:2:\"id\";s:2:\"90\";s:6:\"handle\";s:19:\"rocky_landscape.jpg\";s:4:\"name\";s:15:\"Rocky Landscape\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:308;a:12:{s:2:\"id\";s:2:\"89\";s:6:\"handle\";s:19:\"mountain_view_4.jpg\";s:4:\"name\";s:15:\"Mountain View 4\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1203\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:309;a:13:{s:2:\"id\";s:3:\"529\";s:6:\"handle\";s:13:\"Fitness-4.jpg\";s:5:\"video\";s:13:\"Fitness-4.mp4\";s:4:\"name\";s:10:\"Fitness 4 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:46:50\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:310;a:13:{s:2:\"id\";s:3:\"528\";s:6:\"handle\";s:13:\"Fitness-3.jpg\";s:5:\"video\";s:13:\"Fitness-3.mp4\";s:4:\"name\";s:10:\"Fitness 3 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:46:50\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:311;a:13:{s:2:\"id\";s:3:\"527\";s:6:\"handle\";s:9:\"Chess.jpg\";s:5:\"video\";s:9:\"Chess.mp4\";s:4:\"name\";s:6:\"Chess \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:46:50\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:312;a:13:{s:2:\"id\";s:3:\"526\";s:6:\"handle\";s:13:\"Fitness-2.jpg\";s:5:\"video\";s:13:\"Fitness-2.mp4\";s:4:\"name\";s:10:\"Fitness 2 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:46:50\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:313;a:13:{s:2:\"id\";s:3:\"525\";s:6:\"handle\";s:11:\"Fitness.jpg\";s:5:\"video\";s:11:\"Fitness.mp4\";s:4:\"name\";s:8:\"Fitness \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:46:50\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:314;a:13:{s:2:\"id\";s:3:\"524\";s:6:\"handle\";s:9:\"Earth.jpg\";s:5:\"video\";s:9:\"Earth.mp4\";s:4:\"name\";s:6:\"Earth \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:5:\"space\";s:4:\"name\";s:5:\"Space\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:44:06\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:315;a:13:{s:2:\"id\";s:3:\"523\";s:6:\"handle\";s:11:\"Space-2.jpg\";s:5:\"video\";s:11:\"Space-2.mp4\";s:4:\"name\";s:8:\"Space 2 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:5:\"space\";s:4:\"name\";s:5:\"Space\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1440\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:44:06\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:316;a:13:{s:2:\"id\";s:3:\"522\";s:6:\"handle\";s:13:\"Asteroids.jpg\";s:5:\"video\";s:13:\"Asteroids.mp4\";s:4:\"name\";s:10:\"Asteroids \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:5:\"space\";s:4:\"name\";s:5:\"Space\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:44:06\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:317;a:13:{s:2:\"id\";s:3:\"521\";s:6:\"handle\";s:9:\"Space.jpg\";s:5:\"video\";s:9:\"Space.mp4\";s:4:\"name\";s:6:\"Space \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:5:\"space\";s:4:\"name\";s:5:\"Space\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:44:06\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:318;a:13:{s:2:\"id\";s:3:\"520\";s:6:\"handle\";s:10:\"People.jpg\";s:5:\"video\";s:10:\"People.mp4\";s:4:\"name\";s:7:\"People \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:42:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:319;a:13:{s:2:\"id\";s:3:\"519\";s:6:\"handle\";s:11:\"Walking.jpg\";s:5:\"video\";s:11:\"Walking.mp4\";s:4:\"name\";s:8:\"Walking \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:42:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:320;a:13:{s:2:\"id\";s:3:\"518\";s:6:\"handle\";s:19:\"Double-Exposure.jpg\";s:5:\"video\";s:19:\"Double-Exposure.mp4\";s:4:\"name\";s:16:\"Double Exposure \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:42:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:321;a:13:{s:2:\"id\";s:3:\"517\";s:6:\"handle\";s:8:\"Girl.jpg\";s:5:\"video\";s:8:\"Girl.mp4\";s:4:\"name\";s:5:\"Girl \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1088\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:42:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:322;a:13:{s:2:\"id\";s:3:\"516\";s:6:\"handle\";s:17:\"Bengal-Lights.jpg\";s:5:\"video\";s:17:\"Bengal-Lights.mp4\";s:4:\"name\";s:14:\"Bengal Lights \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:42:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:323;a:13:{s:2:\"id\";s:3:\"515\";s:6:\"handle\";s:13:\"Swiping-2.jpg\";s:5:\"video\";s:13:\"Swiping-2.mp4\";s:4:\"name\";s:10:\"Swiping 2 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:324;a:13:{s:2:\"id\";s:3:\"514\";s:6:\"handle\";s:11:\"Mock-Up.jpg\";s:5:\"video\";s:11:\"Mock-Up.mp4\";s:4:\"name\";s:8:\"Mock Up \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:325;a:13:{s:2:\"id\";s:3:\"513\";s:6:\"handle\";s:13:\"Countdown.jpg\";s:5:\"video\";s:13:\"Countdown.mp4\";s:4:\"name\";s:10:\"Countdown \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:326;a:13:{s:2:\"id\";s:3:\"512\";s:6:\"handle\";s:18:\"Wall-Sketching.jpg\";s:5:\"video\";s:18:\"Wall-Sketching.mp4\";s:4:\"name\";s:15:\"Wall Sketching \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:327;a:13:{s:2:\"id\";s:3:\"511\";s:6:\"handle\";s:26:\"Typing-on-the-keyboard.jpg\";s:5:\"video\";s:26:\"Typing-on-the-keyboard.mp4\";s:4:\"name\";s:23:\"Typing on the keyboard \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:328;a:13:{s:2:\"id\";s:3:\"510\";s:6:\"handle\";s:11:\"Meeting.jpg\";s:5:\"video\";s:11:\"Meeting.mp4\";s:4:\"name\";s:8:\"Meeting \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:329;a:13:{s:2:\"id\";s:3:\"509\";s:6:\"handle\";s:11:\"Swiping.jpg\";s:5:\"video\";s:11:\"Swiping.mp4\";s:4:\"name\";s:8:\"Swiping \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:330;a:13:{s:2:\"id\";s:3:\"508\";s:6:\"handle\";s:9:\"Alarm.jpg\";s:5:\"video\";s:9:\"Alarm.mp4\";s:4:\"name\";s:6:\"Alarm \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1013\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:331;a:13:{s:2:\"id\";s:3:\"507\";s:6:\"handle\";s:13:\"Hey-World.jpg\";s:5:\"video\";s:13:\"Hey-World.mp4\";s:4:\"name\";s:10:\"Hey World \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:332;a:13:{s:2:\"id\";s:3:\"506\";s:6:\"handle\";s:28:\"Typing-on-the-keyboard-2.jpg\";s:5:\"video\";s:28:\"Typing-on-the-keyboard-2.mp4\";s:4:\"name\";s:25:\"Typing on the keyboard 2 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:333;a:13:{s:2:\"id\";s:3:\"505\";s:6:\"handle\";s:10:\"Valley.jpg\";s:5:\"video\";s:10:\"Valley.mp4\";s:4:\"name\";s:7:\"Valley \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:35:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:334;a:13:{s:2:\"id\";s:3:\"504\";s:6:\"handle\";s:9:\"Stars.jpg\";s:5:\"video\";s:9:\"Stars.mp4\";s:4:\"name\";s:6:\"Stars \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:35:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:335;a:13:{s:2:\"id\";s:3:\"503\";s:6:\"handle\";s:21:\"Car-in-the-forest.jpg\";s:5:\"video\";s:21:\"Car-in-the-forest.mp4\";s:4:\"name\";s:18:\"Car in the forest \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1012\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:35:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:336;a:13:{s:2:\"id\";s:3:\"502\";s:6:\"handle\";s:15:\"Aerial-Shot.jpg\";s:5:\"video\";s:15:\"Aerial-Shot.mp4\";s:4:\"name\";s:12:\"Aerial Shot \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:35:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:337;a:13:{s:2:\"id\";s:3:\"501\";s:6:\"handle\";s:14:\"Disco-Ball.jpg\";s:5:\"video\";s:14:\"Disco-Ball.mp4\";s:4:\"name\";s:11:\"Disco Ball \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:33:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:338;a:13:{s:2:\"id\";s:3:\"500\";s:6:\"handle\";s:22:\"Man-Playing-Guitar.jpg\";s:5:\"video\";s:22:\"Man-Playing-Guitar.mp4\";s:4:\"name\";s:19:\"Man Playing Guitar \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:33:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:339;a:13:{s:2:\"id\";s:3:\"499\";s:6:\"handle\";s:14:\"Live-Music.jpg\";s:5:\"video\";s:14:\"Live-Music.mp4\";s:4:\"name\";s:11:\"Live Music \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:33:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:340;a:13:{s:2:\"id\";s:3:\"498\";s:6:\"handle\";s:12:\"Cheer-Up.jpg\";s:5:\"video\";s:12:\"Cheer-Up.mp4\";s:4:\"name\";s:9:\"Cheer Up \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:33:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:341;a:13:{s:2:\"id\";s:3:\"497\";s:6:\"handle\";s:14:\"Night-club.jpg\";s:5:\"video\";s:14:\"Night-club.mp4\";s:4:\"name\";s:11:\"Night club \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:33:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:342;a:13:{s:2:\"id\";s:3:\"496\";s:6:\"handle\";s:17:\"Cup-Of-Coffee.jpg\";s:5:\"video\";s:17:\"Cup-Of-Coffee.mp4\";s:4:\"name\";s:14:\"Cup Of Coffee \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:30:48\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:343;a:13:{s:2:\"id\";s:3:\"495\";s:6:\"handle\";s:7:\"Pot.jpg\";s:5:\"video\";s:7:\"Pot.mp4\";s:4:\"name\";s:4:\"Pot \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:30:48\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:344;a:13:{s:2:\"id\";s:3:\"494\";s:6:\"handle\";s:11:\"Grill-2.jpg\";s:5:\"video\";s:11:\"Grill-2.mp4\";s:4:\"name\";s:8:\"Grill 2 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:30:48\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:345;a:13:{s:2:\"id\";s:3:\"493\";s:6:\"handle\";s:13:\"Rice-Bowl.jpg\";s:5:\"video\";s:13:\"Rice-Bowl.mp4\";s:4:\"name\";s:10:\"Rice Bowl \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1010\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:30:48\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:346;a:13:{s:2:\"id\";s:3:\"492\";s:6:\"handle\";s:9:\"Grill.jpg\";s:5:\"video\";s:9:\"Grill.mp4\";s:4:\"name\";s:6:\"Grill \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:30:48\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:347;a:13:{s:2:\"id\";s:3:\"491\";s:6:\"handle\";s:9:\"Water.jpg\";s:5:\"video\";s:9:\"Water.mp4\";s:4:\"name\";s:6:\"Water \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:24:15\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:348;a:13:{s:2:\"id\";s:3:\"490\";s:6:\"handle\";s:17:\"Feet-and-Sand.jpg\";s:5:\"video\";s:17:\"Feet-and-Sand.mp4\";s:4:\"name\";s:14:\"Feet and Sand \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:24:15\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:349;a:13:{s:2:\"id\";s:3:\"489\";s:6:\"handle\";s:9:\"Ocean.jpg\";s:5:\"video\";s:9:\"Ocean.mp4\";s:4:\"name\";s:6:\"Ocean \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:24:15\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:350;a:13:{s:2:\"id\";s:3:\"488\";s:6:\"handle\";s:9:\"Waves.jpg\";s:5:\"video\";s:9:\"Waves.mp4\";s:4:\"name\";s:6:\"Waves \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:24:15\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:351;a:13:{s:2:\"id\";s:3:\"487\";s:6:\"handle\";s:10:\"Hearts.jpg\";s:5:\"video\";s:10:\"Hearts.mp4\";s:4:\"name\";s:7:\"Hearts \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:352;a:13:{s:2:\"id\";s:3:\"486\";s:6:\"handle\";s:12:\"Octagons.jpg\";s:5:\"video\";s:12:\"Octagons.mp4\";s:4:\"name\";s:9:\"Octagons \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:353;a:13:{s:2:\"id\";s:3:\"485\";s:6:\"handle\";s:11:\"Squares.jpg\";s:5:\"video\";s:11:\"Squares.mp4\";s:4:\"name\";s:8:\"Squares \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:354;a:13:{s:2:\"id\";s:3:\"484\";s:6:\"handle\";s:12:\"Pink-ink.jpg\";s:5:\"video\";s:12:\"Pink-ink.mp4\";s:4:\"name\";s:9:\"Pink ink \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:355;a:13:{s:2:\"id\";s:3:\"483\";s:6:\"handle\";s:22:\"Blurred-Background.jpg\";s:5:\"video\";s:22:\"Blurred-Background.mp4\";s:4:\"name\";s:19:\"Blurred Background \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:356;a:13:{s:2:\"id\";s:3:\"482\";s:6:\"handle\";s:20:\"Blinking-bubbles.jpg\";s:5:\"video\";s:20:\"Blinking-bubbles.mp4\";s:4:\"name\";s:17:\"Blinking bubbles \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:357;a:13:{s:2:\"id\";s:3:\"481\";s:6:\"handle\";s:13:\"Fireworks.jpg\";s:5:\"video\";s:13:\"Fireworks.mp4\";s:4:\"name\";s:10:\"Fireworks \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:358;a:13:{s:2:\"id\";s:3:\"480\";s:6:\"handle\";s:12:\"Dark-ink.jpg\";s:5:\"video\";s:12:\"Dark-ink.mp4\";s:4:\"name\";s:9:\"Dark ink \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:359;a:13:{s:2:\"id\";s:3:\"238\";s:6:\"handle\";s:12:\"Mt_Baker.jpg\";s:5:\"video\";s:12:\"Mt_Baker.mp4\";s:4:\"name\";s:9:\"Mt Baker \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:360;a:13:{s:2:\"id\";s:3:\"237\";s:6:\"handle\";s:16:\"Two-Swimmers.jpg\";s:5:\"video\";s:16:\"Two-Swimmers.mp4\";s:4:\"name\";s:13:\"Two Swimmers \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:361;a:13:{s:2:\"id\";s:3:\"236\";s:6:\"handle\";s:14:\"Boats_Maze.jpg\";s:5:\"video\";s:14:\"Boats_Maze.mp4\";s:4:\"name\";s:11:\"Boats Maze \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:362;a:13:{s:2:\"id\";s:3:\"235\";s:6:\"handle\";s:18:\"Candolim-Beach.jpg\";s:5:\"video\";s:18:\"Candolim-Beach.mp4\";s:4:\"name\";s:15:\"Candolim Beach \";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:363;a:13:{s:2:\"id\";s:3:\"234\";s:6:\"handle\";s:17:\"Working-Space.jpg\";s:5:\"video\";s:17:\"Working-Space.mp4\";s:4:\"name\";s:14:\"Working Space \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:364;a:13:{s:2:\"id\";s:3:\"233\";s:6:\"handle\";s:9:\"Wavez.jpg\";s:5:\"video\";s:9:\"Wavez.mp4\";s:4:\"name\";s:6:\"Wavez \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:365;a:13:{s:2:\"id\";s:3:\"232\";s:6:\"handle\";s:17:\"Coconut-Grove.jpg\";s:5:\"video\";s:17:\"Coconut-Grove.mp4\";s:4:\"name\";s:14:\"Coconut Grove \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:366;a:13:{s:2:\"id\";s:3:\"231\";s:6:\"handle\";s:19:\"Very-Open-Space.jpg\";s:5:\"video\";s:19:\"Very-Open-Space.mp4\";s:4:\"name\";s:16:\"Very Open Space \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:367;a:13:{s:2:\"id\";s:3:\"230\";s:6:\"handle\";s:14:\"Office-Day.jpg\";s:5:\"video\";s:14:\"Office-Day.mp4\";s:4:\"name\";s:11:\"Office Day \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:368;a:13:{s:2:\"id\";s:3:\"229\";s:6:\"handle\";s:12:\"The-Hill.jpg\";s:5:\"video\";s:12:\"The-Hill.mp4\";s:4:\"name\";s:9:\"The Hill \";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:369;a:13:{s:2:\"id\";s:3:\"339\";s:6:\"handle\";s:19:\"best_price_dark.jpg\";s:5:\"video\";s:19:\"best_price_dark.mp4\";s:4:\"name\";s:15:\"best_price_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"best_price_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-26 09:24:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:370;a:13:{s:2:\"id\";s:3:\"337\";s:6:\"handle\";s:27:\"limited_time_offer_dark.jpg\";s:5:\"video\";s:27:\"limited_time_offer_dark.mp4\";s:4:\"name\";s:23:\"limited_time_offer_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:23:\"limited_time_offer_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-26 09:24:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:371;a:13:{s:2:\"id\";s:3:\"336\";s:6:\"handle\";s:26:\"slider_revolution_dark.jpg\";s:5:\"video\";s:26:\"slider_revolution_dark.mp4\";s:4:\"name\";s:22:\"slider_revolution_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:22:\"slider_revolution_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-26 09:24:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:372;a:13:{s:2:\"id\";s:3:\"335\";s:6:\"handle\";s:19:\"mick_brown_dark.jpg\";s:5:\"video\";s:19:\"mick_brown_dark.mp4\";s:4:\"name\";s:15:\"mick_brown_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"mick_brown_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-26 09:24:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:373;a:13:{s:2:\"id\";s:3:\"334\";s:6:\"handle\";s:14:\"sales_dark.jpg\";s:5:\"video\";s:14:\"sales_dark.mp4\";s:4:\"name\";s:10:\"sales_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:10:\"sales_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:374;a:13:{s:2:\"id\";s:3:\"333\";s:6:\"handle\";s:21:\"robert_smith_dark.jpg\";s:5:\"video\";s:21:\"robert_smith_dark.mp4\";s:4:\"name\";s:17:\"robert_smith_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"robert_smith_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:375;a:13:{s:2:\"id\";s:3:\"332\";s:6:\"handle\";s:21:\"product_name_dark.jpg\";s:5:\"video\";s:21:\"product_name_dark.mp4\";s:4:\"name\";s:17:\"product_name_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"product_name_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:376;a:13:{s:2:\"id\";s:3:\"331\";s:6:\"handle\";s:21:\"high_quality_dark.jpg\";s:5:\"video\";s:21:\"high_quality_dark.mp4\";s:4:\"name\";s:17:\"high_quality_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"high_quality_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:377;a:13:{s:2:\"id\";s:3:\"330\";s:6:\"handle\";s:24:\"robert_johnson_light.jpg\";s:5:\"video\";s:24:\"robert_johnson_light.mp4\";s:4:\"name\";s:20:\"robert_johnson_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:20:\"robert_johnson_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:378;a:13:{s:2:\"id\";s:3:\"329\";s:6:\"handle\";s:21:\"jake_collins_dark.jpg\";s:5:\"video\";s:21:\"jake_collins_dark.mp4\";s:4:\"name\";s:17:\"jake_collins_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"jake_collins_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:379;a:13:{s:2:\"id\";s:3:\"328\";s:6:\"handle\";s:22:\"daniele_wood_light.jpg\";s:5:\"video\";s:22:\"daniele_wood_light.mp4\";s:4:\"name\";s:18:\"daniele_wood_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"daniele_wood_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:31:30\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:380;a:13:{s:2:\"id\";s:3:\"327\";s:6:\"handle\";s:23:\"michael_blake_light.jpg\";s:5:\"video\";s:23:\"michael_blake_light.mp4\";s:4:\"name\";s:19:\"michael_blake_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:19:\"michael_blake_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:381;a:13:{s:2:\"id\";s:3:\"326\";s:6:\"handle\";s:22:\"product_name_light.jpg\";s:5:\"video\";s:22:\"product_name_light.mp4\";s:4:\"name\";s:18:\"product_name_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"product_name_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:382;a:13:{s:2:\"id\";s:3:\"325\";s:6:\"handle\";s:24:\"rebecca_cooper_light.jpg\";s:5:\"video\";s:24:\"rebecca_cooper_light.mp4\";s:4:\"name\";s:20:\"rebecca_cooper_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:20:\"rebecca_cooper_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:383;a:13:{s:2:\"id\";s:3:\"324\";s:6:\"handle\";s:28:\"limited_time_offer_light.jpg\";s:5:\"video\";s:28:\"limited_time_offer_light.mp4\";s:4:\"name\";s:24:\"limited_time_offer_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:24:\"limited_time_offer_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:384;a:13:{s:2:\"id\";s:3:\"322\";s:6:\"handle\";s:22:\"jake_michael_light.jpg\";s:5:\"video\";s:22:\"jake_michael_light.mp4\";s:4:\"name\";s:18:\"jake_michael_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"jake_michael_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:385;a:13:{s:2:\"id\";s:3:\"321\";s:6:\"handle\";s:23:\"colin_johnson_light.jpg\";s:5:\"video\";s:23:\"colin_johnson_light.mp4\";s:4:\"name\";s:19:\"colin_johnson_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:19:\"colin_johnson_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:386;a:13:{s:2:\"id\";s:3:\"320\";s:6:\"handle\";s:21:\"colin_morris_dark.jpg\";s:5:\"video\";s:21:\"colin_morris_dark.mp4\";s:4:\"name\";s:17:\"colin_morris_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"colin_morris_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:387;a:13:{s:2:\"id\";s:3:\"319\";s:6:\"handle\";s:22:\"justin_cooper_dark.jpg\";s:5:\"video\";s:22:\"justin_cooper_dark.mp4\";s:4:\"name\";s:18:\"justin_cooper_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:18:\"justin_cooper_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:388;a:13:{s:2:\"id\";s:3:\"318\";s:6:\"handle\";s:21:\"james-dodson_dark.jpg\";s:5:\"video\";s:21:\"james-dodson_dark.mp4\";s:4:\"name\";s:17:\"james-dodson_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"james-dodson_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:389;a:13:{s:2:\"id\";s:3:\"317\";s:6:\"handle\";s:23:\"robert_sanders_dark.jpg\";s:5:\"video\";s:23:\"robert_sanders_dark.mp4\";s:4:\"name\";s:19:\"robert_sanders_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:19:\"robert_sanders_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:390;a:13:{s:2:\"id\";s:3:\"316\";s:6:\"handle\";s:21:\"emily_carney_dark.jpg\";s:5:\"video\";s:21:\"emily_carney_dark.mp4\";s:4:\"name\";s:17:\"emily_carney_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"emily_carney_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:391;a:13:{s:2:\"id\";s:3:\"315\";s:6:\"handle\";s:22:\"michael-smith_dark.jpg\";s:5:\"video\";s:22:\"michael-smith_dark.mp4\";s:4:\"name\";s:18:\"michael-smith_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:18:\"michael-smith_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:392;a:13:{s:2:\"id\";s:3:\"314\";s:6:\"handle\";s:23:\"sandra_johnson_dark.jpg\";s:5:\"video\";s:23:\"sandra_johnson_dark.mp4\";s:4:\"name\";s:19:\"sandra_johnson_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:19:\"sandra_johnson_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:393;a:13:{s:2:\"id\";s:3:\"313\";s:6:\"handle\";s:22:\"robert_bolton_dark.jpg\";s:5:\"video\";s:22:\"robert_bolton_dark.mp4\";s:4:\"name\";s:18:\"robert_bolton_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:18:\"robert_bolton_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:394;a:13:{s:2:\"id\";s:3:\"312\";s:6:\"handle\";s:25:\"elegant_captions_dark.png\";s:5:\"video\";s:25:\"elegant_captions_dark.mp4\";s:4:\"name\";s:21:\"elegant_captions_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:21:\"elegant_captions_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-18 14:41:45\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:395;a:13:{s:2:\"id\";s:3:\"311\";s:6:\"handle\";s:19:\"Caption_Dark_06.png\";s:5:\"video\";s:19:\"Caption_Dark_06.mp4\";s:4:\"name\";s:15:\"Caption_Dark_06\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_06\";s:5:\"width\";s:3:\"414\";s:6:\"height\";s:3:\"225\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:396;a:13:{s:2:\"id\";s:3:\"310\";s:6:\"handle\";s:19:\"Header_Light_02.png\";s:5:\"video\";s:19:\"Header_Light_02.mp4\";s:4:\"name\";s:15:\"Header_Light_02\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:15:\"Header_Light_02\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:397;a:13:{s:2:\"id\";s:3:\"309\";s:6:\"handle\";s:21:\"Columns_4_Dark_01.png\";s:5:\"video\";s:21:\"Columns_4_Dark_01.mp4\";s:4:\"name\";s:17:\"Columns_4_Dark_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"Columns_4_Dark_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:398;a:13:{s:2:\"id\";s:3:\"308\";s:6:\"handle\";s:18:\"Header_Dark_01.png\";s:5:\"video\";s:18:\"Header_Dark_01.mp4\";s:4:\"name\";s:14:\"Header_Dark_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:14:\"Header_Dark_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:399;a:13:{s:2:\"id\";s:3:\"307\";s:6:\"handle\";s:19:\"Caption_Dark_03.png\";s:5:\"video\";s:19:\"Caption_Dark_03.mp4\";s:4:\"name\";s:15:\"Caption_Dark_03\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_03\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:400;a:13:{s:2:\"id\";s:3:\"306\";s:6:\"handle\";s:21:\"Columns_3_Dark_01.png\";s:5:\"video\";s:21:\"Columns_3_Dark_01.mp4\";s:4:\"name\";s:17:\"Columns_3_Dark_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"Columns_3_Dark_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:401;a:13:{s:2:\"id\";s:3:\"305\";s:6:\"handle\";s:19:\"Caption_Dark_05.png\";s:5:\"video\";s:19:\"Caption_Dark_05.mp4\";s:4:\"name\";s:15:\"Caption_Dark_05\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_05\";s:5:\"width\";s:4:\"1104\";s:6:\"height\";s:3:\"600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:402;a:13:{s:2:\"id\";s:3:\"304\";s:6:\"handle\";s:20:\"Caption_Light_06.png\";s:5:\"video\";s:20:\"Caption_Light_06.mp4\";s:4:\"name\";s:16:\"Caption_Light_06\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_06\";s:5:\"width\";s:3:\"828\";s:6:\"height\";s:3:\"450\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:403;a:13:{s:2:\"id\";s:3:\"303\";s:6:\"handle\";s:19:\"Header_Light_01.png\";s:5:\"video\";s:19:\"Header_Light_01.mp4\";s:4:\"name\";s:15:\"Header_Light_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:15:\"Header_Light_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:404;a:13:{s:2:\"id\";s:3:\"302\";s:6:\"handle\";s:20:\"Caption_Light_03.png\";s:5:\"video\";s:20:\"Caption_Light_03.mp4\";s:4:\"name\";s:16:\"Caption_Light_03\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_03\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:405;a:13:{s:2:\"id\";s:3:\"301\";s:6:\"handle\";s:19:\"Caption_Dark_01.png\";s:5:\"video\";s:19:\"Caption_Dark_01.mp4\";s:4:\"name\";s:15:\"Caption_Dark_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:406;a:13:{s:2:\"id\";s:3:\"300\";s:6:\"handle\";s:21:\"PromoCode_Dark_01.png\";s:5:\"video\";s:21:\"PromoCode_Dark_01.mp4\";s:4:\"name\";s:17:\"PromoCode_Dark_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"PromoCode_Dark_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:407;a:13:{s:2:\"id\";s:3:\"299\";s:6:\"handle\";s:19:\"Caption_Dark_02.png\";s:5:\"video\";s:19:\"Caption_Dark_02.mp4\";s:4:\"name\";s:15:\"Caption_Dark_02\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_02\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:408;a:13:{s:2:\"id\";s:3:\"298\";s:6:\"handle\";s:18:\"Header_Dark_02.png\";s:5:\"video\";s:18:\"Header_Dark_02.mp4\";s:4:\"name\";s:14:\"Header_Dark_02\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:14:\"Header_Dark_02\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:409;a:13:{s:2:\"id\";s:3:\"297\";s:6:\"handle\";s:22:\"Columns_3_Light_01.png\";s:5:\"video\";s:22:\"Columns_3_Light_01.mp4\";s:4:\"name\";s:18:\"Columns_3_Light_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"Columns_3_Light_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:410;a:13:{s:2:\"id\";s:3:\"296\";s:6:\"handle\";s:20:\"Caption_Light_01.png\";s:5:\"video\";s:20:\"Caption_Light_01.mp4\";s:4:\"name\";s:16:\"Caption_Light_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:411;a:13:{s:2:\"id\";s:3:\"295\";s:6:\"handle\";s:19:\"Caption_Dark_04.png\";s:5:\"video\";s:19:\"Caption_Dark_04.mp4\";s:4:\"name\";s:15:\"Caption_Dark_04\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_04\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:412;a:13:{s:2:\"id\";s:3:\"294\";s:6:\"handle\";s:20:\"Caption_Light_02.png\";s:5:\"video\";s:20:\"Caption_Light_02.mp4\";s:4:\"name\";s:16:\"Caption_Light_02\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_02\";s:5:\"width\";s:3:\"828\";s:6:\"height\";s:3:\"450\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:413;a:13:{s:2:\"id\";s:3:\"293\";s:6:\"handle\";s:20:\"Caption_Light_04.png\";s:5:\"video\";s:20:\"Caption_Light_04.mp4\";s:4:\"name\";s:16:\"Caption_Light_04\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_04\";s:5:\"width\";s:4:\"1104\";s:6:\"height\";s:3:\"600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:414;a:13:{s:2:\"id\";s:3:\"292\";s:6:\"handle\";s:22:\"Columns_4_Light_01.png\";s:5:\"video\";s:22:\"Columns_4_Light_01.mp4\";s:4:\"name\";s:18:\"Columns_4_Light_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"Columns_4_Light_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:415;a:13:{s:2:\"id\";s:3:\"291\";s:6:\"handle\";s:20:\"Caption_Light_05.png\";s:5:\"video\";s:20:\"Caption_Light_05.mp4\";s:4:\"name\";s:16:\"Caption_Light_05\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_05\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:416;a:13:{s:2:\"id\";s:3:\"290\";s:6:\"handle\";s:22:\"PromoCode_Light_01.png\";s:5:\"video\";s:22:\"PromoCode_Light_01.mp4\";s:4:\"name\";s:18:\"PromoCode_Light_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"PromoCode_Light_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}}s:4:\"tags\";a:18:{i:28;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}i:5;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:20;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:21;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}i:25;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}i:2;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:16;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}i:26;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}i:18;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:4;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}i:19;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:23;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}i:3;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:24;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}i:22;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:29;a:3:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:5:\"space\";s:4:\"name\";s:5:\"Space\";}i:27;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}}", "no");
INSERT INTO `wp_options` VALUES("189", "revslider-templates-check", "1727206366", "yes");
INSERT INTO `wp_options` VALUES("190", "revslider-templates-hash", "996de3cbf3342517b1715327dc28eaeb", "yes");
INSERT INTO `wp_options` VALUES("191", "rs-templates-new", "", "off");
INSERT INTO `wp_options` VALUES("192", "rs-templates", "{\"hash\":\"23874d89549f72355cd0874f215f120c\",\"slider\":{\"0\":{\"id\":\"1\",\"title\":\"Classic Carousel\",\"alias\":\"classic-carousel\",\"zip\":\"classic-carousel.zip\",\"uid\":\"146a01dd380c0cdee85c4456ee68cd84\",\"img\":\"classic-carousel\\/slider.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/carousel-slider-plugin\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=carousel-slider-plugin\",\"version\":\"1.0.0\",\"required\":\"5.0.5\",\"width\":\"1240\",\"height\":\"600\",\"description\":\"<span class=\\\"ttm_content\\\">Our classic, full-width carousel example. Drag, swipe or click to navigate!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"cat\":\"Revolution Base\",\"filter\":[\"carousel\"],\"plugin_require\":null,\"date\":\"2016-02-22 13:21:33\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"1\":{\"id\":\"2\",\"title\":\"Classic Slider\",\"alias\":\"classicslider\",\"zip\":\"classicslider.zip\",\"uid\":\"a0d6a9248c9066b404ba0f1cdadc5cf2\",\"img\":\"classicslider\\/slider.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/wordpress-slideshow-gallery\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-slideshow-gallery\",\"version\":\"1.0.0\",\"required\":\"5.0.5\",\"width\":\"1240\",\"height\":\"600\",\"description\":\" <span class=\\\"ttm_content\\\">A classic slideshow example with timer, bullets and arrow navigation.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"cat\":\"Revolution Base\",\"filter\":[\"slider\"],\"plugin_require\":null,\"date\":\"2016-02-24 13:21:33\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"2\":{\"id\":\"3\",\"title\":\"Content Tabs\",\"alias\":\"contenttabs\",\"zip\":\"contenttabs.zip\",\"uid\":\"e02e91604b690123a3d07a65582c4fd0\",\"img\":\"contenttabs\\/slider.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/wordpress-content-tabs-slider\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-content-tabs-slider\",\"version\":\"1.0.0\",\"required\":\"5.0.5\",\"width\":\"1024\",\"height\":\"600\",\"description\":\" <span class=\\\"ttm_content\\\">An auto-size slider with a cool split-text animation effect. Navigate with vertical bullets and thumbs.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"cat\":\"Revolution Base\",\"filter\":[\"slider\"],\"plugin_require\":null,\"date\":\"2016-02-24 13:21:33\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"3\":{\"id\":\"4\",\"title\":\"Facebook Feed\",\"alias\":\"facebook-feed\",\"zip\":\"facebook-feed.zip\",\"uid\":\"5506431d5b1babcb25dcf52c508d42e3\",\"img\":\"facebook-feed\\/slider.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/wordpress-facebook-feed\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-facebook-feed\",\"version\":\"1.0.1\",\"required\":\"5.0.5\",\"width\":\"800\",\"height\":\"600\",\"description\":\"<span class=\\\"ttm_content\\\"> This slider is automatically populated by a Facebook stream. Just one slide is needed to show a whole feed!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">The content source is set to <a href=\\\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/module-content\\/#flickr\\\" target=\\\"_blank\\\">\\\"Facebook Stream\\\"<\\/a>. Make sure to input your correct API information in the slider settings.<br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Revolution Base\",\"filter\":[\"slider\",\"socialmedia\"],\"plugin_require\":null,\"date\":\"2016-02-24 13:21:33\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"4\":{\"id\":\"5\",\"title\":\"Fashion\",\"alias\":\"fashion\",\"zip\":\"fashion.zip\",\"uid\":\"4f4b914d6db35e19101ff003c4e7ea3a\",\"img\":\"fashion\\/slider.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/wordpress-one-page-slider-theme\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-one-page-slider-theme\",\"version\":\"1.0.0\",\"required\":\"5.0.5\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"  <span class=\\\"ttm_content\\\">A front-page slider that can be used as an intro for your website. Navigate by using mouse-wheel scroll or bullets.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"cat\":\"Revolution Base\",\"filter\":[\"slider\"],\"plugin_require\":null,\"date\":\"2016-02-24 13:21:33\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"5\":{\"id\":\"6\",\"title\":\"Flickr Gallery\",\"alias\":\"flickr-gallery\",\"zip\":\"flickr-gallery.zip\",\"uid\":\"ad85cfac7acfa678e6a1b8febfee51ed\",\"img\":\"flickr-gallery\\/slider.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/wordpress-flickr-slider\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-flickr-slider\",\"version\":\"1.0.0\",\"required\":\"5.0.5\",\"width\":\"800\",\"height\":\"640\",\"description\":\" <span class=\\\"ttm_content\\\"> This slider is automatically populated by a Flickr stream. Just one slide is needed to show a whole feed!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"cat\":\"Revolution Base\",\"filter\":[\"slider\",\"socialmedia\"],\"plugin_require\":null,\"date\":\"2016-02-24 13:21:33\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"6\":{\"id\":\"7\",\"title\":\"Gym\",\"alias\":\"gym\",\"zip\":\"gym.zip\",\"uid\":\"e4d81f13f96fb9bc905f4ad89615032b\",\"img\":\"gym\\/slider.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/one-page-wordpress-slider\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=one-page-wordpress-slider\",\"version\":\"1.0.1\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">A front-page slider that can be used as an intro for your website. Navigate by using mouse-wheel scroll or the slider menu.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">This is a \\\"Default\\\" content slider. Edit the slides to change images and texts.<br\\/>Some content is in <a href=\\\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/global-layers\\/\\\" target=\\\"_blank\\\">\\\"Static \\/ Global Layers\\\"<\\/a><br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Instructions for <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/modify-burger-menu\\/\\\" target=\\\"_blank\\\">changing the menu<\\/a>.<\\/span><br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Revolution Base\",\"filter\":[\"slider\"],\"plugin_require\":null,\"date\":\"2016-02-24 13:21:33\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"7\":{\"id\":\"8\",\"title\":\"Highlight Carousel\",\"alias\":\"highlight-carousel\",\"zip\":\"highlight-carousel.zip\",\"uid\":\"ada52163f723a942f782351fa0396b3d\",\"img\":\"highlight-carousel\\/slider.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/wordpress-swipe-slider\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-swipe-slider\",\"version\":\"1.0.0\",\"required\":\"5.0.5\",\"width\":\"800\",\"height\":\"720\",\"description\":\"  <span class=\\\"ttm_content\\\">A swipe-controlled carousel with an additional tab-based navigation.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\\r\\n\",\"cat\":\"Revolution Base\",\"filter\":[\"carousel\"],\"plugin_require\":null,\"date\":\"2016-02-24 13:21:33\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"8\":{\"id\":\"9\",\"title\":\"Highlight Showcase\",\"alias\":\"highlight-showcase\",\"zip\":\"highlight-showcase.zip\",\"uid\":\"2bfe0bd410fb48fec9d942eab1e21530\",\"img\":\"highlight-showcase\\/slider.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/wordpress-parallax-slideshow\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-parallax-slideshow\",\"version\":\"1.0.0\",\"required\":\"5.0.5\",\"width\":\"1230\",\"height\":\"720\",\"description\":\"<span class=\\\"ttm_content\\\">A tab-based navigation, a slideshow timer and cool animations make this slider interesting!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"cat\":\"Revolution Base\",\"filter\":[\"slider\"],\"plugin_require\":null,\"date\":\"2016-02-24 13:21:33\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"9\":{\"id\":\"10\",\"title\":\"Image Hero\",\"alias\":\"image-hero\",\"zip\":\"imagehero.zip\",\"uid\":\"7db18781d44f2adc28c962440894aac1\",\"img\":\"imagehero\\/slider.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/wordpress-hero-image\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-hero-image\",\"version\":\"1.0.2\",\"required\":\"5.0.5\",\"width\":\"1240\",\"height\":\"600\",\"description\":\"<span class=\\\"ttm_content\\\">A commonly used full-width image hero block with texts.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"cat\":\"Revolution Base\",\"filter\":[\"hero\"],\"plugin_require\":null,\"date\":\"2016-02-24 13:21:33\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"10\":{\"id\":\"11\",\"title\":\"Instagram Gallery\",\"alias\":\"insta-gallery\",\"zip\":\"insta-gallery.zip\",\"uid\":\"711732b0d42ec2b57818a2b9b1d86cba\",\"img\":\"insta-gallery\\/slider.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/wordpress-instagram-gallery\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-instagram-gallery\",\"version\":\"1.0.1\",\"required\":\"5.0.5\",\"width\":\"640\",\"height\":\"640\",\"description\":\"<span class=\\\"ttm_content\\\">This slider is automatically populated by a Instagram stream. Just one slide is needed to show a whole feed!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">The content source is set to <a href=\\\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/module-content\\/#flickr\\\" target=\\\"_blank\\\">\\\"Instagram Stream\\\"<\\/a>. Make sure to input your correct API information in the slider settings.<br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Revolution Base\",\"filter\":[\"slider\",\"socialmedia\"],\"plugin_require\":null,\"date\":\"2016-02-24 13:21:33\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"11\":{\"id\":\"12\",\"title\":\"Levano Restaurant Bar\",\"alias\":\"levanorestaurantbar\",\"zip\":\"levanorestaurantbar.zip\",\"uid\":\"4178f837db67d1b2eb6cb5840bbd0b42\",\"img\":\"levanorestaurantbar\\/slider.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/wordpress-front-page-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-front-page-template\",\"version\":\"1.0.1\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">A front-page slider that can be used as an intro for your website. Navigate by using mouse-wheel scroll or bullets.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">This is a \\\"Default\\\" content slider. Edit the slides to change images and texts.<br\\/>Some content is in <a href=\\\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/global-layers\\/\\\" target=\\\"_blank\\\">\\\"Static \\/ Global Layers\\\"<\\/a><br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Instructions for <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/modify-burger-menu\\/\\\" target=\\\"_blank\\\">changing the menu<\\/a>.<\\/span><br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Revolution Base\",\"filter\":[\"slider\"],\"plugin_require\":null,\"date\":\"2016-02-24 13:21:33\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"12\":{\"id\":\"13\",\"title\":\"Main Feature Slider\",\"alias\":\"mainfeature\",\"zip\":\"mainfeature.zip\",\"uid\":\"1e002a3230ab00095bedc6f60393ee7f\",\"img\":\"mainfeature\\/slider.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=revolution.themepunch.com\",\"version\":\"1.0.0\",\"required\":\"5.0.5\",\"width\":\"1230\",\"height\":\"750\",\"description\":\" <span class=\\\"ttm_content\\\">A slightly stripped down version of the main preview slider.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">This is a \\\"Default\\\" content slider. Just edit the slides to change images and texts.<br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Revolution Base\",\"filter\":[\"slider\"],\"plugin_require\":null,\"date\":\"2016-02-24 13:21:33\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"13\":{\"id\":\"14\",\"title\":\"Media Gallery Two\",\"alias\":\"media-gallery-two\",\"zip\":\"media-gallery-two.zip\",\"uid\":\"d002f1b1b55805f9322c264c5504ba5a\",\"img\":\"media-gallery-two\\/slider.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/wordpress-media-gallery-slider\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-media-gallery-slider\",\"version\":\"1.0.1\",\"required\":\"6.2.22\",\"width\":\"1230\",\"height\":\"692\",\"description\":\"<span class=\\\"ttm_content\\\">A media gallery example with Vimeo, HTML5 and Youtube videos.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">This is a \\\"Default\\\" content slider. Just edit the slides to change media and titles.<br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Revolution Base\",\"filter\":[\"slider\"],\"plugin_require\":null,\"date\":\"2016-02-24 13:21:33\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"14\":{\"id\":\"15\",\"title\":\"Media Carousel Autoplay\",\"alias\":\"media-carousel-autoplay\",\"zip\":\"media-carousel-autoplay.zip\",\"uid\":\"393d7875b1cc9d933378b35e4f645d76\",\"img\":\"media-carousel-autoplay\\/slider.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/wordpress-media-gallery\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-media-gallery\",\"version\":\"1.0.0\",\"required\":\"5.0.5\",\"width\":\"720\",\"height\":\"405\",\"description\":\"<span class=\\\"ttm_content\\\">A media carousel with \\\"autoplay\\\" activated. Swipe or click tabs to navigate the slider.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">This is a \\\"Default\\\" content slider. Just edit the slides to change media and caption texts.<br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Revolution Base\",\"filter\":[\"carousel\"],\"plugin_require\":null,\"date\":\"2016-02-24 13:21:33\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"15\":{\"id\":\"16\",\"title\":\"News Background Video\",\"alias\":\"news-background-video\",\"zip\":\"news-bg-video.zip\",\"uid\":\"a0efe44ac3af0f958b3f84c816a08272\",\"img\":\"news-bg-video\\/slider.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/wordpress-content-blocks\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-content-blocks\",\"version\":\"1.0.2\",\"required\":\"5.0.5\",\"width\":\"1240\",\"height\":\"500\",\"description\":\"<span class=\\\"ttm_content\\\">A hero block with HTML5 background video that plays when entering the screen.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">This is a \\\"Default\\\" content hero slider. Just edit the slide to change the background video and texts.<br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Revolution Base\",\"filter\":[\"hero\"],\"plugin_require\":null,\"date\":\"2016-02-24 13:21:33\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"16\":{\"id\":\"17\",\"title\":\"News Gallery\",\"alias\":\"news-gallery\",\"zip\":\"news-gallery.zip\",\"uid\":\"3a069c3b286dbb9ee435563f747e3300\",\"img\":\"news-gallery\\/slider.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/wordpress-news-rotator\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-news-rotator\",\"version\":\"1.0.0\",\"required\":\"5.0.5\",\"width\":\"1240\",\"height\":\"500\",\"description\":\"<span class=\\\"ttm_content\\\">A news gallery slideshow with tab navigation. Great for any blog!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">This is a \\\"Default\\\" content slider. Just edit the slides to change images and texts.<br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Revolution Base\",\"filter\":[\"slider\"],\"plugin_require\":null,\"date\":\"2016-02-24 13:21:33\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"17\":{\"id\":\"18\",\"title\":\"News Gallery Post Based\",\"alias\":\"news-gallery-post-based\",\"zip\":\"news-gallery-post-based.zip\",\"uid\":\"32fe05b1039c29ab9420bfd15aec5488\",\"img\":\"news-gallery-post-based\\/slider.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/wordpress-post-slider\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-post-slider\",\"version\":\"1.0.0\",\"required\":\"5.0.5\",\"width\":\"1240\",\"height\":\"500\",\"description\":\"<span class=\\\"ttm_content\\\"> This slider is automatically populated by WordPress posts.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">The content source is set to <a href=\\\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/module-content\\/#flickr\\\" target=\\\"_blank\\\">\\\"Post-Based Slider\\\"<\\/a>. Make sure to select the post type you want to display in the slider settings.<br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Revolution Base\",\"filter\":[\"slider\",\"postbased\"],\"plugin_require\":null,\"date\":\"2016-02-24 13:21:33\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"18\":{\"id\":\"19\",\"title\":\"News Hero\",\"alias\":\"news-hero\",\"zip\":\"news-hero.zip\",\"uid\":\"96a0385538a17c8c81ed8175740f70ea\",\"img\":\"news-hero\\/slider.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/wordpress-content-blocks\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-content-blocks\",\"version\":\"1.0.1\",\"required\":\"5.0.5\",\"width\":\"1240\",\"height\":\"500\",\"description\":\"<span class=\\\"ttm_content\\\">A image hero block with ken burns effect.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">This is a \\\"Default\\\" content hero slider. Just edit the slide to change the background image and texts.<br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Revolution Base\",\"filter\":[\"hero\"],\"plugin_require\":null,\"date\":\"2016-02-24 13:21:33\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"19\":{\"id\":\"20\",\"title\":\"News Video\",\"alias\":\"news-video\",\"zip\":\"news-video.zip\",\"uid\":\"f901e9e16e0363248156c2209eb584e9\",\"img\":\"news-video\\/slider.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/wordpress-content-blocks\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-content-blocks\",\"version\":\"1.0.0\",\"required\":\"5.0.5\",\"width\":\"1240\",\"height\":\"500\",\"description\":\"<span class=\\\"ttm_content\\\">A Vimeo background video hero block with play \\/ pause buttons.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">This is a \\\"Default\\\" content hero slider. Just edit the slide to change the video and texts.<br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Revolution Base\",\"filter\":[\"hero\"],\"plugin_require\":null,\"date\":\"2016-02-24 13:21:33\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"20\":{\"id\":\"21\",\"title\":\"Newsletter Hero\",\"alias\":\"newsletter-hero\",\"zip\":\"newsletter-hero.zip\",\"uid\":\"6290a9864d8c4c6311784586ed1cc5fe\",\"img\":\"newsletter-hero\\/slider.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/wordpress-newsletter-signup\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-newsletter-signup\",\"version\":\"1.0.2\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"600\",\"description\":\"<span class=\\\"ttm_content\\\">This hero block uses a custom styled Mailchimp newsletter signup field.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">This is a \\\"Default\\\" content hero slider. Just edit the slide to change the background image, texts, and <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/how-to-setup-mailchimp-for-the-newsletter-hero-template\\/\\\" target=\\\"_blank\\\">Mailchimp code<\\/a>.<br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Revolution Base\",\"filter\":[\"hero\"],\"plugin_require\":null,\"date\":\"2016-02-24 13:21:33\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"21\":{\"id\":\"22\",\"title\":\"Not Generic\",\"alias\":\"notgeneric\",\"zip\":\"notgeneric.zip\",\"uid\":\"9d87ba95e02210a9f82387add2ceadf9\",\"img\":\"notgeneric\\/slider.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/wordpress-fullscreen-slider\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-fullscreen-slider\",\"version\":\"1.0.0\",\"required\":\"5.0.5\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">A full-screen slider with a layer based navigation and sleek content elements.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">This is a \\\"Default\\\" content slider. Edit the slides to change images and texts.<br\\/>Some content is in <a href=\\\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/global-layers\\/\\\" target=\\\"_blank\\\">\\\"Static \\/ Global Layers\\\"<\\/a><br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Instructions for <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/modify-burger-menu\\/\\\" target=\\\"_blank\\\">changing the menu<\\/a>.<\\/span><br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Revolution Base\",\"filter\":[\"slider\"],\"plugin_require\":null,\"date\":\"2016-02-24 13:21:33\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"22\":{\"id\":\"23\",\"title\":\"Photography\",\"alias\":\"photography\",\"zip\":\"photography.zip\",\"uid\":\"1b2072547afb75e49f33b016751ed360\",\"img\":\"photography\\/slider.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/wordpress-photography-slider\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-photography-slider\",\"version\":\"1.0.1\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">A front-page slider that can be used as an intro for your website. Navigate by using mouse-wheel scroll or the layer-based menu.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">This is a \\\"Default\\\" content slider. Edit the slides to change images and texts.<br\\/>Some content is in <a href=\\\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/global-layers\\/\\\" target=\\\"_blank\\\">\\\"Static \\/ Global Layers\\\"<\\/a><br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Instructions for <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/modify-burger-menu\\/\\\" target=\\\"_blank\\\">changing the menu<\\/a>.<\\/span><br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Revolution Base\",\"filter\":[\"slider\"],\"plugin_require\":null,\"date\":\"2016-02-24 13:21:33\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"23\":{\"id\":\"24\",\"title\":\"Photography Carousel\",\"alias\":\"photography-carousel\",\"zip\":\"photography-carousel.zip\",\"uid\":\"9a84b859ba23dc49ba8784e3a86545fa\",\"img\":\"photography-carousel\\/slider.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/wordpress-photo-gallery\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-photo-gallery\",\"version\":\"1.0.0\",\"required\":\"5.0.5\",\"width\":\"1024\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">A front-page carousel that can be used as an intro for your website. Navigate by using mouse-wheel scroll or the layer-based menu.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">This is a \\\"Default\\\" content slider. Edit the slides to change images and texts.<br\\/>Some content is in <a href=\\\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/global-layers\\/\\\" target=\\\"_blank\\\">\\\"Static \\/ Global Layers\\\"<\\/a><br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Instructions for <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/modify-burger-menu\\/\\\" target=\\\"_blank\\\">changing the menu<\\/a>.<\\/span><br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Revolution Base\",\"filter\":[\"carousel\"],\"plugin_require\":null,\"date\":\"2016-02-24 13:21:33\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"24\":{\"id\":\"25\",\"title\":\"Search Form Hero\",\"alias\":\"search-form-hero\",\"zip\":\"search-form-hero.zip\",\"uid\":\"e09eb1bd0f22b3a2b02a1aa251dd1f3e\",\"img\":\"search-form-hero\\/slider.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/wordpress-search-form-hero\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-search-form-hero\",\"version\":\"1.0.2\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"600\",\"description\":\"<span class=\\\"ttm_content\\\">This hero block uses a custom styled input field to show search results on a WordPress site.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">This is a \\\"Default\\\" content hero slider. Just edit the slide to change the background image, texts, and search field code.<br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Revolution Base\",\"filter\":[\"hero\"],\"plugin_require\":null,\"date\":\"2016-02-24 13:21:33\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"25\":{\"id\":\"26\",\"title\":\"Showcase Carousel\",\"alias\":\"showcasecarousel\",\"zip\":\"showcasecarousel.zip\",\"uid\":\"c5ca218398331bd2c064efc2f62eae56\",\"img\":\"showcasecarousel\\/slider.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/wordpress-cover-flow-gallery\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-cover-flow-gallery\",\"version\":\"1.0.1\",\"required\":\"5.0.5\",\"width\":\"600\",\"height\":\"600\",\"description\":\"<span class=\\\"ttm_content\\\">A fancy carousel that rotates, fades and scales slider items.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\\r\\n\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">This is a \\\"Default\\\" content carousel. Just edit the slides to change images and texts.<br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Revolution Base\",\"filter\":[\"carousel\"],\"plugin_require\":null,\"date\":\"2016-02-24 13:21:33\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"26\":{\"id\":\"27\",\"title\":\"Sports Hero\",\"alias\":\"sports-hero\",\"zip\":\"sportshero.zip\",\"uid\":\"8de7a145f32a362d618d2595ffa2f724\",\"img\":\"sportshero\\/slider.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/wordpress-image-hero\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-image-hero\",\"version\":\"1.0.2\",\"required\":\"5.0.5\",\"width\":\"1240\",\"height\":\"720\",\"description\":\"<span class=\\\"ttm_content\\\">An sports themed image hero block with buttons.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">This is a \\\"Default\\\" content hero slider. Just edit the slide to change the background image and texts.<br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Revolution Base\",\"filter\":[\"hero\"],\"plugin_require\":null,\"date\":\"2016-02-24 13:21:33\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"28\":{\"id\":\"29\",\"title\":\"Vimeo Gallery\",\"alias\":\"vimeo-gallery\",\"zip\":\"vimeo-gallery.zip\",\"uid\":\"fa824ce1ff3942ec268fc9eda60df539\",\"img\":\"vimeo-gallery\\/slider.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/wordpress-vimeo-gallery\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-vimeo-gallery\",\"version\":\"1.0.1\",\"required\":\"5.0.5\",\"width\":\"1230\",\"height\":\"692\",\"description\":\"<span class=\\\"ttm_content\\\">This slider is automatically populated by a Vimeo stream. Just one slide is needed to show a whole feed!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">The content source is set to <a href=\\\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/module-content\\/#flickr\\\" target=\\\"_blank\\\">\\\"Vimeo Stream\\\"<\\/a>. Make sure to input your correct API information in the slider settings.<br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Revolution Base\",\"filter\":[\"slider\",\"socialmedia\"],\"plugin_require\":null,\"date\":\"2016-02-24 13:21:33\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"29\":{\"id\":\"30\",\"title\":\"Vimeo Hero\",\"alias\":\"vimeohero\",\"zip\":\"vimeohero.zip\",\"uid\":\"c575575f96173d88589cddcb06120b77\",\"img\":\"vimeohero\\/slider.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/wordpress-hero-vimeo\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-hero-vimeo\",\"version\":\"1.0.0\",\"required\":\"5.0.5\",\"width\":\"1240\",\"height\":\"600\",\"description\":\"<span class=\\\"ttm_content\\\">A commonly used Vimeo video background hero block.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">This is a \\\"Default\\\" content hero slider. Just edit the slide to change the background video and texts.<br\\/><br\\/><\\/span>\\r\\nScreencast for <a href=\\\"https:\\/\\/www.youtube.com\\/playlist?list=PLSCdqDWVMJPPXEuOEqYEQMAsp0vAYw52_\\\" target=\\\"_blank\\\">mobile video<\\/a> considerations.<\\/a>\\r\\n<br\\/><br\\/>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Revolution Base\",\"filter\":[\"hero\"],\"plugin_require\":null,\"date\":\"2016-02-24 13:21:33\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"30\":{\"id\":\"31\",\"title\":\"Web Product Dark\",\"alias\":\"web-product-dark\",\"zip\":\"web-product-dark.zip\",\"uid\":\"39b872cf0608e63c3a503e58374dc30a\",\"img\":\"web-product-dark\\/slider.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/wordpress-frontpage-slider\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-frontpage-slider\",\"version\":\"1.0.0\",\"required\":\"5.0.5\",\"width\":\"1400\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">A front-page slider that can be used as an intro for your website. Navigate by using mouse-wheel scroll or the layer-based menu.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">This is a \\\"Default\\\" content slider. Edit the slides to change images and texts.<br\\/>Some content is in <a href=\\\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/global-layers\\/\\\" target=\\\"_blank\\\">\\\"Static \\/ Global Layers\\\"<\\/a><br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Instructions for <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/modify-burger-menu\\/\\\" target=\\\"_blank\\\">changing the menu<\\/a>.<\\/span><br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Revolution Base\",\"filter\":[\"slider\"],\"plugin_require\":null,\"date\":\"2016-02-24 13:21:33\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"31\":{\"id\":\"32\",\"title\":\"Web Product Dark Hero\",\"alias\":\"web-product-dark-hero\",\"zip\":\"web-product-dark-hero.zip\",\"uid\":\"b6784e8925221f36677217979d26e6f0\",\"img\":\"web-product-dark-hero\\/slider.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/wordpress-header-image\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-header-image\",\"version\":\"1.0.0\",\"required\":\"5.0.5\",\"width\":\"1400\",\"height\":\"768\",\"description\":\"<span class=\\\"ttm_content\\\">A modern hero block with three common devices. The screens of each device can be changed easily!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">This is a \\\"Default\\\" content hero slider. Just edit the slide to change the background image and texts.<br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Revolution Base\",\"filter\":[\"hero\"],\"plugin_require\":null,\"date\":\"2016-02-24 13:21:33\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"32\":{\"id\":\"33\",\"title\":\"Web Product Light Hero\",\"alias\":\"web-product-light-hero\",\"zip\":\"web-product-light-hero.zip\",\"uid\":\"428e65d6aaa6ef775429989d50516492\",\"img\":\"web-product-light-hero\\/slider.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/hero-image-wordpress\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=hero-image-wordpress\",\"version\":\"1.0.0\",\"required\":\"5.0.5\",\"width\":\"1400\",\"height\":\"768\",\"description\":\"<span class=\\\"ttm_content\\\">A modern hero block with three common devices. The screens of each device can be changed easily!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">This is a \\\"Default\\\" content hero slider. Just edit the slide to change the image and texts.<br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Revolution Base\",\"filter\":[\"hero\"],\"plugin_require\":null,\"date\":\"2016-02-24 13:21:33\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"33\":{\"id\":\"34\",\"title\":\"Web Product Light\",\"alias\":\"webproductlight\",\"zip\":\"webproductlight.zip\",\"uid\":\"fa23dab5bf1139c6393828647a9de4e0\",\"img\":\"webproductlight\\/slider.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/wordpress-cover-page\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-cover-page\",\"version\":\"1.0.0\",\"required\":\"5.0.5\",\"width\":\"1400\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">A front-page slider that can be used as an intro for your website. Navigate by using mouse-wheel scroll or the layer-based menu.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">This is a \\\"Default\\\" content slider. Edit the slides to change images and texts.<br\\/>Some content is in <a href=\\\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/global-layers\\/\\\" target=\\\"_blank\\\">\\\"Static \\/ Global Layers\\\"<\\/a><br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Instructions for <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/modify-burger-menu\\/\\\" target=\\\"_blank\\\">changing the menu<\\/a>.<\\/span><br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Revolution Base\",\"filter\":[\"slider\"],\"plugin_require\":null,\"date\":\"2016-02-24 13:21:33\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"34\":{\"id\":\"35\",\"title\":\"Youtube Gallery\",\"alias\":\"youtube-gallery\",\"zip\":\"youtube-gallery.zip\",\"uid\":\"ee9e4928ac74f5f0c0b697ce708f5aa7\",\"img\":\"youtube-gallery\\/slider.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/wordpress-youtube-gallery\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-youtube-gallery\",\"version\":\"1.0.1\",\"required\":\"5.0.5\",\"width\":\"1240\",\"height\":\"600\",\"description\":\"<span class=\\\"ttm_content\\\"> This slider is automatically populated by a YouTube stream. Just one slide is needed to show a whole feed!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">The content source is set to <a href=\\\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/module-content\\/#flickr\\\" target=\\\"_blank\\\">\\\"YouTube Stream\\\"<\\/a>. Make sure to input your correct API information in the slider settings.<br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Revolution Base\",\"filter\":[\"slider\",\"socialmedia\"],\"plugin_require\":null,\"date\":\"2016-02-24 13:21:33\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"35\":{\"id\":\"36\",\"title\":\"Youtube Hero\",\"alias\":\"youtubehero\",\"zip\":\"youtubehero.zip\",\"uid\":\"e0b2c12a45841bdf21cb96305f2c85bf\",\"img\":\"youtubehero\\/slider.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/wordpress-youtube-header\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-youtube-header\",\"version\":\"1.0.3\",\"required\":\"5.0.5\",\"width\":\"1240\",\"height\":\"600\",\"description\":\"<span class=\\\"ttm_content\\\">A YouTube video background hero block.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">This is a \\\"Default\\\" content hero slider. Just edit the slide to change the background video and texts.<br\\/><br\\/><\\/span>\\r\\nScreencast for <a href=\\\"https:\\/\\/www.youtube.com\\/playlist?list=PLSCdqDWVMJPPXEuOEqYEQMAsp0vAYw52_\\\" target=\\\"_blank\\\">mobile video<\\/a> considerations.<\\/a>\\r\\n<br\\/><br\\/>\\r\\nLearn how to <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/enable-sound-for-the-youtube-hero-template\\/\\\" target=\\\"_blank\\\">enable sound for the background video<\\/a><br \\/><br \\/>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Revolution Base\",\"filter\":[\"hero\"],\"plugin_require\":null,\"date\":\"2016-02-24 13:21:33\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"36\":{\"id\":\"37\",\"title\":\"Scroll Effect\",\"alias\":\"scroll-effect\",\"zip\":\"scroll-effect.zip\",\"uid\":\"417f59e9db87aa7e47c8509eb88d4af6\",\"img\":\"scrolleffect\\/slide1.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/big-bold-fullscreen-slider\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=big-bold-fullscreen-slider\",\"version\":\"1.0.0\",\"required\":\"5.0.5\",\"width\":\"1240\",\"height\":\"600\",\"description\":\"<span class=\\\"ttm_content\\\">A full-screen slider with a unique scroll effect and big, bold text.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">This is a \\\"Default\\\" content slider. Edit the slides to change images and texts.<br\\/>For further configuration options please view the <a href=\\\"https:\\/\\/https:\\/\\/www.themepunch.com\\/slider-revolution\\/custom-css-javascript\\/\\\" target=\\\"_blank\\\">\\\"Custom CSS\\/JS\\\"<\\/a> section in the slider settings.<br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\"],\"plugin_require\":null,\"date\":\"2016-02-24 13:21:33\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"37\":{\"id\":\"38\",\"title\":\"Content Zoom\",\"alias\":\"content-zoom\",\"zip\":\"content-zoom.zip\",\"uid\":\"42ef8cdb70d42ec6ff6fa3b69a027b5f\",\"img\":\"contentzoom\\/slide1.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/content-zoom-slider\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=content-zoom-slider\",\"version\":\"1.0.0\",\"required\":\"5.0.5\",\"width\":\"1240\",\"height\":\"600\",\"description\":\"<span class=\\\"ttm_content\\\">A very unique full-width slider that uses <a href=\\\"https:\\/\\/www.themepunch.com\\/revslider-doc\\/layer-settings\\/#layeractions\\\" target=\\\"_blank\\\">\\\"Layer Actions\\\"<\\/a> to their potential.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">This is a \\\"Default\\\" content slider. Edit the slides to change images and texts.<br\\/>It might be helpful to use the \\\"hide\\/show layer\\\" feature to efficiently edit all content.<br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\"],\"plugin_require\":null,\"date\":\"2016-02-24 13:21:33\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"38\":{\"id\":\"39\",\"title\":\"Food Carousel\",\"alias\":\"food-carousel\",\"zip\":\"food-carousel.zip\",\"uid\":\"a7bf54527b6658a0a308c70c729779fe\",\"img\":\"foodcarousel\\/slider_cover.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/food-carousel-slider\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=food-carousel-slider\",\"version\":\"1.0.0\",\"required\":\"5.0.5\",\"width\":\"1240\",\"height\":\"600\",\"description\":\"<span class=\\\"ttm_content\\\">A fancy carousel with detail content on each slide. <a href=\\\"https:\\/\\/www.themepunch.com\\/revslider-doc\\/layer-settings\\/#layeractions\\\" target=\\\"_blank\\\">\\\"Layer Actions\\\"<\\/a> are used to show and hide layers.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">This is a \\\"Default\\\" content slider. Edit the slides to change images and texts.<br\\/>It might be helpful to use the \\\"hide\\/show layer\\\" feature to efficiently edit all content.<br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"carousel\"],\"plugin_require\":null,\"date\":\"2016-02-24 13:21:33\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"40\":{\"id\":\"41\",\"title\":\"Travel Static Captions\",\"alias\":\"travel-static-captions\",\"zip\":\"travel-static-captions.zip\",\"uid\":\"bbe7d61c7c741ebc7aa1ce1082b0cb71\",\"img\":\"travel-static-captions\\/slide1.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/travel-slideshow\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=travel-slideshow\",\"version\":\"1.0.0\",\"required\":\"5.0.5\",\"width\":\"1240\",\"height\":\"600\",\"description\":\"<span class=\\\"ttm_content\\\">A slideshow example with static captions layers above a rotating image background.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">This is a \\\"Default\\\" content slider. Edit the slides to change images and texts.<br\\/>Some content is in <a href=\\\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/global-layers\\/\\\" target=\\\"_blank\\\">\\\"Static \\/ Global Layers\\\"<\\/a><br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\"],\"plugin_require\":null,\"date\":\"2016-02-24 13:21:33\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"41\":{\"id\":\"42\",\"title\":\"Concept\",\"alias\":\"concept\",\"zip\":\"concept.zip\",\"uid\":\"47cb06083e87503762f6746725117a3c\",\"img\":\"concept\\/slide1.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/fullscreen-wordpress-plugin\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=fullscreen-wordpress-plugin\",\"version\":\"1.0.0\",\"required\":\"5.0.5\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">A full-screen slider that uses <a href=\\\"https:\\/\\/www.themepunch.com\\/revslider-doc\\/layer-settings\\/#layeractions\\\" target=\\\"_blank\\\">\\\"Layer Actions\\\"<\\/a> to their potential.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">This is a \\\"Default\\\" content slider. Edit the slides to change images and texts.<br\\/>It might be helpful to use the \\\"hide\\/show layer\\\" feature to efficiently edit all content.<br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\"],\"plugin_require\":null,\"date\":\"2016-02-24 13:21:33\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"42\":{\"id\":\"43\",\"title\":\"True Fullscreen\",\"alias\":\"fullscreen-button\",\"zip\":\"fullscreen-button.zip\",\"uid\":\"618a43bdf89333b555531f6d6ecde359\",\"img\":\"fullscreen-button\\/slide1.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/wordpress-sidebar-slideshow\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-sidebar-slideshow\",\"version\":\"1.0.0\",\"required\":\"5.1\",\"width\":\"1240\",\"height\":\"800\",\"description\":\"<span class=\\\"ttm_content\\\">A slider with a full-screen button that uses <a href=\\\"https:\\/\\/www.themepunch.com\\/revslider-doc\\/layer-settings\\/#layeractions\\\" target=\\\"_blank\\\">\\\"Layer Actions\\\"<\\/a> to their potential.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">This is a \\\"Default\\\" content slider. Just edit the slides to change the background images and texts.<br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\"],\"plugin_require\":null,\"date\":\"2016-02-24 13:21:33\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"43\":{\"id\":\"44\",\"title\":\"Creative Freedom\",\"alias\":\"creativefreedom\",\"zip\":\"creativefreedom.zip\",\"uid\":\"8902bf6c93126c2c6323626b9e872621\",\"img\":\"creativefreedom\\/slide1.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/wordpress-touch-slider\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-touch-slider\",\"version\":\"1.0.0\",\"required\":\"5.1\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">A full-screen slider with a unique vertical navigation and 3D-parallax effects.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">This is a \\\"Default\\\" content slider. Just edit the slides to change images, videos and texts.<br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\"],\"plugin_require\":null,\"date\":\"2016-02-24 13:21:33\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"44\":{\"id\":\"45\",\"title\":\"3D Parallax Scene\",\"alias\":\"parallaxscene\",\"zip\":\"parallaxscene.zip\",\"uid\":\"51566f1ce649708e97a0f5dfaf05ea19\",\"img\":\"parallaxscene\\/slide1.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/wordpress-3d-parallax\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-3d-parallax\",\"version\":\"1.0.2\",\"required\":\"5.1\",\"width\":\"1240\",\"height\":\"700\",\"description\":\"<span class=\\\"ttm_content\\\">A 3D-parallax hero scene with mouse-controlled effects. Smart image arrangement creates a convincing 3D effect. Tooltips are shown using <a href=\\\"https:\\/\\/www.themepunch.com\\/revslider-doc\\/layer-settings\\/#layeractions\\\" target=\\\"_blank\\\">\\\"Layer Actions\\\"<\\/a>.<\\/span>\\r\\n<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">This is a \\\"Default\\\" content hero slider. Just edit the slide to change the background image and texts.<br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\"],\"plugin_require\":null,\"date\":\"2016-02-24 13:21:33\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"45\":{\"id\":\"46\",\"title\":\"Wow Factor\",\"alias\":\"slidingoverlays\",\"zip\":\"slidingoverlays.zip\",\"uid\":\"18002d17e8bc7ca61b0951f5305a759e\",\"img\":\"slidingoverlays\\/slide1.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/responsive-wordpress-slider\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=responsive-wordpress-slider\",\"version\":\"1.0.0\",\"required\":\"5.1\",\"width\":\"1240\",\"height\":\"768\",\"description\":\"<span class=\\\"ttm_content\\\">A 3D-parallax effect full-screen slider.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">This is a \\\"Default\\\" content slider. Just edit the slides to change images and texts.<br\\/><br\\/><\\/span>\\r\\nScreencast for <a href=\\\"https:\\/\\/www.youtube.com\\/playlist?list=PLSCdqDWVMJPPXEuOEqYEQMAsp0vAYw52_\\\" target=\\\"_blank\\\">mobile video<\\/a> considerations.<\\/a>\\r\\n<br\\/><br\\/>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\"],\"plugin_require\":null,\"date\":\"2016-02-24 13:21:33\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"46\":{\"id\":\"47\",\"title\":\"3D Web Product\",\"alias\":\"web-product-light-hero-3d\",\"zip\":\"web-product-light-hero-3d.zip\",\"uid\":\"efd345c5da805414093e46066cefd751\",\"img\":\"web-product-light-hero-3d\\/slide1.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/wordpress-3d-scene\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-3d-scene\",\"version\":\"1.0.0\",\"required\":\"5.1\",\"width\":\"1400\",\"height\":\"668\",\"description\":\"<span class=\\\"ttm_content\\\">A 3D-parallax hero scene slider with a convincing depth-effect and animated clouds.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">This is a \\\"Default\\\" content slider. Just edit the slides to change images and texts.<br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\"],\"plugin_require\":null,\"date\":\"2016-02-24 13:21:33\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"47\":{\"id\":\"48\",\"title\":\"WooCommerce Big\",\"alias\":\"woobig\",\"zip\":\"woobig.zip\",\"uid\":\"bfb09a39656c7c80e86b468fc5b3403c\",\"img\":\"woobig\\/slide1.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/woocommerce-slider\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=woocommerce-slider\",\"version\":\"1.0.0\",\"required\":\"5.0.5\",\"width\":\"1200\",\"height\":\"600\",\"description\":\"<span class=\\\"ttm_content\\\">This slider is automatically populated by WooCommerce posts. Just one slide is needed to show a whole feed!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">The content source is set to <a href=\\\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/module-content\\/#flickr\\\" target=\\\"_blank\\\">\\\"WooCommerce Slider\\\"<\\/a>. Make sure to select the products you want to show in the slider settings.<br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\",\"postbased\",\"woocommerce\"],\"plugin_require\":null,\"date\":\"2016-02-24 13:21:33\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"48\":{\"id\":\"49\",\"title\":\"WooCommerce Small\",\"alias\":\"woocommercesmall\",\"zip\":\"woocommercesmall.zip\",\"uid\":\"b17c2adcc5c4c4b68a7ac6fee32fa030\",\"img\":\"woocommercesmall\\/slide1.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/woocommerce-slider\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=woocommerce-slider\",\"version\":\"1.0.0\",\"required\":\"5.1\",\"width\":\"400\",\"height\":\"266\",\"description\":\" <span class=\\\"ttm_content\\\">This slider is automatically populated by WooCommerce posts. Just one slide is needed to show a whole feed!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">The content source is set to <a href=\\\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/module-content\\/#flickr\\\" target=\\\"_blank\\\">\\\"WooCommerce Slider\\\"<\\/a>. Make sure to select the products you want to show in the slider settings.<br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\",\"postbased\",\"woocommerce\"],\"plugin_require\":null,\"date\":\"2016-02-24 13:21:33\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"49\":{\"id\":\"50\",\"title\":\"Restaurant Header\",\"alias\":\"finedining\",\"zip\":\"finedining.zip\",\"uid\":\"03481a9e258501fbe3888b48830ea845\",\"img\":\"finedining\\/slide1.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/restaurant-hero-header\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=restaurant-hero-header\",\"version\":\"1.0.0\",\"required\":\"5.0.5\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">A full-screen hero block slider that shows different background layers on button hover using <a href=\\\"https:\\/\\/www.themepunch.com\\/revslider-doc\\/layer-settings\\/#layeractions\\\" target=\\\"_blank\\\">\\\"Layer Actions\\\"<\\/a>.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">This is a \\\"Default\\\" content hero slider. Just edit the slide to change the background image and texts.<br\\/><br\\/><\\/span>\\r\\nScreencast for <a href=\\\"https:\\/\\/www.youtube.com\\/playlist?list=PLSCdqDWVMJPPXEuOEqYEQMAsp0vAYw52_\\\" target=\\\"_blank\\\">mobile video<\\/a> considerations.<\\/a>\\r\\n<br\\/><br\\/>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\"],\"plugin_require\":null,\"date\":\"2016-02-24 13:21:33\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"50\":{\"id\":\"51\",\"title\":\"Agency Website Header\",\"alias\":\"agency-intro\",\"zip\":\"agency-intro.zip\",\"uid\":\"e9be2afdd55a0c8d0d8d0cc12ba4c82f\",\"img\":\"agency-intro\\/slide1.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/agency-website-hero-header\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=agency-website-hero-header\",\"version\":\"1.0.0\",\"required\":\"5.0.5\",\"width\":\"1240\",\"height\":\"868\",\"description\":\" <span class=\\\"ttm_content\\\">A full-screen hero block slider with ken burns effect and video modal on button click. <a href=\\\"https:\\/\\/www.themepunch.com\\/revslider-doc\\/layer-settings\\/#layeractions\\\" target=\\\"_blank\\\">\\\"Layer Actions\\\"<\\/a> are used to achieve this effect.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">This is a \\\"Default\\\" content slider. Edit the slides to change images and texts.<br\\/>It might be helpful to use the \\\"hide\\/show layer\\\" feature to efficiently edit all content.<br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\"],\"plugin_require\":null,\"date\":\"2016-02-24 13:21:33\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"51\":{\"id\":\"52\",\"title\":\"Team Slider\",\"alias\":\"ourteam\",\"zip\":\"ourteam.zip\",\"uid\":\"d8eb1fec07a79202d1118bb17f70c233\",\"img\":\"ourteam\\/slide1.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/thumbnail-hover-slider-revolution-plugin\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=thumbnail-hover-slider-revolution-plugin\",\"version\":\"1.0.0\",\"required\":\"5.1.4\",\"width\":\"1400\",\"height\":\"800\",\"description\":\"<span class=\\\"ttm_content\\\">A team slider that changes slides and displays additional information on thumbnail hover. It uses <a href=\\\"https:\\/\\/www.themepunch.com\\/revslider-doc\\/layer-settings\\/#layeractions\\\" target=\\\"_blank\\\">\\\"Layer Actions\\\"<\\/a> to achieve this effect.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">This is a \\\"Default\\\" content slider. Edit the slides to change images and texts.<br\\/>It might be helpful to use the \\\"hide\\/show layer\\\" feature to efficiently edit all content.<br\\/>Some content is in <a href=\\\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/global-layers\\/\\\" target=\\\"_blank\\\">\\\"Static \\/ Global Layers\\\"<\\/a><br\\/><br\\/><\\/span>\\r\\nLearn how to <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/modify-thumbnails-for-our-team-template\\/\\\" target=\\\"_blank\\\">modify the thumbnails<\\/a><br\\/><br\\/>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\"],\"plugin_require\":null,\"date\":\"2016-02-24 13:21:33\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"52\":{\"id\":\"53\",\"title\":\"Team Carousel\",\"alias\":\"our-team-carousel\",\"zip\":\"our-team-carousel.zip\",\"uid\":\"37656d5dcab1f265c025cb2a3d669809\",\"img\":\"ourteamcarousel\\/slide1.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/thumbnail-hover-carousel-slider-revolution-plugin\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=thumbnail-hover-carousel-slider-revolution-plugin\",\"version\":\"1.0.0\",\"required\":\"5.1.4\",\"width\":\"1000\",\"height\":\"800\",\"description\":\" <span class=\\\"ttm_content\\\">A team carousel that changes slides and displays additional information on thumbnail hover. It uses <a href=\\\"https:\\/\\/www.themepunch.com\\/revslider-doc\\/layer-settings\\/#layeractions\\\" target=\\\"_blank\\\">\\\"Layer Actions\\\"<\\/a> to achieve this effect.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">This is a \\\"Default\\\" content carousel. Edit the slides to change images and texts.<br\\/>It might be helpful to use the \\\"hide\\/show layer\\\" feature to efficiently edit all content.<br\\/>Some content is in <a href=\\\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/global-layers\\/\\\" target=\\\"_blank\\\">\\\"Static \\/ Global Layers\\\"<\\/a><br\\/><br\\/><\\/span>\\r\\nLearn how to <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/modify-thumbnails-for-our-team-template\\/\\\" target=\\\"_blank\\\">modify the thumbnails<\\/a><br\\/><br\\/>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"carousel\"],\"plugin_require\":null,\"date\":\"2016-02-24 13:21:33\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"53\":{\"id\":\"54\",\"title\":\"4K Youtube Slider\",\"alias\":\"betteryoutube\",\"zip\":\"betteryoutube.zip\",\"uid\":\"d7c5fef9f257037d7a148038aa2a1857\",\"img\":\"betteryoutube\\/slide1.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/fullscreen-4k-youtube-video-gallery-slider-revolution-plugin\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=fullscreen-4k-youtube-video-gallery-slider-revolution-plugin\",\"version\":\"1.0.2\",\"required\":\"5.1.4\",\"width\":\"1200\",\"height\":\"675\",\"description\":\" <span class=\\\"ttm_content\\\">A full-screen youtube gallery with 4K videos as an example. <a href=\\\"https:\\/\\/www.themepunch.com\\/revslider-doc\\/layer-settings\\/#layeractions\\\" target=\\\"_blank\\\">\\\"Layer Actions\\\"<\\/a> are used to breathe life into navigation elements.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">This is a \\\"Default\\\" content slider. Edit the slides to change videos and texts.<br\\/>It might be helpful to use the \\\"hide\\/show layer\\\" feature to efficiently edit all content.<br\\/><br\\/><\\/span>\\r\\nScreencast for <a href=\\\"https:\\/\\/www.youtube.com\\/playlist?list=PLSCdqDWVMJPPXEuOEqYEQMAsp0vAYw52_\\\" target=\\\"_blank\\\">mobile video<\\/a> considerations.<\\/a>\\r\\n<br\\/><br\\/>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\"],\"plugin_require\":null,\"date\":\"2016-02-24 13:21:33\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false,\"is_new\":true},\"54\":{\"id\":\"55\",\"title\":\"Agency Website Header\",\"alias\":\"agencywebsiteheader\",\"zip\":\"agencywebsiteheader.zip\",\"uid\":\"c11d272c87277a7a38d9e7fd13e27947\",\"img\":\"agencywebsiteheader\\/slide1.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/fullscreen-hero-slider\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=fullscreen-hero-slider\",\"version\":\"1.0.0\",\"required\":\"5.1.5\",\"width\":\"1240\",\"height\":\"868\",\"description\":\" <span class=\\\"ttm_content\\\">A very unique full-screen slider that uses <a href=\\\"https:\\/\\/www.themepunch.com\\/revslider-doc\\/layer-settings\\/#layeractions\\\" target=\\\"_blank\\\">\\\"Layer Actions\\\"<\\/a> to their potential.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">This is a \\\"Default\\\" content slider. Edit the slides to change images and texts.<br\\/>It might be helpful to use the \\\"hide\\/show layer\\\" feature to efficiently edit all content.<br\\/>Some content is in <a href=\\\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/global-layers\\/\\\" target=\\\"_blank\\\">\\\"Static \\/ Global Layers\\\"<\\/a><br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\"],\"plugin_require\":null,\"date\":\"2016-02-24 13:21:33\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"55\":{\"id\":\"56\",\"title\":\"Coming Soon\",\"alias\":\"comingsoon\",\"zip\":\"comingsoon.zip\",\"uid\":\"0f89edf995512e6d6e864a2ee7221829\",\"img\":\"comingsoon\\/slide1.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/coming-soon-wordpress-under-construction-site\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=coming-soon-wordpress-under-construction-site\",\"version\":\"1.0.0\",\"required\":\"5.1.5\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">A full-screen slider that can be used as a \\\"Coming Soon\\\" page. <a href=\\\"https:\\/\\/www.themepunch.com\\/revslider-doc\\/layer-settings\\/#layeractions\\\" target=\\\"_blank\\\">\\\"Layer Actions\\\"<\\/a> are used to achieve various interaction possibilities.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">This is a \\\"Default\\\" content slider. Edit the slides to change images and texts.<br\\/>For further configuration options please view the <a href=\\\"https:\\/\\/https:\\/\\/www.themepunch.com\\/slider-revolution\\/custom-css-javascript\\/\\\" target=\\\"_blank\\\">\\\"Custom CSS\\/JS\\\"<\\/a> section in the slider settings.<br\\/><br\\/><\\/span>\\r\\nInstructions for <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/change-date-for-coming-soon-template\\/\\\" target=\\\"_blank\\\">how to change the date.<\\/a><br \\/><br \\/>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\"],\"plugin_require\":null,\"date\":\"2016-02-24 13:21:33\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"56\":{\"id\":\"57\",\"title\":\"Christmas Snow Scene\",\"alias\":\"snowscene\",\"zip\":\"snowscene.zip\",\"uid\":\"a747bf0837caff86c62419a746690209\",\"img\":\"snowscene\\/slide1.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/christmas-snow-scene\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=christmas-snow-scene\",\"version\":\"1.0.5\",\"required\":\"5.0.5\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">A slider with multiple christmas themed slides and a neat snow fall effect.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">This is a \\\"Default\\\" content slider. Edit the slides to change images and texts.<br\\/>For further configuration options please view the <a href=\\\"https:\\/\\/https:\\/\\/www.themepunch.com\\/slider-revolution\\/custom-css-javascript\\/\\\" target=\\\"_blank\\\">\\\"Custom CSS\\/JS\\\"<\\/a> section in the slider settings.<br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\"],\"plugin_require\":\"[{\\\"path\\\":\\\"revslider-snow-addon\\\\\\/revslider-snow-addon.php\\\",\\\"name\\\":\\\"Snow AddOn\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/www.themepunch.com\\\\\\/slider-revolution\\\\\\/install-addons\\\\\\/\\\"}]\",\"date\":\"2016-02-24 13:21:33\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"57\":{\"id\":\"58\",\"title\":\"Rock Band Music\",\"alias\":\"rockband\",\"zip\":\"rockband.zip\",\"uid\":\"5f557a5fad2fd6ca982a6ae6e9619637\",\"img\":\"rockband\\/slide1.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/rock-band-music-theme-slider-revolution-plugin\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=rock-band-music-theme-slider-revolution-plugin\",\"version\":\"1.0.0\",\"required\":\"5.1.5\",\"width\":\"1240\",\"height\":\"868\",\"description\":\" <span class=\\\"ttm_content\\\">A rock band themed hero block slider with an embedded SoundCloud element.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">This is a \\\"Default\\\" content hero slider. Just edit the slide to change the background video and texts.<br\\/><br\\/><\\/span>\\r\\nScreencast for <a href=\\\"https:\\/\\/www.youtube.com\\/playlist?list=PLSCdqDWVMJPPXEuOEqYEQMAsp0vAYw52_\\\" target=\\\"_blank\\\">mobile video<\\/a> considerations.<\\/a>\\r\\n<br\\/><br\\/>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\"],\"plugin_require\":null,\"date\":\"2016-02-24 13:21:33\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"58\":{\"id\":\"59\",\"title\":\"Sleek Landing Page\",\"alias\":\"sleeklandingpage\",\"zip\":\"sleeklandingpage.zip\",\"uid\":\"07f7f2608936a8ae226213b7d99eee3f\",\"img\":\"sleeklandingpage\\/slide1.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/landing-page-free-wordpress-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=landing-page-free-wordpress-template\",\"version\":\"1.0.0\",\"required\":\"5.1.5\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">A full-screen slider that can be used as an App-Landing-Page. The object layers and custom animations create a unique effect.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">This is a \\\"Default\\\" content slider. Edit the slides to change images and texts.<br\\/>Some content is in <a href=\\\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/global-layers\\/\\\" target=\\\"_blank\\\">\\\"Static \\/ Global Layers\\\"<\\/a><br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\"],\"plugin_require\":null,\"date\":\"2016-02-22 13:21:33\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"59\":{\"id\":\"60\",\"title\":\"App Landing Page\",\"alias\":\"applandingpage\",\"zip\":\"applandingpage.zip\",\"uid\":\"38eb600893c1484ab8fd2a3dce3678d7\",\"img\":\"applandingpage\\/slide1.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/app-landing-page-free-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=app-landing-page-free-template\",\"version\":\"1.0.0\",\"required\":\"5.2.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">A full-screen hero block that can be used as an app landing page. The detail view is build using <a href=\\\"https:\\/\\/www.themepunch.com\\/revslider-doc\\/layer-settings\\/#layeractions\\\">\\\"Layer Actions\\\"<\\/a>.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">This is a \\\"Default\\\" content slider. Edit the slides to change images and texts.<br\\/>It might be helpful to use the \\\"hide\\/show layer\\\" feature to efficiently edit all content.<br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"60\":{\"id\":\"61\",\"title\":\"Desk Scene\",\"alias\":\"deskscene\",\"zip\":\"deskscene.zip\",\"uid\":\"172a1a89a3e3b333cb4dbeb238f534c5\",\"img\":\"deskscene\\/slide1.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/hero-desk-scene\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=hero-desk-scene\",\"version\":\"1.0.0\",\"required\":\"5.2.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">A beautiful desk scene with a cool reveal effect when scrolling down.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">This is a \\\"Default\\\" content hero slider. Just edit the slide to change the background image and texts.<br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"61\":{\"id\":\"62\",\"title\":\"Clean News Slider\",\"alias\":\"cleannewsslider\",\"zip\":\"cleannewsslider.zip\",\"uid\":\"82c3f521fe31b80984be0f19e1a9899e\",\"img\":\"cleannewsslider\\/slide1.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/wordpress-news-slider\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-news-slider\",\"version\":\"1.0.0\",\"required\":\"5.2.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">A slideshow example with clean content and thumbnail navigation.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\\r\\n\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">This is a \\\"Default\\\" content slider. Just edit the slides to change images and texts.<br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"62\":{\"id\":\"63\",\"title\":\"Image Gallery\",\"alias\":\"imagegallery\",\"zip\":\"imagegallery.zip\",\"uid\":\"cef1d75357df2cb53b990c74a214813e\",\"img\":\"imagegallery\\/slide1.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/wordpress-photo-gallery-plugin\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-photo-gallery-plugin\",\"version\":\"1.0.0\",\"required\":\"5.2.0\",\"width\":\"1000\",\"height\":\"667\",\"description\":\"<span class=\\\"ttm_content\\\">A photo gallery suitable to display your images using <a href=\\\"https:\\/\\/www.themepunch.com\\/revslider-doc\\/layer-settings\\/#layeractions\\\">\\\"Layer Actions\\\"<\\/a> to their potential.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">This is a \\\"Default\\\" content slider. Edit the slides to change images and texts.<br\\/>Some content is in <a href=\\\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/global-layers\\/\\\" target=\\\"_blank\\\">\\\"Static \\/ Global Layers\\\"<\\/a><br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"63\":{\"id\":\"64\",\"title\":\"Standard WP Gallery\",\"alias\":\"standard-wp-gallery\",\"zip\":\"standard-wp-gallery.zip\",\"uid\":\"632035b8a27652d8081dbdfa343dc93d\",\"img\":\"standard-wp-gallery\\/slide1.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/wordpress-photo-gallery-plugin\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-photo-gallery-plugin\",\"version\":\"1.0.0\",\"required\":\"5.2.0\",\"width\":\"1000\",\"height\":\"667\",\"description\":\"<span class=\\\"ttm_content\\\">A photo gallery that uses the \\\"Standard WP Gallery\\\" add-on to display images.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">Please follow the setup guide on the \\\"Standard WP Gallery\\\" add-on page.<br\\/>Some content is in <a href=\\\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/global-layers\\/\\\" target=\\\"_blank\\\">\\\"Static \\/ Global Layers\\\"<\\/a><br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\",\"postbased\"],\"plugin_require\":\"[{\\\"path\\\":\\\"revslider-gallery-addon\\\\\\/revslider-gallery-addon.php\\\",\\\"name\\\":\\\"WP Gallery AddOn\\\",\\\"url\\\":\\\"http:\\\\\\/\\\\\\/revolution.themepunch.com\\\\\\/wordpress-photo-gallery-plugin\\\"}]\",\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"64\":{\"id\":\"65\",\"title\":\"Clean News Post Based\",\"alias\":\"clean-news-post-based\",\"zip\":\"clean-news-post-based.zip\",\"uid\":\"f4cf5bbe51afa5a361754bb081cbabf2\",\"img\":\"clean-news-post-based\\/slide1.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/wordpress-news-slider\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-news-slider\",\"version\":\"1.0.0\",\"required\":\"5.2.0\",\"width\":\"1200\",\"height\":\"600\",\"description\":\"<span class=\\\"ttm_content\\\"> This slider is automatically populated by WordPress posts.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">The content source is set to <a href=\\\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/module-content\\/#flickr\\\" target=\\\"_blank\\\">\\\"Post-Based Slider\\\"<\\/a>. Make sure to select the post type you want to display in the slider settings.<br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\",\"postbased\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"65\":{\"id\":\"66\",\"title\":\"Interactive Whiteboard\",\"alias\":\"interactivewhiteboard\",\"zip\":\"interactivewhiteboard.zip\",\"uid\":\"058b4af535d6c6c7bcec5225845e3eb4\",\"img\":\"interactivewhiteboard\\/slide1.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/interactive-whiteboard-animation-free-addon\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=interactive-whiteboard-animation-free-addon\",\"version\":\"1.0.5\",\"required\":\"5.2.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">This is the example slider from the Whiteboard add-on preview.<br\\/><a href=\\\"https:\\/\\/www.themepunch.com\\/revslider-doc\\/layer-settings\\/#layeractions\\\">\\\"Layer Actions\\\"<\\/a> are used to achieve certain effects.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">This slider template requires the <a href=\\\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/whiteboard-addon\\/\\\" target=\\\"_blank\\\">Whiteboard add-on<\\/a> to be installed. Edit the slides to change images and texts.<br\\/>Some content is in <a href=\\\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/global-layers\\/\\\" target=\\\"_blank\\\">\\\"Static \\/ Global Layers\\\"<\\/a><br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\"],\"plugin_require\":\"[{\\\"path\\\":\\\"revslider-whiteboard-addon\\\\\\/revslider-whiteboard-addon.php\\\",\\\"name\\\":\\\"Whiteboard AddOn\\\",\\\"url\\\":\\\"http:\\\\\\/\\\\\\/revolution.themepunch.com\\\\\\/interactive-whiteboard-animation-free-addon\\\"}]\",\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"66\":{\"id\":\"68\",\"title\":\"Innovation Slider\",\"alias\":\"innovation\",\"zip\":\"innovation.zip\",\"uid\":\"d3440b69126d9c186fddc713b18b0002\",\"img\":\"innovation\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/best-wordpress-slider-plugin-2016\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=best-wordpress-slider-plugin-2016\",\"version\":\"1.0.5\",\"required\":\"5.2.3.5\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">A full-screen slider with an elegant fade-out parallax effect. <a href=\\\"https:\\/\\/www.themepunch.com\\/revslider-doc\\/layer-settings\\/#layeractions\\\">\\\"Layer Actions\\\"<\\/a> are used for links on layers.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">This is a \\\"Default\\\" content slider. Edit the slides to change images, videos and texts.<br\\/>For further configuration options please view the <a href=\\\"https:\\/\\/https:\\/\\/www.themepunch.com\\/slider-revolution\\/custom-css-javascript\\/\\\" target=\\\"_blank\\\">\\\"Custom CSS\\/JS\\\"<\\/a> section in the slider settings.<br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\"],\"plugin_require\":null,\"date\":\"2016-03-29 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"67\":{\"id\":\"69\",\"title\":\"Dark Content Block - Menu\",\"alias\":\"dark-fullsite-block-menu\",\"zip\":\"packs\\/dark-fullsite-block-menu.zip\",\"uid\":\"bf4bd226719d3c3d3146592976e31ca1\",\"img\":\"dark-fullsite-block-menu\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/dark-wordpress-parallax-theme\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=dark-wordpress-parallax-theme\",\"version\":\"1.0.0\",\"required\":\"5.2.5\",\"width\":\"1024\",\"height\":\"768\",\"description\":\"<span class=\\\"ttm_content\\\">You can use this slider as a module on your website or install it as part of a slider pack.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Fullsite Dark\",\"package_order\":\"0\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"2\",\"installed\":false},\"68\":{\"id\":\"70\",\"title\":\"Dark Content Block - Hero\",\"alias\":\"dark-fullsite-block-1\",\"zip\":\"packs\\/dark-fullsite-block-1.zip\",\"uid\":\"d8859245fe600288ca932dc29aca751f\",\"img\":\"dark-fullsite-block-1\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/dark-wordpress-parallax-theme\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=dark-wordpress-parallax-theme\",\"version\":\"1.0.0\",\"required\":\"5.2.5\",\"width\":\"1024\",\"height\":\"768\",\"description\":\"<span class=\\\"ttm_content\\\">You can use this slider as a module on your website or install it as part of a slider pack.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Fullsite Dark\",\"package_order\":\"1\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"2\",\"installed\":false},\"69\":{\"id\":\"71\",\"title\":\"Dark Content Block - About\",\"alias\":\"dark-fullsite-block-2-about\",\"zip\":\"packs\\/dark-fullsite-block-2-about.zip\",\"uid\":\"298401901521a197a8294c1b4f73df3e\",\"img\":\"dark-fullsite-block-2-about\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/dark-wordpress-parallax-theme\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=dark-wordpress-parallax-theme\",\"version\":\"1.0.0\",\"required\":\"5.2.5\",\"width\":\"1024\",\"height\":\"768\",\"description\":\"<span class=\\\"ttm_content\\\">You can use this slider as a module on your website or install it as part of a slider pack.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Fullsite Dark\",\"package_order\":\"2\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"2\",\"installed\":false},\"70\":{\"id\":\"72\",\"title\":\"Dark Content Block - Services\",\"alias\":\"dark-fullsite-block-3-services\",\"zip\":\"packs\\/dark-fullsite-block-3-services.zip\",\"uid\":\"8da3ed605472ed6a26c745fb52f85f82\",\"img\":\"dark-fullsite-block-3-services\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/dark-wordpress-parallax-theme\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=dark-wordpress-parallax-theme\",\"version\":\"1.0.0\",\"required\":\"5.2.5\",\"width\":\"1024\",\"height\":\"768\",\"description\":\"<span class=\\\"ttm_content\\\">You can use this slider as a module on your website or install it as part of a slider pack.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Fullsite Dark\",\"package_order\":\"3\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"2\",\"installed\":false},\"71\":{\"id\":\"73\",\"title\":\"Dark Content Block - Products\",\"alias\":\"dark-fullsite-block-4-products\",\"zip\":\"packs\\/dark-fullsite-block-4-products.zip\",\"uid\":\"99e4f40399d20261a6131043d0e50b0c\",\"img\":\"dark-fullsite-block-4-products\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/dark-wordpress-parallax-theme\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=dark-wordpress-parallax-theme\",\"version\":\"1.0.0\",\"required\":\"5.2.5\",\"width\":\"1024\",\"height\":\"768\",\"description\":\"<span class=\\\"ttm_content\\\">You can use this slider as a module on your website or install it as part of a slider pack.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\\r\\n\",\"cat\":\"Premium\",\"filter\":[\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Fullsite Dark\",\"package_order\":\"4\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"2\",\"installed\":false},\"72\":{\"id\":\"74\",\"title\":\"Dark Content Block - Testimonials\",\"alias\":\"dark-fullsite-block-5-testimonials\",\"zip\":\"packs\\/dark-fullsite-block-5-testimonials.zip\",\"uid\":\"2f9121e0eedd51afe85e233d0743acab\",\"img\":\"dark-fullsite-block-5-testimonials\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/dark-wordpress-parallax-theme\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=dark-wordpress-parallax-theme\",\"version\":\"1.0.0\",\"required\":\"5.2.5\",\"width\":\"1024\",\"height\":\"768\",\"description\":\"<span class=\\\"ttm_content\\\">You can use this slider as a module on your website or install it as part of a slider pack.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Fullsite Dark\",\"package_order\":\"5\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"2\",\"installed\":false},\"73\":{\"id\":\"75\",\"title\":\"Dark Content Block - Callout\",\"alias\":\"dark-fullsite-block-6-callout\",\"zip\":\"packs\\/dark-fullsite-block-6-callout.zip\",\"uid\":\"55fbecb113ff21f050be7adc08637329\",\"img\":\"dark-fullsite-block-6-callout\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/dark-wordpress-parallax-theme\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=dark-wordpress-parallax-theme\",\"version\":\"1.0.0\",\"required\":\"5.2.5\",\"width\":\"1024\",\"height\":\"768\",\"description\":\"<span class=\\\"ttm_content\\\">You can use this slider as a module on your website or install it as part of a slider pack.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Fullsite Dark\",\"package_order\":\"6\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"2\",\"installed\":false},\"74\":{\"id\":\"76\",\"title\":\"Dark Content Block - Footer\",\"alias\":\"dark-fullsite-block-7-footer\",\"zip\":\"packs\\/dark-fullsite-block-7-footer.zip\",\"uid\":\"2ff517f5c7c54e3e0c2dd733cfd3400e\",\"img\":\"dark-fullsite-block-7-footer\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/dark-wordpress-parallax-theme\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=dark-wordpress-parallax-theme\",\"version\":\"1.0.0\",\"required\":\"5.2.5\",\"width\":\"1024\",\"height\":\"768\",\"description\":\"<span class=\\\"ttm_content\\\">You can use this slider as a module on your website or install it as part of a slider pack.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Fullsite Dark\",\"package_order\":\"7\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"2\",\"installed\":false},\"75\":{\"id\":\"77\",\"title\":\"Light Content Block - Menu\",\"alias\":\"fullsite-block-menu\",\"zip\":\"packs\\/fullsite-block-menu.zip\",\"uid\":\"8010971f34387d5f94a1f4e577ef382a\",\"img\":\"fullsite-block-menu\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/wordpress-parallax-theme\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-parallax-theme\",\"version\":\"1.0.0\",\"required\":\"5.2.5\",\"width\":\"1024\",\"height\":\"768\",\"description\":\"<span class=\\\"ttm_content\\\">You can use this slider as a module on your website or install it as part of a slider pack.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Fullsite\",\"package_order\":\"0\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"1\",\"installed\":false},\"76\":{\"id\":\"78\",\"title\":\"Light Content Block - Hero\",\"alias\":\"fullsite-block1\",\"zip\":\"packs\\/fullsite-block1.zip\",\"uid\":\"45bf7179843e01ce112e8ec754b0455c\",\"img\":\"fullsite-block1\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/wordpress-parallax-theme\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-parallax-theme\",\"version\":\"1.0.0\",\"required\":\"5.2.5\",\"width\":\"1024\",\"height\":\"768\",\"description\":\"<span class=\\\"ttm_content\\\">You can use this slider as a module on your website or install it as part of a slider pack.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Fullsite\",\"package_order\":\"1\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"1\",\"installed\":false},\"77\":{\"id\":\"79\",\"title\":\"Light Content Block - About\",\"alias\":\"fullsite-block-2-about\",\"zip\":\"packs\\/fullsite-block-2-about.zip\",\"uid\":\"8402b460638a746d36433cb161440b7d\",\"img\":\"fullsite-block-2-about\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/wordpress-parallax-theme\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-parallax-theme\",\"version\":\"1.0.0\",\"required\":\"5.2.5\",\"width\":\"1024\",\"height\":\"768\",\"description\":\"<span class=\\\"ttm_content\\\">You can use this slider as a module on your website or install it as part of a slider pack.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Fullsite\",\"package_order\":\"2\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"1\",\"installed\":false},\"78\":{\"id\":\"80\",\"title\":\"Light Content Block - Services\",\"alias\":\"fullsite-block-3-services\",\"zip\":\"packs\\/fullsite-block-3-services.zip\",\"uid\":\"7b8cea27f4d6ae17c5e1eae12457bd06\",\"img\":\"fullsite-block-3-services\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/wordpress-parallax-theme\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-parallax-theme\",\"version\":\"1.0.0\",\"required\":\"5.2.5\",\"width\":\"1024\",\"height\":\"768\",\"description\":\"<span class=\\\"ttm_content\\\">You can use this slider as a module on your website or install it as part of a slider pack.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Fullsite\",\"package_order\":\"3\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"1\",\"installed\":false},\"79\":{\"id\":\"81\",\"title\":\"Light Content Block - Products\",\"alias\":\"fullsite-block-4-products\",\"zip\":\"packs\\/fullsite-block-4-products.zip\",\"uid\":\"d148935362d7122636cda0635eae4be7\",\"img\":\"fullsite-block-4-products\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/wordpress-parallax-theme\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-parallax-theme\",\"version\":\"1.0.0\",\"required\":\"5.2.5\",\"width\":\"1024\",\"height\":\"768\",\"description\":\"<span class=\\\"ttm_content\\\">You can use this slider as a module on your website or install it as part of a slider pack.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Fullsite\",\"package_order\":\"4\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"1\",\"installed\":false},\"80\":{\"id\":\"82\",\"title\":\"Light Content Block - Testimonials\",\"alias\":\"fullsite-block-5-testimonials\",\"zip\":\"packs\\/fullsite-block-5-testimonials.zip\",\"uid\":\"06255bfd421e40f71fa8197b839dbf03\",\"img\":\"fullsite-block-5-testimonials\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/wordpress-parallax-theme\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-parallax-theme\",\"version\":\"1.0.0\",\"required\":\"5.2.5\",\"width\":\"1024\",\"height\":\"768\",\"description\":\"<span class=\\\"ttm_content\\\">You can use this slider as a module on your website or install it as part of a slider pack.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Fullsite\",\"package_order\":\"5\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"1\",\"installed\":false},\"81\":{\"id\":\"83\",\"title\":\"Light Content Block - Callout\",\"alias\":\"fullsite-block-6-callout\",\"zip\":\"packs\\/fullsite-block-6-callout.zip\",\"uid\":\"8a88c3447676b613ec5db2fe5d63315c\",\"img\":\"fullsite-block-6-callout\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/wordpress-parallax-theme\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-parallax-theme\",\"version\":\"1.0.0\",\"required\":\"5.2.5\",\"width\":\"1024\",\"height\":\"768\",\"description\":\"<span class=\\\"ttm_content\\\">You can use this slider as a module on your website or install it as part of a slider pack.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Fullsite\",\"package_order\":\"6\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"1\",\"installed\":false},\"82\":{\"id\":\"84\",\"title\":\"Light Content Block - Footer\",\"alias\":\"fullsite-block-7-footer\",\"zip\":\"packs\\/fullsite-block-7-footer.zip\",\"uid\":\"34300b4407a2093eb2e1e08868fa8319\",\"img\":\"fullsite-block-7-footer\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/wordpress-parallax-theme\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-parallax-theme\",\"version\":\"1.0.0\",\"required\":\"5.2.5\",\"width\":\"1024\",\"height\":\"768\",\"description\":\"<span class=\\\"ttm_content\\\">You can use this slider as a module on your website or install it as part of a slider pack.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Fullsite\",\"package_order\":\"7\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"1\",\"installed\":false},\"83\":{\"id\":\"85\",\"title\":\"Tech Journal\",\"alias\":\"techjournal\",\"zip\":\"techjournal.zip\",\"uid\":\"7f92d70d1c108378f915b18c2ceb71d6\",\"img\":\"techjournal\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/wordpress-parallax-theme\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-parallax-theme\",\"version\":\"1.0.0\",\"required\":\"5.2.5.1\",\"width\":\"1024\",\"height\":\"768\",\"description\":\"<span class=\\\"ttm_content\\\">A full-width slider with navigation direction-based transitions.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">This is a \\\"Default\\\" content slider. Edit the slides to change images and texts.<br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"84\":{\"id\":\"86\",\"title\":\"Car Dealership\",\"alias\":\"cardealership\",\"zip\":\"cardealership.zip\",\"uid\":\"bb010838855a8ae4d1dd68e139bf169e\",\"img\":\"cardealership\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/car-dealership-slider\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=car-dealership-slider\",\"version\":\"1.0.0\",\"required\":\"5.2.5.1\",\"width\":\"1240\",\"height\":\"650\",\"description\":\"<span class=\\\"ttm_content\\\">A full-width slider with navigation direction-based transitions.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">This is a \\\"Default\\\" content slider. Edit the slides to change images and texts.<br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"85\":{\"id\":\"87\",\"title\":\"FullScreen Menu Slider\",\"alias\":\"fullscreenmenu\",\"zip\":\"fullscreenmenu.zip\",\"uid\":\"6de81d74c4bf193e2e274d43038adc85\",\"img\":\"fullscreenmenu\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/wordpress-fullscreen-menu\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-fullscreen-menu\",\"version\":\"1.0.1\",\"required\":\"5.2.5.3\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">A full-screen slider that contains a menu with slide blur effect.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">This is a \\\"Default\\\" content slider. Edit the slides to change images and texts.<br\\/>Some content is in <a href=\\\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/global-layers\\/\\\" target=\\\"_blank\\\">\\\"Static \\/ Global Layers\\\"<\\/a><br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"86\":{\"id\":\"88\",\"title\":\"Creative Frontpage\",\"alias\":\"creativefrontpage\",\"zip\":\"creativefrontpage.zip\",\"uid\":\"0636cb368af3bcaa2f68eb0ebefe6439\",\"img\":\"creativefrontpage\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/best-wordpress-slider\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=best-wordpress-slider\",\"version\":\"1.0.0\",\"required\":\"5.2.5.3\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">A full-screen slider with hidden slides that are triggered via  <a href=\\\"https:\\/\\/www.themepunch.com\\/revslider-doc\\/layer-settings\\/#layeractions\\\" target=\\\"_blank\\\">\\\"Layer Actions\\\"<\\/a>.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">This is a \\\"Default\\\" content slider. Edit the slides to change images and texts.<br\\/>Some content is in <a href=\\\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/global-layers\\/\\\" target=\\\"_blank\\\">\\\"Static \\/ Global Layers\\\"<\\/a><br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"95\":{\"id\":\"97\",\"title\":\"Focus Parallax Effect\",\"alias\":\"focusparallax\",\"zip\":\"focusparallax.zip\",\"uid\":\"13bd15fb3ddf8b9841cb55b89389cc73\",\"img\":\"focusparallax\\/slide1.jpg\",\"preview\":\" https:\\/\\/revolution.themepunch.com\\/parallax-effect-wordpress-plugin\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=parallax-effect-wordpress-plugin\",\"version\":\"1.0.0\",\"required\":\"5.2.5.3\",\"width\":\"1240\",\"height\":\"900\",\"description\":\"<span class=\\\"ttm_content\\\">A full-screen slider with mouse controlled parallax effects. <a href=\\\"https:\\/\\/www.themepunch.com\\/revslider-doc\\/layer-settings\\/#layeractions\\\">\\\"Layer Actions\\\"<\\/a> are used for links on layers.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">This is a \\\"Default\\\" content slider. Edit the slides to change images and texts.<br\\/>Some content is in <a href=\\\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/global-layers\\/\\\" target=\\\"_blank\\\">\\\"Static \\/ Global Layers\\\"<\\/a><br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"96\":{\"id\":\"98\",\"title\":\"Duotone Slider\",\"alias\":\"duotone\",\"zip\":\"duotone.zip\",\"uid\":\"494862ceb6cb7c6658ad7cd36848cccd\",\"img\":\"duotone\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/wordpress-header-image-slider\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-header-image-slider\",\"version\":\"1.0.0\",\"required\":\"5.2.5.4\",\"width\":\"1200\",\"height\":\"800\",\"description\":\"<span class=\\\"ttm_content\\\">A full-screen slider with unique parallax scroll effect. <a href=\\\"https:\\/\\/www.themepunch.com\\/revslider-doc\\/layer-settings\\/#layeractions\\\">\\\"Layer Actions\\\"<\\/a> are used for links on layers.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">This is a \\\"Default\\\" content slider. Edit the slides to change images and texts.<br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"97\":{\"id\":\"99\",\"title\":\"Minimal Menu\",\"alias\":\"r_menu\",\"zip\":\"packs\\/r_menu.zip\",\"uid\":\"30d6a6895db1a5f29b1679061551c9f0\",\"img\":\"r_menu\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/minimal-website-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=minimal-website-template\",\"version\":\"1.0.1\",\"required\":\"5.2.6\",\"width\":\"1240\",\"height\":\"110\",\"description\":\"<span class=\\\"ttm_content\\\">You can use this slider as a module on your website or install it as part of a slider pack.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">\\r\\nIn the <a href=\\\"https:\\/\\/https:\\/\\/www.themepunch.com\\/slider-revolution\\/custom-css-javascript\\/\\\" target=\\\"_blank\\\">Custom JavaScript<\\/a> section of the \\\"Minimal Menu\\\" Template you can scroll down to the color change section.<br\\/>\\r\\nFor any elements you want to background color change in addition to the sites body, add this class to the <a href=\\\"https:\\/\\/www.themepunch.com\\/revslider-doc\\/layer-attributes\\/\\\" target=\\\"_blank\\\">Layers Attributes<\\/a> \\\".tp-colorchange\\\".<br\\/><br\\/>\\r\\nIf you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Minimal Website Template\",\"package_order\":\"0\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"4\",\"installed\":false},\"98\":{\"id\":\"100\",\"title\":\"Minimal Hero\",\"alias\":\"rhero\",\"zip\":\"packs\\/r_hero.zip\",\"uid\":\"b8b46186956f6e66ad0c08e4532bbbde\",\"img\":\"r_hero\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/minimal-website-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=minimal-website-template\",\"version\":\"1.0.0\",\"required\":\"5.2.6\",\"width\":\"1240\",\"height\":\"700\",\"description\":\"<span class=\\\"ttm_content\\\">You can use this slider as a module on your website or install it as part of a slider pack.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">\\r\\nIn the <a href=\\\"https:\\/\\/https:\\/\\/www.themepunch.com\\/slider-revolution\\/custom-css-javascript\\/\\\" target=\\\"_blank\\\">Custom JavaScript<\\/a> section of the \\\"Minimal Menu\\\" Template you can scroll down to the color change section.<br\\/>\\r\\nFor any elements you want to background color change in addition to the sites body, add this class to the <a href=\\\"https:\\/\\/www.themepunch.com\\/revslider-doc\\/layer-attributes\\/\\\" target=\\\"_blank\\\">Layers Attributes<\\/a> \\\".tp-colorchange\\\".<br\\/><br\\/>\\r\\nIf you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Minimal Website Template\",\"package_order\":\"1\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"4\",\"installed\":false},\"99\":{\"id\":\"101\",\"title\":\"Minimal About\",\"alias\":\"r_about\",\"zip\":\"packs\\/r_about.zip\",\"uid\":\"343010c4b4c03f92888c3e9e95bc2bb1\",\"img\":\"r_about\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/minimal-website-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=minimal-website-template\",\"version\":\"1.0.0\",\"required\":\"5.2.6\",\"width\":\"1240\",\"height\":\"900\",\"description\":\"<span class=\\\"ttm_content\\\">You can use this slider as a module on your website or install it as part of a slider pack.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">\\r\\nIn the <a href=\\\"https:\\/\\/https:\\/\\/www.themepunch.com\\/slider-revolution\\/custom-css-javascript\\/\\\" target=\\\"_blank\\\">Custom JavaScript<\\/a> section of the \\\"Minimal Menu\\\" Template you can scroll down to the color change section.<br\\/>\\r\\nFor any elements you want to background color change in addition to the sites body, add this class to the <a href=\\\"https:\\/\\/www.themepunch.com\\/revslider-doc\\/layer-attributes\\/\\\" target=\\\"_blank\\\">Layers Attributes<\\/a> \\\".tp-colorchange\\\".<br\\/><br\\/>\\r\\nIf you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Minimal Website Template\",\"package_order\":\"2\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"4\",\"installed\":false},\"100\":{\"id\":\"102\",\"title\":\"Minimal Products\",\"alias\":\"r_products\",\"zip\":\"packs\\/r_products.zip\",\"uid\":\"dda93e85c6a4456d132040147f087f39\",\"img\":\"r_products\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/minimal-website-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=minimal-website-template\",\"version\":\"1.0.0\",\"required\":\"5.2.6\",\"width\":\"1240\",\"height\":\"1100\",\"description\":\"<span class=\\\"ttm_content\\\">You can use this slider as a module on your website or install it as part of a slider pack.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">\\r\\nIn the <a href=\\\"https:\\/\\/https:\\/\\/www.themepunch.com\\/slider-revolution\\/custom-css-javascript\\/\\\" target=\\\"_blank\\\">Custom JavaScript<\\/a> section of the \\\"Minimal Menu\\\" Template you can scroll down to the color change section.<br\\/>\\r\\nFor any elements you want to background color change in addition to the sites body, add this class to the <a href=\\\"https:\\/\\/www.themepunch.com\\/revslider-doc\\/layer-attributes\\/\\\" target=\\\"_blank\\\">Layers Attributes<\\/a> \\\".tp-colorchange\\\".<br\\/><br\\/>\\r\\nIf you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Minimal Website Template\",\"package_order\":\"3\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"4\",\"installed\":false},\"101\":{\"id\":\"103\",\"title\":\"Minimal Info\",\"alias\":\"r_info\",\"zip\":\"packs\\/r_info.zip\",\"uid\":\"d6e368e8fd4862174af6c980389ae530\",\"img\":\"r_info\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/minimal-website-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=minimal-website-template\",\"version\":\"1.0.0\",\"required\":\"5.2.6\",\"width\":\"1240\",\"height\":\"800\",\"description\":\"<span class=\\\"ttm_content\\\">You can use this slider as a module on your website or install it as part of a slider pack.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">\\r\\nIn the <a href=\\\"https:\\/\\/https:\\/\\/www.themepunch.com\\/slider-revolution\\/custom-css-javascript\\/\\\" target=\\\"_blank\\\">Custom JavaScript<\\/a> section of the \\\"Minimal Menu\\\" Template you can scroll down to the color change section.<br\\/>\\r\\nFor any elements you want to background color change in addition to the sites body, add this class to the <a href=\\\"https:\\/\\/www.themepunch.com\\/revslider-doc\\/layer-attributes\\/\\\" target=\\\"_blank\\\">Layers Attributes<\\/a> \\\".tp-colorchange\\\".<br\\/><br\\/>\\r\\nIf you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Minimal Website Template\",\"package_order\":\"4\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"4\",\"installed\":false},\"102\":{\"id\":\"104\",\"title\":\"Inspiration Header\",\"alias\":\"inspirationheader\",\"zip\":\"inspirationheader.zip\",\"uid\":\"69f04b2be0b618fa7e184af83b86b7e7\",\"img\":\"inspirationheader\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/wordpress-theme-header\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-theme-header\",\"version\":\"1.0.0\",\"required\":\"5.2.6\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">This full-screen hero slider features sequentially animated texts and cool parallax elements.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">This is a \\\"Default\\\" content hero slider. Just edit the slide to change the background image and texts.<br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"103\":{\"id\":\"105\",\"title\":\"Magazine Slider\",\"alias\":\"magazineposts\",\"zip\":\"magazineposts.zip\",\"uid\":\"c562f3457e4edbd030959f7c5e6e0f7c\",\"img\":\"magazineposts\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/wordpress-magazine-slider\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-magazine-slider\",\"version\":\"1.0.1\",\"required\":\"5.2.6\",\"width\":\"1400\",\"height\":\"1000\",\"description\":\"<span class=\\\"ttm_content\\\">A full-width slider with a mouse-controlled 3D-Parallax effect. Enjoy! <a href=\\\"https:\\/\\/www.themepunch.com\\/revslider-doc\\/layer-settings\\/#layeractions\\\">\\\"Layer Actions\\\"<\\/a> are used for links on layers.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">This is a \\\"Default\\\" content slider. Edit the slides to change images and texts.<br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"104\":{\"id\":\"106\",\"title\":\"News Header\",\"alias\":\"explorationheader\",\"zip\":\"explorationheader.zip\",\"uid\":\"8f20d5a868c90ded08b835fb9e8307d7\",\"img\":\"explorationheader\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/wordpress-news-header\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-news-header\",\"version\":\"1.0.1\",\"required\":\"5.2.6\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">A full-screen slider that is a perfect fit for displaying news on your websites header! Check out <a href=\\\"https:\\/\\/www.themepunch.com\\/revslider-doc\\/layer-settings\\/#layeractions\\\">\\\"Layer Actions\\\"<\\/a> to add links to buttons.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">This is a \\\"Default\\\" content slider. Edit the slides to change images and texts.<br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"105\":{\"id\":\"107\",\"title\":\"Minimal Website Package\",\"alias\":\"minimal-website-package\",\"zip\":\"\",\"uid\":\"minimal-website-package\",\"img\":\"packages\\/template_group_1_1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/minimal-website-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=minimal-website-template\",\"version\":\"1.0.0\",\"required\":\"5.2.6\",\"width\":\"1240\",\"height\":\"110\",\"description\":\"<span class=\\\"ttm_content\\\">The Minimal Website Template is a one-pager website with a unique background color change effect on scrolling down.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">\\r\\nIn the <a href=\\\"https:\\/\\/https:\\/\\/www.themepunch.com\\/slider-revolution\\/custom-css-javascript\\/\\\" target=\\\"_blank\\\">Custom JavaScript<\\/a> section of the \\\"Minimal Menu\\\" Template you can scroll down to the color change section.<br\\/>\\r\\nFor any elements you want to background color change in addition to the sites body, add this class to the <a href=\\\"https:\\/\\/www.themepunch.com\\/revslider-doc\\/layer-attributes\\/\\\" target=\\\"_blank\\\">Layers Attributes<\\/a> \\\".tp-colorchange\\\".<br\\/><br\\/>\\r\\nIf you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Minimal Website Template\",\"package_order\":\"0\",\"package_parent\":\"true\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"4\",\"installed\":false},\"107\":{\"id\":\"109\",\"title\":\"Dark Content Block Package\",\"alias\":\"dark-fullsite-block-package\",\"zip\":\"\",\"uid\":\"dark-fullsite-block-package\",\"img\":\"packages\\/template_group_4.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/dark-wordpress-parallax-theme\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=dark-wordpress-parallax-theme\",\"version\":\"1.0.0\",\"required\":\"5.2.5\",\"width\":\"1024\",\"height\":\"768\",\"description\":\"<span class=\\\"ttm_content\\\">This Minimal Website Template has some sleek parallax effects and on-demand loading modules.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Fullsite Dark\",\"package_order\":\"0\",\"package_parent\":\"true\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"2\",\"installed\":false},\"108\":{\"id\":\"110\",\"title\":\"Light Content Block Package\",\"alias\":\"fullsite-block-package\",\"zip\":\"\",\"uid\":\"fullsite-block-package\",\"img\":\"packages\\/template_group_3.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/wordpress-parallax-theme\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-parallax-theme\",\"version\":\"1.0.0\",\"required\":\"5.2.5\",\"width\":\"1024\",\"height\":\"768\",\"description\":\"<span class=\\\"ttm_content\\\">This Minimal Website Template has some sleek parallax effects and on-demand loading modules.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Fullsite\",\"package_order\":\"0\",\"package_parent\":\"true\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"1\",\"installed\":false},\"109\":{\"id\":\"111\",\"title\":\"Typewriter Effect\",\"alias\":\"typewritereffect\",\"zip\":\"typewritereffect.zip\",\"uid\":\"d6f8bae06cc4a7b158d680c01e59ddc2\",\"img\":\"typewritereffect\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/wordpress-typewriter-effect\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-typewriter-effect\",\"version\":\"1.0.0\",\"required\":\"5.3.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">This is the example slider from the Typewriter add-on preview.<br\\/><a href=\\\"https:\\/\\/www.themepunch.com\\/revslider-doc\\/layer-settings\\/#layeractions\\\">\\\"Layer Actions\\\"<\\/a> are used for links on buttons.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">This slider template requires the <a href=\\\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/typewriter-addon\\/\\\" target=\\\"_blank\\\">Typewriter add-on<\\/a> to be installed. Edit the slides to change images and texts.<br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\"],\"plugin_require\":\"[{\\\"path\\\":\\\"revslider-typewriter-addon\\\\\\/revslider-typewriter-addon.php\\\",\\\"name\\\":\\\"Typewriter AddOn\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/www.themepunch.com\\\\\\/slider-revolution\\\\\\/typewriter-addon\\\\\\/\\\"}]\",\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"110\":{\"id\":\"112\",\"title\":\"Blend Mode Header\",\"alias\":\"blendmodeheader\",\"zip\":\"blendmodeheader.zip\",\"uid\":\"2e44e976596d757aab40ffa28086dcf9\",\"img\":\"blendmodeheader\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/blend-mode-hero-header\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=blend-mode-hero-header\",\"version\":\"1.0.0\",\"required\":\"5.3.0\",\"width\":\"1240\",\"height\":\"1000\",\"description\":\"<span class=\\\"ttm_content\\\">This full-screen hero header with HMTL5 background video, utilizes the new 5.3 blend mode effect.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">This is a \\\"Default\\\" content hero slider. Just edit the slide to change the background image and texts.<br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"111\":{\"id\":\"113\",\"title\":\"Themeplicity Menu\",\"alias\":\"themeplicity_menu\",\"zip\":\"packs\\/themeplicity_menu.zip\",\"uid\":\"7d5c1e75eaafa63683895a32a62f4ce0\",\"img\":\"themeplicity_menu\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/wordpress-theme\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-theme\",\"version\":\"1.0.2\",\"required\":\"5.3.0\",\"width\":\"1240\",\"height\":\"90\",\"description\":\"<span class=\\\"ttm_content\\\">You can use this slider as a module on your website or install it as part of a slider pack. <\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Themeplicity Website Template\",\"package_order\":\"0\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"5\",\"installed\":false},\"112\":{\"id\":\"114\",\"title\":\"Themeplicity Header\",\"alias\":\"themeplicity_header\",\"zip\":\"packs\\/themeplicity_header.zip\",\"uid\":\"907091e4d58acc7d12f802de2f280b7d\",\"img\":\"themeplicity_header\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/wordpress-theme\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-theme\",\"version\":\"1.0.2\",\"required\":\"5.3.0\",\"width\":\"1240\",\"height\":\"1000\",\"description\":\"<span class=\\\"ttm_content\\\">You can use this slider as a module on your website or install it as part of a slider pack. <\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Themeplicity Website Template\",\"package_order\":\"1\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"5\",\"installed\":false},\"113\":{\"id\":\"115\",\"title\":\"Themeplicity Offer\",\"alias\":\"themeplicity_offer\",\"zip\":\"packs\\/themeplicity_offer.zip\",\"uid\":\"1bd8f9aa2f3e340449664c65ba17fb51\",\"img\":\"themeplicity_offer\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/wordpress-theme\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-theme\",\"version\":\"1.0.2\",\"required\":\"5.3.0\",\"width\":\"1240\",\"height\":\"330\",\"description\":\"<span class=\\\"ttm_content\\\">You can use this slider as a module on your website or install it as part of a slider pack. <\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Themeplicity Website Template\",\"package_order\":\"2\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"5\",\"installed\":false},\"114\":{\"id\":\"116\",\"title\":\"Themeplicity What We Do\",\"alias\":\"themeplicity_whatwedo\",\"zip\":\"packs\\/themeplicity_whatwedo.zip\",\"uid\":\"aa800a44b5a3eab30414dde1f32bfed7\",\"img\":\"themeplicity_whatwedo\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/wordpress-theme\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-theme\",\"version\":\"1.0.2\",\"required\":\"5.3.0\",\"width\":\"1240\",\"height\":\"813\",\"description\":\"<span class=\\\"ttm_content\\\">You can use this slider as a module on your website or install it as part of a slider pack. <\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Themeplicity Website Template\",\"package_order\":\"3\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"5\",\"installed\":false},\"115\":{\"id\":\"117\",\"title\":\"Themeplicity Projects\",\"alias\":\"themeplicity_projects\",\"zip\":\"packs\\/themeplicity_projects.zip\",\"uid\":\"5f61b3a13033ba6a51a18270163e0a50\",\"img\":\"themeplicity_projects\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/wordpress-theme\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-theme\",\"version\":\"1.0.2\",\"required\":\"5.3.0\",\"width\":\"1240\",\"height\":\"813\",\"description\":\"<span class=\\\"ttm_content\\\">You can use this slider as a module on your website or install it as part of a slider pack. <\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Themeplicity Website Template\",\"package_order\":\"4\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"5\",\"installed\":false},\"116\":{\"id\":\"118\",\"title\":\"Themeplicity Whats Great\",\"alias\":\"themeplicity_whatsgreat\",\"zip\":\"packs\\/themeplicity_whatsgreat.zip\",\"uid\":\"ce9faf8c55ed2e33e091b23667e7173b\",\"img\":\"themeplicity_whatsgreat\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/wordpress-theme\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-theme\",\"version\":\"1.0.2\",\"required\":\"5.3.0\",\"width\":\"1240\",\"height\":\"900\",\"description\":\"<span class=\\\"ttm_content\\\">You can use this slider as a module on your website or install it as part of a slider pack. <\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Themeplicity Website Template\",\"package_order\":\"5\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"5\",\"installed\":false},\"117\":{\"id\":\"119\",\"title\":\"Themeplicity Tables\",\"alias\":\"themeplicity_tables\",\"zip\":\"packs\\/themeplicity_tables.zip\",\"uid\":\"f28bb4cd20ec1f29a1de7da5ad09c293\",\"img\":\"themeplicity_tables\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/wordpress-theme\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-theme\",\"version\":\"1.0.2\",\"required\":\"5.3.0\",\"width\":\"1240\",\"height\":\"1059\",\"description\":\"<span class=\\\"ttm_content\\\">You can use this slider as a module on your website or install it as part of a slider pack. <\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Themeplicity Website Template\",\"package_order\":\"6\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"5\",\"installed\":false},\"118\":{\"id\":\"120\",\"title\":\"Themeplicity Contactform\",\"alias\":\"themeplicity_contactform\",\"zip\":\"packs\\/themeplicity_contactform.zip\",\"uid\":\"3e59da970f534490774fa8e053f5b5ed\",\"img\":\"themeplicity_contactform\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/wordpress-theme\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-theme\",\"version\":\"1.0.2\",\"required\":\"5.3.0\",\"width\":\"1240\",\"height\":\"1067\",\"description\":\"<span class=\\\"ttm_content\\\">You can use this slider as a module on your website or install it as part of a slider pack. <\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Themeplicity Website Template\",\"package_order\":\"7\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"5\",\"installed\":false},\"119\":{\"id\":\"121\",\"title\":\"Themeplicity Footer\",\"alias\":\"themeplicity_footer\",\"zip\":\"packs\\/themeplicity_footer.zip\",\"uid\":\"89eeb0b4b852c5f743e1bd76e3e8f2ef\",\"img\":\"themeplicity_footer\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/wordpress-theme\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-theme\",\"version\":\"1.0.2\",\"required\":\"5.3.0\",\"width\":\"1240\",\"height\":\"780\",\"description\":\"<span class=\\\"ttm_content\\\">You can use this slider as a module on your website or install it as part of a slider pack. <\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Themeplicity Website Template\",\"package_order\":\"8\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"5\",\"installed\":false},\"120\":{\"id\":\"122\",\"title\":\"Themeplicity Package\",\"alias\":\"themeplicity-package\",\"zip\":\"\",\"uid\":\"themeplicity-package\",\"img\":\"packages\\/templatepack_themeplicity.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/wordpress-theme\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-theme\",\"version\":\"1.0.2\",\"required\":\"5.3.0\",\"width\":\"1024\",\"height\":\"768\",\"description\":\"<span class=\\\"ttm_content\\\">The Themeplicity Website Template uses the new groups & rows feature introduced in 5.3 to its full potential.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Themeplicity Website Template\",\"package_order\":\"0\",\"package_parent\":\"true\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"5\",\"installed\":false},\"121\":{\"id\":\"123\",\"title\":\"Nice And Clean Menu\",\"alias\":\"NiceAndClean_Menu\",\"zip\":\"packs\\/NiceAndClean_Menu.zip\",\"uid\":\"3f8c01e26c7446428e045c4b1180776d\",\"img\":\"NiceAndClean_Menu\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/nice-clean-responsive-wordpress-theme\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=nice-clean-responsive-wordpress-theme\",\"version\":\"1.0.1\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"90\",\"description\":\"<span class=\\\"ttm_content\\\">You can use this slider as a module on your website or install it as part of a slider pack. <\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Nice & Clean Template\",\"package_order\":\"0\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"6\",\"installed\":false},\"122\":{\"id\":\"124\",\"title\":\"Nice And Clean Header\",\"alias\":\"NiceAndClean_Header\",\"zip\":\"packs\\/NiceAndClean_Header.zip\",\"uid\":\"76931033addb20a62557c2845a4d6a11\",\"img\":\"NiceAndClean_Header\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/nice-clean-responsive-wordpress-theme\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=nice-clean-responsive-wordpress-theme\",\"version\":\"1.0.1\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">You can use this slider as a module on your website or install it as part of a slider pack. <\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Nice & Clean Template\",\"package_order\":\"1\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"6\",\"installed\":false},\"123\":{\"id\":\"125\",\"title\":\"Nice And Clean Services\",\"alias\":\"NiceAndClean_Services\",\"zip\":\"packs\\/NiceAndClean_Services.zip\",\"uid\":\"02f72ec606800c8215bcadea09624e87\",\"img\":\"NiceAndClean_Services\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/nice-clean-responsive-wordpress-theme\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=nice-clean-responsive-wordpress-theme\",\"version\":\"1.0.1\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"360\",\"description\":\"<span class=\\\"ttm_content\\\">You can use this slider as a module on your website or install it as part of a slider pack. <\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Nice & Clean Template\",\"package_order\":\"2\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"6\",\"installed\":false},\"124\":{\"id\":\"126\",\"title\":\"Nice And Clean About\",\"alias\":\"NiceAndClean_About\",\"zip\":\"packs\\/NiceAndClean_About.zip\",\"uid\":\"9510f6fdbb8e9473e8c22f692a6bc89f\",\"img\":\"NiceAndClean_About\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/nice-clean-responsive-wordpress-theme\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=nice-clean-responsive-wordpress-theme\",\"version\":\"1.0.1\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"800\",\"description\":\"<span class=\\\"ttm_content\\\">You can use this slider as a module on your website or install it as part of a slider pack. <\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Nice & Clean Template\",\"package_order\":\"3\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"6\",\"installed\":false},\"125\":{\"id\":\"127\",\"title\":\"Nice And Clean Video\",\"alias\":\"niceandclean_video\",\"zip\":\"packs\\/niceandclean_video.zip\",\"uid\":\"2bb9e1ad329435cc500542d0c7025e15\",\"img\":\"niceandclean_video\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/nice-clean-responsive-wordpress-theme\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=nice-clean-responsive-wordpress-theme\",\"version\":\"1.0.1\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"800\",\"description\":\"<span class=\\\"ttm_content\\\">You can use this slider as a module on your website or install it as part of a slider pack. <\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Nice & Clean Template\",\"package_order\":\"4\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"6\",\"installed\":false},\"126\":{\"id\":\"128\",\"title\":\"Nice And Clean Highlights\",\"alias\":\"niceandclean_highlights\",\"zip\":\"packs\\/niceandclean_highlights.zip\",\"uid\":\"ff396af163a79d2d5b35db17c1ea7aa6\",\"img\":\"niceandclean_highlights\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/nice-clean-responsive-wordpress-theme\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=nice-clean-responsive-wordpress-theme\",\"version\":\"1.0.1\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"800\",\"description\":\"<span class=\\\"ttm_content\\\">You can use this slider as a module on your website or install it as part of a slider pack. <\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Nice & Clean Template\",\"package_order\":\"5\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"6\",\"installed\":false},\"127\":{\"id\":\"129\",\"title\":\"Nice And Clean Projects\",\"alias\":\"NiceAndClean_Projects\",\"zip\":\"packs\\/NiceAndClean_Projects.zip\",\"uid\":\"1e6695959ef83f8975b52289c08a4d44\",\"img\":\"NiceAndClean_Projects\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/nice-clean-responsive-wordpress-theme\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=nice-clean-responsive-wordpress-theme\",\"version\":\"1.0.1\",\"required\":\"6.0.0\",\"width\":\"600\",\"height\":\"600\",\"description\":\"<span class=\\\"ttm_content\\\">You can use this slider as a module on your website or install it as part of a slider pack. <\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Nice & Clean Template\",\"package_order\":\"6\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"6\",\"installed\":false},\"128\":{\"id\":\"130\",\"title\":\"Nice And Clean TextBlocks\",\"alias\":\"niceandclean_textblocks\",\"zip\":\"packs\\/niceandclean_textblocks.zip\",\"uid\":\"1f33eb839c96ea3225faff1c8d382b05\",\"img\":\"niceandclean_textblocks\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/nice-clean-responsive-wordpress-theme\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=nice-clean-responsive-wordpress-theme\",\"version\":\"1.0.1\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"800\",\"description\":\"<span class=\\\"ttm_content\\\">You can use this slider as a module on your website or install it as part of a slider pack. <\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Nice & Clean Template\",\"package_order\":\"7\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"6\",\"installed\":false},\"129\":{\"id\":\"131\",\"title\":\"Nice And Clean CallOut\",\"alias\":\"niceandclean_callout\",\"zip\":\"packs\\/niceandclean_callout.zip\",\"uid\":\"54d4d9bcf79d357de0e614700e909863\",\"img\":\"niceandclean_callout\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/nice-clean-responsive-wordpress-theme\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=nice-clean-responsive-wordpress-theme\",\"version\":\"1.0.1\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"500\",\"description\":\"<span class=\\\"ttm_content\\\">You can use this slider as a module on your website or install it as part of a slider pack. <\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Nice & Clean Template\",\"package_order\":\"8\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"6\",\"installed\":false},\"130\":{\"id\":\"132\",\"title\":\"Nice And Clean Footer\",\"alias\":\"niceandclean_footer\",\"zip\":\"packs\\/niceandclean_footer.zip\",\"uid\":\"5492d7f72b3771a4e754f91bda063b15\",\"img\":\"niceandclean_footer\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/nice-clean-responsive-wordpress-theme\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=nice-clean-responsive-wordpress-theme\",\"version\":\"1.0.1\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"400\",\"description\":\"<span class=\\\"ttm_content\\\">You can use this slider as a module on your website or install it as part of a slider pack.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">For using the social sharing buttons, please install the social sharing add-on.<br><br><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Nice & Clean Template\",\"package_order\":\"9\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"6\",\"installed\":false},\"131\":{\"id\":\"134\",\"title\":\"80s Style Intro\",\"alias\":\"80s\",\"zip\":\"80s.zip\",\"uid\":\"98881ab51f71b2fbdb220752d321b15a\",\"img\":\"80s\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/80s-style-intro\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=80s-style-intro\",\"version\":\"1.0.0\",\"required\":\"5.3.1\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">This intro hero block takes you back to the 80\'s with some funky effects.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">This is a \\\"Default\\\" content hero slider. Just edit the slide to change the background image and text.<br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"132\":{\"id\":\"135\",\"title\":\"Blur Effect Slider\",\"alias\":\"blurslider\",\"zip\":\"blurslider.zip\",\"uid\":\"83bd6e1ccef83f03c944fa05b0a2d879\",\"img\":\"blurslider\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/blur-effect-slider\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=blur-effect-slider\",\"version\":\"1.0.0\",\"required\":\"5.3.1\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">This slider makes use of the brand new blur effects available with version 5.3.1.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">This is a \\\"Default\\\" content slider. Just edit the slides to change the background images and texts.<br\\/><br\\/><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"133\":{\"id\":\"136\",\"title\":\"Coming Soon Add-On\",\"alias\":\"ComingSoonAddon\",\"zip\":\"ComingSoonAddon.zip\",\"uid\":\"51258492055b940099eb96ba52901fa9\",\"img\":\"ComingSoonAddon\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/coming-soon-add-on\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=coming-soon-add-on\",\"version\":\"1.0.0\",\"required\":\"5.3.1\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">This slider template makes use of the brand new Coming Soon Add-On.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\"],\"plugin_require\":\"[{\\\"path\\\":\\\"revslider-maintenance-addon\\\\\\/revslider-maintenance-addon.php\\\",\\\"name\\\":\\\"Coming Soon & Maintenance AddOn\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/www.themepunch.com\\\\\\/revslider-doc\\\\\\/add-coming-soon-maintenance\\\\\\/\\\"}]\",\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"134\":{\"id\":\"137\",\"title\":\"Nice And Clean Package\",\"alias\":\"nice-and-clean-package\",\"zip\":\"\",\"uid\":\"nice-and-clean-package\",\"img\":\"packages\\/templatepack_niceandclean.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/nice-clean-responsive-wordpress-theme\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=nice-clean-responsive-wordpress-theme\",\"version\":\"1.0.1\",\"required\":\"6.0.0\",\"width\":\"1024\",\"height\":\"800\",\"description\":\"<span class=\\\"ttm_content\\\">The Nice & Clean Website Template uses groups & rows for a fully responsive website experience. Elegant blur effects available since version 5.3.1 make this template stand out!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Nice & Clean Template\",\"package_order\":\"0\",\"package_parent\":\"true\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"6\",\"installed\":false},\"135\":{\"id\":\"138\",\"title\":\"Snow Effect Add-On\",\"alias\":\"snowaddon\",\"zip\":\"snowaddon.zip\",\"uid\":\"7408d8567b8af5716eaabd390422e51b\",\"img\":\"snowaddon\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/snow-effect-add-on\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=snow-effect-add-on\",\"version\":\"1.0.0\",\"required\":\"5.3.1\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">Add a pleasant Snow Effect to your website with this slider template. Make sure to install the \\\"Holiday Snow\\\" Add-On.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\"],\"plugin_require\":\"[{\\\"path\\\":\\\"revslider-snow-addon\\\\\\/revslider-snow-addon.php\\\",\\\"name\\\":\\\"Snow AddOn\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/www.themepunch.com\\\\\\/slider-revolution\\\\\\/install-addons\\\\\\/\\\"}]\",\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"136\":{\"id\":\"139\",\"title\":\"Particle Effect One\",\"alias\":\"particle-effect-one\",\"zip\":\"particle-effect-one.zip\",\"uid\":\"a4611c906e35ca60f617da86217b5299\",\"img\":\"particle-effect-one\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/particle-effect-for-wordpress\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=particle-effect-for-wordpress\",\"version\":\"1.0.0\",\"required\":\"5.3.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">A unique particle effect that can serve as a stunning intro for your website.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">The blend mode effect is achieved through a layer image with CSS blend mode. If you want to customize this effect, select the \\\"BLEND MODE IMAGE\\\" layer and go to \\\"advanced style -> filters -> blend mode\\\".<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\"],\"plugin_require\":\"[{\\\"path\\\":\\\"revslider-particles-addon\\\\\\/revslider-particles-addon.php\\\",\\\"name\\\":\\\"Particles Effect AddOn\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/www.themepunch.com\\\\\\/slider-revolution\\\\\\/install-addons\\\\\\/\\\"}]\",\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"How to Increase Engagement with Particle Effects and Blend Mode [Tutorial]\",\"guide_url\":\"https:\\/\\/www.sliderrevolution.com\\/tutorials\\/how-to-increase-engagement-with-particle-effects-and-blend-mode\\/\",\"guide_img\":\"tutorial\\/particle-effect-one.png\",\"active\":\"1\",\"installed\":false},\"137\":{\"id\":\"140\",\"title\":\"Particle Effect Two\",\"alias\":\"particle-effect-two\",\"zip\":\"particle-effect-two.zip\",\"uid\":\"b8ecbf43374a69e4ab329ea834862ef8\",\"img\":\"particle-effect-two\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/particle-effect-intro\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=particle-effect-intro\",\"version\":\"1.0.0\",\"required\":\"5.3.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">A unique particle effect that can serve as a stunning intro for your website.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\"],\"plugin_require\":\"[{\\\"path\\\":\\\"revslider-particles-addon\\\\\\/revslider-particles-addon.php\\\",\\\"name\\\":\\\"Particles Effect AddOn\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/www.themepunch.com\\\\\\/slider-revolution\\\\\\/install-addons\\\\\\/\\\"}]\",\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"138\":{\"id\":\"141\",\"title\":\"Particle Effect Three\",\"alias\":\"particle-effect-three\",\"zip\":\"particle-effect-three.zip\",\"uid\":\"b33bc2c5655d8d51cd17c3740f72e748\",\"img\":\"particle-effect-three\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/particle-background-effect\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=particle-background-effect\",\"version\":\"1.0.0\",\"required\":\"5.3.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">A unique particle effect that can serve as a stunning intro for your website.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">The blend mode effect is achieved through a layer image with CSS blend mode. If you want to customize this effect, select the \\\"BLEND IMAGE\\\" layer and go to \\\"advanced style -> filters -> blend mode\\\".<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\"],\"plugin_require\":\"[{\\\"path\\\":\\\"revslider-particles-addon\\\\\\/revslider-particles-addon.php\\\",\\\"name\\\":\\\"Particles Effect AddOn\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/www.themepunch.com\\\\\\/slider-revolution\\\\\\/install-addons\\\\\\/\\\"}]\",\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"139\":{\"id\":\"142\",\"title\":\"Portfolio Viewer\",\"alias\":\"portfolioviewer\",\"zip\":\"portfolioviewer.zip\",\"uid\":\"9ac7230ff5b880fb6c8f28fbbc123b3b\",\"img\":\"portfolioviewer\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/wordpress-portfolio-plugin\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-portfolio-plugin\",\"version\":\"1.0.2\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">This slider template can be used to display your portfolio highlights in a stunning way, utilising out free particles add-on and blend modes.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">The navigation for the slides is found in the <a href=\\\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/global-layers\\/\\\" target=\\\"_blank\\\">Static Layers<\\/a>.<\\/span><span class=\\\"ttm_space\\\"><\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\"],\"plugin_require\":\"[{\\\"path\\\":\\\"revslider-particles-addon\\\\\\/revslider-particles-addon.php\\\",\\\"name\\\":\\\"Particles Effect AddOn\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/www.themepunch.com\\\\\\/slider-revolution\\\\\\/install-addons\\\\\\/\\\"}]\",\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"140\":{\"id\":\"143\",\"title\":\"App Showcase\",\"alias\":\"appshowcase\",\"zip\":\"appshowcase.zip\",\"uid\":\"082aef931b0369080bc30c3a2a0c331f\",\"img\":\"appshowcase\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/app-showcase-wordpress-plugin\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=app-showcase-wordpress-plugin\",\"version\":\"1.0.0\",\"required\":\"5.3.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">This template shows off our new \\\"Polyfold Effects\\\" Add-On in form of an App product showcase module. Get started now and illustrate your Apps key features in a striking way!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\"],\"plugin_require\":\"[{\\\"path\\\":\\\"revslider-polyfold-addon\\\\\\/revslider-polyfold-addon.php\\\",\\\"name\\\":\\\"Polyfold Scroll Effect AddOn\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/www.themepunch.com\\\\\\/slider-revolution\\\\\\/install-addons\\\\\\/\\\"}]\",\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"141\":{\"id\":\"144\",\"title\":\"Gravity Design Hero\",\"alias\":\"gravitydesign\",\"zip\":\"gravitydesign.zip\",\"uid\":\"7bdbe73a6e5bf290cb4412708ac4134d\",\"img\":\"gravitydesign\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/best-wordpress-slider-plugin-2017\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=best-wordpress-slider-plugin-2017\",\"version\":\"1.0.1\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">This hero template shows a striking mouse-parallax scene and cool particle effects. Requires our \\\"Particle Effects\\\" Add-on to be installed.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\"],\"plugin_require\":\"[{\\\"path\\\":\\\"revslider-particles-addon\\\\\\/revslider-particles-addon.php\\\",\\\"name\\\":\\\"Particles Effect AddOn\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/www.themepunch.com\\\\\\/slider-revolution\\\\\\/install-addons\\\\\\/\\\"}]\",\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"How to Create an Exciting Action Shot for Your Hero Image [Tutorial]\",\"guide_url\":\"https:\\/\\/www.sliderrevolution.com\\/tutorials\\/how-to-create-an-exciting-action-shot-for-your-hero-image\\/\",\"guide_img\":\"tutorial\\/gravitydesign.png\",\"active\":\"1\",\"installed\":false},\"142\":{\"id\":\"145\",\"title\":\"404 Error Page\",\"alias\":\"404errorpage\",\"zip\":\"404errorpage.zip\",\"uid\":\"2dc62d802b42b73088651cac17d0c486\",\"img\":\"404errorpage\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/404-error-page-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=404-error-page-template\",\"version\":\"1.0.1\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">This template can be used as a custom error page on your website with our new 404 page Add-On. Of course you can also use this template as a regular hero header.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\"],\"plugin_require\":\"{\\\"1\\\":{\\\"path\\\":\\\"revslider-particles-addon\\\\\\/revslider-particles-addon.php\\\",\\\"name\\\":\\\"Particles Effect AddOn\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/www.themepunch.com\\\\\\/slider-revolution\\\\\\/install-addons\\\\\\/\\\"}}\",\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"143\":{\"id\":\"146\",\"title\":\"Carousel Gallery\",\"alias\":\"carouselgallery\",\"zip\":\"carouselgallery.zip\",\"uid\":\"041838fd32923c40e15c998f0ea19526\",\"img\":\"carouselgallery\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/wordpress-carousel-gallery\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-carousel-gallery\",\"version\":\"1.0.0\",\"required\":\"5.4\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">This carousel gallery features a subtle parallax effect, html5 video and a fullscreen button.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"cat\":\"Premium\",\"filter\":[\"carousel\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"144\":{\"id\":\"147\",\"title\":\"Filmstrip Effect\",\"alias\":\"filmstrip\",\"zip\":\"filmstrip.zip\",\"uid\":\"7bd142f272cc15d86998a79520e9e581\",\"img\":\"filmstrip\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/filmstrip-add-on-slider\\/ ?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content= \",\"version\":\"1.0.2\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">This template uses our Filmstrip Add-On to display a continuous scrolling set of images per slide.\\r\\n There is lots of customization options like animation speed and direction.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\"],\"plugin_require\":\"[{\\\"path\\\":\\\"revslider-filmstrip-addon\\\\\\/revslider-filmstrip-addon.php\\\",\\\"name\\\":\\\"Background FilmStrip AddOn\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/www.themepunch.com\\\\\\/slider-revolution\\\\\\/install-addons\\\\\\/\\\"}]\",\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"145\":{\"id\":\"148\",\"title\":\"Space Opera\",\"alias\":\"spaceopera\",\"zip\":\"spaceopera.zip\",\"uid\":\"a2c8bffcb138a86c0f373adebb6de046\",\"img\":\"spaceopera\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/space-opera-presentation\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=space-opera-presentation\",\"version\":\"1.0.0\",\"required\":\"5.4\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Space Opera template can be enjoyed as a slow paced, full-screen slider experience and is great to show your most prominent photos.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\"],\"plugin_require\":\"[{\\\"path\\\":\\\"revslider-particles-addon\\\\\\/revslider-particles-addon.php\\\",\\\"name\\\":\\\"Particles Effect AddOn\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/www.themepunch.com\\\\\\/slider-revolution\\\\\\/install-addons\\\\\\/\\\"}]\",\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"146\":{\"id\":\"149\",\"title\":\"Website Intro\",\"alias\":\"websiteintro\",\"zip\":\"websiteintro.zip\",\"uid\":\"348df76d999456aa19be58c9df56ae20\",\"img\":\"websiteintro\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/website-intro-wordpress-slider\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=website-intro-wordpress-slider\",\"version\":\"1.0.0\",\"required\":\"5.4\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">Making use of our new Slicey Add-On, this slider show a really cool effect you just have to experience yourself! Just change the slides background images and the existing slices will automatically be applied.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\"],\"plugin_require\":\"[{\\\"path\\\":\\\"revslider-slicey-addon\\\\\\/revslider-slicey-addon.php\\\",\\\"name\\\":\\\"Background Slicey AddOn\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/www.themepunch.com\\\\\\/slider-revolution\\\\\\/install-addons\\\\\\/\\\"}]\",\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"How to Create a Slider Animation Effect Your Visitors Won\\u2019t Forget [Tutorial]\",\"guide_url\":\"https:\\/\\/www.sliderrevolution.com\\/tutorials\\/how-to-create-a-slider-animation-effect\\/\",\"guide_img\":\"tutorial\\/websiteintro.png\",\"active\":\"1\",\"installed\":false},\"147\":{\"id\":\"150\",\"title\":\"Mask Showcase\",\"alias\":\"maskshowcase\",\"zip\":\"maskshowcase.zip\",\"uid\":\"fc943c31e2da9c63b252aeabf554d128\",\"img\":\"maskshowcase\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/minimal-mask-showcase\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=minimal-mask-showcase\",\"version\":\"1.0.0\",\"required\":\"5.4\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Mask Showcase template uses gradients and the amazing block layer animations. A minimal slider treat for any website!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"148\":{\"id\":\"151\",\"title\":\"Parallax Zoom Slices\",\"alias\":\"parallaxzoomslices\",\"zip\":\"parallaxzoomslices.zip\",\"uid\":\"83537cae05709ddb9bcb7375470a5894\",\"img\":\"parallaxzoomslices\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/parallax-zoom-slices-wordpress-plugin\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=parallax-zoom-slices-wordpress-plugin\",\"version\":\"1.0.0\",\"required\":\"5.4\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">This template uses the Slicey Add-On to add a unique effect to slide background images. You can simple change the background images and the slice effect will automatically be applied.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\"],\"plugin_require\":\"[{\\\"path\\\":\\\"revslider-slicey-addon\\\\\\/revslider-slicey-addon.php\\\",\\\"name\\\":\\\"Background Slicey AddOn\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/www.themepunch.com\\\\\\/slider-revolution\\\\\\/install-addons\\\\\\/\\\"}]\",\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"149\":{\"id\":\"152\",\"title\":\"Double Exposure Effect\",\"alias\":\"doubleexposureeffect\",\"zip\":\"doubleexposureeffect.zip\",\"uid\":\"8d9229b5cbcf5bda5fbdc6a8e01a2b8c\",\"img\":\"doubleexposureeffect\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/wordpress-double-exposure-effect\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-double-exposure-effect\",\"version\":\"1.0.1\",\"required\":\"6.4.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">Make any website special with the double exposure effect slider. Use as a header module or anywhere you want!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"150\":{\"id\":\"153\",\"title\":\"Mountain Parallax Header\",\"alias\":\"mountainparallaxheader\",\"zip\":\"mountainparallaxheader.zip\",\"uid\":\"8dc64663f317a2abdf179bbe341d016e\",\"img\":\"mountainparallaxheader\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/mountain-wordpress-parallax-header\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=mountain-wordpress-parallax-header\",\"version\":\"1.0.0\",\"required\":\"5.4.2\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">This template is a cool intro for any page, featuring a striking parallax effect. Just change texts and links and you\'re done!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"How to Place Text Behind Objects in Your Hero Image [Tutorial]\",\"guide_url\":\"https:\\/\\/www.sliderrevolution.com\\/tutorials\\/place-text-behind-objects\\/\",\"guide_img\":\"tutorial\\/mountainparallaxheader.png\",\"active\":\"1\",\"installed\":false},\"151\":{\"id\":\"154\",\"title\":\"GoodNews One-Pager Package\",\"alias\":\"goodnews-one-pager-package\",\"zip\":\"\",\"uid\":\"goodnews-one-pager-package\",\"img\":\"packages\\/templatepack_goodnews_one_pager.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/goodnews-responsive-wordpress-theme\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=goodnews-responsive-wordpress-theme\",\"version\":\"1.0.2\",\"required\":\"6.4.0\",\"width\":\"1024\",\"height\":\"768\",\"description\":\"<span class=\\\"ttm_content\\\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"carousel\",\"slider\",\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"GoodNews One-Pager\",\"package_order\":\"0\",\"package_parent\":\"true\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"7\",\"installed\":false},\"152\":{\"id\":\"155\",\"title\":\"GoodNews Menu\",\"alias\":\"goodnewsmenu\",\"zip\":\"packs\\/goodnewsmenu.zip\",\"uid\":\"4cbc82501ff340fcdc0acf7eb3ba2640\",\"img\":\"goodnewsmenu\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/goodnews-responsive-wordpress-theme\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=goodnews-responsive-wordpress-theme\",\"version\":\"1.0.2\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">You can use this slider as a module on your website or install it as part of a slider pack. <\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"GoodNews One-Pager\",\"package_order\":\"1\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"7\",\"installed\":false},\"153\":{\"id\":\"156\",\"title\":\"GoodNews Header\",\"alias\":\"goodnewsheader\",\"zip\":\"packs\\/goodnewsheader.zip\",\"uid\":\"c6660b6bdbf596f38466f569596f5259\",\"img\":\"goodnewsheader\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/goodnews-responsive-wordpress-theme\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=goodnews-responsive-wordpress-theme\",\"version\":\"1.0.2\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"GoodNews One-Pager\",\"package_order\":\"2\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"7\",\"installed\":false},\"154\":{\"id\":\"157\",\"title\":\"GoodNews Whats Hot\",\"alias\":\"goodnewswhatshot\",\"zip\":\"packs\\/goodnewswhatshot.zip\",\"uid\":\"cb841ce64a99a6644adab049cf5405cd\",\"img\":\"goodnewswhatshot\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/goodnews-responsive-wordpress-theme\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=goodnews-responsive-wordpress-theme\",\"version\":\"1.0.2\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"GoodNews One-Pager\",\"package_order\":\"3\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"7\",\"installed\":false},\"155\":{\"id\":\"158\",\"title\":\"GoodNews Featured\",\"alias\":\"goodnewsfeatured\",\"zip\":\"packs\\/goodnewsfeatured.zip\",\"uid\":\"00bde4b09e3700da7183999eaf137ccc\",\"img\":\"goodnewsfeatured\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/goodnews-responsive-wordpress-theme\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=goodnews-responsive-wordpress-theme\",\"version\":\"1.0.3\",\"required\":\"6.4.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"GoodNews One-Pager\",\"package_order\":\"4\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"7\",\"installed\":false},\"156\":{\"id\":\"159\",\"title\":\"GoodNews Spotlight\",\"alias\":\"goodnewsspotlight\",\"zip\":\"packs\\/goodnewsspotlight.zip\",\"uid\":\"138076241a828e1c5764379944755f2b\",\"img\":\"goodnewsspotlight\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/goodnews-responsive-wordpress-theme\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=goodnews-responsive-wordpress-theme\",\"version\":\"1.0.4\",\"required\":\"6.4.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"GoodNews One-Pager\",\"package_order\":\"5\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"7\",\"installed\":false},\"157\":{\"id\":\"160\",\"title\":\"GoodNews Carousel\",\"alias\":\"goodnewscarousel\",\"zip\":\"packs\\/goodnewscarousel.zip\",\"uid\":\"d29d4460a6015e30d08d2714232d3768\",\"img\":\"goodnewscarousel\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/goodnews-responsive-wordpress-theme\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=goodnews-responsive-wordpress-theme\",\"version\":\"1.0.2\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"carousel\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"GoodNews One-Pager\",\"package_order\":\"6\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"7\",\"installed\":false},\"158\":{\"id\":\"161\",\"title\":\"GoodNews Callout\",\"alias\":\"goodnewscallout\",\"zip\":\"packs\\/goodnewscallout.zip\",\"uid\":\"d9568b3193e96577fae630b3a6728785\",\"img\":\"goodnewscallout\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/goodnews-responsive-wordpress-theme\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=goodnews-responsive-wordpress-theme\",\"version\":\"1.0.2\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"GoodNews One-Pager\",\"package_order\":\"7\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"7\",\"installed\":false},\"159\":{\"id\":\"162\",\"title\":\"GoodNews Footer\",\"alias\":\"goodnewsfooter\",\"zip\":\"packs\\/goodnewsfooter.zip\",\"uid\":\"34f43f891cb8d55375149dc4bbc38298\",\"img\":\"goodnewsfooter\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/goodnews-responsive-wordpress-theme\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=goodnews-responsive-wordpress-theme\",\"version\":\"1.0.2\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"GoodNews One-Pager\",\"package_order\":\"8\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"7\",\"installed\":false},\"160\":{\"id\":\"163\",\"title\":\"GoodNews Content Page Package\",\"alias\":\"goodnews-content-page-package\",\"zip\":\"\",\"uid\":\"goodnews-content-page-package\",\"img\":\"packages\\/templatepack_goodnews_content_page_package.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/goodnews-responsive-wordpress-theme-content\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=goodnews-responsive-wordpress-theme-content\",\"version\":\"1.0.1\",\"required\":\"6.0.0\",\"width\":\"1024\",\"height\":\"768\",\"description\":\"<span class=\\\"ttm_content\\\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\",\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"GoodNews Content Page\",\"package_order\":\"0\",\"package_parent\":\"true\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"8\",\"installed\":false},\"161\":{\"id\":\"164\",\"title\":\"GoodNews Menu Back\",\"alias\":\"goodnewsmenuback\",\"zip\":\"packs\\/goodnewsmenuback.zip\",\"uid\":\"1340d1aeefba497a7d404d12a1fceed4\",\"img\":\"goodnewsmenuback\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/goodnews-responsive-wordpress-theme-content\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=goodnews-responsive-wordpress-theme-content\",\"version\":\"1.0.1\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"GoodNews Content Page\",\"package_order\":\"1\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"8\",\"installed\":false},\"162\":{\"id\":\"165\",\"title\":\"GoodNews Blog Header\",\"alias\":\"goodnewsblogheader\",\"zip\":\"packs\\/goodnewsblogheader.zip\",\"uid\":\"abc4d7c1e48475c6def05f1f6d8bf564\",\"img\":\"goodnewsblogheader\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/goodnews-responsive-wordpress-theme-content\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=goodnews-responsive-wordpress-theme-content\",\"version\":\"1.0.1\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"GoodNews Content Page\",\"package_order\":\"2\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"8\",\"installed\":false},\"163\":{\"id\":\"166\",\"title\":\"GoodNews Blog Content\",\"alias\":\"goodnewsblogcontent\",\"zip\":\"packs\\/goodnewsblogcontent.zip\",\"uid\":\"bbf34563da6db2779c29599b503b07e9\",\"img\":\"goodnewsblogcontent\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/goodnews-responsive-wordpress-theme-content\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=goodnews-responsive-wordpress-theme-content\",\"version\":\"1.0.1\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"GoodNews Content Page\",\"package_order\":\"3\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"8\",\"installed\":false},\"164\":{\"id\":\"167\",\"title\":\"GoodNews Testimonials\",\"alias\":\"goodnewstestimonials\",\"zip\":\"packs\\/goodnewstestimonials.zip\",\"uid\":\"606b7336e86f69c567542d3f43712b56\",\"img\":\"goodnewstestimonials\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/goodnews-responsive-wordpress-theme-content\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=goodnews-responsive-wordpress-theme-content\",\"version\":\"1.0.1\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"GoodNews Content Page\",\"package_order\":\"4\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"8\",\"installed\":false},\"165\":{\"id\":\"168\",\"title\":\"GoodNews Blog Footer\",\"alias\":\"goodnewsblogfooter\",\"zip\":\"packs\\/goodnewsblogfooter.zip\",\"uid\":\"1fb88aecfb116fde67ce8d52bd3b5f05\",\"img\":\"goodnewsblogfooter\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/goodnews-responsive-wordpress-theme-content\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=goodnews-responsive-wordpress-theme-content\",\"version\":\"1.0.1\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"GoodNews Content Page\",\"package_order\":\"5\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"8\",\"installed\":false},\"166\":{\"id\":\"169\",\"title\":\"Before After Slider\",\"alias\":\"beforeafterslider\",\"zip\":\"beforeafterslider.zip\",\"uid\":\"6e615091a1fc3037c24b985ce5136fb2\",\"img\":\"beforeafterslider\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/before-after-slider\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=before-after-slider\",\"version\":\"1.0.1\",\"required\":\"5.4.3.2\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">This is the example slider for our Before \\/ After Add-On that allows you to create unique presentations with a comparing functionality.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">How to install <a href=\\\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\\\" target=\\\"_blank\\\">Add-Ons<\\/a>.<\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\"],\"plugin_require\":\"[{\\\"path\\\":\\\"revslider-beforeafter-addon\\\\\\/revslider-beforeafter-addon.php\\\",\\\"name\\\":\\\"Before After AddOn\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/www.themepunch.com\\\\\\/slider-revolution\\\\\\/install-addons\\\\\\/\\\"}]\",\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false,\"is_new\":true},\"167\":{\"id\":\"170\",\"title\":\"Product Showcase\",\"alias\":\"productshowcase\",\"zip\":\"productshowcase.zip\",\"uid\":\"a43447670260aaa7e8ff66cedfddb57a\",\"img\":\"productshowcase\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/wordpress-product-showcase-slider\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-product-showcase-slider\",\"version\":\"1.0.0\",\"required\":\"5.4.5\",\"width\":\"1240\",\"height\":\"900\",\"description\":\"<span class=\\\"ttm_content\\\">Looking to sell products effectively? Our product showcase slider is just what you are looking for!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"168\":{\"id\":\"171\",\"title\":\"Overexposure Transition\",\"alias\":\"overexposuretransition\",\"zip\":\"overexposuretransition.zip\",\"uid\":\"13f16bbe6c6d646c7d0cb817a0d3d181\",\"img\":\"overexposuretransition\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/overexposure-transition-effect\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=overexposure-transition-effect\",\"version\":\"1.0.0\",\"required\":\"5.4.5\",\"width\":\"1240\",\"height\":\"900\",\"description\":\"<span class=\\\"ttm_content\\\">Subtle overexposure transitions and smooth color fade effects make this slider stand out.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">How to install <a href=\\\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\\\" target=\\\"_blank\\\">Add-Ons<\\/a>.<\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\"],\"plugin_require\":\"[{\\\"path\\\":\\\"revslider-particles-addon\\\\\\/revslider-particles-addon.php\\\",\\\"name\\\":\\\"Particles Effect AddOn\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/www.themepunch.com\\\\\\/slider-revolution\\\\\\/install-addons\\\\\\/\\\"}]\",\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"169\":{\"id\":\"172\",\"title\":\"Parallax Scroll\",\"alias\":\"parallaxscroll\",\"zip\":\"parallaxscroll.zip\",\"uid\":\"82546ee2f6af6c6682852f495109b3c3\",\"img\":\"parallaxscroll\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/parallax-scroll\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=parallax-scroll\",\"version\":\"1.0.0\",\"required\":\"5.4.5\",\"width\":\"1240\",\"height\":\"900\",\"description\":\"<span class=\\\"ttm_content\\\">A strikingly colourful header for your website with super smooth parallax effects.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"170\":{\"id\":\"173\",\"title\":\"TechCo One-Pager Package\",\"alias\":\"techco-one-pager-package\",\"zip\":\"\",\"uid\":\"techco-one-pager-package\",\"img\":\"packages\\/techco_overview.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/techco-one-page-wordpress-theme\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=techco-one-page-wordpress-theme\",\"version\":\"1.0.2\",\"required\":\"6.1.6\",\"width\":\"1024\",\"height\":\"768\",\"description\":\"<span class=\\\"ttm_content\\\">The TechCo One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\",\"hero\",\"website\"],\"plugin_require\":\"[{\\\"path\\\":\\\"revslider-particles-addon\\\\\\/revslider-particles-addon.php\\\",\\\"name\\\":\\\"Particles Effect AddOn\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/www.themepunch.com\\\\\\/slider-revolution\\\\\\/install-addons\\\\\\/\\\"}]\",\"date\":\"0000-00-00 00:00:00\",\"package\":\"TechCo One-Pager\",\"package_order\":\"0\",\"package_parent\":\"true\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"9\",\"installed\":false},\"171\":{\"id\":\"174\",\"title\":\"TechCo Menu\",\"alias\":\"techco-menu\",\"zip\":\"packs\\/techco-menu.zip\",\"uid\":\"55e5efee828cdf1ff7e2d3b90a301ea9\",\"img\":\"techco-menu\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/techco-one-page-wordpress-theme\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=techco-one-page-wordpress-theme\",\"version\":\"1.0.2\",\"required\":\"6.1.6\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The TechCo One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"TechCo One-Pager\",\"package_order\":\"1\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"9\",\"installed\":false},\"172\":{\"id\":\"175\",\"title\":\"TechCo Header\",\"alias\":\"techco-header\",\"zip\":\"packs\\/techco-header.zip\",\"uid\":\"fb574d1376de9b1e408c91f51e6497d7\",\"img\":\"techco-header\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/techco-one-page-wordpress-theme\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=techco-one-page-wordpress-theme\",\"version\":\"1.0.2\",\"required\":\"6.1.6\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The TechCo One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":\"[{\\\"path\\\":\\\"revslider-particles-addon\\\\\\/revslider-particles-addon.php\\\",\\\"name\\\":\\\"Particles Effect AddOn\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/www.themepunch.com\\\\\\/slider-revolution\\\\\\/install-addons\\\\\\/\\\"}]\",\"date\":\"0000-00-00 00:00:00\",\"package\":\"TechCo One-Pager\",\"package_order\":\"2\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"9\",\"installed\":false},\"173\":{\"id\":\"176\",\"title\":\"TechCo About\",\"alias\":\"techco-about\",\"zip\":\"packs\\/techco-about.zip\",\"uid\":\"ba216da8231e55118d87e37d2358812c\",\"img\":\"techco-about\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/techco-one-page-wordpress-theme\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=techco-one-page-wordpress-theme\",\"version\":\"1.0.2\",\"required\":\"6.1.6\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The TechCo One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"TechCo One-Pager\",\"package_order\":\"3\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"9\",\"installed\":false},\"174\":{\"id\":\"177\",\"title\":\"TechCo Services\",\"alias\":\"techco-services\",\"zip\":\"packs\\/techco-services.zip\",\"uid\":\"ef4a8ddbb5e1136133f7bc1227248e22\",\"img\":\"techco-services\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/techco-one-page-wordpress-theme\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=techco-one-page-wordpress-theme\",\"version\":\"1.0.2\",\"required\":\"6.1.6\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The TechCo One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"TechCo One-Pager\",\"package_order\":\"4\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"9\",\"installed\":false},\"175\":{\"id\":\"178\",\"title\":\"TechCo Video\",\"alias\":\"techco-video\",\"zip\":\"packs\\/techco-video.zip\",\"uid\":\"d7bb92281d05f39f9bc9eca71f90e402\",\"img\":\"techco-video\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/techco-one-page-wordpress-theme\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=techco-one-page-wordpress-theme\",\"version\":\"1.0.2\",\"required\":\"6.1.6\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The TechCo One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"TechCo One-Pager\",\"package_order\":\"5\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"9\",\"installed\":false},\"176\":{\"id\":\"179\",\"title\":\"TechCo Prices\",\"alias\":\"techco-prices\",\"zip\":\"packs\\/techco-prices.zip\",\"uid\":\"6291f404efbea12bb181352aba71ef11\",\"img\":\"techco-prices\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/techco-one-page-wordpress-theme\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=techco-one-page-wordpress-theme\",\"version\":\"1.0.2\",\"required\":\"6.1.6\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The TechCo One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"TechCo One-Pager\",\"package_order\":\"6\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"9\",\"installed\":false},\"177\":{\"id\":\"180\",\"title\":\"TechCo Testimonials\",\"alias\":\"techco-testimonials\",\"zip\":\"packs\\/techco-testimonials.zip\",\"uid\":\"3460bd51f6b80599266fecb7fbb918be\",\"img\":\"techco-testimonials\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/techco-one-page-wordpress-theme\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=techco-one-page-wordpress-theme\",\"version\":\"1.0.2\",\"required\":\"6.1.6\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The TechCo One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"TechCo One-Pager\",\"package_order\":\"7\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"9\",\"installed\":false},\"178\":{\"id\":\"181\",\"title\":\"TechCo Footer\",\"alias\":\"techco-footer\",\"zip\":\"packs\\/techco-footer.zip\",\"uid\":\"640abcd549137520461a4a71ff758a3b\",\"img\":\"techco-footer\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/techco-one-page-wordpress-theme\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=techco-one-page-wordpress-theme\",\"version\":\"1.0.2\",\"required\":\"6.1.6\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The TechCo One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"TechCo One-Pager\",\"package_order\":\"8\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"9\",\"installed\":false},\"179\":{\"id\":\"182\",\"title\":\"Live Weather\",\"alias\":\"weather\",\"zip\":\"weather.zip\",\"uid\":\"aab92e69374e4c7b8c6741fe02e574b9\",\"img\":\"weather\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/wordpress-live-weather-add-on\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-live-weather-add-on\",\"version\":\"1.0.3\",\"required\":\"5.4.5.2\",\"width\":\"1240\",\"height\":\"900\",\"description\":\"<span class=\\\"ttm_content\\\">Showcasing our weather add-on, this slider show a different cities temperatures and forecast on each slide.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\"],\"plugin_require\":\"[{\\\"path\\\":\\\"revslider-weather-addon\\\\\\/revslider-weather-addon.php\\\",\\\"name\\\":\\\"Live Weather AddOn\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/www.themepunch.com\\\\\\/slider-revolution\\\\\\/install-addons\\\\\\/\\\"}]\",\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"180\":{\"id\":\"183\",\"title\":\"360 Panorama Tour\",\"alias\":\"360panorama\",\"zip\":\"360panorama.zip\",\"uid\":\"332720fdacdbb38f65e8327a2a96c52d\",\"img\":\"360panorama\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/360-degree-real-estate-virtual-tour\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=360-degree-real-estate-virtual-tour\",\"version\":\"1.0.0\",\"required\":\"5.4.5.2\",\"width\":\"1240\",\"height\":\"900\",\"description\":\"<span class=\\\"ttm_content\\\">An example template for our Panorama 360 tour add-on, created for the real estate market.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\"],\"plugin_require\":\"[{\\\"path\\\":\\\"revslider-panorama-addon\\\\\\/revslider-panorama-addon.php\\\",\\\"name\\\":\\\"Panorama AddOn\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/www.themepunch.com\\\\\\/slider-revolution\\\\\\/install-addons\\\\\\/\\\"}]\",\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"181\":{\"id\":\"184\",\"title\":\"Duotone Add-on\",\"alias\":\"duotone-add-on\",\"zip\":\"duotone-add-on.zip\",\"uid\":\"a428c6f363b3146e96d20a6f44958922\",\"img\":\"duotone-add-on\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/wordpress-duotone-effect-add-on\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-duotone-effect-add-on\",\"version\":\"1.0.0\",\"required\":\"5.4.6\",\"width\":\"1240\",\"height\":\"900\",\"description\":\"<span class=\\\"ttm_content\\\">This example template showcases 3 of the 30 Duotone filters available in our brand new Duotone Add-On.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\"],\"plugin_require\":\"[{\\\"path\\\":\\\"revslider-particles-addon\\\\\\/revslider-particles-addon.php\\\",\\\"name\\\":\\\"Particles Effect AddOn\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/www.themepunch.com\\\\\\/slider-revolution\\\\\\/install-addons\\\\\\/\\\"},{\\\"path\\\":\\\"revslider-duotonefilters-addon\\\\\\/revslider-duotonefilters-addon.php\\\",\\\"name\\\":\\\"Duotone AddOn\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/www.themepunch.com\\\\\\/slider-revolution\\\\\\/install-addons\\\\\\/\\\"}]\",\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"182\":{\"id\":\"185\",\"title\":\"Reveal Add-on\",\"alias\":\"reveal-add-on\",\"zip\":\"reveal-add-on.zip\",\"uid\":\"7fa7525d8ff7fa7365cb98a437e88e32\",\"img\":\"reveal-add-on\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/wordpress-content-reveal-effect\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-content-reveal-effect\",\"version\":\"1.0.0\",\"required\":\"5.4.6\",\"width\":\"1240\",\"height\":\"900\",\"description\":\"<span class=\\\"ttm_content\\\">An example template that uses our Reveal Add-On, which adds 14 new preloaders combined with reveal loading effects for any slider or hero.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\"],\"plugin_require\":\"[{\\\"path\\\":\\\"revslider-particles-addon\\\\\\/revslider-particles-addon.php\\\",\\\"name\\\":\\\"Particles Effect AddOn\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/www.themepunch.com\\\\\\/slider-revolution\\\\\\/install-addons\\\\\\/\\\"},{\\\"path\\\":\\\"revslider-revealer-addon\\\\\\/revslider-revealer-addon.php\\\",\\\"name\\\":\\\"Reveal AddOn\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/www.themepunch.com\\\\\\/slider-revolution\\\\\\/install-addons\\\\\\/\\\"}]\",\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"202\":{\"id\":\"211\",\"title\":\"Immersion One Page\",\"alias\":\"immersion-one-page-package\",\"zip\":\"\",\"uid\":\"immersion-one-page-package\",\"img\":\"packages\\/immersion_overview.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/immersion-wordpress-one-page-theme-2018\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=immersion-wordpress-one-page-theme-2018\",\"version\":\"1.0.0\",\"required\":\"5.4.6\",\"width\":\"1024\",\"height\":\"768\",\"description\":\"<span class=\\\"ttm_content\\\">The Immersion WordPress one page theme is a great fit if you quickly want to setup a visually oriented one page website. Using the power of Slider Revolution, we added some interesting effects like slicing and smooth parallax.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\",\"hero\",\"website\"],\"plugin_require\":\"[{\\\"path\\\":\\\"revslider-typewriter-addon\\\\\\/revslider-typewriter-addon.php\\\",\\\"name\\\":\\\"Typewriter AddOn\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/www.themepunch.com\\\\\\/slider-revolution\\\\\\/typewriter-addon\\\\\\/\\\"},{\\\"path\\\":\\\"revslider-slicey-addon\\\\\\/revslider-slicey-addon.php\\\",\\\"name\\\":\\\"Background Slicey AddOn\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/www.themepunch.com\\\\\\/slider-revolution\\\\\\/install-addons\\\\\\/\\\"}]\",\"date\":\"0000-00-00 00:00:00\",\"package\":\"Immersion One Page\",\"package_order\":\"0\",\"package_parent\":\"true\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"10\",\"installed\":false},\"203\":{\"id\":\"212\",\"title\":\"Immersion Header\",\"alias\":\"immersion_header\",\"zip\":\"packs\\/immersion_header.zip\",\"uid\":\"853da51256308b341ecd030bd4883229\",\"img\":\"immersion_header\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/immersion-wordpress-one-page-theme-2018\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=immersion-wordpress-one-page-theme-2018\",\"version\":\"1.0.0\",\"required\":\"5.4.6\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Immersion WordPress one page theme is a great fit if you quickly want to setup a visually oriented one page website. Using the power of Slider Revolution, we added some interesting effects like slicing and smooth parallax.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":\"[{\\\"path\\\":\\\"revslider-typewriter-addon\\\\\\/revslider-typewriter-addon.php\\\",\\\"name\\\":\\\"Typewriter AddOn\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/www.themepunch.com\\\\\\/slider-revolution\\\\\\/typewriter-addon\\\\\\/\\\"}]\",\"date\":\"0000-00-00 00:00:00\",\"package\":\"Immersion One Page\",\"package_order\":\"1\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"10\",\"installed\":false},\"204\":{\"id\":\"213\",\"title\":\"Immersion Mountains\",\"alias\":\"immersion-mountains\",\"zip\":\"packs\\/immersion-mountains.zip\",\"uid\":\"817167eb3fe22b7e065ba210cbe6d53c\",\"img\":\"immersion-mountains\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/immersion-wordpress-one-page-theme-2018\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=immersion-wordpress-one-page-theme-2018\",\"version\":\"1.0.0\",\"required\":\"5.4.6\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Immersion WordPress one page theme is a great fit if you quickly want to setup a visually oriented one page website. Using the power of Slider Revolution, we added some interesting effects like slicing and smooth parallax.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":\"[{\\\"path\\\":\\\"revslider-slicey-addon\\\\\\/revslider-slicey-addon.php\\\",\\\"name\\\":\\\"Background Slicey AddOn\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/www.themepunch.com\\\\\\/slider-revolution\\\\\\/install-addons\\\\\\/\\\"}]\",\"date\":\"0000-00-00 00:00:00\",\"package\":\"Immersion One Page\",\"package_order\":\"2\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"10\",\"installed\":false},\"205\":{\"id\":\"214\",\"title\":\"Immersion Product\",\"alias\":\"immersion-product\",\"zip\":\"packs\\/immersion-product.zip\",\"uid\":\"64134f263484d2bbcd7ef088ffbbfb4b\",\"img\":\"immersion-product\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/immersion-wordpress-one-page-theme-2018\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=immersion-wordpress-one-page-theme-2018\",\"version\":\"1.0.0\",\"required\":\"5.4.6\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Immersion WordPress one page theme is a great fit if you quickly want to setup a visually oriented one page website. Using the power of Slider Revolution, we added some interesting effects like slicing and smooth parallax.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Immersion One Page\",\"package_order\":\"3\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"10\",\"installed\":false},\"206\":{\"id\":\"215\",\"title\":\"Immersion Design\",\"alias\":\"immersion-design\",\"zip\":\"packs\\/immersion-design.zip\",\"uid\":\"91e1d77c1a2826438763804f4d02bc26\",\"img\":\"immersion-design\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/immersion-wordpress-one-page-theme-2018\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=immersion-wordpress-one-page-theme-2018\",\"version\":\"1.0.0\",\"required\":\"5.4.6\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Immersion WordPress one page theme is a great fit if you quickly want to setup a visually oriented one page website. Using the power of Slider Revolution, we added some interesting effects like slicing and smooth parallax.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Immersion One Page\",\"package_order\":\"4\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"10\",\"installed\":false},\"207\":{\"id\":\"216\",\"title\":\"Immersion Phototgraphy\",\"alias\":\"immersion-photography\",\"zip\":\"packs\\/immersion-photography.zip\",\"uid\":\"e3ddf0c577b09740f5cbf2e38ffd684d\",\"img\":\"immersion-photography\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/immersion-wordpress-one-page-theme-2018\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=immersion-wordpress-one-page-theme-2018\",\"version\":\"1.0.0\",\"required\":\"5.4.6\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Immersion WordPress one page theme is a great fit if you quickly want to setup a visually oriented one page website. Using the power of Slider Revolution, we added some interesting effects like slicing and smooth parallax.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Immersion One Page\",\"package_order\":\"5\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"10\",\"installed\":false},\"208\":{\"id\":\"217\",\"title\":\"Immersion Grid\",\"alias\":\"immersion-grid\",\"zip\":\"packs\\/immersion-grid.zip\",\"uid\":\"b6903868189bb83b2c7a852fde3a7dc3\",\"img\":\"immersion-grid\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/immersion-wordpress-one-page-theme-2018\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=immersion-wordpress-one-page-theme-2018\",\"version\":\"1.0.1\",\"required\":\"5.4.6\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Immersion WordPress one page theme is a great fit if you quickly want to setup a visually oriented one page website. Using the power of Slider Revolution, we added some interesting effects like slicing and smooth parallax.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Immersion One Page\",\"package_order\":\"6\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"10\",\"installed\":false},\"209\":{\"id\":\"218\",\"title\":\"Funky Intro Slider\",\"alias\":\"funkyslider\",\"zip\":\"funkyslider.zip\",\"uid\":\"2d4187e3fdad19b976be335253c8925d\",\"img\":\"funkyslider\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/funky-intro-slider-wordpress-plugin\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=funky-intro-slider-wordpress-plugin\",\"version\":\"1.0.1\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">This funky intro slider fits just right if you need a striking introduction to your website! Sleek, beautiful and easily customizable!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\"],\"plugin_require\":\"[{\\\"path\\\":\\\"revslider-typewriter-addon\\\\\\/revslider-typewriter-addon.php\\\",\\\"name\\\":\\\"Typewriter AddOn\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/www.themepunch.com\\\\\\/slider-revolution\\\\\\/typewriter-addon\\\\\\/\\\"},{\\\"path\\\":\\\"revslider-revealer-addon\\\\\\/revslider-revealer-addon.php\\\",\\\"name\\\":\\\"Reveal AddOn\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/www.themepunch.com\\\\\\/slider-revolution\\\\\\/install-addons\\\\\\/\\\"}]\",\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"210\":{\"id\":\"219\",\"title\":\"Clear View Magazine\",\"alias\":\"clear-view-magazine-package\",\"zip\":\"\",\"uid\":\"clear-view-magazine-package\",\"img\":\"packages\\/clear_view_magazine_overview.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/clear-view-minimal-magazine-wordpress-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=clear-view-minimal-magazine-wordpress-template\",\"version\":\"1.0.3\",\"required\":\"6.1.6\",\"width\":\"1024\",\"height\":\"768\",\"description\":\"<span class=\\\"ttm_content\\\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"website\"],\"plugin_require\":\"[{\\\"path\\\":\\\"revslider-revealer-addon\\\\\\/revslider-revealer-addon.php\\\",\\\"name\\\":\\\"Reveal AddOn\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/www.themepunch.com\\\\\\/slider-revolution\\\\\\/install-addons\\\\\\/\\\"}]\",\"date\":\"0000-00-00 00:00:00\",\"package\":\"Clear View Magazine\",\"package_order\":\"0\",\"package_parent\":\"true\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"11\",\"installed\":false},\"211\":{\"id\":\"220\",\"title\":\"Clear View Menu\",\"alias\":\"clearview_menu\",\"zip\":\"packs\\/clearview_menu.zip\",\"uid\":\"eaecee5fa5f3c3a7f4d2a96c4616a353\",\"img\":\"clearview_menu\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/clear-view-minimal-magazine-wordpress-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=clear-view-minimal-magazine-wordpress-template\",\"version\":\"1.0.3\",\"required\":\"6.1.6\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Clear View Magazine\",\"package_order\":\"1\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"11\",\"installed\":false},\"212\":{\"id\":\"221\",\"title\":\"Clear View Header\",\"alias\":\"clearview_header\",\"zip\":\"packs\\/clearview_header.zip\",\"uid\":\"25e3dd80ad130875d7438a07952cb0cd\",\"img\":\"clearview_header\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/clear-view-minimal-magazine-wordpress-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=clear-view-minimal-magazine-wordpress-template\",\"version\":\"1.0.3\",\"required\":\"6.1.6\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":\"[{\\\"path\\\":\\\"revslider-revealer-addon\\\\\\/revslider-revealer-addon.php\\\",\\\"name\\\":\\\"Reveal AddOn\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/www.themepunch.com\\\\\\/slider-revolution\\\\\\/install-addons\\\\\\/\\\"}]\",\"date\":\"0000-00-00 00:00:00\",\"package\":\"Clear View Magazine\",\"package_order\":\"2\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"11\",\"installed\":false},\"213\":{\"id\":\"222\",\"title\":\"Clear View Mission\",\"alias\":\"clearview_mission\",\"zip\":\"packs\\/clearview_mission.zip\",\"uid\":\"35b2092a49fd2beb549342e69097eb5b\",\"img\":\"clearview_mission\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/clear-view-minimal-magazine-wordpress-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=clear-view-minimal-magazine-wordpress-template\",\"version\":\"1.0.3\",\"required\":\"6.1.6\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Clear View Magazine\",\"package_order\":\"3\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"11\",\"installed\":false},\"214\":{\"id\":\"223\",\"title\":\"Clear View Slider\",\"alias\":\"clear-view-slider\",\"zip\":\"packs\\/clear-view-slider.zip\",\"uid\":\"d2e17edffce16ed78c54b0ef23fd7e05\",\"img\":\"clear-view-slider\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/clear-view-minimal-magazine-wordpress-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=clear-view-minimal-magazine-wordpress-template\",\"version\":\"1.0.3\",\"required\":\"6.1.6\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Clear View Magazine\",\"package_order\":\"4\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"11\",\"installed\":false},\"215\":{\"id\":\"224\",\"title\":\"Clear View News\",\"alias\":\"clear-view-news\",\"zip\":\"packs\\/clear-view-news.zip\",\"uid\":\"5698d3131ba141e9afcfd2906739dd00\",\"img\":\"clear-view-news\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/clear-view-minimal-magazine-wordpress-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=clear-view-minimal-magazine-wordpress-template\",\"version\":\"1.0.3\",\"required\":\"6.1.6\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Clear View Magazine\",\"package_order\":\"5\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"11\",\"installed\":false},\"216\":{\"id\":\"225\",\"title\":\"Clear View Clients\",\"alias\":\"clear-view-clients\",\"zip\":\"packs\\/clear-view-clients.zip\",\"uid\":\"b95616a94832e22bdfac5ce60232be1b\",\"img\":\"clear-view-clients\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/clear-view-minimal-magazine-wordpress-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=clear-view-minimal-magazine-wordpress-template\",\"version\":\"1.0.3\",\"required\":\"6.1.6\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Clear View Magazine\",\"package_order\":\"6\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"11\",\"installed\":false},\"217\":{\"id\":\"226\",\"title\":\"Clear View Contact\",\"alias\":\"clear-view-contact\",\"zip\":\"packs\\/clear-view-contact.zip\",\"uid\":\"0e0cc1d8f6f6500e5f8a2b091fa3b4cb\",\"img\":\"clear-view-contact\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/clear-view-minimal-magazine-wordpress-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=clear-view-minimal-magazine-wordpress-template\",\"version\":\"1.0.3\",\"required\":\"6.1.6\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Clear View Magazine\",\"package_order\":\"7\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"11\",\"installed\":false},\"218\":{\"id\":\"227\",\"title\":\"Clear View Post Page\",\"alias\":\"clear-view-post-page-package\",\"zip\":\"\",\"uid\":\"clear-view-post-page-package\",\"img\":\"packages\\/clear_view_post_page_overview.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/clear-view-single-post-page-wordpress-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=clear-view-single-post-page-wordpress-template\",\"version\":\"1.0.1\",\"required\":\"6.1.6\",\"width\":\"1024\",\"height\":\"768\",\"description\":\"<span class=\\\"ttm_content\\\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"website\"],\"plugin_require\":\"[{\\\"path\\\":\\\"revslider-revealer-addon\\\\\\/revslider-revealer-addon.php\\\",\\\"name\\\":\\\"Reveal AddOn\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/www.themepunch.com\\\\\\/slider-revolution\\\\\\/install-addons\\\\\\/\\\"}]\",\"date\":\"0000-00-00 00:00:00\",\"package\":\"Clear View Post Page\",\"package_order\":\"0\",\"package_parent\":\"true\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"12\",\"installed\":false},\"219\":{\"id\":\"228\",\"title\":\"Clear View Single Menu\",\"alias\":\"clear-view-single-menu\",\"zip\":\"packs\\/clear-view-single-menu.zip\",\"uid\":\"1e80f81982f8a4ea763482d4fa99d321\",\"img\":\"clear-view-single-menu\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/clear-view-single-post-page-wordpress-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=clear-view-single-post-page-wordpress-template\",\"version\":\"1.0.1\",\"required\":\"6.1.6\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Clear View Post Page\",\"package_order\":\"1\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"12\",\"installed\":false},\"220\":{\"id\":\"229\",\"title\":\"Clear View Single Header\",\"alias\":\"clear-view-single-header\",\"zip\":\"packs\\/clear-view-single-header.zip\",\"uid\":\"c8d717627be6cd5e70922ab609694dbf\",\"img\":\"clear-view-single-header\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/clear-view-single-post-page-wordpress-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=clear-view-single-post-page-wordpress-template\",\"version\":\"1.0.1\",\"required\":\"6.1.6\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":\"[{\\\"path\\\":\\\"revslider-revealer-addon\\\\\\/revslider-revealer-addon.php\\\",\\\"name\\\":\\\"Reveal AddOn\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/www.themepunch.com\\\\\\/slider-revolution\\\\\\/install-addons\\\\\\/\\\"}]\",\"date\":\"0000-00-00 00:00:00\",\"package\":\"Clear View Post Page\",\"package_order\":\"2\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"12\",\"installed\":false},\"221\":{\"id\":\"230\",\"title\":\"Clear View Single Media\",\"alias\":\"clear-view-single-media\",\"zip\":\"packs\\/clear-view-single-media.zip\",\"uid\":\"c480368ded2a64f0cdd44f1674213814\",\"img\":\"clear-view-single-media\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/clear-view-single-post-page-wordpress-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=clear-view-single-post-page-wordpress-template\",\"version\":\"1.0.1\",\"required\":\"6.1.6\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Clear View Post Page\",\"package_order\":\"3\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"12\",\"installed\":false},\"222\":{\"id\":\"231\",\"title\":\"Clear View Single More\",\"alias\":\"clear-view-single-more\",\"zip\":\"packs\\/clear-view-single-more.zip\",\"uid\":\"9c693190df26218366d1f77e10cf550a\",\"img\":\"clear-view-single-more\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/clear-view-single-post-page-wordpress-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=clear-view-single-post-page-wordpress-template\",\"version\":\"1.0.1\",\"required\":\"6.1.6\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Clear View Post Page\",\"package_order\":\"4\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"12\",\"installed\":false},\"223\":{\"id\":\"232\",\"title\":\"Clear View Single Contact\",\"alias\":\"clear-view-single-contact\",\"zip\":\"packs\\/clear-view-single-contact.zip\",\"uid\":\"73c0a889f2b654a87b5aba1ff76fbc5c\",\"img\":\"clear-view-single-contact\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/clear-view-single-post-page-wordpress-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=clear-view-single-post-page-wordpress-template\",\"version\":\"1.0.1\",\"required\":\"6.1.6\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Clear View Post Page\",\"package_order\":\"5\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"12\",\"installed\":false},\"224\":{\"id\":\"233\",\"title\":\"Clean Landing Page\",\"alias\":\"cleanlandingpage\",\"zip\":\"cleanlandingpage.zip\",\"uid\":\"727a3680d312f22c6a5998ebdb9afe52\",\"img\":\"cleanlandingpage\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/clean-landing-page-for-wordpress\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=clean-landing-page-for-wordpress\",\"version\":\"1.0.1\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Clean Landing Page is a fullscreen Intro Module that is a striking introduction to any minimal website, with no unnecessary elements.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\"],\"plugin_require\":\"[{\\\"path\\\":\\\"revslider-typewriter-addon\\\\\\/revslider-typewriter-addon.php\\\",\\\"name\\\":\\\"Typewriter AddOn\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/www.themepunch.com\\\\\\/slider-revolution\\\\\\/typewriter-addon\\\\\\/\\\"}]\",\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"225\":{\"id\":\"234\",\"title\":\"Clear Cut\",\"alias\":\"clearcut\",\"zip\":\"clearcut.zip\",\"uid\":\"07f43c00e9b4d3057a03cdb3385ad2b7\",\"img\":\"clearcut\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/clear-cut-portfolio-website-for-wordpress\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=clear-cut-portfolio-website-for-wordpress\",\"version\":\"1.0.1\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Clear Cut Template is an All-In-One Portfolio Website solution that works best for smaller portfolios. Highlight your best work in a striking and mobile friendly fashion!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"226\":{\"id\":\"235\",\"title\":\"Wonderstruck One-Pager\",\"alias\":\"wonderstruck-one-pager-package\",\"zip\":\"\",\"uid\":\"wonderstruck-one-pager-package\",\"img\":\"packages\\/wonderstruck-one-pager-overview.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/wonderstruck-one-page-website-for-wordpress?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wonderstruck-one-page-website-for-wordpress\",\"version\":\"1.0.0\",\"required\":\"5.4.7\",\"width\":\"1024\",\"height\":\"768\",\"description\":\"<span class=\\\"ttm_content\\\">The Wonderstruck One-Pager Template is a clean, colorful way to showcase your portfolio online. Just install, change the content and you have a mobile ready online experience!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Wonderstruck One-Pager\",\"package_order\":\"0\",\"package_parent\":\"true\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"13\",\"installed\":false},\"227\":{\"id\":\"236\",\"title\":\"Wonderstruck Menu\",\"alias\":\"wonderstruck_menu\",\"zip\":\"packs\\/wonderstruck_menu.zip\",\"uid\":\"0a976e9aaae59c4f795b38f59f5a08d8\",\"img\":\"wonderstruck_menu\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/wonderstruck-one-page-website-for-wordpress?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wonderstruck-one-page-website-for-wordpress\",\"version\":\"1.0.0\",\"required\":\"5.4.7\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Wonderstruck One-Pager Template is a clean, colorful way to showcase your portfolio online. Just install, change the content and you have a mobile ready online experience!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Wonderstruck One-Pager\",\"package_order\":\"1\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"13\",\"installed\":false},\"228\":{\"id\":\"237\",\"title\":\"Wonderstruck Header\",\"alias\":\"wonderstruck_header\",\"zip\":\"packs\\/wonderstruck_header.zip\",\"uid\":\"e1379f77a902960a0ce12d44d85a9e0a\",\"img\":\"wonderstruck_header\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/wonderstruck-one-page-website-for-wordpress?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wonderstruck-one-page-website-for-wordpress\",\"version\":\"1.0.0\",\"required\":\"5.4.7\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Wonderstruck One-Pager Template is a clean, colorful way to showcase your portfolio online. Just install, change the content and you have a mobile ready online experience!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Wonderstruck One-Pager\",\"package_order\":\"2\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"13\",\"installed\":false},\"229\":{\"id\":\"238\",\"title\":\"Wonderstruck About\",\"alias\":\"wonderstruck_about\",\"zip\":\"packs\\/wonderstruck_about.zip\",\"uid\":\"d207fb140fd328acc3038300ea52082a\",\"img\":\"wonderstruck_about\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/wonderstruck-one-page-website-for-wordpress?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wonderstruck-one-page-website-for-wordpress\",\"version\":\"1.0.0\",\"required\":\"5.4.7\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Wonderstruck One-Pager Template is a clean, colorful way to showcase your portfolio online. Just install, change the content and you have a mobile ready online experience!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Wonderstruck One-Pager\",\"package_order\":\"3\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"13\",\"installed\":false},\"230\":{\"id\":\"239\",\"title\":\"Wonderstruck Works\",\"alias\":\"wonderstruck-works\",\"zip\":\"packs\\/wonderstruck-works.zip\",\"uid\":\"4476935097e27d92454b0011b7700c1d\",\"img\":\"wonderstruck-works\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/wonderstruck-one-page-website-for-wordpress?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wonderstruck-one-page-website-for-wordpress\",\"version\":\"1.0.0\",\"required\":\"5.4.7\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Wonderstruck One-Pager Template is a clean, colorful way to showcase your portfolio online. Just install, change the content and you have a mobile ready online experience!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Wonderstruck One-Pager\",\"package_order\":\"4\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"13\",\"installed\":false},\"231\":{\"id\":\"240\",\"title\":\"Wonderstruck Contact\",\"alias\":\"wonderstruck-contact\",\"zip\":\"packs\\/wonderstruck-contact.zip\",\"uid\":\"9e4911521f77bce2b8efa40f4c2adc22\",\"img\":\"wonderstruck-contact\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/wonderstruck-one-page-website-for-wordpress?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wonderstruck-one-page-website-for-wordpress\",\"version\":\"1.0.0\",\"required\":\"5.4.7\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Wonderstruck One-Pager Template is a clean, colorful way to showcase your portfolio online. Just install, change the content and you have a mobile ready online experience!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Wonderstruck One-Pager\",\"package_order\":\"5\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"13\",\"installed\":false},\"232\":{\"id\":\"241\",\"title\":\"Bubble Morph\",\"alias\":\"bubblemorph\",\"zip\":\"bubblemorph.zip\",\"uid\":\"1102d6f5460ab82cb612cbe9f1d9514b\",\"img\":\"bubblemorph\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/bubble-morph-effect-add-on-for-wordpress\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=bubble-morph-effect-add-on-for-wordpress\",\"version\":\"1.0.0\",\"required\":\"5.4.7\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Bubble Morph Add-On allows you to create interesting Lava-Lamp style effects on any of your Slider Revolution content.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\"],\"plugin_require\":\"[{\\\"path\\\":\\\"revslider-bubblemorph-addon\\\\\\/revslider-bubblemorph-addon.php\\\",\\\"name\\\":\\\"BubbleMorph AddOn\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/www.themepunch.com\\\\\\/slider-revolution\\\\\\/install-addons\\\\\\/\\\"}]\",\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"233\":{\"id\":\"242\",\"title\":\"Distortion AddOn\",\"alias\":\"distortionaddon\",\"zip\":\"distortionaddon.zip\",\"uid\":\"0ad46c9929bb2fa6316f1e6ced301aaf\",\"img\":\"distortionaddon\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/distortion-effect-add-on-for-wordpress\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=distortion-effect-add-on-for-wordpress\",\"version\":\"1.0.0\",\"required\":\"5.4.7\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Distortion Add-On allows you to create interesting Distortion style effects on any of your Slider Revolution content.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\"],\"plugin_require\":\"[{\\\"path\\\":\\\"revslider-liquideffect-addon\\\\\\/revslider-liquideffect-addon.php\\\",\\\"name\\\":\\\"Distortion Effect AddOn\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/www.themepunch.com\\\\\\/slider-revolution\\\\\\/install-addons\\\\\\/\\\"}]\",\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"234\":{\"id\":\"243\",\"title\":\"Club Flyer\",\"alias\":\"clubflyer\",\"zip\":\"clubflyer.zip\",\"uid\":\"dab73b9904d0e643a35b0475980998bd\",\"img\":\"clubflyer\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/club-flyer-landing-page-template-for-wordpress\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=club-flyer-landing-page-template-for-wordpress\",\"version\":\"1.0.0\",\"required\":\"5.4.8\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">This Club Fyler Template for Slider Revolution uses the brand new Exploding Layers Add-On to create a captivating effect. Tap into unlimited creative potential. <\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\"],\"plugin_require\":\"[{\\\"path\\\":\\\"revslider-explodinglayers-addon\\\\\\/revslider-explodinglayers-addon.php\\\",\\\"name\\\":\\\"Exploding Layers AddOn\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/www.themepunch.com\\\\\\/slider-revolution\\\\\\/install-addons\\\\\\/\\\"}]\",\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"235\":{\"id\":\"244\",\"title\":\"Paintbrush AddOn\",\"alias\":\"paintbrushaddon\",\"zip\":\"paintbrushaddon.zip\",\"uid\":\"c85c48a6742b4bf72a2590cc1b50f6a0\",\"img\":\"paintbrushaddon\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/paintbrush-effect-add-on-for-wordpress\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=paintbrush-effect-add-on-for-wordpress\",\"version\":\"1.0.2\",\"required\":\"6.5.3\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Paintbrush Add-On for WordPress allows you to add cool mouse interaction effects to your Slider Revolution content. Examples: Blur Reveal, Color Reveal, Scratch Me Free.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\"],\"plugin_require\":\"[{\\\"path\\\":\\\"revslider-paintbrush-addon\\\\\\/revslider-paintbrush-addon.php\\\",\\\"name\\\":\\\"Paintbrush AddOn\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/www.themepunch.com\\\\\\/slider-revolution\\\\\\/install-addons\\\\\\/\\\"}]\",\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"How to Add a Unique Paintbrush Effect to Your Website with Slider Revolution [Tutorial]\",\"guide_url\":\"https:\\/\\/www.sliderrevolution.com\\/tutorials\\/unique-paintbrush-effect\\/\",\"guide_img\":\"tutorial\\/paintbrushaddon.png\",\"active\":\"1\",\"installed\":false},\"236\":{\"id\":\"245\",\"title\":\"Parallax One-Pager\",\"alias\":\"parallax-one-pager-package\",\"zip\":\"\",\"uid\":\"parallax-one-pager-package\",\"img\":\"packages\\/parallax-one-pager-package.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/parallax-one-page-wordpress-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=parallax-one-page-wordpress-template\",\"version\":\"1.0.0\",\"required\":\"5.4.8\",\"width\":\"1024\",\"height\":\"768\",\"description\":\"<span class=\\\"ttm_content\\\">The Parallax One-Page WordPress Template is consisting of 3 hero blocks and contains a beautiful parallax mountain scene. An impactful opening to your web presence!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"website\"],\"plugin_require\":\"[{\\\"path\\\":\\\"revslider-particles-addon\\\\\\/revslider-particles-addon.php\\\",\\\"name\\\":\\\"Particles Effect AddOn\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/www.themepunch.com\\\\\\/slider-revolution\\\\\\/install-addons\\\\\\/\\\"}]\",\"date\":\"0000-00-00 00:00:00\",\"package\":\"Parallax One-Pager\",\"package_order\":\"0\",\"package_parent\":\"true\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"14\",\"installed\":false},\"237\":{\"id\":\"246\",\"title\":\"Parallax Header\",\"alias\":\"parallax_header\",\"zip\":\"packs\\/parallax_header.zip\",\"uid\":\"32bf4a0f5136853bd6bd366275a7a60b\",\"img\":\"parallax_header\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/parallax-one-page-wordpress-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=parallax-one-page-wordpress-template\",\"version\":\"1.0.0\",\"required\":\"5.4.8\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Parallax One-Page WordPress Template is consisting of 3 hero blocks and contains a beautiful parallax mountain scene. An impactful opening to your web presence!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Parallax One-Pager\",\"package_order\":\"1\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"14\",\"installed\":false},\"238\":{\"id\":\"247\",\"title\":\"Parallax Content\",\"alias\":\"parallax_content\",\"zip\":\"packs\\/parallax_content.zip\",\"uid\":\"a25c5fb8f74757476ab4dc038e56f90d\",\"img\":\"parallax_content\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/parallax-one-page-wordpress-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=parallax-one-page-wordpress-template\",\"version\":\"1.0.0\",\"required\":\"5.4.8\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Parallax One-Page WordPress Template is consisting of 3 hero blocks and contains a beautiful parallax mountain scene. An impactful opening to your web presence!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Parallax One-Pager\",\"package_order\":\"2\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"14\",\"installed\":false},\"239\":{\"id\":\"248\",\"title\":\"Parallax Footer\",\"alias\":\"parallax_footer\",\"zip\":\"packs\\/parallax_footer.zip\",\"uid\":\"665dff9ea6eaf162a2a1f160f51a9ddb\",\"img\":\"parallax_footer\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/parallax-one-page-wordpress-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=parallax-one-page-wordpress-template\",\"version\":\"1.0.0\",\"required\":\"5.4.8\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Parallax One-Page WordPress Template is consisting of 3 hero blocks and contains a beautiful parallax mountain scene. An impactful opening to your web presence!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":\"[{\\\"path\\\":\\\"revslider-particles-addon\\\\\\/revslider-particles-addon.php\\\",\\\"name\\\":\\\"Particles Effect AddOn\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/www.themepunch.com\\\\\\/slider-revolution\\\\\\/install-addons\\\\\\/\\\"}]\",\"date\":\"0000-00-00 00:00:00\",\"package\":\"Parallax One-Pager\",\"package_order\":\"3\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"14\",\"installed\":false},\"240\":{\"id\":\"249\",\"title\":\"Le Chef Restaurant\",\"alias\":\"le-chef-restaurant\",\"zip\":\"\",\"uid\":\"le-chef-restaurant-package\",\"img\":\"packages\\/le-chef-restaurant-package.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/le-chef-restaurant-website-wordpress-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=le-chef-restaurant-website-wordpress-template\",\"version\":\"1.0.0\",\"required\":\"5.4.8\",\"width\":\"1024\",\"height\":\"768\",\"description\":\"<span class=\\\"ttm_content\\\">The Le Chef Restaurant Template is a One-Page Website and a full solution for your clients Restaurant. Showcase images in the header slideshow and present the Restaurants offering in a clear way!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"website\"],\"plugin_require\":\"[{\\\"path\\\":\\\"revslider-particles-addon\\\\\\/revslider-particles-addon.php\\\",\\\"name\\\":\\\"Particles Effect AddOn\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/www.themepunch.com\\\\\\/slider-revolution\\\\\\/install-addons\\\\\\/\\\"}]\",\"date\":\"0000-00-00 00:00:00\",\"package\":\"Le Chef Restaurant\",\"package_order\":\"0\",\"package_parent\":\"true\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"15\",\"installed\":false},\"241\":{\"id\":\"250\",\"title\":\"Le Chef Menu\",\"alias\":\"le-chef-menu\",\"zip\":\"packs\\/le-chef-menu.zip\",\"uid\":\"2f2a6a333431fefe4a7b3b6a982b2ff5\",\"img\":\"le-chef-menu\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/le-chef-restaurant-website-wordpress-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=le-chef-restaurant-website-wordpress-template\",\"version\":\"1.0.0\",\"required\":\"5.4.8\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Le Chef Restaurant Template is a One-Page Website and a full solution for your clients Restaurant. Showcase images in the header slideshow and present the Restaurants offering in a clear way!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Le Chef Restaurant\",\"package_order\":\"1\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"15\",\"installed\":false},\"242\":{\"id\":\"251\",\"title\":\"Le Chef Header\",\"alias\":\"le-chef-header\",\"zip\":\"packs\\/le-chef-header.zip\",\"uid\":\"06450ca3be5a4a8959f3752ab974e574\",\"img\":\"le-chef-header\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/le-chef-restaurant-website-wordpress-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=le-chef-restaurant-website-wordpress-template\",\"version\":\"1.0.0\",\"required\":\"5.4.8\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Le Chef Restaurant Template is a One-Page Website and a full solution for your clients Restaurant. Showcase images in the header slideshow and present the Restaurants offering in a clear way!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Le Chef Restaurant\",\"package_order\":\"2\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"15\",\"installed\":false},\"243\":{\"id\":\"252\",\"title\":\"Le Chef Philosophy\",\"alias\":\"le-chef-philosophy\",\"zip\":\"packs\\/le-chef-philosophy.zip\",\"uid\":\"a532fd029addeb18106e751409b8e20a\",\"img\":\"le-chef-philosophy\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/le-chef-restaurant-website-wordpress-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=le-chef-restaurant-website-wordpress-template\",\"version\":\"1.0.0\",\"required\":\"5.4.8\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Le Chef Restaurant Template is a One-Page Website and a full solution for your clients Restaurant. Showcase images in the header slideshow and present the Restaurants offering in a clear way!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Le Chef Restaurant\",\"package_order\":\"3\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"15\",\"installed\":false},\"244\":{\"id\":\"253\",\"title\":\"Le Chef Food\",\"alias\":\"le-chef-food\",\"zip\":\"packs\\/le-chef-food.zip\",\"uid\":\"cd4b6a2cb5de2dd20a0e8ba0c35451df\",\"img\":\"le-chef-food\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/le-chef-restaurant-website-wordpress-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=le-chef-restaurant-website-wordpress-template\",\"version\":\"1.0.0\",\"required\":\"5.4.8\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Le Chef Restaurant Template is a One-Page Website and a full solution for your clients Restaurant. Showcase images in the header slideshow and present the Restaurants offering in a clear way!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Le Chef Restaurant\",\"package_order\":\"4\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"15\",\"installed\":false},\"245\":{\"id\":\"254\",\"title\":\"Le Chef La Carte\",\"alias\":\"le-chef-la-carte\",\"zip\":\"packs\\/le-chef-la-carte.zip\",\"uid\":\"6f312749679c3ba52c41189a6b8bf729\",\"img\":\"le-chef-la-carte\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/le-chef-restaurant-website-wordpress-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=le-chef-restaurant-website-wordpress-template\",\"version\":\"1.0.0\",\"required\":\"5.4.8\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Le Chef Restaurant Template is a One-Page Website and a full solution for your clients Restaurant. Showcase images in the header slideshow and present the Restaurants offering in a clear way!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Le Chef Restaurant\",\"package_order\":\"5\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"15\",\"installed\":false},\"246\":{\"id\":\"255\",\"title\":\"Le Chef Footer\",\"alias\":\"le-chef-footer\",\"zip\":\"packs\\/le-chef-footer.zip\",\"uid\":\"12fc241e8e5b9e5df9758c43448e2907\",\"img\":\"le-chef-footer\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/le-chef-restaurant-website-wordpress-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=le-chef-restaurant-website-wordpress-template\",\"version\":\"1.0.0\",\"required\":\"5.4.8\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Le Chef Restaurant Template is a One-Page Website and a full solution for your clients Restaurant. Showcase images in the header slideshow and present the Restaurants offering in a clear way!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Le Chef Restaurant\",\"package_order\":\"6\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"15\",\"installed\":false},\"247\":{\"id\":\"256\",\"title\":\"News Magazine Slider\",\"alias\":\"news-magazine-slider\",\"zip\":\"news-magazine-slider.zip\",\"uid\":\"31f2c1506babb1fef459401f051d2d52\",\"img\":\"news-magazine-slider\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/news-magazine-slider-for-wordpress\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=news-magazine-slider-for-wordpress\",\"version\":\"1.0.1\",\"required\":\"5.4.8\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Magazine Slider offers various layouts that support static content images, HTML5 and Youtube video. Great for any blog or news website!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\"],\"plugin_require\":\"[{\\\"path\\\":\\\"revslider-revealer-addon\\\\\\/revslider-revealer-addon.php\\\",\\\"name\\\":\\\"Reveal AddOn\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/www.themepunch.com\\\\\\/slider-revolution\\\\\\/install-addons\\\\\\/\\\"}]\",\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false,\"is_new\":true},\"248\":{\"id\":\"257\",\"title\":\"Real Estate Slider\",\"alias\":\"real-estate-slider\",\"zip\":\"real-estate-slider.zip\",\"uid\":\"739ce6336e46815094387c9448e6c804\",\"img\":\"real-estate-slider\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/real-estate-slider-for-wordpress\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=real-estate-slider-for-wordpress\",\"version\":\"1.0.1\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Real Estate Slider allows to display real estate offers with a large ken burns background image and additional thumbnail hover images.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"249\":{\"id\":\"258\",\"title\":\"Fashion Header\",\"alias\":\"fashion-header\",\"zip\":\"fashion-header.zip\",\"uid\":\"24ece4e7f4d31cd90377c62abbd9e25a\",\"img\":\"fashion-header\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/fashion-shop-header-slider-for-wordpress\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=fashion-shop-header-slider-for-wordpress\",\"version\":\"1.0.0\",\"required\":\"5.4.8\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Fashion Shop Header ist the ideal Slider to display as an intro to your shop website or as a separator in between content. Our unique \\\"Bubble Morph\\\" effect makes this module stand out!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\"],\"plugin_require\":\"[{\\\"path\\\":\\\"revslider-bubblemorph-addon\\\\\\/revslider-bubblemorph-addon.php\\\",\\\"name\\\":\\\"BubbleMorph AddOn\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/www.themepunch.com\\\\\\/slider-revolution\\\\\\/install-addons\\\\\\/\\\"}]\",\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"250\":{\"id\":\"259\",\"title\":\"Seasonal Offer\",\"alias\":\"seasonaloffer\",\"zip\":\"seasonaloffer.zip\",\"uid\":\"caf2f17f8fd64f2f89dcb3c8dd238457\",\"img\":\"seasonaloffer\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/seasonal-offer-christmas-header-for-wordpress\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=seasonal-offer-christmas-header-for-wordpress\",\"version\":\"1.0.0\",\"required\":\"5.4.8.1\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">Use the Seasonal Offer Header to promote special offers in the holiday season, or just to add some snowy christmas spirit to your website!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\"],\"plugin_require\":\"[{\\\"path\\\":\\\"revslider-snow-addon\\\\\\/revslider-snow-addon.php\\\",\\\"name\\\":\\\"Snow AddOn\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/www.themepunch.com\\\\\\/slider-revolution\\\\\\/install-addons\\\\\\/\\\"}]\",\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"251\":{\"id\":\"260\",\"title\":\"Barber Shop\",\"alias\":\"barber-shop\",\"zip\":\"\",\"uid\":\"barber-shop-package\",\"img\":\"packages\\/barber-shop-package.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/barber-shop-template-for-wordpress\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=barber-shop-template-for-wordpress\",\"version\":\"1.0.2\",\"required\":\"6.0.0\",\"width\":\"1024\",\"height\":\"768\",\"description\":\"<span class=\\\"ttm_content\\\">The Barber Shop is a useful One-Page template presenting all information about your business. Build your websites faster with Slider Revolution templates.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Barber Shop\",\"package_order\":\"0\",\"package_parent\":\"true\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"16\",\"installed\":false},\"252\":{\"id\":\"261\",\"title\":\"Barber Shop Header\",\"alias\":\"barber-shop-header\",\"zip\":\"packs\\/barber-shop-header.zip\",\"uid\":\"71c995d36d39a0e8a04cffdf753f2ba2\",\"img\":\"barber-shop-header\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/barber-shop-template-for-wordpress\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=barber-shop-template-for-wordpress\",\"version\":\"1.0.2\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Barber Shop is a useful One-Page template presenting all information about your business. Build your websites faster with Slider Revolution templates.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Barber Shop\",\"package_order\":\"1\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"16\",\"installed\":false},\"253\":{\"id\":\"262\",\"title\":\"Barber Shop Mobile Menu\",\"alias\":\"barber-shop-mobile-menu\",\"zip\":\"packs\\/barber-shop-mobile-menu.zip\",\"uid\":\"762c6fb5c6306f37becb1e55773c2592\",\"img\":\"barber-shop-mobile-menu\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/barber-shop-template-for-wordpress\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=barber-shop-template-for-wordpress\",\"version\":\"1.0.2\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Barber Shop is a useful One-Page template presenting all information about your business. Build your websites faster with Slider Revolution templates.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Barber Shop\",\"package_order\":\"2\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"16\",\"installed\":false},\"254\":{\"id\":\"263\",\"title\":\"Barber Shop First Screen\",\"alias\":\"barber-shop-first-screen\",\"zip\":\"packs\\/barber-shop-first-screen.zip\",\"uid\":\"acf70bfd64cff2c3c2ea5585223575da\",\"img\":\"barber-shop-first-screen\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/barber-shop-template-for-wordpress\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=barber-shop-template-for-wordpress\",\"version\":\"1.0.2\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Barber Shop is a useful One-Page template presenting all information about your business. Build your websites faster with Slider Revolution templates.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Barber Shop\",\"package_order\":\"3\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"16\",\"installed\":false},\"255\":{\"id\":\"264\",\"title\":\"Barber Shop About\",\"alias\":\"barber-shop-about\",\"zip\":\"packs\\/barber-shop-about.zip\",\"uid\":\"bc8b63cfc7f8c34173b4fd5b082fc05a\",\"img\":\"barber-shop-about\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/barber-shop-template-for-wordpress\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=barber-shop-template-for-wordpress\",\"version\":\"1.0.2\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Barber Shop is a useful One-Page template presenting all information about your business. Build your websites faster with Slider Revolution templates.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Barber Shop\",\"package_order\":\"4\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"16\",\"installed\":false},\"256\":{\"id\":\"265\",\"title\":\"Barber Shop Services\",\"alias\":\"barber-shop-services\",\"zip\":\"packs\\/barber-shop-services.zip\",\"uid\":\"d65121d6f84fabd812a2b621b768e10e\",\"img\":\"barber-shop-services\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/barber-shop-template-for-wordpress\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=barber-shop-template-for-wordpress\",\"version\":\"1.0.2\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Barber Shop is a useful One-Page template presenting all information about your business. Build your websites faster with Slider Revolution templates.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Barber Shop\",\"package_order\":\"5\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"16\",\"installed\":false},\"257\":{\"id\":\"266\",\"title\":\"Barber Shop Barbers\",\"alias\":\"barber-shop-barbers\",\"zip\":\"packs\\/barber-shop-barbers.zip\",\"uid\":\"003e9fec9693072119c8f8d8b6690c4d\",\"img\":\"barber-shop-barbers\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/barber-shop-template-for-wordpress\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=barber-shop-template-for-wordpress\",\"version\":\"1.0.2\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Barber Shop is a useful One-Page template presenting all information about your business. Build your websites faster with Slider Revolution templates.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Barber Shop\",\"package_order\":\"6\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"16\",\"installed\":false},\"258\":{\"id\":\"267\",\"title\":\"Barber Shop Contacts\",\"alias\":\"barber-shop-contacts\",\"zip\":\"packs\\/barber-shop-contacts.zip\",\"uid\":\"cdcc08f5d6c90dbcfd0502bda2401643\",\"img\":\"barber-shop-contacts\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/barber-shop-template-for-wordpress\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=barber-shop-template-for-wordpress\",\"version\":\"1.0.2\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Barber Shop is a useful One-Page template presenting all information about your business. Build your websites faster with Slider Revolution templates.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Barber Shop\",\"package_order\":\"7\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"16\",\"installed\":false},\"259\":{\"id\":\"268\",\"title\":\"Barber Shop Footer\",\"alias\":\"barber-shop-footer\",\"zip\":\"packs\\/barber-shop-footer.zip\",\"uid\":\"26ca5ae0de7cdbb2ca19348b6e01eda0\",\"img\":\"barber-shop-footer\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/barber-shop-template-for-wordpress\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=barber-shop-template-for-wordpress\",\"version\":\"1.0.2\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Barber Shop is a useful One-Page template presenting all information about your business. Build your websites faster with Slider Revolution templates.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Barber Shop\",\"package_order\":\"8\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"16\",\"installed\":false},\"260\":{\"id\":\"269\",\"title\":\"Fitness Club\",\"alias\":\"fitness-club-template\",\"zip\":\"fitness-club-template.zip\",\"uid\":\"14ea10d68d6aad1df62b3becf71df754\",\"img\":\"fitness-club-template\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/fitness-club-header-for-wordpress\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=fitness-club-header-for-wordpress\",\"version\":\"1.0.1\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Fitness Club Header is the perfect introduction to your fitness themed website. Showcase your current offers or service portfolio with sleek transitions!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"261\":{\"id\":\"270\",\"title\":\"Soccer School\",\"alias\":\"soccer-school\",\"zip\":\"soccer-school.zip\",\"uid\":\"9906b48812aff67097f990eeee42dd41\",\"img\":\"soccer-school\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/soccer-club-slider-for-wordpress\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=soccer-club-slider-for-wordpress\",\"version\":\"1.0.0\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Soccer Club Header is the perfect introduction to your Soccer School themed website. Showcase your current offers or service portfolio with sleek transitions!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\"],\"plugin_require\":\"[{\\\"path\\\":\\\"revslider-revealer-addon\\\\\\/revslider-revealer-addon.php\\\",\\\"name\\\":\\\"Reveal AddOn\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/www.themepunch.com\\\\\\/slider-revolution\\\\\\/install-addons\\\\\\/\\\"}]\",\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"262\":{\"id\":\"271\",\"title\":\"Music Band\",\"alias\":\"music-band-template\",\"zip\":\"music-band-template.zip\",\"uid\":\"91e79657bf1b1812f8114a00ab8e0eb4\",\"img\":\"music-band-template\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/music-band-template-for-wordpress\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=music-band-template-for-wordpress\",\"version\":\"1.0.1\",\"required\":\"5.4.8.2\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Music Band Header is the perfect introduction to your Music Band themed website. Showcase your current songs, albums and videos with sleek transitions!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\"],\"plugin_require\":\"[{\\\"path\\\":\\\"revslider-revealer-addon\\\\\\/revslider-revealer-addon.php\\\",\\\"name\\\":\\\"Reveal AddOn\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/www.themepunch.com\\\\\\/slider-revolution\\\\\\/install-addons\\\\\\/\\\"}]\",\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"263\":{\"id\":\"272\",\"title\":\"Restaurant Menu\",\"alias\":\"restaurant-menu\",\"zip\":\"restaurant-menu.zip\",\"uid\":\"078809cffb21b6c4d3f5aaa2daeb193d\",\"img\":\"restaurant-menu\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/restaurant-menu-slider-for-wordpress\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=restaurant-menu-slider-for-wordpress\",\"version\":\"1.0.0\",\"required\":\"5.4.8.3\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Restaurant Menu Header is the perfect introduction to your Restaurant themed website. Showcase your current dishes with sleek transitions!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"How to Create a Digital Menu Teaser for Your Foodie Website [Tutorial]\",\"guide_url\":\"https:\\/\\/www.sliderrevolution.com\\/tutorials\\/how-to-create-a-digital-menu-teaser-for-your-foodie-website\\/\",\"guide_img\":\"tutorial\\/restaurant-menu.png\",\"active\":\"1\",\"installed\":false},\"264\":{\"id\":\"273\",\"title\":\"Cinematic Slider\",\"alias\":\"cinematic-slider\",\"zip\":\"cinematic-slider.zip\",\"uid\":\"c53e7dcbb6b656ae7b4c91d333589838\",\"img\":\"cinematic-slider\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/cinematic-slider-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=cinematic-slider-template\",\"version\":\"1.0.0\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">Bold texts and a cinematic transition effect make this slider stand out!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"265\":{\"id\":\"274\",\"title\":\"3D Parallax Cubes\",\"alias\":\"3d-parallax-cubes\",\"zip\":\"3d-parallax-cubes.zip\",\"uid\":\"c5b809a1829f8f809c9a768cd3d6b3cb\",\"img\":\"3d-parallax-cubes\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/3d-parallax-cubes-slider-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=3d-parallax-cubes-slider-template\",\"version\":\"1.0.0\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">This amazing 3D cubes parallax effect can be an eye-opening intro for your website!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"266\":{\"id\":\"275\",\"title\":\"Medicare Medical Services Website\",\"alias\":\"medicare-medical-services-website\",\"zip\":\"\",\"uid\":\"medicare-medical-services-website-package\",\"img\":\"packages\\/medicare_package.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/medicare-medical-services-website\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=medicare-medical-services-website\",\"version\":\"1.0.0\",\"required\":\"6.0.0\",\"width\":\"1024\",\"height\":\"768\",\"description\":\"<span class=\\\"ttm_content\\\">The Medicare Medical Services template is a great solution for your medical practice or hospital.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Medicare Medical Services\",\"package_order\":\"0\",\"package_parent\":\"true\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"17\",\"installed\":false},\"267\":{\"id\":\"276\",\"title\":\"Medicare Menu\",\"alias\":\"medicare-menu\",\"zip\":\"packs\\/medicare-menu.zip\",\"uid\":\"0e4ca8fc281e20251b3fffa19d470fed\",\"img\":\"medicare-menu\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/medicare-medical-services-website\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=medicare-medical-services-website\",\"version\":\"1.0.0\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Medicare Medical Services template is a great solution for your medical practice or hospital.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Medicare Medical Services\",\"package_order\":\"1\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"17\",\"installed\":false},\"268\":{\"id\":\"277\",\"title\":\"Medicare Header\",\"alias\":\"medicare-header\",\"zip\":\"packs\\/medicare-header.zip\",\"uid\":\"03e8ade247d8c96f548bc0515f34043f\",\"img\":\"medicare-header\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/medicare-medical-services-website\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=medicare-medical-services-website\",\"version\":\"1.0.0\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Medicare Medical Services template is a great solution for your medical practice or hospital.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Medicare Medical Services\",\"package_order\":\"2\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"17\",\"installed\":false},\"269\":{\"id\":\"278\",\"title\":\"Medicare About\",\"alias\":\"medicare-about\",\"zip\":\"packs\\/medicare-about.zip\",\"uid\":\"a3ab9e89155ef2542820343f30b29f72\",\"img\":\"medicare-about\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/medicare-medical-services-website\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=medicare-medical-services-website\",\"version\":\"1.0.0\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Medicare Medical Services template is a great solution for your medical practice or hospital.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Medicare Medical Services\",\"package_order\":\"3\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"17\",\"installed\":false},\"270\":{\"id\":\"279\",\"title\":\"Medicare Highlight\",\"alias\":\"medicare-highlight\",\"zip\":\"packs\\/medicare-highlight.zip\",\"uid\":\"c3c8a74e5402489f1a85a0c83890ef1f\",\"img\":\"medicare-highlight\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/medicare-medical-services-website\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=medicare-medical-services-website\",\"version\":\"1.0.0\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Medicare Medical Services template is a great solution for your medical practice or hospital.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Medicare Medical Services\",\"package_order\":\"4\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"17\",\"installed\":false},\"271\":{\"id\":\"280\",\"title\":\"Medicare Services\",\"alias\":\"medicare-services\",\"zip\":\"packs\\/medicare-services.zip\",\"uid\":\"8869b0834d4649dcc3221bed65980806\",\"img\":\"medicare-services\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/medicare-medical-services-website\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=medicare-medical-services-website\",\"version\":\"1.0.0\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Medicare Medical Services template is a great solution for your medical practice or hospital.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Medicare Medical Services\",\"package_order\":\"5\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"17\",\"installed\":false},\"272\":{\"id\":\"281\",\"title\":\"Medicare Doctors\",\"alias\":\"medicare-doctors\",\"zip\":\"packs\\/medicare-doctors.zip\",\"uid\":\"2c9d57afd64244b5f7e30b0d87c842f9\",\"img\":\"medicare-doctors\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/medicare-medical-services-website\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=medicare-medical-services-website\",\"version\":\"1.0.0\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Medicare Medical Services template is a great solution for your medical practice or hospital.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Medicare Medical Services\",\"package_order\":\"6\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"17\",\"installed\":false},\"273\":{\"id\":\"282\",\"title\":\"Medicare Research\",\"alias\":\"medicare-research\",\"zip\":\"packs\\/medicare-research.zip\",\"uid\":\"31e84a91fc8b8d5296e715e539a076d0\",\"img\":\"medicare-research\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/medicare-medical-services-website\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=medicare-medical-services-website\",\"version\":\"1.0.0\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Medicare Medical Services template is a great solution for your medical practice or hospital.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Medicare Medical Services\",\"package_order\":\"7\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"17\",\"installed\":false},\"274\":{\"id\":\"283\",\"title\":\"Medicare Why Choose\",\"alias\":\"medicare-whychoose\",\"zip\":\"packs\\/medicare-whychoose.zip\",\"uid\":\"6dad61c672127de9e35884caa45d49a0\",\"img\":\"medicare-whychoose\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/medicare-medical-services-website\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=medicare-medical-services-website\",\"version\":\"1.0.0\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Medicare Medical Services template is a great solution for your medical practice or hospital.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Medicare Medical Services\",\"package_order\":\"8\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"17\",\"installed\":false},\"275\":{\"id\":\"284\",\"title\":\"Medicare Contact\",\"alias\":\"medicare-contact\",\"zip\":\"packs\\/medicare-contact.zip\",\"uid\":\"89bc35ad8beb62a149c42262ae49a270\",\"img\":\"medicare-contact\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/medicare-medical-services-website\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=medicare-medical-services-website\",\"version\":\"1.0.0\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Medicare Medical Services template is a great solution for your medical practice or hospital.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Medicare Medical Services\",\"package_order\":\"9\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"17\",\"installed\":false},\"276\":{\"id\":\"285\",\"title\":\"Medicare Footer\",\"alias\":\"medicare-footer\",\"zip\":\"packs\\/medicare-footer.zip\",\"uid\":\"ccf63e5233b3d63009e5ee90db51b37b\",\"img\":\"medicare-footer\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/medicare-medical-services-website\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=medicare-medical-services-website\",\"version\":\"1.0.0\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Medicare Medical Services template is a great solution for your medical practice or hospital.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Medicare Medical Services\",\"package_order\":\"10\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"17\",\"installed\":false},\"277\":{\"id\":\"286\",\"title\":\"Coffee Joint Website\",\"alias\":\"coffee-joint-website\",\"zip\":\"\",\"uid\":\"coffee-joint-website-package\",\"img\":\"packages\\/coffee_package.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/coffee-joint-coffee-shop-website-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=coffee-joint-coffee-shop-website-template\",\"version\":\"1.0.0\",\"required\":\"6.0.0\",\"width\":\"1024\",\"height\":\"768\",\"description\":\"<span class=\\\"ttm_content\\\">The Coffee Joint website template is a great solution for your cafe or bistro.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Coffee Joint\",\"package_order\":\"0\",\"package_parent\":\"true\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"18\",\"installed\":false},\"278\":{\"id\":\"287\",\"title\":\"Coffee Menu\",\"alias\":\"coffee-menu\",\"zip\":\"packs\\/coffee-menu.zip\",\"uid\":\"81195cad7be3f5180a267b34ce8cf966\",\"img\":\"coffee-menu\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/coffee-joint-coffee-shop-website-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=coffee-joint-coffee-shop-website-template\",\"version\":\"1.0.0\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Coffee Joint website template is a great solution for your cafe or bistro.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Coffee Joint\",\"package_order\":\"1\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"18\",\"installed\":false},\"279\":{\"id\":\"288\",\"title\":\"Coffee Header\",\"alias\":\"coffee-header\",\"zip\":\"packs\\/coffee-header.zip\",\"uid\":\"5eed8adb9d3ae12168ad4735ac63eb20\",\"img\":\"coffee-header\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/coffee-joint-coffee-shop-website-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=coffee-joint-coffee-shop-website-template\",\"version\":\"1.0.0\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Coffee Joint website template is a great solution for your cafe or bistro.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Coffee Joint\",\"package_order\":\"2\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"18\",\"installed\":false},\"280\":{\"id\":\"289\",\"title\":\"Coffee Philosophy\",\"alias\":\"coffee-philosophy\",\"zip\":\"packs\\/coffee-philosophy.zip\",\"uid\":\"76b5ccae3fa87fd0f991b87e7ae71c27\",\"img\":\"coffee-philosophy\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/coffee-joint-coffee-shop-website-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=coffee-joint-coffee-shop-website-template\",\"version\":\"1.0.0\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Coffee Joint website template is a great solution for your cafe or bistro.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Coffee Joint\",\"package_order\":\"3\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"18\",\"installed\":false},\"281\":{\"id\":\"290\",\"title\":\"Coffee Carte\",\"alias\":\"coffee-carte\",\"zip\":\"packs\\/coffee-carte.zip\",\"uid\":\"470214ddd2cec585629fb79a0fd908d6\",\"img\":\"coffee-carte\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/coffee-joint-coffee-shop-website-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=coffee-joint-coffee-shop-website-template\",\"version\":\"1.0.0\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Coffee Joint website template is a great solution for your cafe or bistro.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Coffee Joint\",\"package_order\":\"4\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"18\",\"installed\":false},\"282\":{\"id\":\"291\",\"title\":\"Coffee Teaser\",\"alias\":\"coffee-teaser\",\"zip\":\"packs\\/coffee-teaser.zip\",\"uid\":\"2ed868896c92a7bfb6431803c79e8486\",\"img\":\"coffee-teaser\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/coffee-joint-coffee-shop-website-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=coffee-joint-coffee-shop-website-template\",\"version\":\"1.0.0\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Coffee Joint website template is a great solution for your cafe or bistro.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Coffee Joint\",\"package_order\":\"5\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"18\",\"installed\":false},\"283\":{\"id\":\"292\",\"title\":\"Coffee Find Us\",\"alias\":\"coffee-findus\",\"zip\":\"packs\\/coffee-findus.zip\",\"uid\":\"96d3784473dfa64bce9e1e4101919927\",\"img\":\"coffee-findus\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/coffee-joint-coffee-shop-website-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=coffee-joint-coffee-shop-website-template\",\"version\":\"1.0.0\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Coffee Joint website template is a great solution for your cafe or bistro.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Coffee Joint\",\"package_order\":\"6\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"18\",\"installed\":false},\"284\":{\"id\":\"293\",\"title\":\"Coffee Footer\",\"alias\":\"coffee-footer\",\"zip\":\"packs\\/coffee-footer.zip\",\"uid\":\"6027c25e87a5fe7fd8727a51c0967915\",\"img\":\"coffee-footer\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/coffee-joint-coffee-shop-website-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=coffee-joint-coffee-shop-website-template\",\"version\":\"1.0.0\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Coffee Joint website template is a great solution for your cafe or bistro.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Coffee Joint\",\"package_order\":\"7\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"18\",\"installed\":false},\"285\":{\"id\":\"294\",\"title\":\"Minimal Portfolio Website\",\"alias\":\"minimal-portfolio-website\",\"zip\":\"\",\"uid\":\"minimal-portfolio-website\",\"img\":\"packages\\/minimal_portfolio_package.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/minimal-portfolio-website-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=minimal-portfolio-website-template\",\"version\":\"1.0.2\",\"required\":\"6.0.0\",\"width\":\"1024\",\"height\":\"768\",\"description\":\"<span class=\\\"ttm_content\\\">The Minimal Portfolio template is a slide based website with additional modal detail pages.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Minimal Portfolio\",\"package_order\":\"0\",\"package_parent\":\"true\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"19\",\"installed\":false},\"286\":{\"id\":\"295\",\"title\":\"Minimal Portfolio\",\"alias\":\"minimal-portfolio\",\"zip\":\"packs\\/minimal-portfolio.zip\",\"uid\":\"183b97b301d5ff0b171c067a87c8a3f5\",\"img\":\"minimal-portfolio\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/minimal-portfolio-website-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=minimal-portfolio-website-template\",\"version\":\"1.0.2\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Minimal Portfolio template is a slide based website with additional modal detail pages.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Minimal Portfolio\",\"package_order\":\"1\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"19\",\"installed\":false},\"287\":{\"id\":\"296\",\"title\":\"Minimal Portfolio Modal\",\"alias\":\"minimal-portfolio-modal\",\"zip\":\"packs\\/minimal-portfolio-modal.zip\",\"uid\":\"6874e6cec3663670f209a8d8a4f26b16\",\"img\":\"minimal-portfolio-modal\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/minimal-portfolio-website-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=minimal-portfolio-website-template\",\"version\":\"1.0.1\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Minimal Portfolio template is a slide based website with additional modal detail pages.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Minimal Portfolio\",\"package_order\":\"2\",\"package_parent\":\"\",\"modal\":\"1\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"19\",\"installed\":false},\"288\":{\"id\":\"297\",\"title\":\"Angled Business Website\",\"alias\":\"angled-business-website\",\"zip\":\"\",\"uid\":\"angled-business-website-package\",\"img\":\"packages\\/angled_package.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/angled-business-website-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=angled-business-website-template\",\"version\":\"1.0.0\",\"required\":\"6.0.0\",\"width\":\"1024\",\"height\":\"768\",\"description\":\"<span class=\\\"ttm_content\\\">The Angled Business Website template is a geometric, parallax one-page website with modal based detail pages.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Angled Business\",\"package_order\":\"0\",\"package_parent\":\"true\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"20\",\"installed\":false},\"289\":{\"id\":\"298\",\"title\":\"Angled Menu\",\"alias\":\"angled-menu\",\"zip\":\"packs\\/angled-menu.zip\",\"uid\":\"2fe0c4682d1231ee3918be9e4fcb1837\",\"img\":\"angled-menu\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/angled-business-website-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=angled-business-website-template\",\"version\":\"1.0.0\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Angled Business Website template is a geometric, parallax one-page website with modal based detail pages.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Angled Business\",\"package_order\":\"1\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"20\",\"installed\":false},\"290\":{\"id\":\"299\",\"title\":\"Angled Header\",\"alias\":\"angled-header\",\"zip\":\"packs\\/angled-header.zip\",\"uid\":\"09462601d4edca8dff899de6f666dc47\",\"img\":\"angled-header\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/angled-business-website-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=angled-business-website-template\",\"version\":\"1.0.0\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Angled Business Website template is a geometric, parallax one-page website with modal based detail pages.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Angled Business\",\"package_order\":\"2\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"20\",\"installed\":false},\"291\":{\"id\":\"300\",\"title\":\"Angled News\",\"alias\":\"angled-news\",\"zip\":\"packs\\/angled-news.zip\",\"uid\":\"b315105763ed91214cb2f0ac12615729\",\"img\":\"angled-news\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/angled-business-website-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=angled-business-website-template\",\"version\":\"1.0.0\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Angled Business Website template is a geometric, parallax one-page website with modal based detail pages.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Angled Business\",\"package_order\":\"3\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"20\",\"installed\":false},\"292\":{\"id\":\"301\",\"title\":\"Angled Services\",\"alias\":\"angled-services\",\"zip\":\"packs\\/angled-services.zip\",\"uid\":\"7605651c1487e1a6c32edc70017be8ad\",\"img\":\"angled-services\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/angled-business-website-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=angled-business-website-template\",\"version\":\"1.0.0\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Angled Business Website template is a geometric, parallax one-page website with modal based detail pages.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Angled Business\",\"package_order\":\"4\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"20\",\"installed\":false},\"293\":{\"id\":\"302\",\"title\":\"Angled Success\",\"alias\":\"angled-success\",\"zip\":\"packs\\/angled-success.zip\",\"uid\":\"9e3fa974a42ecf80e1ec6ff991fca430\",\"img\":\"angled-success\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/angled-business-website-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=angled-business-website-template\",\"version\":\"1.0.0\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Angled Business Website template is a geometric, parallax one-page website with modal based detail pages.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Angled Business\",\"package_order\":\"5\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"20\",\"installed\":false},\"294\":{\"id\":\"303\",\"title\":\"Angled Footer\",\"alias\":\"angled-footer\",\"zip\":\"packs\\/angled-footer.zip\",\"uid\":\"aed4eaa2f7883351ba9c9947feef153e\",\"img\":\"angled-footer\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/angled-business-website-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=angled-business-website-template\",\"version\":\"1.0.0\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Angled Business Website template is a geometric, parallax one-page website with modal based detail pages.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Angled Business\",\"package_order\":\"6\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"20\",\"installed\":false},\"295\":{\"id\":\"304\",\"title\":\"Angled Content Modal\",\"alias\":\"angled-content-modal\",\"zip\":\"packs\\/angled-content-modal.zip\",\"uid\":\"4ddc74515fdf84f974217e4ed47a7c66\",\"img\":\"angled-content-modal\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/angled-business-website-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=angled-business-website-template\",\"version\":\"1.0.0\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Angled Business Website template is a geometric, parallax one-page website with modal based detail pages.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Angled Business\",\"package_order\":\"7\",\"package_parent\":\"\",\"modal\":\"1\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"20\",\"installed\":false},\"296\":{\"id\":\"312\",\"title\":\"Retouch Before and After\",\"alias\":\"Retouch\",\"zip\":\"Retouch.zip\",\"uid\":\"58894991f1abd8b448c8d353b1b5fe76\",\"img\":\"Retouch\\/slide1.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/retouch-before-after-slider\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=retouch-before-after-slider\",\"version\":\"1.0.1\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Retouch Slider is the perfect way to compare your photos before and after retouching.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\"],\"plugin_require\":\"[{\\\"path\\\":\\\"revslider-beforeafter-addon\\\\\\/revslider-beforeafter-addon.php\\\",\\\"name\\\":\\\"Before After AddOn\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/www.themepunch.com\\\\\\/slider-revolution\\\\\\/install-addons\\\\\\/\\\"}]\",\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"297\":{\"id\":\"313\",\"title\":\"Tech Slider\",\"alias\":\"tech-slider\",\"zip\":\"tech-slider.zip\",\"uid\":\"a98e2b264f00a1116d21808c6a543162\",\"img\":\"tech-slider\\/slide1.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/tech-showcase-slider-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=tech-showcase-slider-template\",\"version\":\"1.0.0\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">This classic slider module with sleek device mockups features a smooth parallax effect.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"298\":{\"id\":\"314\",\"title\":\"Peak Agency Website\",\"alias\":\"peak-agency-website\",\"zip\":\"\",\"uid\":\"peak-agency-website-package\",\"img\":\"packages\\/peak_package.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/peak-agency-website-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=peak-agency-website-template\",\"version\":\"1.0.0\",\"required\":\"6.0.0\",\"width\":\"1024\",\"height\":\"768\",\"description\":\"<span class=\\\"ttm_content\\\">The Peak Agency Website template is a minimal, light one-pager.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Peak Agency\",\"package_order\":\"0\",\"package_parent\":\"true\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"22\",\"installed\":false},\"299\":{\"id\":\"315\",\"title\":\"Peak Header\",\"alias\":\"peak-header\",\"zip\":\"packs\\/peak-header.zip\",\"uid\":\"b721bd612e9fbc5182418ad3fd7d0808\",\"img\":\"peak-header\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/peak-agency-website-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=peak-agency-website-template\",\"version\":\"1.0.0\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Peak Agency Website template is a minimal, light one-pager.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Peak Agency\",\"package_order\":\"1\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"22\",\"installed\":false},\"300\":{\"id\":\"316\",\"title\":\"Peak About\",\"alias\":\"peak-about\",\"zip\":\"packs\\/peak-about.zip\",\"uid\":\"7e68b1012fb03490d45c7f79e8cb1b19\",\"img\":\"peak-about\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/peak-agency-website-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=peak-agency-website-template\",\"version\":\"1.0.0\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Peak Agency Website template is a minimal, light one-pager.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Peak Agency\",\"package_order\":\"2\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"22\",\"installed\":false},\"301\":{\"id\":\"317\",\"title\":\"Peak Portfolio\",\"alias\":\"peak-portfolio\",\"zip\":\"packs\\/peak-portfolio.zip\",\"uid\":\"6198d1885ba9e95221c33e404f21bdbc\",\"img\":\"peak-portfolio\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/peak-agency-website-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=peak-agency-website-template\",\"version\":\"1.0.0\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Peak Agency Website template is a minimal, light one-pager.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Peak Agency\",\"package_order\":\"3\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"22\",\"installed\":false},\"302\":{\"id\":\"318\",\"title\":\"Peak Footer\",\"alias\":\"peak-footer\",\"zip\":\"packs\\/peak-footer.zip\",\"uid\":\"2dead6897ad3b3a709b380d81242f76b\",\"img\":\"peak-footer\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/peak-agency-website-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=peak-agency-website-template\",\"version\":\"1.0.0\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Peak Agency Website template is a minimal, light one-pager.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Peak Agency\",\"package_order\":\"4\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"22\",\"installed\":false},\"304\":{\"id\":\"320\",\"title\":\"Portfolio Welcome\",\"alias\":\"portfolio-welcome\",\"zip\":\"packs\\/portfolio-welcome.zip\",\"uid\":\"97336b8785e4a7b27facaf1547e0464d\",\"img\":\"portfolio-welcome\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/modern-portfolio-website\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=modern-portfolio-website\",\"version\":\"1.0.1\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">A modern portfolio template with fancy scroll animations and a colorful design.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Modern Portfolio\",\"package_order\":\"1\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"How to Add a Dramatic Pop of Color to Your Site with a Duotone Effect [Tutorial]\",\"guide_url\":\"https:\\/\\/www.sliderrevolution.com\\/tutorials\\/how-to-add-a-dramatic-pop-of-color-to-your-site-with-a-duotone-effect\\/\",\"guide_img\":\"tutorial\\/Modern-Portfolio-Website.png\",\"active\":\"1\",\"package_id\":\"23\",\"installed\":false},\"305\":{\"id\":\"321\",\"title\":\"Portfolio About\",\"alias\":\"portfolio-about\",\"zip\":\"packs\\/portfolio-about.zip\",\"uid\":\"5d3a4724fd453de5313ceb6696c1db62\",\"img\":\"portfolio-about\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/modern-portfolio-website\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=modern-portfolio-website\",\"version\":\"1.0.1\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">A modern portfolio template with fancy scroll animations and a colorful design.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Modern Portfolio\",\"package_order\":\"2\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"How to Add a Dramatic Pop of Color to Your Site with a Duotone Effect [Tutorial]\",\"guide_url\":\"https:\\/\\/www.sliderrevolution.com\\/tutorials\\/how-to-add-a-dramatic-pop-of-color-to-your-site-with-a-duotone-effect\\/\",\"guide_img\":\"tutorial\\/Modern-Portfolio-Website.png\",\"active\":\"1\",\"package_id\":\"23\",\"installed\":false},\"306\":{\"id\":\"322\",\"title\":\"Portfolio Works Title\",\"alias\":\"portfolio-works-title\",\"zip\":\"packs\\/portfolio-works-title.zip\",\"uid\":\"cbb5c6e875cc1f25b463fdf89cabef28\",\"img\":\"portfolio-works-title\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/modern-portfolio-website\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=modern-portfolio-website\",\"version\":\"1.0.1\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">A modern portfolio template with fancy scroll animations and a colorful design.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Modern Portfolio\",\"package_order\":\"3\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"How to Add a Dramatic Pop of Color to Your Site with a Duotone Effect [Tutorial]\",\"guide_url\":\"https:\\/\\/www.sliderrevolution.com\\/tutorials\\/how-to-add-a-dramatic-pop-of-color-to-your-site-with-a-duotone-effect\\/\",\"guide_img\":\"tutorial\\/Modern-Portfolio-Website.png\",\"active\":\"1\",\"package_id\":\"23\",\"installed\":false},\"307\":{\"id\":\"323\",\"title\":\"Portfolio Works Content\",\"alias\":\"portfolio-works-content\",\"zip\":\"packs\\/portfolio-works-content.zip\",\"uid\":\"5c87311128c7794ffa6ee07ea0648082\",\"img\":\"portfolio-works-content\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/modern-portfolio-website\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=modern-portfolio-website\",\"version\":\"1.0.1\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">A modern portfolio template with fancy scroll animations and a colorful design.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Modern Portfolio\",\"package_order\":\"4\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"How to Add a Dramatic Pop of Color to Your Site with a Duotone Effect [Tutorial]\",\"guide_url\":\"https:\\/\\/www.sliderrevolution.com\\/tutorials\\/how-to-add-a-dramatic-pop-of-color-to-your-site-with-a-duotone-effect\\/\",\"guide_img\":\"tutorial\\/Modern-Portfolio-Website.png\",\"active\":\"1\",\"package_id\":\"23\",\"installed\":false},\"308\":{\"id\":\"324\",\"title\":\"Portfolio Contacts\",\"alias\":\"portfolio-contacts\",\"zip\":\"packs\\/portfolio-contacts.zip\",\"uid\":\"bd81feffad83b69218f7e837478038e5\",\"img\":\"portfolio-contacts\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/modern-portfolio-website\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=modern-portfolio-website\",\"version\":\"1.0.1\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">A modern portfolio template with fancy scroll animations and a colorful design.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Modern Portfolio\",\"package_order\":\"5\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"How to Add a Dramatic Pop of Color to Your Site with a Duotone Effect [Tutorial]\",\"guide_url\":\"https:\\/\\/www.sliderrevolution.com\\/tutorials\\/how-to-add-a-dramatic-pop-of-color-to-your-site-with-a-duotone-effect\\/\",\"guide_img\":\"tutorial\\/Modern-Portfolio-Website.png\",\"active\":\"1\",\"package_id\":\"23\",\"installed\":false},\"309\":{\"id\":\"325\",\"title\":\"App Studio Website\",\"alias\":\"app-studio-website\",\"zip\":\"\",\"uid\":\"app-studio-website-package\",\"img\":\"packages\\/App_Studio_package.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/app-studio-website\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=app-studio-website\",\"version\":\"1.0.2\",\"required\":\"6.0.0\",\"width\":\"1024\",\"height\":\"768\",\"description\":\"<span class=\\\"ttm_content\\\">A modern one-page presentation website to present your mobile app development team.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"App Studio\",\"package_order\":\"0\",\"package_parent\":\"true\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"24\",\"installed\":false},\"310\":{\"id\":\"326\",\"title\":\"App Studio Welcome\",\"alias\":\"App-Studio-Welcome\",\"zip\":\"packs\\/App-Studio-Welcome.zip\",\"uid\":\"2ce0f3c54214b04e6c3a9becfd59730c\",\"img\":\"App-Studio-Welcome\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/app-studio-website\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=app-studio-website\",\"version\":\"1.0.2\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">A modern one-page presentation website to present your mobile app development team.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"App Studio\",\"package_order\":\"1\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"24\",\"installed\":false},\"311\":{\"id\":\"327\",\"title\":\"App Studio Services\",\"alias\":\"App-Studio-Services\",\"zip\":\"packs\\/App-Studio-Services.zip\",\"uid\":\"5df7776271ec69d2f9edaa6b842715a9\",\"img\":\"App-Studio-Services\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/app-studio-website\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=app-studio-website\",\"version\":\"1.0.3\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">A modern one-page presentation website to present your mobile app development team.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"App Studio\",\"package_order\":\"2\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"24\",\"installed\":false,\"is_new\":true},\"312\":{\"id\":\"328\",\"title\":\"App Studio About\",\"alias\":\"App-Studio-About\",\"zip\":\"packs\\/App-Studio-About.zip\",\"uid\":\"af8b84dc116c629df7bd89fc69271a2e\",\"img\":\"App-Studio-About\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/app-studio-website\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=app-studio-website\",\"version\":\"1.0.2\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">A modern one-page presentation website to present your mobile app development team.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"App Studio\",\"package_order\":\"3\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"24\",\"installed\":false},\"313\":{\"id\":\"329\",\"title\":\"App Studio Contacts\",\"alias\":\"App-Studio-Contacts\",\"zip\":\"packs\\/App-Studio-Contacts.zip\",\"uid\":\"afbbd2214c983d314f3215a00db9198d\",\"img\":\"App-Studio-Contacts\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/app-studio-website\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=app-studio-website\",\"version\":\"1.0.2\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">A modern one-page presentation website to present your mobile app development team.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"App Studio\",\"package_order\":\"4\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"24\",\"installed\":false},\"314\":{\"id\":\"330\",\"title\":\"Cube Animation\",\"alias\":\"cube-animation\",\"zip\":\"cube-animation.zip\",\"uid\":\"c03dd3cfc60479dfc6d79ddb64fa0ec5\",\"img\":\"cube-animation\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/cube-animation-slider-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=cube-animation-slider-template\",\"version\":\"1.0.0\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">A modern slider with text elements, cube animations and a striking call to action button.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"installed\":false},\"315\":{\"id\":\"331\",\"title\":\"Basic Website\",\"alias\":\"basic-website\",\"zip\":\"\",\"uid\":\"basic-website-package\",\"img\":\"packages\\/basic_package.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/basic-website\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=basic-website\",\"version\":\"1.0.1\",\"required\":\"6.0.0\",\"width\":\"1024\",\"height\":\"768\",\"description\":\"<span class=\\\"ttm_content\\\">The Basic Website template is a minimal one-page website with all the essential modules. Usable and quickly customizable.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Basic Website\",\"package_order\":\"0\",\"package_parent\":\"true\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"25\",\"installed\":false},\"316\":{\"id\":\"332\",\"title\":\"Basic Menu\",\"alias\":\"basic-menu\",\"zip\":\"packs\\/basic-menu.zip\",\"uid\":\"39277f53b2cb5ac644a1649b47c37270\",\"img\":\"basic-menu\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/basic-website\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=basic-website\",\"version\":\"1.0.2\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Basic Website template is a minimal one-page website with all the essential modules. Usable and quickly customizable.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Basic Website\",\"package_order\":\"1\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"25\",\"installed\":false,\"is_new\":true},\"317\":{\"id\":\"333\",\"title\":\"Basic Header\",\"alias\":\"basic-header\",\"zip\":\"packs\\/basic-header.zip\",\"uid\":\"ad7a32dbccb0bdf9de64cf2adfa950a2\",\"img\":\"basic-header\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/basic-website\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=basic-website\",\"version\":\"1.0.1\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Basic Website template is a minimal one-page website with all the essential modules. Usable and quickly customizable.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Basic Website\",\"package_order\":\"2\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"25\",\"installed\":false},\"318\":{\"id\":\"334\",\"title\":\"Basic Content\",\"alias\":\"basic-content\",\"zip\":\"packs\\/basic-content.zip\",\"uid\":\"0b12f3b183a3c8206e3a7b28d2d93108\",\"img\":\"basic-content\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/basic-website\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=basic-website\",\"version\":\"1.0.1\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Basic Website template is a minimal one-page website with all the essential modules. Usable and quickly customizable.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Basic Website\",\"package_order\":\"3\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"25\",\"installed\":false},\"319\":{\"id\":\"335\",\"title\":\"Basic Carousel\",\"alias\":\"basic-carousel\",\"zip\":\"packs\\/basic-carousel.zip\",\"uid\":\"e4abb5c6d5cf914530575a982d3dfc14\",\"img\":\"basic-carousel\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/basic-website\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=basic-website\",\"version\":\"1.0.1\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Basic Website template is a minimal one-page website with all the essential modules. Usable and quickly customizable.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"carousel\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Basic Website\",\"package_order\":\"4\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"25\",\"installed\":false},\"320\":{\"id\":\"336\",\"title\":\"Basic Callout\",\"alias\":\"basic-callout\",\"zip\":\"packs\\/basic-callout.zip\",\"uid\":\"2ccc208b9322f5435d0f4ff64c6d9dab\",\"img\":\"basic-callout\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/basic-website\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=basic-website\",\"version\":\"1.0.1\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Basic Website template is a minimal one-page website with all the essential modules. Usable and quickly customizable.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Basic Website\",\"package_order\":\"5\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"25\",\"installed\":false},\"321\":{\"id\":\"337\",\"title\":\"Basic Grid\",\"alias\":\"basic-grid\",\"zip\":\"packs\\/basic-grid.zip\",\"uid\":\"3cb4b41d2992eba012921b8fb7c96daa\",\"img\":\"basic-grid\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/basic-website\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=basic-website\",\"version\":\"1.0.1\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Basic Website template is a minimal one-page website with all the essential modules. Usable and quickly customizable.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Basic Website\",\"package_order\":\"6\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"25\",\"installed\":false},\"322\":{\"id\":\"338\",\"title\":\"Basic Video Block\",\"alias\":\"basic-video-block\",\"zip\":\"packs\\/basic-video-block.zip\",\"uid\":\"e7c1d42b21819741f3e72c1325dae5ed\",\"img\":\"basic-video-block\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/basic-website\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=basic-website\",\"version\":\"1.0.1\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Basic Website template is a minimal one-page website with all the essential modules. Usable and quickly customizable.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Basic Website\",\"package_order\":\"7\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"25\",\"installed\":false},\"323\":{\"id\":\"339\",\"title\":\"Basic Footer\",\"alias\":\"basic-footer\",\"zip\":\"packs\\/basic-footer.zip\",\"uid\":\"ed8f6a554775ebace558af2f4f2dcbac\",\"img\":\"basic-footer\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/basic-website\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=basic-website\",\"version\":\"1.0.1\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Basic Website template is a minimal one-page website with all the essential modules. Usable and quickly customizable.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Basic Website\",\"package_order\":\"8\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"25\",\"installed\":false},\"324\":{\"id\":\"340\",\"title\":\"Basic Lightbox\",\"alias\":\"basic-lightbox\",\"zip\":\"packs\\/basic-lightbox.zip\",\"uid\":\"e4b025b300b1a8f417d04eb80113fac2\",\"img\":\"basic-lightbox\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/basic-website\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=basic-website\",\"version\":\"1.0.1\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Basic Website template is a minimal one-page website with all the essential modules. Usable and quickly customizable.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Basic Website\",\"package_order\":\"9\",\"package_parent\":\"\",\"modal\":\"1\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"25\",\"installed\":false},\"325\":{\"id\":\"341\",\"title\":\"Nature Slider\",\"alias\":\"nature-slider\",\"zip\":\"nature-slider.zip\",\"uid\":\"eef1a4584ec1c3b8c26c305cca44e805\",\"img\":\"nature-slider\\/slide1.jpg\",\"preview\":\"http:\\/\\/revolution.themepunch.com\\/nature-explorer-slider\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=nature-explorer-slider\",\"version\":\"1.0.0\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Nature Explorer Slider Template uses the Distortion and Particle Effects Add-Ons.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\"],\"plugin_require\":\"[{\\\"path\\\":\\\"revslider-particles-addon\\\\\\/revslider-particles-addon.php\\\",\\\"name\\\":\\\"Particles Effect AddOn\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/www.themepunch.com\\\\\\/slider-revolution\\\\\\/install-addons\\\\\\/\\\"},{\\\"path\\\":\\\"revslider-liquideffect-addon\\\\\\/revslider-liquideffect-addon.php\\\",\\\"name\\\":\\\"Distortion Effect AddOn\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/www.themepunch.com\\\\\\/slider-revolution\\\\\\/install-addons\\\\\\/\\\"}]\",\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"How to Design a Featured Post Slider That Impresses Readers [Tutorial]\",\"guide_url\":\"https:\\/\\/www.sliderrevolution.com\\/tutorials\\/featured-post-slider\\/\",\"guide_img\":\"tutorial\\/nature-slider.png\",\"active\":\"1\",\"installed\":false},\"326\":{\"id\":\"342\",\"title\":\"Art Gallery\",\"alias\":\"art-gallery\",\"zip\":\"art-gallery.zip\",\"uid\":\"b8c5095ae3407337e6e5b2a8515e7d6e\",\"img\":\"art-gallery\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/art-gallery-slider-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=art-gallery-slider-template\",\"version\":\"1.0.1\",\"required\":\"6.2.22\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">A modern slider with large, geometric elements and interesting mask animations.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"Promote Your Most Recent Content with a Colorful Hero Design [Tutorial]\",\"guide_url\":\"https:\\/\\/www.sliderrevolution.com\\/tutorials\\/promote-your-most-recent-content-with-a-colorful-hero-design\\/\",\"guide_img\":\"tutorial\\/Art-Gallery-Slider.png\",\"active\":\"1\",\"installed\":false},\"327\":{\"id\":\"343\",\"title\":\"Construction Company\",\"alias\":\"construction-company-website\",\"zip\":\"\",\"uid\":\"construction-company-website-package\",\"img\":\"packages\\/construction_package.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/construction-company-website\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=construction-company-website\",\"version\":\"1.0.1\",\"required\":\"6.0.0\",\"width\":\"1024\",\"height\":\"768\",\"description\":\"<span class=\\\"ttm_content\\\">The Construction Company is the perfect introduction to your Construction themed website. Showcase your current projects, services and contact information with sleek transitions!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"website\"],\"plugin_require\":\"[{\\\"path\\\":\\\"revslider-revealer-addon\\\\\\/revslider-revealer-addon.php\\\",\\\"name\\\":\\\"Reveal AddOn\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/www.themepunch.com\\\\\\/slider-revolution\\\\\\/install-addons\\\\\\/\\\"}]\",\"date\":\"0000-00-00 00:00:00\",\"package\":\"Construction Company\",\"package_order\":\"0\",\"package_parent\":\"true\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"26\",\"installed\":false},\"328\":{\"id\":\"344\",\"title\":\"Construction Header\",\"alias\":\"Construction-Header\",\"zip\":\"packs\\/Construction-Header.zip\",\"uid\":\"5c77de774b8f5487c1276c4a7b3dc80c\",\"img\":\"Construction-Header\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/construction-company-website\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=construction-company-website\",\"version\":\"1.0.1\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Construction Company is the perfect introduction to your Construction themed website. Showcase your current projects, services and contact information with sleek transitions!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Construction Company\",\"package_order\":\"1\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"26\",\"installed\":false},\"329\":{\"id\":\"345\",\"title\":\"Construction Home\",\"alias\":\"Construction-Home\",\"zip\":\"packs\\/Construction-Home.zip\",\"uid\":\"fcb277f0c07dad270d2a7cef4431bef8\",\"img\":\"Construction-Home\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/construction-company-website\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=construction-company-website\",\"version\":\"1.0.1\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Construction Company is the perfect introduction to your Construction themed website. Showcase your current projects, services and contact information with sleek transitions!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Construction Company\",\"package_order\":\"2\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"26\",\"installed\":false},\"330\":{\"id\":\"346\",\"title\":\"Construction Projects\",\"alias\":\"Construction-Projects\",\"zip\":\"packs\\/Construction-Projects.zip\",\"uid\":\"0c847173c3739f79778dc2c0fc9704e4\",\"img\":\"Construction-Projects\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/construction-company-website\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=construction-company-website\",\"version\":\"1.0.1\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Construction Company is the perfect introduction to your Construction themed website. Showcase your current projects, services and contact information with sleek transitions!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Construction Company\",\"package_order\":\"3\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"26\",\"installed\":false},\"331\":{\"id\":\"347\",\"title\":\"Construction History\",\"alias\":\"Construction-History\",\"zip\":\"packs\\/Construction-History.zip\",\"uid\":\"758da120c4b6c5606692faf0aa43aac6\",\"img\":\"Construction-History\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/construction-company-website\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=construction-company-website\",\"version\":\"1.0.1\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Construction Company is the perfect introduction to your Construction themed website. Showcase your current projects, services and contact information with sleek transitions!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Construction Company\",\"package_order\":\"4\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"26\",\"installed\":false},\"332\":{\"id\":\"348\",\"title\":\"Construction Services\",\"alias\":\"Construction-Services\",\"zip\":\"packs\\/Construction-Services.zip\",\"uid\":\"5ad5b841c1d89e97ddbf972c8b11abd4\",\"img\":\"Construction-Services\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/construction-company-website\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=construction-company-website\",\"version\":\"1.0.1\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Construction Company is the perfect introduction to your Construction themed website. Showcase your current projects, services and contact information with sleek transitions!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Construction Company\",\"package_order\":\"5\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"zindex=\\\"10\\\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"26\",\"installed\":false},\"333\":{\"id\":\"349\",\"title\":\"Construction Contacts\",\"alias\":\"Construction-Contacts\",\"zip\":\"packs\\/Construction-Contacts.zip\",\"uid\":\"b8c3c34046bb91ebb243e4da64745d37\",\"img\":\"Construction-Contacts\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/construction-company-website\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=construction-company-website\",\"version\":\"1.0.1\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Construction Company is the perfect introduction to your Construction themed website. Showcase your current projects, services and contact information with sleek transitions!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">If you want to setup the full website example as seen in the preview, please follow the <a href=\\\"https:\\/\\/www.themepunch.com\\/faq\\/setup-content-blocks-template\\/\\\" target=\\\"_blank\\\">Content Blocks instructions here<\\/a>.<br><br>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Construction Company\",\"package_order\":\"6\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"26\",\"installed\":false},\"334\":{\"id\":\"350\",\"title\":\"Classic Cars Evolution\",\"alias\":\"Classic-Cars-Evolution\",\"zip\":\"Classic-Cars-Evolution.zip\",\"uid\":\"7061757f128fd624b0227715dab73b74\",\"img\":\"Classic-Cars-Evolution\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/classic-cars-before-after-hero\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=classic-cars-before-after-hero\",\"version\":\"1.0.2\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Classic Cars Evolution Slider is a great example of our popular before & after Add-On.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\"],\"plugin_require\":\"[{\\\"path\\\":\\\"revslider-beforeafter-addon\\\\\\/revslider-beforeafter-addon.php\\\",\\\"name\\\":\\\"Before After AddOn\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/www.themepunch.com\\\\\\/slider-revolution\\\\\\/install-addons\\\\\\/\\\"}]\",\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"How to Create an Interactive Before-and-After Image Slider [Tutorial]\",\"guide_url\":\"https:\\/\\/www.sliderrevolution.com\\/tutorials\\/how-to-create-an-interactive-before-and-after-image-slider\\/\",\"guide_img\":\"tutorial\\/Classic-Cars-Evolution.jpg\",\"active\":\"1\",\"installed\":false,\"is_new\":true},\"335\":{\"id\":\"351\",\"title\":\"404 Error Space Theme\",\"alias\":\"404-Error-Space-Theme\",\"zip\":\"404-Error-Space-Theme.zip\",\"uid\":\"6412adc7ec025826328e40e552a14e1e\",\"img\":\"404-Error-Space-Theme\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/404-error-page\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=404-error-page\",\"version\":\"1.0.2\",\"required\":\"6.0.0\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Classic Cars Evolution Slider is the perfect way to make your error page more beautiful.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package_order\":\"0\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"How to Create a 404 Page That Will Convert Instead of Cost You Visitors [Tutorial]\",\"guide_url\":\"https:\\/\\/www.sliderrevolution.com\\/tutorials\\/how-to-create-a-404-page\\/\",\"guide_img\":\"tutorial\\/404-Error-Space-Theme.png\",\"active\":\"1\",\"installed\":false},\"336\":{\"id\":\"352\",\"title\":\"Landing Page\",\"alias\":\"landing-page-website\",\"zip\":\"\",\"uid\":\"landing-page-website-package\",\"img\":\"packages\\/lp_package.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/landing-page-builder\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=landing-page-builder\",\"version\":\"1.0.0\",\"required\":\"6.0.8\",\"width\":\"1024\",\"height\":\"768\",\"description\":\"<span class=\\\"ttm_content\\\">Landing Page is a one-page website template with standard modules to build an effective landing page for your business\\/product.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">After installing this template package, please remove the \\\"price modal\\\" module shortcode from the automatically created page. Also, a small modification is needed in these templates: \\\"Landing Page Hero\\\", \\\"Landing page Call to Action\\\" and \\\"Landing Page Footer\\\". Click the buttons in these template and then go to \\\"layer -> actions\\\" and set the target of the \\\"Open Slider Modal\\\" action to the \\\"Landing Page Price Modal\\\".<\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Landing Page\",\"package_order\":\"0\",\"package_parent\":\"true\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"27\",\"installed\":false},\"337\":{\"id\":\"353\",\"title\":\"Landing Page Hero\",\"alias\":\"landing-page-hero\",\"zip\":\"packs\\/landing-page-hero.zip\",\"uid\":\"d328635caa20da7ee8a3ab687f8656ff\",\"img\":\"landing-page-hero\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/landing-page-builder\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=landing-page-builder\",\"version\":\"1.0.0\",\"required\":\"6.0.8\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">Landing Page is a one-page website template with standard modules to build an effective landing page for your business\\/product.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">After installing this template package, please remove the \\\"price modal\\\" module shortcode from the automatically created page. Also, a small modification is needed in these templates: \\\"Landing Page Hero\\\", \\\"Landing page Call to Action\\\" and \\\"Landing Page Footer\\\". Click the buttons in these template and then go to \\\"layer -> actions\\\" and set the target of the \\\"Open Slider Modal\\\" action to the \\\"Landing Page Price Modal\\\".<\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Landing Page\",\"package_order\":\"1\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"27\",\"installed\":false},\"338\":{\"id\":\"354\",\"title\":\"Landing Page Features\",\"alias\":\"landing-page-features\",\"zip\":\"packs\\/landing-page-features.zip\",\"uid\":\"6552bc72abace10918a64866d9bb79c1\",\"img\":\"landing-page-features\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/landing-page-builder\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=landing-page-builder\",\"version\":\"1.0.1\",\"required\":\"6.0.8\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">Landing Page is a one-page website template with standard modules to build an effective landing page for your business\\/product.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">After installing this template package, please remove the \\\"price modal\\\" module shortcode from the automatically created page. Also, a small modification is needed in these templates: \\\"Landing Page Hero\\\", \\\"Landing page Call to Action\\\" and \\\"Landing Page Footer\\\". Click the buttons in these template and then go to \\\"layer -> actions\\\" and set the target of the \\\"Open Slider Modal\\\" action to the \\\"Landing Page Price Modal\\\".<\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Landing Page\",\"package_order\":\"3\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"27\",\"installed\":false},\"339\":{\"id\":\"355\",\"title\":\"Landing Page Callout\",\"alias\":\"landing-page-callout\",\"zip\":\"packs\\/landing-page-callout.zip\",\"uid\":\"c5b101ea5471e7409ae7effa8d45fbcf\",\"img\":\"landing-page-callout\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/landing-page-builder\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=landing-page-builder\",\"version\":\"1.0.1\",\"required\":\"6.0.8\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">Landing Page is a one-page website template with standard modules to build an effective landing page for your business\\/product.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">After installing this template package, please remove the \\\"price modal\\\" module shortcode from the automatically created page. Also, a small modification is needed in these templates: \\\"Landing Page Hero\\\", \\\"Landing page Call to Action\\\" and \\\"Landing Page Footer\\\". Click the buttons in these template and then go to \\\"layer -> actions\\\" and set the target of the \\\"Open Slider Modal\\\" action to the \\\"Landing Page Price Modal\\\".<\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Landing Page\",\"package_order\":\"4\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"27\",\"installed\":false},\"340\":{\"id\":\"356\",\"title\":\"Landing Page Content\",\"alias\":\"landing-page-content\",\"zip\":\"packs\\/landing-page-content.zip\",\"uid\":\"34da8057a6bb3677c9adf9f18ffc6cf0\",\"img\":\"landing-page-content\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/landing-page-builder\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=landing-page-builder\",\"version\":\"1.0.1\",\"required\":\"6.0.8\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">Landing Page is a one-page website template with standard modules to build an effective landing page for your business\\/product.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">After installing this template package, please remove the \\\"price modal\\\" module shortcode from the automatically created page. Also, a small modification is needed in these templates: \\\"Landing Page Hero\\\", \\\"Landing page Call to Action\\\" and \\\"Landing Page Footer\\\". Click the buttons in these template and then go to \\\"layer -> actions\\\" and set the target of the \\\"Open Slider Modal\\\" action to the \\\"Landing Page Price Modal\\\".<\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Landing Page\",\"package_order\":\"2\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"27\",\"installed\":false},\"341\":{\"id\":\"357\",\"title\":\"Landing Page Testimonials\",\"alias\":\"landing-page-testimonials\",\"zip\":\"packs\\/landing-page-testimonials.zip\",\"uid\":\"a83606e311cd5115422d86f04890cbf1\",\"img\":\"landing-page-testimonials\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/landing-page-builder\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=landing-page-builder\",\"version\":\"1.0.0\",\"required\":\"6.0.8\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">Landing Page is a one-page website template with standard modules to build an effective landing page for your business\\/product.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">After installing this template package, please remove the \\\"price modal\\\" module shortcode from the automatically created page. Also, a small modification is needed in these templates: \\\"Landing Page Hero\\\", \\\"Landing page Call to Action\\\" and \\\"Landing Page Footer\\\". Click the buttons in these template and then go to \\\"layer -> actions\\\" and set the target of the \\\"Open Slider Modal\\\" action to the \\\"Landing Page Price Modal\\\".<\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Landing Page\",\"package_order\":\"5\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"27\",\"installed\":false},\"342\":{\"id\":\"358\",\"title\":\"Landing Page Call to Action\",\"alias\":\"landing-page-call-to-action\",\"zip\":\"packs\\/landing-page-call-to-action.zip\",\"uid\":\"adfb456b27fa7eb6b1415d8f80836f05\",\"img\":\"landing-page-call-to-action\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/landing-page-builder\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=landing-page-builder\",\"version\":\"1.0.0\",\"required\":\"6.0.8\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">Landing Page is a one-page website template with standard modules to build an effective landing page for your business\\/product.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">After installing this template package, please remove the \\\"price modal\\\" module shortcode from the automatically created page. Also, a small modification is needed in these templates: \\\"Landing Page Hero\\\", \\\"Landing page Call to Action\\\" and \\\"Landing Page Footer\\\". Click the buttons in these template and then go to \\\"layer -> actions\\\" and set the target of the \\\"Open Slider Modal\\\" action to the \\\"Landing Page Price Modal\\\".<\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Landing Page\",\"package_order\":\"6\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"27\",\"installed\":false},\"343\":{\"id\":\"359\",\"title\":\"Landing Page Help\",\"alias\":\"landing-page-help\",\"zip\":\"packs\\/landing-page-help.zip\",\"uid\":\"ca502431f9b7f6249d99b02464de2dd7\",\"img\":\"landing-page-help\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/landing-page-builder\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=landing-page-builder\",\"version\":\"1.0.0\",\"required\":\"6.0.8\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">Landing Page is a one-page website template with standard modules to build an effective landing page for your business\\/product.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">After installing this template package, please remove the \\\"price modal\\\" module shortcode from the automatically created page. Also, a small modification is needed in these templates: \\\"Landing Page Hero\\\", \\\"Landing page Call to Action\\\" and \\\"Landing Page Footer\\\". Click the buttons in these template and then go to \\\"layer -> actions\\\" and set the target of the \\\"Open Slider Modal\\\" action to the \\\"Landing Page Price Modal\\\".<\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Landing Page\",\"package_order\":\"7\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"27\",\"installed\":false},\"344\":{\"id\":\"360\",\"title\":\"Landing Page Footer\",\"alias\":\"landing-page-footer\",\"zip\":\"packs\\/landing-page-footer.zip\",\"uid\":\"2a6afc371dbd60cb117f8a0f5d09eac9\",\"img\":\"landing-page-footer\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/landing-page-builder\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=landing-page-builder\",\"version\":\"1.0.0\",\"required\":\"6.0.8\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">Landing Page is a one-page website template with standard modules to build an effective landing page for your business\\/product.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">After installing this template package, please remove the \\\"price modal\\\" module shortcode from the automatically created page. Also, a small modification is needed in these templates: \\\"Landing Page Hero\\\", \\\"Landing page Call to Action\\\" and \\\"Landing Page Footer\\\". Click the buttons in these template and then go to \\\"layer -> actions\\\" and set the target of the \\\"Open Slider Modal\\\" action to the \\\"Landing Page Price Modal\\\".<\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Landing Page\",\"package_order\":\"8\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"27\",\"installed\":false},\"345\":{\"id\":\"361\",\"title\":\"Landing Page Price Modal\",\"alias\":\"landing-page-price-modal\",\"zip\":\"packs\\/landing-page-price-modal.zip\",\"uid\":\"a6c5c0430b46dd4e6e68416964a8c54d\",\"img\":\"landing-page-price-modal\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/landing-page-builder\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=landing-page-builder\",\"version\":\"1.0.0\",\"required\":\"6.0.8\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">Landing Page is a one-page website template with standard modules to build an effective landing page for your business\\/product.<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"setup_notes\":\"<span class=\\\"ttm_content\\\">After installing this template package, please remove the \\\"price modal\\\" module shortcode from the automatically created page. Also, a small modification is needed in these templates: \\\"Landing Page Hero\\\", \\\"Landing page Call to Action\\\" and \\\"Landing Page Footer\\\". Click the buttons in these template and then go to \\\"layer -> actions\\\" and set the target of the \\\"Open Slider Modal\\\" action to the \\\"Landing Page Price Modal\\\".<\\/span>\\r\\n<span class=\\\"ttm_content\\\">Checkout our <a href=\\\"https:\\/\\/revolution.themepunch.com\\/documentation\\\" target=\\\"_blank\\\">Documentation<\\/a> for basic Slider Revolution help.<\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Landing Page\",\"package_order\":\"9\",\"package_parent\":\"\",\"modal\":\"1\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"27\",\"installed\":false},\"346\":{\"id\":\"371\",\"title\":\"Corporate Website\",\"alias\":\"corporate-website\",\"zip\":\"\",\"uid\":\"corporate-website-package\",\"img\":\"packages\\/corporate-website.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/corporate-website-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=corporate-website-template\",\"version\":\"1.0.1\",\"required\":\"6.1.1\",\"width\":\"1024\",\"height\":\"768\",\"description\":\"<span class=\\\"ttm_content\\\">The Corporate Template is a collection of useful modules to construct your website. Portfolio, news, clients, team, contact, basic content, etc. There is something for everyone here!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"cat\":\"Premium\",\"filter\":[\"website\"],\"plugin_require\":\"[{\\\"path\\\":\\\"revslider-typewriter-addon\\\\\\/revslider-typewriter-addon.php\\\",\\\"name\\\":\\\"Typewriter AddOn\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/www.themepunch.com\\\\\\/slider-revolution\\\\\\/typewriter-addon\\\\\\/\\\"}]\",\"date\":\"0000-00-00 00:00:00\",\"package\":\"Corporate Website\",\"package_order\":\"0\",\"package_parent\":\"true\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"29\",\"installed\":false},\"347\":{\"id\":\"372\",\"title\":\"Corporate Header\",\"alias\":\"Corporate-Header\",\"zip\":\"packs\\/Corporate-Header.zip\",\"uid\":\"04f868e3812a1681f00ab89580e5d1f8\",\"img\":\"Corporate-Header\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/corporate-website-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=corporate-website-template\",\"version\":\"1.0.1\",\"required\":\"6.1.1\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Corporate Template is a collection of useful modules to construct your website. Portfolio, news, clients, team, contact, basic content, etc. There is something for everyone here!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Corporate Website\",\"package_order\":\"1\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"29\",\"installed\":false},\"348\":{\"id\":\"373\",\"title\":\"Corporate Welcome Screen\",\"alias\":\"Corporate-Welcome-Screen\",\"zip\":\"packs\\/Corporate-Welcome-Screen.zip\",\"uid\":\"052afe98ef819f7ace041dbbdb749639\",\"img\":\"Corporate-Welcome-Screen\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/corporate-website-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=corporate-website-template\",\"version\":\"1.0.1\",\"required\":\"6.1.1\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Corporate Template is a collection of useful modules to construct your website. Portfolio, news, clients, team, contact, basic content, etc. There is something for everyone here!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":\"[{\\\"path\\\":\\\"revslider-typewriter-addon\\\\\\/revslider-typewriter-addon.php\\\",\\\"name\\\":\\\"Typewriter AddOn\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/www.themepunch.com\\\\\\/slider-revolution\\\\\\/typewriter-addon\\\\\\/\\\"}]\",\"date\":\"0000-00-00 00:00:00\",\"package\":\"Corporate Website\",\"package_order\":\"2\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"29\",\"installed\":false},\"349\":{\"id\":\"374\",\"title\":\"Corporate About\",\"alias\":\"Corporate-About\",\"zip\":\"packs\\/Corporate-About.zip\",\"uid\":\"7bf5f8f6d4cc3016cea86289cb46e5b6\",\"img\":\"Corporate-About\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/corporate-website-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=corporate-website-template\",\"version\":\"1.0.1\",\"required\":\"6.1.1\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Corporate Template is a collection of useful modules to construct your website. Portfolio, news, clients, team, contact, basic content, etc. There is something for everyone here!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Corporate Website\",\"package_order\":\"3\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"29\",\"installed\":false},\"350\":{\"id\":\"375\",\"title\":\"Corporate Portfolio\",\"alias\":\"Corporate-Portfolio\",\"zip\":\"packs\\/Corporate-Portfolio.zip\",\"uid\":\"612c2bd784fea81392dda1644a3c3cf3\",\"img\":\"Corporate-Portfolio\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/corporate-website-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=corporate-website-template\",\"version\":\"1.0.1\",\"required\":\"6.1.1\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Corporate Template is a collection of useful modules to construct your website. Portfolio, news, clients, team, contact, basic content, etc. There is something for everyone here!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Corporate Website\",\"package_order\":\"4\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"29\",\"installed\":false},\"351\":{\"id\":\"376\",\"title\":\"Corporate Chart\",\"alias\":\"Corporate-Chart\",\"zip\":\"packs\\/Corporate-Chart.zip\",\"uid\":\"4d27d9b3b2cfcce750e526aafb322a9f\",\"img\":\"Corporate-Chart\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/corporate-website-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=corporate-website-template\",\"version\":\"1.0.1\",\"required\":\"6.1.1\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Corporate Template is a collection of useful modules to construct your website. Portfolio, news, clients, team, contact, basic content, etc. There is something for everyone here!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Corporate Website\",\"package_order\":\"5\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"29\",\"installed\":false},\"352\":{\"id\":\"377\",\"title\":\"Corporate News\",\"alias\":\"Corporate-News\",\"zip\":\"packs\\/Corporate-News.zip\",\"uid\":\"bb65ed57a0d4db795d8b738f0a92f2d7\",\"img\":\"Corporate-News\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/corporate-website-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=corporate-website-template\",\"version\":\"1.0.1\",\"required\":\"6.1.1\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Corporate Template is a collection of useful modules to construct your website. Portfolio, news, clients, team, contact, basic content, etc. There is something for everyone here!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Corporate Website\",\"package_order\":\"6\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"29\",\"installed\":false},\"353\":{\"id\":\"378\",\"title\":\"Corporate Hiring\",\"alias\":\"Corporate-Hiring\",\"zip\":\"packs\\/Corporate-Hiring.zip\",\"uid\":\"136cf1a91604e819089eb3573a6e100a\",\"img\":\"Corporate-Hiring\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/corporate-website-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=corporate-website-template\",\"version\":\"1.0.1\",\"required\":\"6.1.1\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Corporate Template is a collection of useful modules to construct your website. Portfolio, news, clients, team, contact, basic content, etc. There is something for everyone here!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Corporate Website\",\"package_order\":\"7\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"29\",\"installed\":false},\"354\":{\"id\":\"379\",\"title\":\"Corporate Testimonials\",\"alias\":\"Corporate-Testimonials\",\"zip\":\"packs\\/Corporate-Testimonials.zip\",\"uid\":\"b17aec0afdc31e37359cfa406164463c\",\"img\":\"Corporate-Testimonials\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/corporate-website-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=corporate-website-template\",\"version\":\"1.0.1\",\"required\":\"6.1.1\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Corporate Template is a collection of useful modules to construct your website. Portfolio, news, clients, team, contact, basic content, etc. There is something for everyone here!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Corporate Website\",\"package_order\":\"8\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"29\",\"installed\":false},\"355\":{\"id\":\"380\",\"title\":\"Corporate Store\",\"alias\":\"Corporate-Store\",\"zip\":\"packs\\/Corporate-Store.zip\",\"uid\":\"6240b14620ddc634736716e0cdfdeb31\",\"img\":\"Corporate-Store\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/corporate-website-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=corporate-website-template\",\"version\":\"1.0.1\",\"required\":\"6.1.1\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Corporate Template is a collection of useful modules to construct your website. Portfolio, news, clients, team, contact, basic content, etc. There is something for everyone here!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Corporate Website\",\"package_order\":\"9\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"29\",\"installed\":false},\"356\":{\"id\":\"381\",\"title\":\"Corporate Support\",\"alias\":\"Corporate-Support\",\"zip\":\"packs\\/Corporate-Support.zip\",\"uid\":\"9424292a78076ce68c2faf587b26cdad\",\"img\":\"Corporate-Support\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/corporate-website-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=corporate-website-template\",\"version\":\"1.0.1\",\"required\":\"6.1.1\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Corporate Template is a collection of useful modules to construct your website. Portfolio, news, clients, team, contact, basic content, etc. There is something for everyone here!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Corporate Website\",\"package_order\":\"10\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"29\",\"installed\":false},\"357\":{\"id\":\"382\",\"title\":\"Corporate Team\",\"alias\":\"Corporate-Team\",\"zip\":\"packs\\/Corporate-Team.zip\",\"uid\":\"4fafe469b5a0a2545625c3f6d7ff3b9e\",\"img\":\"Corporate-Team\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/corporate-website-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=corporate-website-template\",\"version\":\"1.0.1\",\"required\":\"6.1.1\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Corporate Template is a collection of useful modules to construct your website. Portfolio, news, clients, team, contact, basic content, etc. There is something for everyone here!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Corporate Website\",\"package_order\":\"11\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"29\",\"installed\":false},\"358\":{\"id\":\"383\",\"title\":\"Corporate Selected Projects Title\",\"alias\":\"Corporate-Selected-Projects-Title\",\"zip\":\"packs\\/Corporate-Selected-Projects-Title.zip\",\"uid\":\"0ed3c41f51e6bf404c2fe179fa8d8ceb\",\"img\":\"Corporate-Selected-Projects-Title\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/corporate-website-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=corporate-website-template\",\"version\":\"1.0.1\",\"required\":\"6.1.1\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Corporate Template is a collection of useful modules to construct your website. Portfolio, news, clients, team, contact, basic content, etc. There is something for everyone here!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Corporate Website\",\"package_order\":\"12\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"29\",\"installed\":false},\"359\":{\"id\":\"384\",\"title\":\"Corporate Selected Projects\",\"alias\":\"Corporate-Selected-Projects\",\"zip\":\"packs\\/Corporate-Selected-Projects.zip\",\"uid\":\"1096c78d5f007f3900228a4092515e2e\",\"img\":\"Corporate-Selected-Projects\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/corporate-website-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=corporate-website-template\",\"version\":\"1.0.1\",\"required\":\"6.1.1\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Corporate Template is a collection of useful modules to construct your website. Portfolio, news, clients, team, contact, basic content, etc. There is something for everyone here!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"cat\":\"Premium\",\"filter\":[\"slider\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Corporate Website\",\"package_order\":\"13\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"29\",\"installed\":false},\"360\":{\"id\":\"385\",\"title\":\"Corporate Clients\",\"alias\":\"Corporate-Clients\",\"zip\":\"packs\\/Corporate-Clients.zip\",\"uid\":\"60fe3a311195bf4dba3e50bd1ab98574\",\"img\":\"Corporate-Clients\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/corporate-website-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=corporate-website-template\",\"version\":\"1.0.1\",\"required\":\"6.1.1\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Corporate Template is a collection of useful modules to construct your website. Portfolio, news, clients, team, contact, basic content, etc. There is something for everyone here!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Corporate Website\",\"package_order\":\"14\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"29\",\"installed\":false},\"361\":{\"id\":\"386\",\"title\":\"Corporate Text Block\",\"alias\":\"Corporate-Text-Block\",\"zip\":\"packs\\/Corporate-Text-Block.zip\",\"uid\":\"93b68bb23d65fd1028b6b5f6d19b85b5\",\"img\":\"Corporate-Text-Block\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/corporate-website-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=corporate-website-template\",\"version\":\"1.0.1\",\"required\":\"6.1.1\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Corporate Template is a collection of useful modules to construct your website. Portfolio, news, clients, team, contact, basic content, etc. There is something for everyone here!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Corporate Website\",\"package_order\":\"15\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"29\",\"installed\":false},\"362\":{\"id\":\"387\",\"title\":\"Corporate Mobile App\",\"alias\":\"Corporate-Mobile-App\",\"zip\":\"packs\\/Corporate-Mobile-App.zip\",\"uid\":\"e592369d233bea673403daa15c6e498a\",\"img\":\"Corporate-Mobile-App\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/corporate-website-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=corporate-website-template\",\"version\":\"1.0.1\",\"required\":\"6.1.1\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Corporate Template is a collection of useful modules to construct your website. Portfolio, news, clients, team, contact, basic content, etc. There is something for everyone here!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Corporate Website\",\"package_order\":\"16\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"29\",\"installed\":false},\"363\":{\"id\":\"388\",\"title\":\"Corporate Contacts\",\"alias\":\"Corporate-Contacts\",\"zip\":\"packs\\/Corporate-Contacts.zip\",\"uid\":\"91ae9488b54b7020f8ae9dfbfd6c563a\",\"img\":\"Corporate-Contacts\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/corporate-website-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=corporate-website-template\",\"version\":\"1.0.1\",\"required\":\"6.1.1\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Corporate Template is a collection of useful modules to construct your website. Portfolio, news, clients, team, contact, basic content, etc. There is something for everyone here!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Corporate Website\",\"package_order\":\"17\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"29\",\"installed\":false},\"364\":{\"id\":\"389\",\"title\":\"Corporate Footer\",\"alias\":\"Corporate-Footer\",\"zip\":\"packs\\/Corporate-Footer.zip\",\"uid\":\"a01df90af203f06194c1a18745d79861\",\"img\":\"Corporate-Footer\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/corporate-website-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=corporate-website-template\",\"version\":\"1.0.1\",\"required\":\"6.1.1\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Corporate Template is a collection of useful modules to construct your website. Portfolio, news, clients, team, contact, basic content, etc. There is something for everyone here!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Corporate Website\",\"package_order\":\"18\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"29\",\"installed\":false},\"365\":{\"id\":\"390\",\"title\":\"Corporate Scroll To Top\",\"alias\":\"Corporate-Scroll-To-Top\",\"zip\":\"packs\\/Corporate-Scroll-To-Top.zip\",\"uid\":\"2d68f6e4590a9a445e6eb055dfee88ba\",\"img\":\"Corporate-Scroll-To-Top\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/corporate-website-template\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=corporate-website-template\",\"version\":\"1.0.1\",\"required\":\"6.1.1\",\"width\":\"1240\",\"height\":\"868\",\"description\":\"<span class=\\\"ttm_content\\\">The Corporate Template is a collection of useful modules to construct your website. Portfolio, news, clients, team, contact, basic content, etc. There is something for everyone here!<\\/span>\\r\\n<span class=\\\"ttm_space\\\"><\\/span>\",\"cat\":\"Premium\",\"filter\":[\"hero\",\"website\"],\"plugin_require\":null,\"date\":\"0000-00-00 00:00:00\",\"package\":\"Corporate Website\",\"package_order\":\"19\",\"package_parent\":\"\",\"modal\":\"0\",\"additions\":\"\",\"guide_title\":\"\",\"guide_url\":\"\",\"guide_img\":\"\",\"active\":\"1\",\"package_id\":\"29\",\"installed\":false},\"367\":{\"id\":\"403\",\"title\":\"Brutal Menu\",\"alias\":\"brutal-menu\",\"zip\":\"packs\\/brutal-menu.zip\",\"uid\":\"04b21c7aee2479793336e964230d6e3f\",\"img\":\"brutal-menu\\/slide1.jpg\",\"preview\":\"https:\\/\\/revolution.themepunch.com\\/brutal-website-template